/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.manager;

import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import core.support.configReader.Config;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.tools.JavaFileObject;

public class ModuleManager {
    public static final String PROJECT_NAME = "project.name";

    public static void writeModuleManagerClass(Map<String, List<String>> panelMap) {
        String projectname = Config.getValue(PROJECT_NAME);
        if (projectname.isEmpty()) {
            projectname = "";
        }
        if (FileCreatorHelper.moduleManagerFileObject != null) {
            return;
        }
        try {
            ModuleManager.writeModuleManagerClassImplementation(panelMap, "Module");
            if (!projectname.isEmpty()) {
                ModuleManager.writeModuleManagerClassImplementation(panelMap, projectname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeModuleManagerClassImplementation(Map<String, List<String>> panelMap, String projectname) throws IOException {
        Logger.debug("start generating module manager class");
        String modulePath = PackageHelper.getFirstModuleFullPath(panelMap);
        String rootModulePath = PackageHelper.getRootPath(modulePath);
        JavaFileObject file = FileCreatorHelper.createFile(rootModulePath, projectname);
        BufferedWriter bw = new BufferedWriter(file.openWriter());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + PackageHelper.MODULE_MANAGER_PATH + ";\n");
        bw.newLine();
        bw.newLine();
        bw.append("public class " + projectname + "Manager {\n");
        for (Map.Entry<String, List<String>> entry : panelMap.entrySet()) {
            String firstElement = entry.getValue().get(0);
            bw.append("\tpublic " + PackageHelper.getPackagePath(firstElement) + "." + PackageHelper.PANEL_MANAGER_CLASS + " " + entry.getKey() + " = new " + PackageHelper.getPackagePath(firstElement) + ".PanelManager();\n");
        }
        bw.append("}\n");
        bw.flush();
        bw.close();
        Logger.debug("complete generating module manager class");
    }
}

