/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.dataObject;

import com.opencsv.CSVReader;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.annotation.helper.DataObjectHelper;
import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;

public class CsvDataObject {
    public static JavaFileObject CSV_File_Object = null;
    public static String MODULE_ROOT = "module";
    public static String DATA_ROOT = "data";
    public static String ID_COLUMN = "@id";

    public static void writeCsvDataClass() {
        try {
            CsvDataObject.writeCsvDataClassImplementation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeCsvDataClassImplementation() throws Exception {
        Logger.debug("<<<< start generating data object classes >>>>");
        List<File> files = DataObjectHelper.getAllCsvDataFiles();
        Logger.debug("csv data class count:  " + files.size());
        if (files.isEmpty()) {
            return;
        }
        CsvDataObject.writeCsvObjectClasses(files);
        Logger.debug("<<<< completed generating data object classes >>>>");
    }

    private static void writeCsvObjectClasses(List<File> files) throws Exception {
        for (File file : files) {
            Logger.debug("writing csv data object:  " + file.getName());
            CsvDataObject.writeCsvObjectClass(file);
        }
    }

    private static void writeCsvObjectClass(File file) throws Exception {
        String column;
        int i;
        String module = PackageHelper.getModuleFromFullPath(file);
        String csvName = file.getName().replaceFirst("[.][^.]+$", "");
        String filePath = PackageHelper.DATA_PATH + "." + module + "." + csvName;
        JavaFileObject fileObject = FileCreatorHelper.createFileAbsolutePath(filePath);
        BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
        List<String[]> csvDataWithHeader = Helper.csv.getAllCsvData(file.getAbsolutePath());
        boolean hasIdColumn = CsvDataObject.hasIdColumn(csvDataWithHeader);
        List<String[]> csvDataOnly = Helper.csv.getAllCsvDataFirstRowAsHeader(file.getAbsolutePath());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package " + DATA_ROOT + "." + module + ";\n");
        bw.newLine();
        bw.newLine();
        bw.append("import org.apache.commons.lang3.StringUtils;\n");
        bw.append("import org.testng.annotations.DataProvider;\n");
        bw.append("import core.helpers.Helper;\n");
        bw.append("import core.helpers.csvHelper.CsvObject;\n");
        bw.newLine();
        bw.newLine();
        bw.append("public class " + csvName + " {\n");
        bw.newLine();
        bw.newLine();
        int firstIndex = 0;
        if (hasIdColumn) {
            firstIndex = 1;
        }
        for (i = firstIndex; i < csvDataWithHeader.get(0).length; ++i) {
            column = csvDataWithHeader.get(0)[i];
            bw.append("private String " + column + " = StringUtils.EMPTY;\n");
        }
        bw.append("private String id = StringUtils.EMPTY;\n");
        bw.newLine();
        bw.newLine();
        for (i = firstIndex; i < csvDataWithHeader.get(0).length; ++i) {
            column = csvDataWithHeader.get(0)[i].trim();
            bw.append("\tpublic " + csvName + " with" + StringUtils.capitalize((String)column) + "(String " + column + ") {\n");
            bw.append("    \tthis." + column + " = " + column + ";\n");
            bw.append("    \treturn this;\n");
            bw.append("}\n");
            bw.newLine();
            bw.newLine();
        }
        for (i = firstIndex; i < csvDataWithHeader.get(0).length; ++i) {
            column = csvDataWithHeader.get(0)[i].trim();
            bw.append("\tpublic String get" + StringUtils.capitalize((String)column) + "() {\n");
            bw.append("    \treturn " + column + ";\n");
            bw.append("}\n");
            bw.newLine();
            bw.newLine();
        }
        for (int rowIndex = 1; rowIndex < csvDataWithHeader.size(); ++rowIndex) {
            String key = CsvDataObject.updateForDuplicateIds(csvDataWithHeader).get(rowIndex - 1).trim();
            key = DataObjectHelper.normalizeMethod(key);
            bw.append("\tpublic " + csvName + " " + key + "() {\n");
            bw.append(" \t  " + csvName + " " + csvName.toLowerCase() + " = new " + csvName + "();\n");
            for (int columnIndex = firstIndex; columnIndex < csvDataWithHeader.get(0).length; ++columnIndex) {
                String column2 = csvDataWithHeader.get(0)[columnIndex].trim();
                String value = "";
                value = csvDataWithHeader.get(rowIndex)[columnIndex];
                value = DataHelper.replaceParameters(value);
                bw.append("\t  " + csvName.toLowerCase() + "." + column2 + " = \"" + value + "\";\n");
            }
            String idValue = "";
            if (hasIdColumn) {
                idValue = key;
            }
            bw.append("\t  " + csvName.toLowerCase() + ".id = \"" + idValue + "\";\n");
            bw.append("    return " + csvName.toLowerCase() + ";\n");
            bw.append("}\n");
            bw.newLine();
            bw.newLine();
        }
        List<String> headers = CsvDataObject.getColumnListFromCsv(file);
        for (int i2 = firstIndex; i2 < headers.size(); ++i2) {
            String column3 = headers.get(i2).trim();
            bw.append("// update value in csv file\n");
            bw.append("\tpublic synchronized void update" + StringUtils.capitalize((String)column3) + "( String " + column3 + ") {\n\n");
            bw.append("\t\tHelper.assertTrue(\"id cannot be empty, select row id. eg. Data.webApp.users().admin().updateName('bob'); \" , !this.id.isEmpty());\n\n");
            bw.append("\t\tString path = \"" + file.getParent().replace(File.separator, File.separator + File.separator) + File.separator + File.separator + "\";\n");
            bw.append("\t\tString fileName = \"" + file.getName() + "\";\n");
            bw.append("\t\tString value = " + column3 + ";\n");
            bw.append("\t\tString[] valueArray = value.split(\",\");\n");
            bw.append("\t\tint columnIndex = Helper.csv.getColumnIndex(\"" + column3 + "\", path  + fileName);\n");
            bw.append("\t\tint rowIndex = Helper.csv.getRowIndex(this.id, path + fileName );\n");
            bw.append("\t\tCsvObject csv = new CsvObject().withCsvPath(path).withCsvFile(\"" + file.getName() + "\").withValue(valueArray).withRow(rowIndex).withColumn(columnIndex);\n");
            bw.append("\t\tHelper.csv.writeToCell(csv, " + column3 + ", path + fileName );\n");
            bw.append("\t}\n ");
            bw.newLine();
        }
        bw.newLine();
        bw.newLine();
        bw.append("\t@DataProvider(name = \"DataRunner\", parallel = true)\n");
        bw.append("\tpublic synchronized Object[][] dataProvider() {\n");
        bw.append("    return new Object[][] {\t\n");
        csvDataOnly = CsvDataObject.normalizeRows(file);
        for (int rowIndex = 0; rowIndex < csvDataOnly.size(); ++rowIndex) {
            List<Object> rowList = Arrays.asList((Object[])csvDataOnly.get(rowIndex));
            String step1 = StringUtils.join(rowList, (String)"\", \"");
            String rowString = "";
            rowString = StringUtils.wrap((String)step1, (String)"\"");
            if (hasIdColumn) {
                rowString = CsvDataObject.removeFirstColumn(rowString);
            }
            rowString = DataHelper.replaceParameters(rowString);
            bw.append(" \t{ " + rowString + " }");
            if (rowIndex < csvDataOnly.size() - 1) {
                bw.append(",\n");
                continue;
            }
            bw.append("\n");
        }
        bw.append("   };\n");
        bw.append("}\n");
        bw.newLine();
        bw.newLine();
        String headerParameters = CsvDataObject.getMethodParametersFromColumnHeaders(headers);
        bw.append("\tpublic void addRow(" + headerParameters + ") {\n\n");
        bw.append("\t\tString path = \"" + file.getParent().replace(File.separator, File.separator + File.separator) + "\";\n");
        bw.append("\t\tString value = " + String.join((CharSequence)" + \",\" +", headers) + ";\n");
        bw.append("\t\tString[] valueArray = value.split(\",\");\n");
        bw.append("\t\tCsvObject csv = new CsvObject().withCsvPath(path).withCsvFile(\"" + file.getName() + "\").withValue(valueArray);\n");
        bw.append("\t\tHelper.csv.AddRow(csv);\n");
        bw.append("\t}\n");
        bw.append("}\n");
        bw.flush();
        bw.close();
    }

    private static List<String> updateForDuplicateIds(List<String[]> csvDataWithHeader) {
        ArrayList<String> idList = new ArrayList<String>();
        int index = 1;
        for (int rowIndex = 1; rowIndex < csvDataWithHeader.size(); ++rowIndex) {
            idList.add(csvDataWithHeader.get(rowIndex)[0]);
        }
        for (int i = 0; i < idList.size(); ++i) {
            if (Collections.frequency(idList, idList.get(i)) <= 1) continue;
            String updatedVal = (String)idList.get(i) + "_duplidateReplaceWithUniqueID_" + index++;
            idList.set(i, updatedVal);
        }
        return idList;
    }

    private static String removeFirstColumn(String row) {
        return row.substring(row.indexOf(",") + 1, row.length());
    }

    private static boolean hasIdColumn(List<String[]> csvDataWithHeader) {
        boolean hasIdColumn = false;
        String idColumn = csvDataWithHeader.get(0)[0];
        if (idColumn.equals(ID_COLUMN)) {
            hasIdColumn = true;
        }
        return hasIdColumn;
    }

    private static List<String[]> normalizeRows(File file) {
        List<String[]> csvDataOnly = Helper.csv.getAllCsvDataFirstRowAsHeader(file.getAbsolutePath());
        List<String[]> csvDataWithHeader = Helper.csv.getAllCsvData(file.getAbsolutePath());
        ArrayList<String[]> updatedList = new ArrayList<String[]>();
        int columnCount = csvDataWithHeader.get(0).length;
        for (String[] row : csvDataOnly) {
            if (row.length < columnCount) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(row));
                for (int i = 0; i < columnCount - row.length; ++i) {
                    list.add("");
                }
                row = list.toArray(new String[list.size()]);
            }
            updatedList.add(row);
        }
        return updatedList;
    }

    private static List<String> getColumnListFromCsv(File file) {
        List<String> headerList = new ArrayList<String>();
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(file.getAbsoluteFile()));
            headerList = Arrays.asList(reader.readNext());
            reader.close();
            if (headerList.isEmpty()) {
                return headerList;
            }
            if (headerList.get(0).equals(ID_COLUMN)) {
                headerList.set(0, ID_COLUMN.replace("@", ""));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return headerList;
    }

    private static String getMethodParametersFromColumnHeaders(List<String> headers) {
        String headerMethod = String.join((CharSequence)", String ", headers);
        return "String " + headerMethod;
    }
}

