/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;

public class ElementHelper {
    protected static String getAttribute(EnhancedBy byValue, String attribute) {
        return ElementHelper.getAttribute(byValue, 0, attribute);
    }

    protected static String getAttribute(EnhancedBy byValue, int index, String attribute) {
        Helper.waitForElementToLoad(byValue);
        EnhancedWebElement element = Element.findElements(byValue);
        return element.getAttribute(attribute, index);
    }

    protected static boolean isElementContainingClass(EnhancedBy by, String value) {
        return ElementHelper.isAttributeContaining(by, "class", value);
    }

    protected static boolean isAttributeContaining(EnhancedBy by, String attribute, String value) {
        String attributeValues = ElementHelper.getAttribute(by, 0, attribute);
        return attributeValues.contains(value);
    }

    protected static void setAttribute(EnhancedBy by, String attribute, String value) {
        ElementHelper.setAttribute(by, 0, attribute, value);
    }

    protected static void setAttribute(EnhancedBy by, int index, String attribute, String value) {
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        Helper.waitForElementToLoad(by);
        String attributeValue = "";
        int retry = 3;
        int currentRetryCount = 0;
        do {
            EnhancedWebElement element = Element.findElements(by);
            element.setAttribute(attribute, index, value);
            attributeValue = Helper.getAttribute(by, index, attribute);
            if (++currentRetryCount <= 1) continue;
            Helper.waitForSeconds(0.5);
        } while ((attributeValue == null || attributeValue.isEmpty()) && currentRetryCount <= retry);
    }

    protected static Dimension getElementSize(EnhancedBy by) {
        Helper.waitForElementToLoad(by);
        EnhancedWebElement element = Element.findElements(by);
        return element.getSize();
    }

    protected static Point getElementPosition(EnhancedBy by) {
        return ElementHelper.getElementPosition(by, 0);
    }

    protected static Point getElementPosition(EnhancedBy by, int index) {
        Helper.waitForElementToLoad(by);
        EnhancedWebElement element = Element.findElements(by);
        return element.getLocation(index);
    }

    protected static int[] findMiddleOfElement(EnhancedBy target) {
        Helper.waitForElementToLoad(target);
        EnhancedWebElement targetElement = Element.findElements(target);
        int x = targetElement.get((int)0).getLocation().x;
        int y = targetElement.get((int)0).getLocation().y;
        TestLog.ConsoleLog("Center at: point x: " + x + " point y: " + y, new Object[0]);
        return new int[]{x, y};
    }
}

