/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExternalInterface {
    private static final String METHOD = "method";

    public static Object ExternalInterfaceRunner(ServiceObject serviceObject) {
        try {
            return ExternalInterface.evaluateTestMethod(serviceObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object evaluateTestMethod(ServiceObject serviceObject) throws Exception {
        if (serviceObject.getMethod().isEmpty()) {
            return null;
        }
        serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
        List<KeyValue> parameterList = DataHelper.getValidationMap(serviceObject.getRequestBody());
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getMethod());
        for (KeyValue keyword : keywords) {
            switch (keyword.key.toLowerCase()) {
                case "method": {
                    Object object = ExternalInterface.runExernalMethod(keyword.value.toString(), parameterList);
                    return object;
                }
            }
        }
        return null;
    }

    public static Object runExernalMethod(String classmethod, List<KeyValue> parameterList) throws Exception {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader();
        Object[] parameters = ExternalInterface.getParameterValues(parameterList);
        Object[] parameterNames = ExternalInterface.getParameterNames(parameterList);
        String[] methodInfo = classmethod.split("\\.");
        if (methodInfo.length < 2) {
            Helper.assertFalse("wrong method format. must be class.method");
        }
        String className = methodInfo[0];
        String methodName = methodInfo[1];
        TestLog.logPass("invoking method: " + methodName + " at class: " + className, new Object[0]);
        File sourceFile = ExternalInterface.getExternalMethodFilePath(className);
        Class externalClass = groovyClassLoader.parseClass(sourceFile);
        Object external = externalClass.newInstance();
        Class<?>[] paramTypes = ExternalInterface.getMethodParameterTypes(externalClass, methodName, parameterNames);
        Method method = null;
        try {
            method = externalClass.getMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            Helper.assertFalse(e.getMessage());
        }
        if (parameterNames.length != paramTypes.length) {
            Helper.assertFalse("number of parameters must match method parameters");
        }
        parameters = ExternalInterface.convertObjectToMethodType(paramTypes, parameters);
        Object object = null;
        try {
            object = method.invoke(external, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
            Helper.assertFalse(e.getMessage());
        }
        groovyClassLoader.close();
        return object;
    }

    public static Object[] convertObjectToMethodType(Class<?>[] paramTypes, Object[] parameterValues) {
        Object[] paramArr = new Object[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            paramArr[i] = ExternalInterface.convertToDataType(paramTypes[i], parameterValues[i]);
        }
        return paramArr;
    }

    public static Object convertToDataType(Class<?> type, Object value) {
        if (type.toString().contains("java.util.ArrayList")) {
            String[] parameterList;
            ArrayList<String> parameterListReconstruct = new ArrayList<String>();
            value = value.toString().replace("[", "").replace("]", "");
            for (String listItem : parameterList = value.toString().split(",")) {
                parameterListReconstruct.add(listItem.toString().trim());
            }
            return parameterListReconstruct;
        }
        if (type.toString().contains("java.lang.String")) {
            return value.toString();
        }
        return JsonHelper.convertToObject(value.toString(), false);
    }

    public static boolean isParameterNamesMatch(String[] parameterNames, Object[] parameterList) {
        String parameterNamesString = Arrays.toString(parameterNames);
        String parameterListString = Arrays.toString(parameterList);
        return parameterNamesString.equals(parameterListString);
    }

    public static Class<?>[] getMethodParameterTypes(Class<?> external, String methodName, Object[] parameterList) {
        CachingParanamer info = new CachingParanamer((Paranamer)new AnnotationParanamer((Paranamer)new BytecodeReadingParanamer()));
        ArrayList<String> methodList = new ArrayList<String>();
        for (Method m : external.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            Object[] parameterNames = info.lookupParameterNames((AccessibleObject)m);
            methodList.add("method: " + m.getName() + "(" + Arrays.toString(parameterNames) + ")");
            boolean isParameterMatch = ExternalInterface.isParameterNamesMatch((String[])parameterNames, parameterList);
            if (m.getParameterCount() != parameterList.length || !isParameterMatch) continue;
            Class<?>[] params = m.getParameterTypes();
            return params;
        }
        if (!methodList.isEmpty()) {
            TestLog.logPass("method: " + methodName + "(" + Arrays.toString(parameterList) + ") not found. methods found: " + Arrays.toString(methodList.toArray()), new Object[0]);
        }
        return null;
    }

    public static File getExternalMethodFilePath(String classmethod) {
        String path = "module" + File.separator + "services" + File.separator + METHOD;
        File folder = new File(Helper.getRootDir() + "src" + File.separator + "main");
        List<File> listOfFiles = new ArrayList<File>();
        listOfFiles = ExternalInterface.getAllFiles(folder, listOfFiles);
        for (File file : listOfFiles) {
            if (!file.getAbsolutePath().contains(path + File.separator + classmethod)) continue;
            return file;
        }
        Helper.assertFalse("directory for external test method not found: " + path);
        return null;
    }

    private static List<File> getAllFiles(File pathToDir, List<File> listOfFiles) {
        if (pathToDir.isDirectory()) {
            String[] subdirs = pathToDir.list();
            for (int i = 0; i < subdirs.length; ++i) {
                ExternalInterface.getAllFiles(new File(pathToDir, subdirs[i]), listOfFiles);
            }
        } else {
            listOfFiles.add(pathToDir);
        }
        return listOfFiles;
    }

    private static Object[] getParameterValues(List<KeyValue> paramters) {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (KeyValue parameter : paramters) {
            parameterList.add(parameter.value);
        }
        String[] paramArr = new String[parameterList.size()];
        return parameterList.toArray(paramArr);
    }

    private static Object[] getParameterNames(List<KeyValue> paramters) {
        ArrayList<String> parameterList = new ArrayList<String>();
        for (KeyValue parameter : paramters) {
            parameterList.add(parameter.key);
        }
        String[] paramArr = new String[parameterList.size()];
        return parameterList.toArray(paramArr);
    }
}

