/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore;

import com.microsoft.appcenter.appium.EnhancedAndroidDriver;
import com.microsoft.appcenter.appium.Factory;
import core.helpers.Helper;
import core.helpers.UtilityHelper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.uiCore.AppiumServer;
import core.uiCore.driverProperties.browserType;
import core.uiCore.driverProperties.driverType;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.windows.WindowsDriver;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;

public class WebDriverSetup {
    public static String SERVER_URL = "web.remote.server.url";
    public static String SERVER_PORT = "web.remote.server.port";
    public static String LATEST_BROWSER_VERSION = "LATEST";

    public WebDriver getWebDriverByType(DriverObject driverObject) throws Exception {
        WebDriver driver = null;
        driverType.DriverType type = driverObject.driverType;
        switch (type) {
            case LOCAL_WEBDRIVER: {
                driver = this.getBrowserDriverByType(driverObject);
                break;
            }
            case REMOTE_WEBDRIVER: {
                driver = new RemoteWebDriver(new URL(this.getServerUrl() + ":" + this.getServerPort() + "/wd/hub"), (Capabilities)driverObject.capabilities);
                break;
            }
            case IOS_DRIVER: {
                if (Config.getBooleanValue("appium.useExternalAppiumServer").booleanValue()) {
                    String server = Config.getValue("appium.externalServer");
                    TestLog.ConsoleLog("driver capabilities " + driverObject.capabilities, new Object[0]);
                    driver = new IOSDriver(new URL(server), (Capabilities)driverObject.capabilities);
                    break;
                }
                TestLog.ConsoleLog("Connecting to internal appium server", new Object[0]);
                AppiumDriverLocalService service = AppiumServer.startAppiumServer(driverObject);
                driver = new IOSDriver(service.getUrl(), (Capabilities)driverObject.capabilities);
                break;
            }
            case ANDROID_DRIVER: {
                if (Config.getBooleanValue("appium.useExternalAppiumServer").booleanValue()) {
                    String server = Config.getValue("appium.externalServer");
                    TestLog.ConsoleLog("driver capabilities " + driverObject.capabilities, new Object[0]);
                    driver = new AndroidDriver(new URL(server), (Capabilities)driverObject.capabilities);
                    break;
                }
                if (PropertiesReader.isUsingCloud()) {
                    EnhancedAndroidDriver appcenterDriver = Factory.createAndroidDriver((URL)new URL("http://localhost:8001/wd/hub"), (DesiredCapabilities)driverObject.capabilities);
                    return appcenterDriver;
                }
                AppiumDriverLocalService service = AppiumServer.startAppiumServer(driverObject);
                driver = new AndroidDriver(service.getUrl(), (Capabilities)driverObject.capabilities);
                break;
            }
            case WINAPP_DRIVER: {
                if (Config.getBooleanValue("appium.useExternalAppiumServer").booleanValue()) {
                    int port = Config.getIntValue("appium.externalPort");
                    String server = Config.getValue("appium.externalServer");
                    driver = new WindowsDriver(new URL("http://" + server + ":" + port + "/wd/hub"), (Capabilities)driverObject.capabilities);
                    break;
                }
                AppiumDriverLocalService service = AppiumServer.startAppiumServer(driverObject);
                driver = new WindowsDriver(service.getUrl(), (Capabilities)driverObject.capabilities);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported driverype " + (Object)((Object)type));
            }
        }
        return driver;
    }

    public WebDriver getBrowserDriverByType(DriverObject driverObject) throws IOException {
        SafariDriver driver = null;
        browserType.BrowserType browserType2 = driverObject.browserType;
        if (driverObject.driverVersion != null && driverObject.driverVersion.equals(LATEST_BROWSER_VERSION)) {
            driverObject.driverVersion = null;
        }
        Map cap = driverObject.capabilities.asMap();
        TestLog.ConsoleLog("capabilities: " + Arrays.toString(cap.entrySet().toArray()), new Object[0]);
        switch (browserType2) {
            case FIREFOX: {
                this.setDriverManager(driverObject, WebDriverManager.firefoxdriver());
                driver = new FirefoxDriver(driverObject.getOptions().getFirefoxOptions());
                break;
            }
            case FIREFOX_HEADLESS: {
                this.setDriverManager(driverObject, WebDriverManager.firefoxdriver());
                driverObject.getOptions().getFirefoxOptions().addArguments(new String[]{"--headless=new"});
                driver = new FirefoxDriver(driverObject.getOptions().getFirefoxOptions());
                break;
            }
            case INTERNET_EXPLORER: {
                this.setDriverManager(driverObject, WebDriverManager.iedriver());
                driver = new InternetExplorerDriver(driverObject.getOptions().getInternetExplorerOptions());
                break;
            }
            case MICROSOFT_EDGE: {
                this.setDriverManager(driverObject, WebDriverManager.edgedriver());
                driver = new EdgeDriver(driverObject.getOptions().getEdgeOptions());
                break;
            }
            case CHROME: {
                this.setDriverManager(driverObject, WebDriverManager.chromedriver());
                driverObject.getOptions().getChromeOptions().addArguments(new String[]{"--remote-allow-origins=*"});
                driver = new ChromeDriver(driverObject.getOptions().getChromeOptions());
                break;
            }
            case CHROME_HEADLESS: {
                this.setDriverManager(driverObject, WebDriverManager.chromedriver());
                driverObject.getOptions().getChromeOptions().addArguments(new String[]{"--headless=new"});
                driver = new ChromeDriver(driverObject.getOptions().getChromeOptions());
                break;
            }
            case SAFARI: {
                driver = new SafariDriver(driverObject.getOptions().getSafariOptions());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported browsertype " + (Object)((Object)browserType2));
            }
        }
        this.printBrowserVersion((WebDriver)driver);
        return driver;
    }

    private void setDriverManager(DriverObject driverObject, WebDriverManager manager) {
        boolean isProxyEnabled;
        String proxyServer = Config.getValue("proxy.host");
        String proxyPort = Config.getValue("proxy.port");
        String proxyUser = Config.getValue("proxy.username");
        String proxyPassword = Config.getValue("proxy.password");
        boolean isForceCache = Config.getBooleanValue("web.driver.manager.proxy.forceCache");
        int timeout_seconds = Config.getIntValue("web.driver.manager.timeoutSeconds");
        String webDriverPath = Config.getValue("web.driver.manual.path");
        if (!webDriverPath.isEmpty()) {
            WebDriverSetup.setManualDriverPath(driverObject.browserType);
            return;
        }
        if (isForceCache) {
            manager = manager.useLocalVersionsPropertiesFirst();
        }
        if ((isProxyEnabled = UtilityHelper.isProxyRequired(driverObject.getInitURL())) && !proxyServer.isEmpty() && !proxyPort.isEmpty()) {
            try {
                manager = manager.proxy(proxyServer + ":" + proxyPort);
                if (!proxyUser.isEmpty() || !proxyPassword.isEmpty()) {
                    manager = manager.proxyUser(proxyUser).proxyPass(proxyPassword);
                }
            }
            catch (NoSuchMethodError er) {
                er.getMessage();
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        manager.driverVersion(driverObject.driverVersion).timeout(timeout_seconds).setup();
    }

    public static void setManualDriverPath(browserType.BrowserType browserType2) {
        String path = Helper.getFullPath(Config.getValue("web.driver.manual.path"));
        switch (browserType2) {
            case FIREFOX: {
                System.setProperty("webdriver.gecko.driver", path);
                break;
            }
            case FIREFOX_HEADLESS: {
                System.setProperty("webdriver.gecko.driver", path);
                break;
            }
            case INTERNET_EXPLORER: {
                System.setProperty("webdriver.ie.driver", path);
                break;
            }
            case MICROSOFT_EDGE: {
                System.setProperty("webdriver.edge.driver", path);
                break;
            }
            case CHROME: {
                System.setProperty("webdriver.chrome.driver", path);
                break;
            }
            case CHROME_HEADLESS: {
                System.setProperty("webdriver.chrome.driver", path);
                break;
            }
            case OPERA: {
                System.setProperty("webdriver.opera.driver", path);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported browsertype " + (Object)((Object)browserType2));
            }
        }
    }

    public static boolean getProxyState() {
        String proxyState = Config.getValue("proxy.enabled");
        return proxyState.equals("true");
    }

    public String getServerUrl() {
        return "http://" + Config.getValue(SERVER_URL);
    }

    public String getServerPort() {
        return Config.getValue(SERVER_PORT);
    }

    public void printBrowserVersion(WebDriver driver) {
        if (driver == null) {
            return;
        }
        Capabilities caps = ((RemoteWebDriver)driver).getCapabilities();
        String browserName = caps.getBrowserName();
        String browserVersion = caps.getBrowserVersion();
        TestLog.ConsoleLog("browser name: '" + browserName + "' browser version: " + browserVersion, new Object[0]);
    }
}

