/*
 * Decompiled with CFR 0.152.
 */
package core.support.logger;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.gherkin.model.Feature;
import com.aventstack.extentreports.gherkin.model.Scenario;
import com.aventstack.extentreports.observer.ExtentObserver;
import com.aventstack.extentreports.reporter.ExtentSparkReporter;
import com.aventstack.extentreports.reporter.configuration.Protocol;
import com.aventstack.extentreports.reporter.configuration.Theme;
import core.helpers.Helper;
import core.helpers.UtilityHelper;
import core.helpers.emailHelper.EmailObject;
import core.support.configReader.Config;
import core.support.listeners.ParamOverrideTestNgService;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ExtentManager {
    public static final String LAUNCH_AFTER_REPORT = "report.launchReportAfterTest";
    public static final String NOTIFY_SLACK_ON_FAIL_ONLY = "slack.notifyOnFailureOnly";
    public static final String NOTIFY_EMAIL_ON_FAIL_ONLY = "email.notifyOnFailureOnly";
    public static final String ENABLE_SLACK_NOTIFICATION = "slack.enableSlackNotification";
    public static final String ENABLE_EMAIL_REPORT = "email.enableEmailReport";
    public static final String REPORT_EXPIRE_DAYS = "report.reportExpireDays";
    public static final String REPORT_TYPE = "report.reporterType";
    public static final String HTML_REPORT_TYPE = "html";
    public static final String KLOV_REPORT_TYPE = "klov";
    public static final String KLOV_SERVER_URL = "klov.server.url";
    public static final String KLOV_MONGODB_URL = "klov.mongodb.url";
    public static Map<String, ExtentTest> classList = new HashMap<String, ExtentTest>();
    private static ExtentReports extent;
    public static String REPORT_DEFAULT_NAME;
    public static String TEST_OUTPUT_PATH;
    public static String TEST_OUTPUT_FULL_PATH;

    public static synchronized ExtentReports getReporter() {
        if (extent == null) {
            ExtentManager.createInstance(ExtentManager.getReportHTMLFullPath());
        }
        return extent;
    }

    public static String getScreenshotsFolderFullPath() {
        return ExtentManager.getReportRootFullPath() + "screenshots/";
    }

    public static String getScreenshotsFolderRelativePath() {
        return "screenshots/";
    }

    public static String getMediaFolderFullPath() {
        return ExtentManager.getReportRootFullPath() + "media/";
    }

    public static String getMediaFolderRelativePathFromHtmlReport() {
        return "media/";
    }

    public static String getMediaFolderRelativePathFromRoot() {
        return ExtentManager.getReportRootRelativePath() + ExtentManager.getMediaFolderRelativePathFromHtmlReport();
    }

    public static String getReportHTMLFullPath() {
        return ExtentManager.getReportRootFullPath() + ExtentManager.getReportName() + ".html";
    }

    public static String getReportRootFullPath() {
        return Helper.getFullPath(ExtentManager.getReportRootRelativePath());
    }

    public static String getReportRootRelativePath() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        String folderName = dateFormat.format(date);
        return TEST_OUTPUT_PATH + "testReports" + File.separator + folderName + File.separator + TestObject.getTestInfo((String)TestObject.getDefaultTestObjectId()).app + File.separator;
    }

    public static ExtentReports createInstance(String fileName) {
        extent = new ExtentReports();
        ExtentReports htmlReporter = new ExtentReports();
        ExtentSparkReporter spark = new ExtentSparkReporter(fileName);
        spark.config().setTheme(Theme.STANDARD);
        spark.config().setDocumentTitle(fileName);
        spark.config().setEncoding("utf-8");
        spark.config().setProtocol(Protocol.HTTPS);
        spark.config().setReportName(fileName);
        htmlReporter.setAnalysisStrategy(AnalysisStrategy.BDD);
        if (Config.getValue(REPORT_TYPE).equals(HTML_REPORT_TYPE)) {
            extent.attachReporter(new ExtentObserver[]{spark});
        }
        ExtentManager.setKlovReportReporter();
        return extent;
    }

    public static void setupReportPage() {
        if (TestObject.getTestInfo().runCount == 0) {
            extent = ExtentManager.getReporter();
        }
    }

    public static void reportSetup() {
        String testId = TestObject.getTestInfo().testId;
        TestObject.testState state = TestObject.getTestState(testId);
        if (!state.equals((Object)TestObject.testState.testMethod)) {
            return;
        }
        ExtentManager.setupReportPage();
        String className = TestObject.getTestInfo().getClassName();
        if (className.equals("ServiceTestRunner")) {
            return;
        }
        if (!classList.containsKey(className)) {
            String testParent = className.substring(className.lastIndexOf(46) + 1).trim();
            testParent = ExtentManager.parseTestName(testParent);
            ExtentTest feature = extent.createTest(Feature.class, testParent);
            classList.put(className, feature);
            TestObject.getTestInfo().testFeature = feature;
        }
        if (TestObject.getTestInfo().runCount == 0) {
            TestObject.getTestInfo().incremenetRunCount();
            String testChild = TestObject.getTestInfo().testName;
            testChild = ExtentManager.parseTestName(testChild);
            ExtentTest scenario = classList.get(className).createNode(Scenario.class, testChild);
            TestObject.getTestInfo().withTestScenario(scenario);
            TestLog.Background(TestObject.getTestInfo().testName + " initialized successfully", new Object[0]);
        }
    }

    public static void setKlovReportReporter() {
    }

    public static void launchReportAfterTest() {
        if (Config.getBooleanValue(LAUNCH_AFTER_REPORT).booleanValue()) {
            URI link = null;
            try {
                if (Config.getValue(REPORT_TYPE).equals(KLOV_REPORT_TYPE)) {
                    link = new URI(Config.getValue(KLOV_SERVER_URL));
                }
                if (Config.getValue(REPORT_TYPE).equals(HTML_REPORT_TYPE)) {
                    link = new File(ExtentManager.getReportHTMLFullPath()).toURI();
                }
                Desktop.getDesktop().browse(link);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    public static void writeTestReport() {
        try {
            new File(ExtentManager.getReportRootFullPath()).mkdirs();
            new File(ExtentManager.getReportHTMLFullPath()).createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ExtentManager.getReporter().flush();
    }

    public static void removeEmptyTestNodesFromReport() {
        for (Map.Entry<String, TestObject> entry : TestObject.testInfo.entrySet()) {
            if (!entry.getValue().testName.contains("Beforesuite") && !entry.getValue().testName.contains("Aftersuite")) continue;
            try {
                ExtentManager.getReporter().removeTest(entry.getValue().testFeature);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        for (Map.Entry<String, TestObject> entry : TestObject.testInfo.entrySet()) {
            if (!entry.getValue().testName.contains("Beforeclass") && !entry.getValue().testName.contains("Aftersuite")) continue;
            try {
                ExtentManager.getReporter().removeTest(entry.getValue().testFeature);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        for (Map.Entry<String, TestObject> entry : TestObject.testInfo.entrySet()) {
            if (entry.getValue().testScenerio == null || entry.getValue().testSubSteps.size() > 1) continue;
            try {
                ExtentManager.getReporter().removeTest(entry.getValue().testScenerio);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    public static void printReportLink() {
        String link = "";
        if (Config.getValue(REPORT_TYPE).equals(KLOV_REPORT_TYPE)) {
            link = Config.getValue(KLOV_SERVER_URL);
        }
        if (Config.getValue(REPORT_TYPE).equals(HTML_REPORT_TYPE)) {
            link = new File(ExtentManager.getReportHTMLFullPath()).toURI().toString();
        }
        System.out.println("Extent test report link: " + link);
        if (Config.getBooleanValue(ParamOverrideTestNgService.REPORT_PORTAL_ENABLE).booleanValue()) {
            String url = Config.getValue(ParamOverrideTestNgService.ENDPOINT);
            System.out.println("Report Portal test report link: " + url);
        }
    }

    public static String getReportName() {
        return REPORT_DEFAULT_NAME;
    }

    public static void slackNotification(String message) {
        if (!Config.getValue(ENABLE_SLACK_NOTIFICATION).equals("true")) {
            return;
        }
        TestLog.ConsoleLog("sending slack notification", new Object[0]);
        String zipFile = UtilityHelper.zipDir(ExtentManager.getReportRootFullPath(), TEST_OUTPUT_FULL_PATH + ExtentManager.getReportName());
        String comment = ExtentManager.getReportName() + " automated tests complete. " + message;
        UtilityHelper.slackNotificationWithFile("test report", comment, zipFile);
    }

    public static void emailTestReport(String message) {
        if (!Config.getValue(ENABLE_EMAIL_REPORT).equals("true")) {
            return;
        }
        String fromEmail = Config.getValue("email.fromEmail");
        String toEmail = Config.getValue("email.toEmail");
        String password = Config.getValue("email.emailPassword");
        String smtpPort = Config.getValue("email.smtpPort");
        String smtpHost = Config.getValue("email.smtpHost");
        Boolean smtpStarttlsEnabled = Config.getBooleanValue("email.smtpStarttlsEnable");
        Boolean smtpAuth = Config.getBooleanValue("email.smtpAuth");
        TestLog.ConsoleLog("sending email report", new Object[0]);
        String zipFilePath = UtilityHelper.zipDir(ExtentManager.getReportRootFullPath(), TEST_OUTPUT_FULL_PATH + ExtentManager.getReportName());
        String comment = ExtentManager.getReportName() + " automated tests complete. " + message;
        EmailObject email = new EmailObject().withToEmail(toEmail).withPassword(password).withFromEmail(fromEmail).withSmtpPort(smtpPort).withSmtpHost(smtpHost).withSmtpStarttlsEnabled(smtpStarttlsEnabled).withSmtpAuth(smtpAuth).withRecipientEmail(toEmail).withBody(comment).withSubject(ExtentManager.getReportName() + " test report").withAttachmentPath(zipFilePath).withAttachmentFile("testReport.zip");
        Helper.sendMail(email);
    }

    public static void clearTestReport() {
        ExtentManager.clearTestReport("");
    }

    public static void clearTestReport(String suitename) {
        if (suitename.equals("failed_rerun_suite")) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)new File(ExtentManager.getReportRootFullPath()));
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public static void clearOldTestReports() {
        int maxDays = Config.getIntValue(REPORT_EXPIRE_DAYS);
        if (maxDays < 1) {
            return;
        }
        File folder = new File(TEST_OUTPUT_FULL_PATH + "testReports/");
        if (!folder.exists()) {
            return;
        }
        for (File file : folder.listFiles()) {
            long diff;
            long diffDays;
            if (!file.isDirectory() || (diffDays = (diff = new Date().getTime() - file.lastModified()) / 86400000L) <= (long)maxDays) continue;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
    }

    public static String parseTestName(String value) {
        String formatted = "";
        value = value.replace("_", " ");
        for (String w : value.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")) {
            w = w.substring(0, 1).toUpperCase() + w.substring(1).toLowerCase();
            formatted = formatted + " " + w;
        }
        return formatted.trim();
    }

    static {
        REPORT_DEFAULT_NAME = "extent";
        TEST_OUTPUT_PATH = File.separator + "test-output" + File.separator;
        TEST_OUTPUT_FULL_PATH = Helper.getFullPath(TEST_OUTPUT_PATH);
    }
}

