/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import com.google.common.util.concurrent.Uninterruptibles;
import core.helpers.AssertHelper;
import core.helpers.Element;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitHelper {
    public boolean waitForElementToLoad(EnhancedBy target) {
        return this.waitForElementToLoad(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToLoad(EnhancedBy target, int time) {
        return this.waitForElementToLoad(target, time, 1);
    }

    public boolean waitForElementToBeVisible(EnhancedBy target, int time, int count) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        EnhancedWebElement elements = Element.findElements(target);
        ExpectedCondition condition = ExpectedConditions.visibilityOf((WebElement)elements);
        return this.waitForCondition2((ExpectedCondition<WebElement>)condition, target, time);
    }

    public boolean waitForElementToLoad(final EnhancedBy target, int time, final int count) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Element.findElements(target).count() >= count;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public void mobile_waitAndRefreshForElementToLoad(EnhancedBy target) {
        this.mobile_waitAndRefreshForElementToLoad(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public void mobile_waitAndRefreshForElementToLoad(final EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        if (!Helper.mobile_isMobile()) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                Helper.mobile.refreshMobileApp();
                boolean isFound = Element.findElements(target).count() >= 1;
                return isFound;
            }
        };
        this.waitForCondition(condition, target, time);
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2) {
        return this.waitForFirstElementToLoad(element1, element2, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        boolean isFound = false;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        do {
            if (Helper.isDisplayed(element1) || Helper.isDisplayed(element2)) {
                isFound = true;
            } else {
                Helper.waitForSeconds(0.1);
            }
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!isFound && passedTimeInSeconds < (long)time);
        return isFound;
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2, EnhancedBy element3) {
        return this.waitForFirstElementToLoad(element1, element2, element3, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2, EnhancedBy element3, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        boolean isFound = false;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        do {
            if (Helper.isDisplayed(element1) || Helper.isDisplayed(element2) || Helper.isDisplayed(element3)) {
                isFound = true;
            } else {
                Helper.waitForSeconds(0.1);
            }
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!isFound && passedTimeInSeconds < (long)time);
        return isFound;
    }

    public boolean waitForAdditionalElementsToLoad(EnhancedBy target, int originalCount) {
        return this.waitForAdditionalElementsToLoad(target, originalCount, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForAdditionalElementsToLoad(final EnhancedBy target, final int originalCount, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        Helper.assertTrue("driver is null", AbstractDriver.getWebDriver() != null);
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Helper.list.getListCount(target) > originalCount;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForElementToBeRemoved(EnhancedBy target) {
        return this.waitForElementToBeRemoved(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeRemoved(EnhancedBy target, int time, int waitForTargetToLoadInSeconds) {
        this.waitForElementToLoad(target, 3);
        return this.waitForElementToBeRemoved(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeRemoved(EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        boolean isRemoved = false;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        do {
            if (!Helper.isDisplayed(target)) {
                isRemoved = true;
            } else {
                Helper.waitForSeconds(0.1);
            }
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!isRemoved && passedTimeInSeconds < (long)time);
        return isRemoved;
    }

    public void waitForSeconds(double seconds) {
        long miliseconds = (long)(seconds * 1000.0);
        Uninterruptibles.sleepUninterruptibly((long)miliseconds, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void waitForPageToLoad() {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        if (!Helper.isWebDriver()) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete");
            }
        };
        this.waitForCondition(condition, null, AbstractDriver.TIMEOUT_SECONDS);
    }

    public void waitForListItemToLoad_Contains(final EnhancedBy list, final String option) {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Helper.list.isContainedInList(list, option);
            }
        };
        this.waitForCondition(condition, list, AbstractDriver.TIMEOUT_SECONDS);
    }

    public void waitForTextToLoad(EnhancedBy target, String text) {
        this.waitForTextToLoad(target, AbstractDriver.TIMEOUT_SECONDS, text);
    }

    public void waitForTextToLoad(final EnhancedBy target, int time, final String text) {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Element.findElements(target).getText().contains(text);
            }
        };
        this.waitForCondition(condition, target, time);
    }

    public boolean waitForElementToBeClickable(EnhancedBy selector) {
        return this.waitForElementToBeClickable(selector, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeClickable(final EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                return elements.count() >= 1 && elements.isEnabled();
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForClassContain(EnhancedBy target, int index, String value) {
        return this.waitForClassContain(target, index, value, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForClassContain(final EnhancedBy target, final int index, final String value, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                return elements.getAttribute(index, "class").contains(value);
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForAnyTextToLoadContaining(EnhancedBy target, String ... text) {
        return this.waitForAnyTextToLoadContaining(target, AbstractDriver.TIMEOUT_SECONDS, text);
    }

    public boolean waitForAnyTextToLoadContaining(final EnhancedBy target, int time, final String ... text) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                String actualValue = elements.getText();
                for (String value : text) {
                    if (!actualValue.contains(value)) continue;
                    return true;
                }
                return false;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForAnyTextToLoad(EnhancedBy target, String ... text) {
        return this.waitForAnyTextToLoad(target, AbstractDriver.TIMEOUT_SECONDS, text);
    }

    public boolean waitForAnyTextToLoad(final EnhancedBy target, int time, final String ... text) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                String actualValue = elements.getText();
                for (String value : text) {
                    if (!actualValue.equals(value)) continue;
                    return true;
                }
                return false;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForCondition(ExpectedCondition<Boolean> condition, EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        this.waitAllJSRequests(time);
        FluentWait wait = new WebDriverWait(AbstractDriver.getWebDriver(), Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).withTimeout(Duration.ofSeconds(time)).ignoring(Exception.class);
        try {
            wait.until(condition);
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS && target != null) {
                AssertHelper.assertTrue("element: " + target.name + " did not meet condition in allowed time (s) " + time, false);
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public boolean waitForCondition2(ExpectedCondition<WebElement> condition2, EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        this.waitAllJSRequests(time);
        FluentWait wait = new WebDriverWait(AbstractDriver.getWebDriver(), Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).withTimeout(Duration.ofSeconds(time)).ignoring(Exception.class);
        try {
            wait.until(condition2);
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS && target != null) {
                AssertHelper.assertTrue("element: " + target.name + " did not meet condition in allowed time (s) " + time, false);
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public void ajaxComplete() {
        JavascriptExecutor jsExec = (JavascriptExecutor)AbstractDriver.getWebDriver();
        try {
            jsExec.executeScript("var callback = arguments[arguments.length - 1];var xhr = new XMLHttpRequest();xhr.open('GET', '/Ajax_call', true);xhr.onreadystatechange = function() {  if (xhr.readyState == 4) {    callback(xhr.responseText);  }};xhr.send();", new Object[0]);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void waitForJQueryLoad(int time) {
        WebDriverWait jsWait = new WebDriverWait(AbstractDriver.getWebDriver(), Duration.ofSeconds(time));
        JavascriptExecutor jsExec = (JavascriptExecutor)AbstractDriver.getWebDriver();
        try {
            ExpectedCondition jQueryLoad = driver -> (Long)((JavascriptExecutor)AbstractDriver.getWebDriver()).executeScript("return jQuery.active", new Object[0]) == 0L;
            boolean jqueryReady = (Boolean)jsExec.executeScript("return jQuery.active==0", new Object[0]);
            if (!jqueryReady) {
                jsWait.until((Function)jQueryLoad);
            }
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    public void waitForAngularLoad(int time) {
        String angularReadyScript = "return angular.element(document).injector().get('$http').pendingRequests.length === 0";
        this.angularLoads(angularReadyScript, time);
    }

    public void waitUntilJSReady(int time) {
        WebDriverWait jsWait = new WebDriverWait(AbstractDriver.getWebDriver(), Duration.ofSeconds(time));
        JavascriptExecutor jsExec = (JavascriptExecutor)AbstractDriver.getWebDriver();
        try {
            ExpectedCondition jsLoad = driver -> ((JavascriptExecutor)AbstractDriver.getWebDriver()).executeScript("return document.readyState", new Object[0]).toString().equals("complete");
            Boolean jsReady = jsExec.executeScript("return document.readyState", new Object[0]).toString().equals("complete");
            if (!jsReady.booleanValue()) {
                jsWait.until((Function)jsLoad);
            }
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    public void waitUntilJQueryReady(int time) {
        try {
            JavascriptExecutor jsExec = (JavascriptExecutor)AbstractDriver.getWebDriver();
            Boolean jQueryDefined = (Boolean)jsExec.executeScript("return typeof jQuery != 'undefined'", new Object[0]);
            if (jQueryDefined == null) {
                return;
            }
            if (jQueryDefined.booleanValue()) {
                Helper.waitForSeconds(0.02);
                this.waitForJQueryLoad(time);
                Helper.waitForSeconds(0.2);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void waitUntilAngularReady(int time) {
        JavascriptExecutor jsExec = (JavascriptExecutor)AbstractDriver.getWebDriver();
        try {
            Boolean angularUnDefined = (Boolean)jsExec.executeScript("return window.angular === undefined", new Object[0]);
            if (angularUnDefined == null) {
                return;
            }
            if (!angularUnDefined.booleanValue()) {
                Boolean angularInjectorUnDefined = (Boolean)jsExec.executeScript("return angular.element(document).injector() === undefined", new Object[0]);
                if (angularInjectorUnDefined == null) {
                    return;
                }
                if (!angularInjectorUnDefined.booleanValue()) {
                    Helper.waitForSeconds(0.02);
                    this.waitForAngularLoad(time);
                    Helper.waitForSeconds(0.02);
                }
            }
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    public void waitUntilAngular5Ready(int time) {
        JavascriptExecutor jsExec = (JavascriptExecutor)AbstractDriver.getWebDriver();
        try {
            Object angular5Check = jsExec.executeScript("return getAllAngularRootElements()[0].attributes['ng-version']", new Object[0]);
            if (angular5Check != null) {
                Boolean angularPageLoaded = (Boolean)jsExec.executeScript("return window.getAllAngularTestabilities().findIndex(x=>!x.isStable()) === -1", new Object[0]);
                if (angularPageLoaded == null) {
                    return;
                }
                if (!angularPageLoaded.booleanValue()) {
                    Helper.waitForSeconds(0.02);
                    this.waitForAngular5Load(time);
                    Helper.waitForSeconds(0.02);
                }
            }
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    public void waitForAngular5Load(int time) {
        String angularReadyScript = "return window.getAllAngularTestabilities().findIndex(x=>!x.isStable()) === -1";
        this.angularLoads(angularReadyScript, time);
    }

    public void angularLoads(String angularReadyScript, int time) {
        WebDriverWait jsWait = new WebDriverWait(AbstractDriver.getWebDriver(), Duration.ofSeconds(time));
        JavascriptExecutor jsExec = (JavascriptExecutor)AbstractDriver.getWebDriver();
        try {
            ExpectedCondition angularLoad = driver -> Boolean.valueOf(((JavascriptExecutor)driver).executeScript(angularReadyScript, new Object[0]).toString());
            Boolean angularReady = Boolean.valueOf(jsExec.executeScript(angularReadyScript, new Object[0]).toString());
            if (angularReady == null) {
                return;
            }
            if (!angularReady.booleanValue()) {
                jsWait.until((Function)angularLoad);
            }
        }
        catch (WebDriverException webDriverException) {
            // empty catch block
        }
    }

    public void waitAllJSRequests(int time) {
        if (Helper.mobile.isWebDriver() && Config.getBooleanValue("global.web.JsWait.enabled").booleanValue()) {
            this.waitUntilJSReady(time);
            this.waitUntilJQueryReady(time);
            this.waitUntilAngularReady(time);
            this.waitUntilAngular5Ready(time);
        }
    }
}

