/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.AssertHelper;
import core.helpers.Element;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.uiCore.driverProperties.browserType;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.InteractsWithApps;
import io.appium.java_client.MultiTouchAction;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.SupportsLegacyAppManagement;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.nativekey.AndroidKey;
import io.appium.java_client.android.nativekey.KeyEvent;
import io.appium.java_client.imagecomparison.OccurrenceMatchingResult;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.remote.SupportsContextSwitching;
import io.appium.java_client.remote.SupportsLocation;
import io.appium.java_client.touch.LongPressOptions;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.ElementOption;
import io.appium.java_client.touch.offset.PointOption;
import io.appium.java_client.windows.WindowsDriver;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.remote.RemoteWebElement;

public class MobileHelper {
    private static final String DISMISS_IF_BLOCKING = "ios.keyboard.dismissIfBlocking";
    private static final String DISMISS_BY_KEY_PRESS = "ios.keyboard.dismissByKeyPress";
    private static final String DISMISS_STRATEGY = "ios.keyboard.dismiss.Strategy";

    public AppiumDriver getAppiumDriver() {
        return (AppiumDriver)AbstractDriver.getWebDriver();
    }

    public AndroidDriver getAndroidDriver() {
        return (AndroidDriver)AbstractDriver.getWebDriver();
    }

    public IOSDriver getiOSDriver() {
        return (IOSDriver)AbstractDriver.getWebDriver();
    }

    public void hideKeyboard() {
        if (this.isIOS()) {
            this.dimissIosKeyboard();
        } else if (this.isAndroid()) {
            this.dimissAndroidKeyboard();
        }
    }

    public void smartHideKeyboard(EnhancedBy element) {
        boolean enableSmartDismissKeyboard = Config.getBooleanValue(DISMISS_IF_BLOCKING);
        if (!enableSmartDismissKeyboard) {
            return;
        }
        if (!Helper.isPresent(element)) {
            this.dimissIosKeyboard();
        }
    }

    public void pressEnterOnAndroid() {
        if (this.isAndroid()) {
            this.getAndroidDriver().pressKey(new KeyEvent(AndroidKey.ENTER));
        }
    }

    public void resetApp() {
        ((SupportsLegacyAppManagement)this.getAppiumDriver()).resetApp();
        TestLog.logPass("I reset the app", new Object[0]);
    }

    public void refreshMobileApp() {
        if (this.isMobile()) {
            ((InteractsWithApps)this.getAppiumDriver()).runAppInBackground(Duration.ofSeconds(1L));
        }
    }

    public boolean isMobile() {
        return AbstractDriver.getWebDriver() instanceof AppiumDriver;
    }

    public boolean isIOS() {
        return AbstractDriver.getWebDriver() instanceof IOSDriver;
    }

    public boolean isAndroid() {
        return AbstractDriver.getWebDriver() instanceof AndroidDriver;
    }

    public boolean isWinApp() {
        return AbstractDriver.getWebDriver() instanceof WindowsDriver;
    }

    public boolean isWebDriver() {
        if (this.isIOS() || this.isAndroid()) {
            return false;
        }
        return AbstractDriver.getWebDriver() instanceof WebDriver;
    }

    public boolean isIeExplorer() {
        if (this.isIOS() || this.isAndroid()) {
            return false;
        }
        if (!this.isWebDriver()) {
            return false;
        }
        String browser = Config.getValue("web.browserType");
        return browser.equals(browserType.BrowserType.INTERNET_EXPLORER.name());
    }

    public void setLocation(Location location) {
        ((SupportsLocation)this.getAppiumDriver()).setLocation(location);
    }

    @Deprecated
    private void scrollToiOS(EnhancedBy element) {
        if (this.isIOS()) {
            try {
                EnhancedWebElement targetElement = Element.findElements(element);
                JavascriptExecutor js = (JavascriptExecutor)AbstractDriver.getWebDriver();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("element", ((RemoteWebElement)targetElement.get(0)).getId());
                params.put("toVisible", "true");
                js.executeScript("mobile: scroll", new Object[]{params});
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
    }

    @Deprecated
    private boolean swipeToDirection_iOS_XCTest(EnhancedBy element, String direction) {
        try {
            EnhancedWebElement targetElement = Element.findElements(element);
            JavascriptExecutor js = (JavascriptExecutor)AbstractDriver.getWebDriver();
            HashMap<String, String> swipeObject = new HashMap<String, String>();
            if (direction.equals("d")) {
                swipeObject.put("direction", "down");
            } else if (direction.equals("u")) {
                swipeObject.put("direction", "up");
            } else if (direction.equals("l")) {
                swipeObject.put("direction", "left");
            } else if (direction.equals("r")) {
                swipeObject.put("direction", "right");
            }
            swipeObject.put("element", ((RemoteWebElement)targetElement.get(0)).getId());
            js.executeScript("mobile:swipe", new Object[]{swipeObject});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    private boolean scrollToDirection_iOS_XCTest(EnhancedBy element, String direction) {
        try {
            EnhancedWebElement targetElement = Element.findElements(element);
            JavascriptExecutor js = (JavascriptExecutor)AbstractDriver.getWebDriver();
            HashMap<String, String> scrollObject = new HashMap<String, String>();
            if (direction.equals("d")) {
                scrollObject.put("direction", "down");
            } else if (direction.equals("u")) {
                scrollObject.put("direction", "up");
            } else if (direction.equals("l")) {
                scrollObject.put("direction", "left");
            } else if (direction.equals("r")) {
                scrollObject.put("direction", "right");
            }
            scrollObject.put("element", ((RemoteWebElement)targetElement.get(0)).getId());
            scrollObject.put("toVisible", "true");
            js.executeScript("mobile:scroll", new Object[]{scrollObject});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void mobile_swipeRight(double durationInSeconds) {
        this.swipe(null, 0, DIRECTION.RIGHT, durationInSeconds);
    }

    public void mobile_swipeRight(EnhancedBy element, int index, double durationInSeconds) {
        this.swipe(element, 0, DIRECTION.RIGHT, durationInSeconds);
    }

    public void mobile_swipeLeft(double durationInSeconds) {
        this.swipe(null, 0, DIRECTION.LEFT, durationInSeconds);
    }

    public void mobile_swipeLeft(EnhancedBy element, int index, double durationInSeconds) {
        this.swipe(element, 0, DIRECTION.LEFT, durationInSeconds);
    }

    public void mobile_swipeUp(double durationInSeconds) {
        this.swipe(null, 0, DIRECTION.UP, durationInSeconds);
    }

    public void mobile_swipeUp(EnhancedBy element, int index, double durationInSeconds) {
        this.swipe(element, 0, DIRECTION.UP, durationInSeconds);
    }

    public void mobile_swipeDown(double durationInSeconds) {
        this.swipe(null, 0, DIRECTION.DOWN, durationInSeconds);
    }

    public void mobile_swipeDown(EnhancedBy element, int index, double durationInSeconds) {
        this.swipe(element, 0, DIRECTION.DOWN, durationInSeconds);
    }

    public OccurrenceMatchingResult findImageOccurrence(File fullImage, File partialImage) {
        try {
            return this.getAppiumDriver().findImageOccurrence(fullImage, partialImage);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setAppiumContexts(String context) {
        TestLog.logPass("I set context to '" + context + "'", new Object[0]);
        Set contextNames = ((SupportsContextSwitching)this.getAppiumDriver()).getContextHandles();
        for (String contextName : contextNames) {
            if (!contextName.contains(context)) continue;
            ((SupportsContextSwitching)this.getAppiumDriver()).context(contextName);
            break;
        }
    }

    public Set<String> mobile_getContextList() {
        Set contextNames = ((SupportsContextSwitching)this.getAppiumDriver()).getContextHandles();
        return contextNames;
    }

    public void mobile_switchToNativeView() {
        this.setAppiumContexts("NATIVE");
    }

    public void mobile_switchToWebView() {
        this.setAppiumContexts("WEBVIEW");
    }

    public void mobile_switchToView(String view) {
        this.setAppiumContexts(view);
    }

    public void switchWindowsHandle(int index) {
        Set windowHandles = this.getAppiumDriver().getWindowHandles();
        ArrayList windowStrings = new ArrayList(windowHandles);
        this.getAppiumDriver().switchTo().window((String)windowStrings.get(index));
    }

    public void mobile_longPress(EnhancedBy target, long miliSeconds) {
        int retry = 0;
        Helper.wait.waitForElementToLoad(target, 5);
        this.longPress(target, miliSeconds + (long)(++retry * 2));
        Helper.wait.waitForElementToBeRemoved(target, 5);
    }

    public void mobile_longPressAndExpect(EnhancedBy target, long miliSeconds, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToBeClickable(target, 10);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = 0;
        do {
            ++retry;
            if (Helper.isPresent(target)) {
                this.longPress(target, miliSeconds + (long)(retry * 2));
            }
            Helper.wait.waitForSeconds(0.5);
        } while (!(isExpectedFound = Helper.wait.waitForElementToBeClickable(expected, targetWaitTimeInSeconds)) && retry < 3);
        AssertHelper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void longPress(EnhancedBy target, long miliSeconds) {
        try {
            EnhancedWebElement targetElement = Element.findElements(target);
            TouchAction action = new TouchAction((PerformsTouchActions)this.getAppiumDriver());
            action.longPress(((LongPressOptions)LongPressOptions.longPressOptions().withElement(ElementOption.element((WebElement)targetElement.get(0)))).withDuration(Duration.ofMillis(miliSeconds))).release().perform();
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void longPress(int x, int y, long miliSeconds) {
        try {
            PointOption point = new PointOption().withCoordinates(x, y);
            TouchAction action = new TouchAction((PerformsTouchActions)this.getAppiumDriver());
            action.longPress(((LongPressOptions)LongPressOptions.longPressOptions().withPosition(point)).withDuration(Duration.ofMillis(miliSeconds))).release().perform();
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public void mobile_zoomOut(int zoomLevel) {
        for (int i = 0; i < zoomLevel; ++i) {
            this.mobile_zoom("out");
        }
    }

    public void mobile_zoomOut(EnhancedBy indicator) {
        for (int retry = 15; !Helper.isPresent(indicator) && retry > 0; --retry) {
            this.mobile_zoomOut(1);
            Helper.wait.waitForSeconds(1.0);
        }
        Helper.wait.waitForSeconds(1.0);
        TestLog.logPass("I zoom out to " + indicator.name, new Object[0]);
    }

    public void mobile_zoomIn(EnhancedBy indicator) {
        for (int retry = 10; !Helper.isPresent(indicator) && retry > 0; --retry) {
            this.mobile_zoomIn(1);
            Helper.wait.waitForSeconds(0.3);
        }
        TestLog.logPass("I zoom in to " + indicator.name, new Object[0]);
    }

    public void mobile_zoomIn(int zoomLevel) {
        for (int i = 0; i < zoomLevel; ++i) {
            this.mobile_zoom("in");
        }
    }

    public void mobile_zoom(String inOut) {
        int screenHeight = this.getAppiumDriver().manage().window().getSize().getHeight();
        int screenWidth = this.getAppiumDriver().manage().window().getSize().getWidth();
        MultiTouchAction multiTouchAction = new MultiTouchAction((PerformsTouchActions)this.getAppiumDriver());
        TouchAction touchAction0 = new TouchAction((PerformsTouchActions)this.getAppiumDriver());
        TouchAction touchAction1 = new TouchAction((PerformsTouchActions)this.getAppiumDriver());
        switch (inOut) {
            case "out": {
                touchAction0.press(PointOption.point((int)(screenWidth / 2 + 100), (int)(screenHeight / 2 + 100))).moveTo(PointOption.point((int)(screenWidth / 2 + 95), (int)(screenWidth / 2 + 95))).release();
                touchAction1.press(PointOption.point((int)(screenWidth / 2 - 100), (int)(screenHeight / 2 - 100))).moveTo(PointOption.point((int)(screenWidth / 2 - 95), (int)(screenWidth / 2 - 95))).release();
                break;
            }
            case "in": {
                touchAction0.press(PointOption.point((int)(screenWidth / 2 - 5), (int)(screenHeight / 2 - 5))).moveTo(PointOption.point((int)(screenWidth / 2 - 10), (int)(screenWidth / 2 - 10))).release();
                touchAction1.press(PointOption.point((int)(screenWidth / 2 + 5), (int)(screenHeight / 2 + 5))).moveTo(PointOption.point((int)(screenWidth / 2 + 10), (int)(screenWidth / 2 + 10))).release();
                break;
            }
        }
        multiTouchAction.add(touchAction0).add(touchAction1).perform();
        Helper.wait.waitForSeconds(0.5);
    }

    public void scrollDown() {
        int pressX = AbstractDriver.getWebDriver().manage().window().getSize().width / 8;
        int bottomY = AbstractDriver.getWebDriver().manage().window().getSize().height * 3 / 6;
        int topY = AbstractDriver.getWebDriver().manage().window().getSize().height / 6;
        this.scroll(pressX, bottomY, pressX, topY);
        Helper.wait.waitForSeconds(1.0);
    }

    public void scrollDownFromCenter() {
        int pressX = AbstractDriver.getWebDriver().manage().window().getSize().width / 2;
        int bottomY = AbstractDriver.getWebDriver().manage().window().getSize().height * 4 / 6;
        int topY = AbstractDriver.getWebDriver().manage().window().getSize().height / 6;
        this.scroll(pressX, bottomY, pressX, topY);
        Helper.wait.waitForSeconds(1.0);
    }

    public void scroll(int fromX, int fromY, int toX, int toY) {
        TouchAction touchAction = new TouchAction((PerformsTouchActions)AbstractDriver.getWebDriver());
        touchAction.longPress((LongPressOptions)LongPressOptions.longPressOptions().withPosition(PointOption.point((int)fromX, (int)fromY))).moveTo(PointOption.point((int)toX, (int)toY)).release().perform();
    }

    public void mobile_scrollToElement(EnhancedBy target) {
        if (this.isMobile()) {
            for (int scrollCount = 5; !Helper.isPresent(target) && scrollCount > 0; --scrollCount) {
                this.scrollDown();
                Helper.wait.waitForElementToLoad(target, 3);
            }
        }
    }

    public void mobile_scrollToElementWithRefresh(EnhancedBy target) {
        if (this.isMobile()) {
            for (int scrollCount = 5; !Helper.isPresent(target) && scrollCount > 0; --scrollCount) {
                this.scrollDown();
                this.tapAtCenterLeft();
                this.refreshMobileApp();
                Helper.wait.waitForElementToLoad(target, 3);
            }
        }
    }

    public void mobile_takePicture() {
        this.getAndroidDriver().pressKey(new KeyEvent(AndroidKey.CAMERA));
    }

    public void mobile_keyCode(int code) {
        this.getAndroidDriver().pressKey(new KeyEvent(AndroidKey.BACK));
    }

    public void mobile_backButton() {
        this.getAndroidDriver().pressKey(new KeyEvent(AndroidKey.BACK));
    }

    public void tapAtCenterLeft() {
        int leftX = AbstractDriver.getWebDriver().manage().window().getSize().width / 8;
        int centerY = AbstractDriver.getWebDriver().manage().window().getSize().height * 1 / 2;
        TouchAction touchAction = new TouchAction((PerformsTouchActions)AbstractDriver.getWebDriver());
        touchAction.tap(PointOption.point((int)leftX, (int)centerY)).perform();
    }

    public void tapAtCenterRight() {
        int leftX = (int)((double)AbstractDriver.getWebDriver().manage().window().getSize().width * 0.95);
        int centerY = AbstractDriver.getWebDriver().manage().window().getSize().height * 1 / 2;
        TouchAction touchAction = new TouchAction((PerformsTouchActions)AbstractDriver.getWebDriver());
        touchAction.tap(PointOption.point((int)leftX, (int)centerY)).perform();
    }

    private Map<String, Integer> setStarterPositionForSwipe(EnhancedBy element, int index, int startX, int startY) {
        HashMap<String, Integer> coordinates = new HashMap<String, Integer>();
        if (element == null) {
            coordinates.put("x", startX);
            coordinates.put("y", startY);
            return coordinates;
        }
        EnhancedWebElement targetElement = Element.findElements(element);
        Point p = targetElement.get(index).getLocation();
        coordinates.put("x", p.getX());
        coordinates.put("y", p.getY());
        return coordinates;
    }

    private void swipe(EnhancedBy element, int index, DIRECTION direction, double durationSec) {
        Dimension size = this.getAppiumDriver().manage().window().getSize();
        int startX = 0;
        int endX = 0;
        int startY = 0;
        int endY = 0;
        switch (direction) {
            case RIGHT: {
                startY = size.height / 2;
                startX = (int)((double)size.width * 0.9);
                endX = (int)((double)size.width * 0.05);
                Map<String, Integer> startPoint = this.setStarterPositionForSwipe(element, index, startX, startY);
                new TouchAction((PerformsTouchActions)this.getAppiumDriver()).press(PointOption.point((int)startPoint.get("x"), (int)startPoint.get("y"))).waitAction(WaitOptions.waitOptions((Duration)Duration.ofSeconds((long)durationSec))).moveTo(PointOption.point((int)endX, (int)startPoint.get("y"))).release().perform();
                break;
            }
            case LEFT: {
                startY = size.height / 2;
                startX = (int)((double)size.width * 0.05);
                endX = (int)((double)size.width * 0.9);
                Map<String, Integer> startPoint = this.setStarterPositionForSwipe(element, index, startX, startY);
                new TouchAction((PerformsTouchActions)this.getAppiumDriver()).press(PointOption.point((int)startPoint.get("x"), (int)startPoint.get("y"))).waitAction(WaitOptions.waitOptions((Duration)Duration.ofSeconds((long)durationSec))).moveTo(PointOption.point((int)endX, (int)startPoint.get("y"))).release().perform();
                break;
            }
            case UP: {
                endY = (int)((double)size.height * 0.7);
                startY = (int)((double)size.height * 0.3);
                startX = size.width / 2;
                Map<String, Integer> startPoint = this.setStarterPositionForSwipe(element, index, startX, startY);
                new TouchAction((PerformsTouchActions)this.getAppiumDriver()).press(PointOption.point((int)startPoint.get("x"), (int)startPoint.get("y"))).waitAction(WaitOptions.waitOptions((Duration)Duration.ofSeconds((long)durationSec))).moveTo(PointOption.point((int)endX, (int)startPoint.get("y"))).release().perform();
                break;
            }
            case DOWN: {
                startY = (int)((double)size.height * 0.7);
                endY = (int)((double)size.height * 0.3);
                startX = size.width / 2;
                Map<String, Integer> startPoint = this.setStarterPositionForSwipe(element, index, startX, startY);
                new TouchAction((PerformsTouchActions)this.getAppiumDriver()).press(PointOption.point((int)startPoint.get("x"), (int)startPoint.get("y"))).waitAction(WaitOptions.waitOptions((Duration)Duration.ofSeconds((long)durationSec))).moveTo(PointOption.point((int)startX, (int)endY)).release().perform();
            }
        }
    }

    private void dimissIosKeyboard() {
        if (this.isIOS()) {
            String dismissStrategy;
            EnhancedBy KEYBOARD_IOS = Element.byClass("XCUIElementTypeKeyboard", "Keyboard");
            if (!Element.findElements(KEYBOARD_IOS).isExist(new int[0])) {
                return;
            }
            block4 : switch (dismissStrategy = Config.getValue(DISMISS_STRATEGY)) {
                case "tapOutside": {
                    EnhancedWebElement targetElement = Element.findElements(KEYBOARD_IOS);
                    Point p = targetElement.get(0).getLocation();
                    int xPosition = 1;
                    int topY = p.getY() - 10;
                    TouchAction touchAction = new TouchAction((PerformsTouchActions)AbstractDriver.getWebDriver());
                    touchAction.tap(PointOption.point((int)xPosition, (int)topY)).perform();
                    break;
                }
                case "keyPress": {
                    ArrayList<String> keys = Config.getValueList(DISMISS_BY_KEY_PRESS);
                    for (String key : keys) {
                        EnhancedBy ios_keys = Element.byAccessibility(key, "keyboard key: " + key);
                        if (!Element.findElements(ios_keys).isExist(new int[0])) continue;
                        Helper.clickAndWait(ios_keys, 0.0);
                        break block4;
                    }
                    break;
                }
                default: {
                    this.getiOSDriver().hideKeyboard();
                }
            }
            if (!Element.findElements(KEYBOARD_IOS).isExist(new int[0])) {
                return;
            }
        }
    }

    private void dimissAndroidKeyboard() {
        if (!this.isAndroid()) {
            return;
        }
        this.getAndroidDriver().hideKeyboard();
    }

    public static enum DIRECTION {
        DOWN,
        UP,
        LEFT,
        RIGHT;

    }
}

