/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.driverProperties.globalProperties;

import core.apiCore.driver.ApiTestDriver;
import core.support.configReader.Config;

public class CrossPlatformProperties {
    private static String PARALLEL_TEST_COUNT = "global.parallelTestCount";
    private static String PARALLEL_TEST_TYPE = "global.parallelTestType";
    public static String RETRY_COUNT = "global.retryCount";
    private static String GLOBAL_TIMEOUT_SECONDS = "global.timeoutSeconds";
    private static String GLOBAL_TIMEOUT_IMPLICIT_SECONDS = "global.timeout.implicit.Seconds";
    private static String AUDIO_COMMENTARY = "report.audioCommentary";
    private static String IS_SINGLE_SIGNIN = "global.isSingleSignIn";
    private static String LANGUAGE = "language";
    private static String AUDIO_COMMENTARY_TYPE = "report.audioCommentaryType";
    private static String PATH = "environment.path";
    private static String ENABLE_BATCH_LOGGING = "report.enableBatchLogging";
    public static String LOCALIZATION_FILE = "localize.file";

    public static int getRetryCount() {
        if (ApiTestDriver.isRunningServiceTest()) {
            return 0;
        }
        return Config.getIntValue(RETRY_COUNT);
    }

    public static int getParallelTests() {
        return Config.getIntValue(PARALLEL_TEST_COUNT);
    }

    public static String getParallelTestType() {
        return Config.getValue(PARALLEL_TEST_TYPE);
    }

    public static int getGlobalTimeout() {
        return Config.getIntValue(GLOBAL_TIMEOUT_SECONDS);
    }

    public static int getGlobalTimeoutImplicitWait() {
        return Config.getIntValue(GLOBAL_TIMEOUT_IMPLICIT_SECONDS);
    }

    public static boolean getAudioCommentary() {
        return Config.getBooleanValue(AUDIO_COMMENTARY);
    }

    public static String getAudioCommentaryType() {
        return Config.getValue(AUDIO_COMMENTARY_TYPE);
    }

    public static String getPath() {
        return Config.getValue(PATH);
    }

    public static Boolean getEnableBatchLogging() {
        return Config.getBooleanValue(ENABLE_BATCH_LOGGING, false);
    }

    public static String getLocalizationFile() {
        return Config.getValue(LOCALIZATION_FILE);
    }

    public static String getLanguage() {
        return Config.getValue(LANGUAGE);
    }

    public static Boolean isSingleSignIn() {
        return Config.getBooleanValue(IS_SINGLE_SIGNIN);
    }

    public String getSimpleDriverType(String driverType2) {
        if (driverType2.toLowerCase().contains("web")) {
            return "web";
        }
        return driverType2.toLowerCase();
    }
}

