/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper;

import core.helpers.Helper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DataObjectHelper {
    public static String DATA_FOLDER = "data";
    public static String OBJECT_FOLDER = "object";
    private static String SOURCE_PATH = Helper.getFullPath("src" + File.separator + "main");

    public static List<File> getAllCsvDataFiles() {
        List<File> files = new ArrayList<File>();
        files = Helper.getFileListWithSubfolders(SOURCE_PATH, ".csv", files);
        files = DataObjectHelper.getTestDataCsvFiles(files);
        return files;
    }

    public static List<File> getTestDataCsvFiles(List<File> files) {
        ArrayList<File> dataFiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.getAbsolutePath().contains(DATA_FOLDER) && !file.getAbsolutePath().contains(OBJECT_FOLDER)) continue;
            dataFiles.add(file);
        }
        return dataFiles;
    }

    public static String normalizeMethod(String methodName) {
        String method = DataObjectHelper.capitalizeMethod(methodName, "\\.");
        method = DataObjectHelper.capitalizeMethod(method, "-");
        method = DataObjectHelper.capitalizeMethod(method, "_");
        method = DataObjectHelper.capitalizeMethod(method, "@");
        if (Character.isDigit((method = DataObjectHelper.capitalizeMethod(method, " ")).charAt(0))) {
            method = "method" + method;
        }
        return method;
    }

    private static String capitalizeMethod(String methodName, String splitter) {
        String methodNormalize = "";
        String[] words = methodName.split(splitter);
        for (int i = 1; i < words.length; ++i) {
            methodNormalize = methodNormalize + StringUtils.capitalize((String)words[i]);
        }
        methodNormalize = words[0] + methodNormalize;
        return methodNormalize;
    }
}

