/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import com.thoughtworks.paranamer.AnnotationParanamer;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.objects.KeyValue;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExternalClassHelper {
    public static Object runInternalClass(String sourcePath, String methodName, List<KeyValue> parameterList) throws Exception {
        Class<?> externalClass = Class.forName(sourcePath);
        Object[] parameters = ExternalClassHelper.getParameterValues(parameterList);
        Object[] parameterNames = ExternalClassHelper.getParameterNames(parameterList);
        Class<?>[] paramTypes = ExternalClassHelper.getMethodParameterTypes(externalClass, methodName, parameters, parameterNames);
        parameters = ExternalClassHelper.convertObjectToMethodType(paramTypes, parameters);
        Method method = externalClass.getMethod(methodName, paramTypes);
        Object object = method.invoke(externalClass, parameters);
        return object;
    }

    private static Object[] convertObjectToMethodType(Class<?>[] paramTypes, Object[] parameterValues) {
        Object[] paramArr = new Object[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            paramArr[i] = ExternalClassHelper.convertToDataType(paramTypes[i], parameterValues[i]);
        }
        return paramArr;
    }

    private static Object convertToDataType(Class<?> type, Object value) {
        if (type.toString().contains("java.util.ArrayList")) {
            String[] parameterList;
            ArrayList<String> parameterListReconstruct = new ArrayList<String>();
            value = value.toString().replace("[", "").replace("]", "");
            for (String listItem : parameterList = value.toString().split(",")) {
                parameterListReconstruct.add(listItem.toString().trim());
            }
            return parameterListReconstruct;
        }
        if (type.toString().contains("java.lang.String")) {
            return value.toString();
        }
        return JsonHelper.convertToObject(value.toString(), false);
    }

    private static Class<?>[] getMethodParameterTypes(Class<?> external, String methodName, Object[] parameterList, Object[] parameterNames) {
        CachingParanamer info = new CachingParanamer((Paranamer)new AnnotationParanamer((Paranamer)new BytecodeReadingParanamer()));
        ArrayList<String> matchingMethodList = new ArrayList<String>();
        ArrayList<String> methodList = new ArrayList<String>();
        boolean isParameterNamesMatch = true;
        for (Method m : external.getMethods()) {
            methodList.add(m.getName());
            if (!m.getName().equals(methodName)) continue;
            Object[] targetParameterNames = info.lookupParameterNames((AccessibleObject)m);
            matchingMethodList.add("method: " + m.getName() + "(" + Arrays.toString(targetParameterNames) + ")");
            if (parameterNames.length != 0) {
                isParameterNamesMatch = ExternalClassHelper.isParameterNamesMatch(parameterNames, targetParameterNames);
            }
            if (m.getParameterCount() != parameterList.length || !isParameterNamesMatch) continue;
            Class<?>[] params = m.getParameterTypes();
            return params;
        }
        if (!matchingMethodList.isEmpty()) {
            Helper.assertFalse("method name found, however, method with correct parameters not found: " + methodName + "(" + Arrays.toString(parameterList) + ") not found. methods found: " + Arrays.toString(matchingMethodList.toArray()));
        } else {
            Helper.assertFalse("method: " + methodName + " not found at: " + external.getPackage() + " . methods found: " + Arrays.toString(methodList.toArray()));
        }
        return null;
    }

    private static Object[] getParameterValues(List<KeyValue> parameters) {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        boolean isParameterNamesProvided = ExternalClassHelper.isParameterNamesProvided(parameters);
        for (KeyValue parameter : parameters) {
            if (isParameterNamesProvided) {
                parameterList.add(parameter.value);
                continue;
            }
            parameterList.add(parameter.key);
        }
        Object[] paramArr = new String[parameterList.size()];
        for (int i = 0; i < parameterList.size(); ++i) {
            paramArr[i] = parameterList.get(i);
        }
        return paramArr;
    }

    protected static Object[] getParameterNames(List<KeyValue> parameters) {
        ArrayList<String> parameterList = new ArrayList<String>();
        boolean isParameterNamesProvided = ExternalClassHelper.isParameterNamesProvided(parameters);
        for (KeyValue parameter : parameters) {
            if (!isParameterNamesProvided) continue;
            parameterList.add(parameter.key);
        }
        String[] paramArr = new String[parameterList.size()];
        return parameterList.toArray(paramArr);
    }

    protected static boolean isParameterNamesProvided(List<KeyValue> paramters) {
        boolean isParameterNamesSet = false;
        for (KeyValue parameter : paramters) {
            if (parameter.key.isEmpty() || parameter.value.toString().isEmpty()) continue;
            return true;
        }
        return isParameterNamesSet;
    }

    protected static boolean isParameterNamesMatch(Object[] parameterNames, Object[] parameterList) {
        String parameterNamesString = Arrays.toString(parameterNames);
        String parameterListString = Arrays.toString(parameterList);
        return parameterNamesString.equals(parameterListString);
    }
}

