/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.manager;

import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Date;
import javax.tools.JavaFileObject;

public class sourceChangeDetector {
    public static final String SOURCE_CHANGE_DETECTOR_CLASS_NAME = "SourceChangeDetector";

    public static void writeModuleBaseClass() {
        try {
            sourceChangeDetector.writeSourceChangeDetectorClass();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeSourceChangeDetectorClass() throws IOException {
        Logger.debug("start generating source change detector class");
        String sourceChangeePath = "marker.SourceChangeDetector";
        JavaFileObject file = FileCreatorHelper.createFileAbsolutePath(sourceChangeePath);
        BufferedWriter bw = new BufferedWriter(file.openWriter());
        Date currentDate = new Date();
        bw.append("/**Auto generated code,don't modify it.\n");
        bw.append("* Author             ---- > Auto Generated.\n");
        bw.append("* Date  And Time     ---- > " + currentDate.toString() + "\n");
        bw.append("*");
        bw.append("**/\n\n\n\n");
        bw.append("package marker;\n");
        bw.newLine();
        bw.newLine();
        bw.append("import java.io.File;\nimport java.io.IOException;\nimport java.net.URISyntaxException;\nimport java.nio.file.Files;\nimport java.nio.file.Paths;\nimport java.util.ArrayList;\nimport java.util.Arrays;\nimport java.util.List;\n\n\n\npublic class SourceChangeDetector {\n\n\tpublic static String GENERATED_SOURCE_DIR = getRootDir() + \"target\" + File.separator + \"generated-sources\"\n\t\t\t+ File.separator;\n\n\tpublic static String SOURCE_DIR = getRootDir() + \"src\" + File.separator + \"main\";\n\tpublic static String RESOURCE_DIR = getRootDir() + \"resources\" + File.separator;\n\tpublic static String MARKER_FILE = GENERATED_SOURCE_DIR + \"annotations\" + File.separator + \"marker\" + File.separator + \"marker.java\";\n\tpublic static String MAVEN_STATUS_DIR = getRootDir() + \"target\" + File.separator + \"maven-status\";\n\n\t\n\t\n\tpublic static void main(String[] args) {\n\t\thasSourceChanged();\n\t\tSystem.out.println(\"<<<<<<<<< running test file change class >>>>>>>>>\");\n\t}\n\n\tpublic static boolean hasSourceChanged() {\n\t\t\n\t\t// has source directory changed\n\t\tboolean hasSourceChanged = hasSourceDirChanged();\n\n\t\t// is marker file available\n\t\tboolean isMarker = new File(MARKER_FILE).exists();\n\n\t\t// if change detected\n\t\tif (hasSourceChanged || !isMarker) {\n\t\t\tSystem.out.println(\"************ Changes detected, initiating new source generation ************\");\n\n\t\t\t// delete maven status dir and marker (to indicated maven needs to generate new code)\n\t\t\tdeleteFile(MARKER_FILE);\n\t\t\tdeleteFile(MAVEN_STATUS_DIR);\n\n\t\t\treturn true;\n\t\t}\n\n\t\treturn false;\n\t}\n\t\n\tprivate static boolean hasSourceDirChanged() {\n\t\t// get list of all files in src and resource directories\n\t\tArrayList<String> sourceListStringArray = getSourceFileList();\n\n\t\tString targetFile = GENERATED_SOURCE_DIR + \"src_dir.txt\";\n\t\tString oldFileList = \"\";\n\t\tboolean hasSourceChanged = true;\n\n\t\tif (new File(targetFile).exists()) {\n\t\t\toldFileList = getFileContent(targetFile);\n\t\t\tArrayList<String> oldDirList = new ArrayList<String>(Arrays.asList(oldFileList.split(\",\")));\n\t\t\thasSourceChanged = hasChangeDetected(oldDirList, sourceListStringArray);\n\t\t}\n\n\t\treturn hasSourceChanged;\n\t}\n\n\t/**\n\t * get list of all files in src and resource directories get src and resource\n\t * directory list, String format separated by \",\"\n\t * \n\t * @return\n\t */\n\tprivate static ArrayList<String> getSourceFileList() {\n\n\t\tSystem.out.println(\"sourceDir : \" + SOURCE_DIR);\n\t\tSystem.out.println(\"keywordDir : \" + RESOURCE_DIR);\n\n\t\t// get all files including sub directories\n\t\tArrayList<String> sourceList = getFileList(SOURCE_DIR);\n\t\tArrayList<String> keywordList = getFileList(RESOURCE_DIR);\n\t\tsourceList.addAll(keywordList);\n\t\tArrayList<String> sourceListStringArray = getFileString(sourceList);\n\n\t\treturn sourceListStringArray;\n\t}\n\n\tprivate static boolean hasChangeDetected(ArrayList<String> oldDirList, ArrayList<String> newDirList) {\n\t\tString oldDir = String.join(\", \", oldDirList);\n\t\tString newDir = String.join(\", \", newDirList);\n\t\tList<String> differenceList = listDifference(oldDirList, newDirList);\n\t\tboolean hasChanged = !oldDir.equals(newDir);\n\n\t\tif (hasChanged) {\n\t\t\tSystem.out.println(\"changes in (src, or keyword) directory detected: \\n\" + \" changes: \");\n\t\t\tdifferenceList.forEach(System.out::println);\n\t\t}\n\n\t\treturn hasChanged;\n\t}\n\n\tprivate static ArrayList<String> listDifference(ArrayList<String> oldDirList, ArrayList<String> newDirList) {\n\t\tList<String> newList = new ArrayList<>(newDirList);\n\t\tnewDirList.removeAll(oldDirList);\n\t\toldDirList.removeAll(newList);\n\n\t\tnewDirList.addAll(oldDirList);\n\n\t\treturn newDirList;\n\t}\n\n\tprivate static ArrayList<String> getFileList(String directory) {\n\t\tArrayList<String> array = new ArrayList<String>();\n\t\tFile file = new File(directory);\n\t\tarray = getFileList(file, array);\n\t\treturn array;\n\t}\n\n\t/**\n\t * convert the file list to a string with absolute file names, separated by \",\"\n\t * \n\t * @param list\n\t * @return\n\t */\n\tprivate static ArrayList<String> getFileString(ArrayList<String> list) {\n\t\tArrayList<String> dirList = new ArrayList<String>();\n\n\t\tfor (String file : list) {\n\t\t\tdirList.add(file);\n\t\t}\n\t\treturn dirList;\n\t}\n\n\t/**\n\t * gets all files in a directory to get all files: File curDir = new File(\".\");\n\t * getAllFiles(curDir);\n\t * \n\t * @param curDir target directory\n\t * @return the list of all files in given directory\n\t */\n\tprivate static ArrayList<String> getFileList(File curDir, ArrayList<String> array) {\n\t\tFile[] filesList = curDir.listFiles();\n\t\tfor (File f : filesList) {\n\t\t\tif (f.isDirectory())\n\t\t\t\tgetFileList(f, array);\n\t\t\tif (f.isFile()) {\n\t\t\t\tarray.add(f.getPath());\n\t\t\t}\n\t\t}\n\t\treturn array;\n\t}\n\n\tprivate static String getRootDir() {\n\t\tString root = \"\";\n\t\ttry {\n\t\t\troot = new File(SourceChangeDetector.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile()\n\t\t\t\t\t.getParent();\n\t\t} catch (URISyntaxException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\t\treturn root + File.separator;\n\t}\n\n\tprivate static String getFileContent(String absolutePath) {\n\t\tString content = \"\";\n\t\tFile file = new File(absolutePath);\n\n\t\t// return empty if file does not exist\n\t\tif (!file.exists())\n\t\t\treturn content;\n\n\t\ttry {\n\t\t\tcontent = new String(Files.readAllBytes(Paths.get(absolutePath)));\n\t\t} catch (IOException e) {\n\t\t\te.printStackTrace();\n\t\t}\n\n\t\treturn content;\n\t}\n\n\tprivate static void deleteFile(String absolutePath) {\n\t\tFile file = new File(absolutePath);\n\t\tif(file.isDirectory()) {\n\t\t\tFile fileDir = new File(absolutePath);\n\t\t\tdeleteDirectory(fileDir);\n\t\t}else\n\t\t\tdeleteSingleFile(absolutePath);\n\t}\n\n\tprivate static void deleteDirectory(File file) {\n\t    File[] contents = file.listFiles();\n\t    if (contents != null) {\n\t        for (File f : contents) {\n\t            \tdeleteDirectory(f);\n\t        }\n\t    }\n\t    file.delete();\n\t}\n\t\n\tprivate static void deleteSingleFile(String absolutePath) {\n\t\tFile file = new File(absolutePath);\n\t\tfile.delete();\n\t}\n}");
        bw.flush();
        bw.close();
        Logger.debug("complete generating module base class");
    }
}

