/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.legacy;

import core.helpers.Element;
import core.helpers.legacy.Helper;
import core.support.listeners.TestListener;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class DriverLegacy {
    public static EnhancedBy getEnhancedElement(WebElement target) {
        List<String[]> locators = DriverLegacy.getLocator(target);
        EnhancedBy element = DriverLegacy.setEnhancedElement(locators);
        return element;
    }

    protected static List<String[]> getLocator(WebElement element) {
        List<Object> paths = new ArrayList();
        try {
            Object findBy = DriverLegacy.getByValueFromWebElement(element);
            paths = DriverLegacy.getLocators(findBy.toString());
        }
        catch (Exception ignored) {
            return DriverLegacy.getLocatorThroughParsing(element.toString());
        }
        if (paths.isEmpty()) {
            TestLog.ConsoleLogError("element could not be parsed: " + element.toString(), new Object[0]);
        }
        return paths;
    }

    public static Object getByValueFromWebElement(WebElement element) {
        Object[] fields = FieldUtils.getAllFields(element.getClass());
        boolean isMobileElement = Arrays.toString(fields).contains("CGLIB$CALLBACK_0");
        Object findBy = null;
        try {
            Object proxyOrigin = null;
            proxyOrigin = isMobileElement ? FieldUtils.readField((Object)element, (String)"CGLIB$CALLBACK_0", (boolean)true) : FieldUtils.readField((Object)element, (String)"h", (boolean)true);
            Object locator = FieldUtils.readField((Object)proxyOrigin, (String)"locator", (boolean)true);
            findBy = FieldUtils.readField((Object)locator, (String)"by", (boolean)true);
            String modifieidLocator = findBy.toString();
            if (modifieidLocator.contains("By.chained")) {
                if (findBy.toString().contains("By.chained({By.all({")) {
                    modifieidLocator = modifieidLocator.replace("By.chained({By.all({", "");
                    modifieidLocator = modifieidLocator.replace("})})", "");
                } else if (findBy.toString().contains("By.chained({")) {
                    modifieidLocator = modifieidLocator.replace("By.chained({", "");
                    modifieidLocator = modifieidLocator.replace("})", "");
                }
            } else if (modifieidLocator.contains("By.all")) {
                modifieidLocator = modifieidLocator.replace("By.all({", "");
                modifieidLocator = modifieidLocator.replace("})", "");
            }
            findBy = modifieidLocator;
        }
        catch (Exception ignored) {
            return DriverLegacy.getLocatorThroughParsing(element.toString());
        }
        return findBy;
    }

    public static List<String[]> getLocatorThroughParsing(String element) {
        String[] locator = new String[2];
        ArrayList<String[]> paths = new ArrayList<String[]>();
        try {
            String path = element;
            String[] pathVariables = null;
            if (path.contains("->")) {
                pathVariables = path.split("->", 2)[1].replaceFirst("(?s)(.*)\\]", "$1").trim().split(":", 2);
            } else {
                pathVariables = path.split("'", 2)[1].replaceAll("'$", "").trim().split(":", 2);
                pathVariables[0] = pathVariables[0].split("By.")[1];
            }
            if (pathVariables.length != 2) {
                throw new IllegalStateException("webElement :( " + path + " )not containg valid by:locator format!");
            }
            String selector = pathVariables[0].trim();
            String value = pathVariables[1].trim();
            locator[0] = selector;
            locator[1] = value;
            paths.add(locator);
            return paths;
        }
        catch (Exception e) {
            TestLog.ConsoleLogError("webElement :( " + element.toString() + " )not containg valid by:locator format!", new Object[0]);
            return paths;
        }
    }

    public static List<String[]> getLocators(String element) {
        if (element.contains("->")) {
            element = element.split("->", 2)[1];
        }
        ArrayList<String> locatorList = new ArrayList<String>();
        String currentLocator = "";
        String[] locators = element.split(",");
        for (int i = 0; i < locators.length; ++i) {
            if (!locators[i].contains("By") && i > 0) {
                currentLocator = currentLocator + ", " + locators[i];
                locatorList.set(locatorList.size() - 1, currentLocator);
                continue;
            }
            locatorList.add(locators[i]);
            currentLocator = locators[i];
        }
        String[] locatorArray = (String[])locatorList.toArray(String[]::new);
        String[] path = new String[2];
        ArrayList<String[]> paths = new ArrayList<String[]>();
        for (String locator : locatorArray) {
            if (locator == null) continue;
            path = locator.toString().split(":", 2);
            if (path.length != 2) {
                TestLog.ConsoleLog("element could not be parsed: " + locator, new Object[0]);
                continue;
            }
            path[0] = path[0].split("By.")[1];
            paths.add(path);
        }
        return paths;
    }

    public static void setDriver(WebDriver driver) {
        TestListener.isTestNG = true;
        TestObject.IS_PROPERTIES_DISABLED = true;
        AbstractDriver.TIMEOUT_SECONDS = 60;
        AbstractDriver.TIMEOUT_IMPLICIT_SECONDS = 5;
        AbstractDriver.setWebDriver(driver);
    }

    public static void setDriver(WebDriver driver, boolean isPropertyDisabled, int timeoutSec, int implicitSec) {
        TestListener.isTestNG = true;
        TestObject.IS_PROPERTIES_DISABLED = isPropertyDisabled;
        AbstractDriver.TIMEOUT_SECONDS = timeoutSec;
        AbstractDriver.TIMEOUT_IMPLICIT_SECONDS = implicitSec;
        AbstractDriver.setWebDriver(driver);
    }

    protected static EnhancedBy setEnhancedElement(List<String[]> locators) {
        EnhancedBy element = new EnhancedBy();
        block38: for (String[] locator : locators) {
            String selector = locator[0].trim();
            String value = locator[1].trim();
            Element.DriverType driverType2 = null;
            driverType2 = Helper.isAndroid() ? Element.DriverType.Android : (Helper.isIOS() ? Element.DriverType.iOS : Element.DriverType.Web);
            switch (selector) {
                case "accessibility": {
                    element.byAccessibility(value, value, driverType2);
                    continue block38;
                }
                case "cssSelector": 
                case "css selector": 
                case "css": {
                    element.byCss(value, value);
                    continue block38;
                }
                case "xpath": {
                    element.byXpath(value, value, driverType2);
                    continue block38;
                }
                case "name": {
                    element.byName(value, value);
                    continue block38;
                }
                case "id": {
                    element.byId(value, value, driverType2);
                    continue block38;
                }
                case "class": 
                case "class name": 
                case "className": {
                    element.byClass(value, value, driverType2);
                    continue block38;
                }
                case "tag name": 
                case "tagName": {
                    element.byTagName(value, value);
                    continue block38;
                }
                case "link text": 
                case "linkText": {
                    element.byLinkText(value, value);
                    continue block38;
                }
                case "partial link text": 
                case "partialLinkText": {
                    element.byPartialLinkText(value, value);
                    continue block38;
                }
                case "iOSNsPredicate": {
                    element.byIOSNsPredicateString(value, value, driverType2);
                    continue block38;
                }
                case "androidUIAutomator": 
                case "uiAutomator": {
                    element.byAndroidUIAutomator(value, value, driverType2);
                    continue block38;
                }
                case "androidDataMatcher": {
                    element.byAndroidDataMatcher(value, value, driverType2);
                    continue block38;
                }
                case "iOSClassChain": {
                    element.byIOSClassChain(value, value, driverType2);
                    continue block38;
                }
            }
            if (!element.elementObject.isEmpty()) continue;
            Helper.assertFalse("selector: " + selector + " not part of selector types");
        }
        return element;
    }
}

