/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.drivers;

import com.aventstack.extentreports.ExtentTest;
import core.support.listeners.TestListener;
import core.support.objects.DriverObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriverJunit;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.util.Map;
import org.openqa.selenium.WebDriver;

public class AbstractDriver {
    public static int TIMEOUT_SECONDS = CrossPlatformProperties.getGlobalTimeout();
    public static int TIMEOUT_IMPLICIT_SECONDS = CrossPlatformProperties.getGlobalTimeoutImplicitWait();

    public void setupDriver(DriverObject driverObject) throws Exception {
        if (AbstractDriver.isJunit()) {
            AbstractDriverJunit abstractDriver = new AbstractDriverJunit();
            abstractDriver.setupWebDriver(driverObject);
        } else if (AbstractDriver.isTestNG()) {
            AbstractDriverTestNG.setupWebDriver(driverObject);
        }
    }

    public static WebDriver getWebDriver() {
        if (AbstractDriver.isJunit()) {
            return AbstractDriverJunit.getWebDriver();
        }
        if (AbstractDriver.isTestNG()) {
            return AbstractDriverTestNG.getWebDriver();
        }
        return null;
    }

    public static void setWebDriver(WebDriver webDriver) {
        if (AbstractDriver.isJunit()) {
            AbstractDriverJunit.setWebDriver(webDriver);
        } else if (AbstractDriver.isTestNG()) {
            AbstractDriverTestNG.setWebDriver(webDriver);
        }
    }

    public static ThreadLocal<ExtentTest> getStep() {
        if (AbstractDriver.isJunit()) {
            return AbstractDriverJunit.step;
        }
        return AbstractDriverTestNG.step;
    }

    public static Boolean isFirstRun() {
        return TestObject.isFirstRun();
    }

    public static Map<WebDriver, DriverObject> getDriverList() {
        return DriverObject.driverList;
    }

    public static boolean isJunit() {
        return !AbstractDriver.isTestNG();
    }

    public static boolean isTestNG() {
        try {
            if (TestListener.isTestNG) {
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return false;
    }
}

