/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.processor;

import com.google.auto.service.AutoService;
import core.helpers.Helper;
import core.support.annotation.helper.FileCreatorHelper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.annotationMap.AnnotationObject;
import core.support.annotation.helper.annotationMap.ModuleMapHelper;
import core.support.annotation.template.config.ConfigManager;
import core.support.annotation.template.config.ConfigVariableGenerator;
import core.support.annotation.template.dataObject.CsvDataObject;
import core.support.annotation.template.dataObject.DataClass;
import core.support.annotation.template.dataObject.ModuleClass;
import core.support.annotation.template.manager.ModuleBase;
import core.support.annotation.template.manager.ModuleManager;
import core.support.annotation.template.manager.PanelManagerGenerator;
import core.support.annotation.template.manager.sourceChangeDetector;
import core.support.annotation.template.service.Service;
import core.support.annotation.template.service.ServiceClass;
import core.support.annotation.template.service.ServiceData;
import core.support.annotation.template.service.ServiceRunner;
import core.support.configReader.PropertiesReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"core.support.annotation.Module"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@AutoService(value={Processor.class})
public class MainGenerator
extends AbstractProcessor {
    private static boolean isAnnotationRun = false;
    public static ProcessingEnvironment PROCESS_ENV;
    public static String ANNOATION_WORKING_DIR;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        PROCESS_ENV = this.processingEnv;
        MainGenerator.setRootWorkingDirectory(this.processingEnv);
        return MainGenerator.runAnnotation();
    }

    public static boolean runAnnotation() {
        if (!isAnnotationRun) {
            isAnnotationRun = true;
            Logger.debug("Annotation called");
            MainGenerator.disableConsoleLogging();
            AnnotationObject annotation = new AnnotationObject().panel();
            Map<String, List<String>> panelMap = ModuleMapHelper.getModuleMap(annotation);
            annotation = new AnnotationObject().data();
            Map<String, List<String>> dataMap = ModuleMapHelper.getModuleMap(annotation);
            annotation = new AnnotationObject().service();
            Map<String, List<String>> serviceMap = ModuleMapHelper.getModuleMap(annotation);
            for (Map.Entry<String, List<String>> entry : dataMap.entrySet()) {
                Logger.debug("module map: module: " + entry.getKey());
                Logger.debug("module map: paths: " + Arrays.toString(entry.getValue().toArray()));
            }
            PanelManagerGenerator.writePanelManagerClass(panelMap);
            ModuleManager.writeModuleManagerClass(panelMap);
            ModuleBase.writeModuleBaseClass(panelMap);
            CsvDataObject.writeCsvDataClass();
            ModuleClass.writeModuleClass(dataMap);
            DataClass.writeDataClass(dataMap);
            Service.writeServiceClass();
            ServiceData.writeServiceDataClass();
            ServiceRunner.writeServiceClass(serviceMap);
            ConfigManager.writeConfigManagerClass();
            ConfigVariableGenerator.writeConfigVariableClass();
            sourceChangeDetector.writeModuleBaseClass();
            ServiceClass.writeServiceGenerationClass();
            MainGenerator.createMarkerClass();
            System.out.println("Annotation generation complete");
        }
        return true;
    }

    protected static void createMarkerClass() {
        try {
            MainGenerator.createFileList("src" + File.separator + "main", "src_dir", false);
            MainGenerator.createFileList("resources", "src_dir", true);
            JavaFileObject fileObject = FileCreatorHelper.createMarkerFile();
            BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
            bw.append("/**Auto generated code,don't modify it. */ \n");
            bw.append("package marker;");
            bw.append("public class marker {}");
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createFileList(String sourceDir, String fileName, boolean isAppend) {
        File Directory = new File(Helper.getFullPath(sourceDir));
        ArrayList<String> fileList = PropertiesReader.getAllFiles(Directory);
        String listString = String.join((CharSequence)",", fileList);
        if (isAppend) {
            Helper.appendToFile("," + listString, "target/generated-sources", fileName, "txt");
        } else {
            Helper.writeFile(listString, "target/generated-sources", fileName, "txt");
        }
    }

    private static void setRootWorkingDirectory(ProcessingEnvironment processingEnv) {
        if (!ANNOATION_WORKING_DIR.isEmpty()) {
            return;
        }
        try {
            JavaFileObject fileObject = PROCESS_ENV.getFiler().createSourceFile("root", new Element[0]);
            BufferedWriter bw = new BufferedWriter(fileObject.openWriter());
            bw.append("/**Auto generated code,don't modify it. */ \n");
            bw.append("package marker;");
            bw.append("public class root {}");
            bw.flush();
            Path projectPath = Paths.get(fileObject.toUri()).getParent().getParent();
            Paths.get(fileObject.toUri()).toFile().delete();
            File workingDir = MainGenerator.getRootPath_reverseNavigation(projectPath.toFile(), "pom.xml");
            ANNOATION_WORKING_DIR = workingDir.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getRootPath_reverseNavigation(File dir, String name) {
        boolean isFound = false;
        do {
            if (dir == null) {
                return null;
            }
            if (dir.isFile() && dir.getName().contains(name)) {
                return dir;
            }
            File[] files = dir.listFiles();
            if (files == null || files.length == 0) {
                dir = dir.getParentFile();
                continue;
            }
            for (File file : files) {
                if (!file.getName().contains(name)) continue;
                return dir;
            }
            dir = dir.getParentFile();
        } while (!isFound);
        return null;
    }

    public static void disableConsoleLogging() {
        File disabledLog = new File(Helper.getFullPath(".externalToolBuilders" + File.separator + "annotation_generator_disableLog.launch"));
        File log = new File(Helper.getFullPath(".externalToolBuilders" + File.separator + "annotation_generator.launch"));
        if (!disabledLog.exists() || !log.exists()) {
            return;
        }
        Path from = disabledLog.toPath();
        Path to = log.toPath();
        try {
            Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        ANNOATION_WORKING_DIR = "";
    }
}

