/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.csvHelper;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.CSVWriter;
import com.opencsv.ICSVParser;
import core.helpers.Helper;
import core.helpers.csvHelper.CsvObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CsvHelper {
    public String getCellData(CsvObject csv) throws Exception {
        String cellValue = "";
        CSVReader readcsv = new CSVReader((Reader)new FileReader(csv.path + File.separator + csv.csvFile));
        List myData = readcsv.readAll();
        cellValue = ((String[])myData.get(csv.row))[csv.column];
        readcsv.close();
        return cellValue;
    }

    public List<String[]> getAllCsvData(String filePath, CsvObject csv) {
        return this.getAllCsvData(filePath + File.separator + csv, 0, true);
    }

    public List<String[]> getAllCsvData(String filePath) {
        return this.getAllCsvData(filePath, 0, true);
    }

    public List<String[]> getAllCsvData(String filePath, int startingRow, boolean skipEmptyRows) {
        ArrayList<String[]> csvList = new ArrayList<String[]>();
        CSVParser parser = new CSVParserBuilder().withSeparator(',').withIgnoreQuotations(true).withIgnoreLeadingWhiteSpace(true).build();
        try {
            String[] line;
            CSVReader readcsv = new CSVReaderBuilder((Reader)new FileReader(filePath)).withSkipLines(startingRow).withCSVParser((ICSVParser)parser).build();
            while ((line = readcsv.readNext()) != null) {
                if (!skipEmptyRows) {
                    csvList.add(line);
                    continue;
                }
                if (line[0].isEmpty()) continue;
                csvList.add(line);
            }
            readcsv.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvList;
    }

    public List<String[]> getAllCsvDataFirstRowAsHeader(String filePath) {
        return this.getAllCsvData(filePath, 1, true);
    }

    public void writeNewCsv(CsvObject csv) {
        String csvPath = csv.path + File.separator + csv.csvFile;
        try {
            CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvPath));
            writer.writeNext(csv.value);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void AddRow(CsvObject csv) {
        String csvPath = csv.path + File.separator + csv.csvFile;
        try {
            CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvPath, true));
            writer.writeNext(csv.value);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToCell(CsvObject csv, String value) {
        String csvPath = csv.path + File.separator + csv.csvFile;
        this.writeToCell(csv, value, csvPath);
    }

    public void writeToCell(CsvObject csv, String value, String csvPath) {
        try {
            CSVParser parser = new CSVParserBuilder().withSeparator(',').withIgnoreQuotations(true).withIgnoreLeadingWhiteSpace(true).build();
            CSVReader reader = new CSVReaderBuilder((Reader)new FileReader(csvPath)).withSkipLines(0).withCSVParser((ICSVParser)parser).build();
            List csvBody = reader.readAll();
            ((String[])csvBody.get((int)csv.row))[csv.column] = value;
            reader.close();
            CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvPath));
            writer.writeAll(csvBody);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendCsv(CsvObject csv) {
        String csvPath = csv.path + File.separator + csv.csvFile;
        try {
            CSVWriter writer = new CSVWriter((Writer)new FileWriter(csvPath, true));
            writer.writeNext(csv.value);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getRowIndex(String id, String filePath) {
        List<String[]> rows = this.getAllCsvData(filePath, 0, false);
        for (int i = 0; i < rows.size(); ++i) {
            String rowId = rows.get(i)[0];
            if (!rowId.equals(id)) continue;
            return i;
        }
        Helper.assertFalse("row not found: '" + id + "' at path: " + filePath);
        return -1;
    }

    public int getColumnIndex(String column, String filePath) {
        List<String[]> rows = this.getAllCsvData(filePath, 0, false);
        int columnSize = rows.get(0).length;
        for (int i = 0; i < columnSize; ++i) {
            String columnValue = rows.get(0)[i].trim();
            if (!columnValue.equals(column)) continue;
            return i;
        }
        Helper.assertFalse("column not found: '" + column + "' at path: " + filePath);
        return -1;
    }
}

