/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.click;

import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.time.Duration;
import org.openqa.selenium.interactions.Actions;

public class ClickHelper
extends Element {
    public void clickAndExpect(EnhancedBy target, EnhancedBy expected) {
        this.clickAndExpect(target, 0, expected, true);
    }

    public void clickAndExpect(EnhancedBy target, EnhancedBy expected, boolean mobileRefresh) {
        this.clickAndExpect(target, 0, expected, mobileRefresh);
    }

    public void clickAndExpectByText(EnhancedBy target, String text, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToLoad(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (!Helper.isPresent(target)) continue;
            Helper.list.selectListItemEqualsByName(target, text);
        } while (!(isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds)) && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndExpectContainsByText(EnhancedBy target, String text, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToLoad(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (!Helper.isPresent(target)) continue;
            Helper.list.selectListItemContainsByName(target, text);
        } while (!(isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds)) && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndExpect(EnhancedBy target, int index, EnhancedBy expected, boolean mobileRefresh) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(target);
        Helper.wait.waitForElementToLoad(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                targetElement.click(index);
            }
            isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds);
            TestLog.ConsoleLog("clickAndExpect: expected: " + expected.name + " : " + isExpectedFound, new Object[0]);
        } while (!isExpectedFound && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndExpectNoRetry(EnhancedBy target, int index, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(target);
        Helper.wait.waitForElementToLoad(target);
        boolean isExpectedFound = false;
        targetElement.click(index);
        isExpectedFound = Helper.wait.waitForElementToLoad(expected);
        TestLog.ConsoleLog("clickAndExpect: expected: " + expected.name + " : " + isExpectedFound, new Object[0]);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndExpectByAction(EnhancedBy target, EnhancedBy expected) {
        this.clickAndExpectByAction(target, 0, expected);
    }

    public void clickAndExpectByAction(EnhancedBy target, int index, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(target);
        Helper.wait.waitForElementToLoad(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                Actions action = new Actions(AbstractDriver.getWebDriver());
                action.click(targetElement.get(0)).perform();
            }
            isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds);
            TestLog.ConsoleLog("clickAndExpect: expected: " + expected.name + " : " + isExpectedFound, new Object[0]);
        } while (!isExpectedFound && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndExpect(EnhancedBy target, int index, EnhancedBy expected) {
        this.clickAndExpect(target, index, expected, true);
    }

    public void clickAndExpect(EnhancedBy target, int index, EnhancedBy expected1, EnhancedBy expected2) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(target);
        Helper.wait.waitForElementToLoad(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                targetElement.click(index);
            }
            if (!(isExpectedFound = Helper.wait.waitForFirstElementToLoad(expected1, expected2, targetWaitTimeInSeconds))) {
                Helper.mobile.refreshMobileApp();
            }
            TestLog.ConsoleLog("clickAndExpect: expected: " + expected1.name + " : or: " + expected2.name + " : " + isExpectedFound, new Object[0]);
        } while (!isExpectedFound && retry > 0);
        Helper.assertTrue("expected element not found: " + expected1.name, isExpectedFound);
    }

    public void clickAndExpect(EnhancedBy target, EnhancedBy expected, EnhancedBy spinner) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(target);
        Helper.wait.waitForElementToLoad(target);
        boolean isExpectedFound = false;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                targetElement.click();
            }
            Helper.wait.waitForSeconds(0.5);
            Helper.wait.waitForElementToBeRemoved(spinner);
        } while (!(isExpectedFound = Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds)) && retry > 0);
        Helper.assertTrue("expected element not found: " + expected.name, isExpectedFound);
    }

    public void clickAndNotExpect(EnhancedBy target, EnhancedBy expected) {
        this.clickAndNotExpect(target, 0, expected);
    }

    public void clickAndNotExpect(EnhancedBy target, int index, EnhancedBy expected) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(target);
        Helper.wait.waitForElementToLoad(target);
        EnhancedWebElement expectedElement = null;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            --retry;
            if (Helper.isPresent(target)) {
                targetElement.click(index);
            }
            Helper.wait.waitForSeconds(0.5);
            Helper.wait.waitForElementToBeRemoved(expected, targetWaitTimeInSeconds);
        } while ((expectedElement = Element.findElements(expected)).isExist(new int[0]) && retry > 0);
        Helper.assertTrue("expected element found", !expectedElement.isExist(new int[0]));
    }

    public void clickAndWait(EnhancedBy target, double timeInSeconds) {
        this.clickAndWait(target, 0, timeInSeconds);
    }

    public void clickAndWait(EnhancedBy target, int index, double timeInSeconds) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        Helper.wait.waitForElementToLoad(target);
        EnhancedWebElement targetElement = Element.findElements(target);
        targetElement.click(index);
        Helper.wait.waitForSeconds(timeInSeconds);
    }

    public void click(EnhancedBy target, int index) {
        TestLog.logPass("I click " + target.name, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(target);
        targetElement.click(index);
    }

    public void clickElementLocationBy(EnhancedBy by, int x, int y) {
        TestLog.logPass("I click element at position offset by x: " + x + " y: " + y, new Object[0]);
        EnhancedWebElement targetElement = Element.findElements(by);
        Actions actions = new Actions(AbstractDriver.getWebDriver());
        Helper.wait.waitForElementToLoad(by);
        actions.moveToElement(targetElement.get(0), x, y).click().perform();
    }

    public void clickPoints(int x, int y) {
        TestLog.logPass("I click point at x: " + x + " y: " + y, new Object[0]);
        Actions action = new Actions(AbstractDriver.getWebDriver());
        action.moveByOffset(x, y).click().build().perform();
        this.resetMouse(x, y);
    }

    public void clickPointsAndExpect(int x, int y, EnhancedBy expected) {
        EnhancedWebElement expectedElement = null;
        int targetWaitTimeInSeconds = 5;
        int retry = AbstractDriver.TIMEOUT_SECONDS / targetWaitTimeInSeconds;
        do {
            this.clickPoints(x, y);
            Helper.wait.waitForSeconds(0.5);
            Helper.wait.waitForElementToLoad(expected, targetWaitTimeInSeconds);
        } while (!(expectedElement = Element.findElements(expected)).isExist(new int[0]) && --retry > 0);
        Helper.assertTrue("expected element not found", expectedElement.isExist(new int[0]));
    }

    public void resetMouse(int x, int y) {
        Actions action = new Actions(AbstractDriver.getWebDriver());
        action.moveByOffset(-x, -y).build().perform();
    }

    public void doubleClickPoints(int x, int y) {
        TestLog.logPass("I double click point at x: " + x + " y: " + y, new Object[0]);
        Actions action = new Actions(AbstractDriver.getWebDriver());
        action.moveByOffset(x, y).click().release().pause(Duration.ofMillis(250L)).click().release().build().perform();
        this.resetMouse(x, y);
    }

    public void clickElementContinsByText(EnhancedBy by, String text) {
        TestLog.ConsoleLog("I click element " + by.name + " with text containing: " + text, new Object[0]);
        Helper.list.selectListItemContainsByName(by, text);
    }

    public void clickAndHold(EnhancedBy target, double seconds) {
        this.clickAndHold(target, 0, seconds);
    }

    public void clickAndHold(EnhancedBy target, int index, double seconds) {
        Helper.wait.waitForElementToBeClickable(target);
        EnhancedWebElement targetElement = Element.findElements(target);
        Actions action = new Actions(AbstractDriver.getWebDriver());
        action.clickAndHold(targetElement.get(index)).perform();
        Helper.wait.waitForSeconds(seconds);
        action.release(targetElement.get(index)).perform();
    }

    public void dragAndDrop(EnhancedBy src, EnhancedBy target) {
        this.dragAndDrop(src, 0, target, 0);
    }

    public void dragAndDrop(EnhancedBy src, int srcIndex, EnhancedBy target, int targetIndex) {
        Helper.wait.waitForElementToLoad(src);
        EnhancedWebElement srcElement = Element.findElements(src);
        EnhancedWebElement targetElement = Element.findElements(target);
        Actions actions = new Actions(AbstractDriver.getWebDriver());
        actions.dragAndDrop(srcElement.get(srcIndex), targetElement.get(targetIndex));
        actions.build().perform();
    }

    public void dragAndDrop(EnhancedBy srcParent, int srcParentIndex, EnhancedBy srcChild, int scrChildIndex, EnhancedBy targetParent, int targeParenttIndex, EnhancedBy targetChild, int targetChildIndex) {
        Helper.wait.waitForElementToLoad(srcParent);
        EnhancedWebElement srcElement = Element.findElements(srcParent, srcParentIndex, srcChild);
        EnhancedWebElement targetElement = Element.findElements(targetParent, targeParenttIndex, targetChild);
        Actions actions = new Actions(AbstractDriver.getWebDriver());
        actions.dragAndDrop(srcElement.get(scrChildIndex), targetElement.get(targetChildIndex));
        actions.build().perform();
    }

    public void dragAndDrop(EnhancedBy src, int xOffset, int yOffset) {
        Helper.wait.waitForElementToLoad(src);
        EnhancedWebElement srcElement = Element.findElements(src);
        Actions actions = new Actions(AbstractDriver.getWebDriver());
        actions.dragAndDropBy(srcElement.get(0), xOffset, yOffset);
        actions.build().perform();
    }
}

