/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.interfaces.RestApiInterface;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.RestAssured;
import io.restassured.specification.RequestSpecification;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Authentication {
    public static final String BASIC_AUTHORIZATION = "BASIC";
    public static final String NTLM_AUTHORIZATION = "NTLM";
    public static final String AUTHENTICATION_DISABLE = "authentication.disabled";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTHENTICATION = "auth";

    public static void authenticator(ServiceObject serviceObject) {
        if (serviceObject == null) {
            Helper.assertFalse("apiobject is null");
        }
        if (Config.getBooleanValue(AUTHENTICATION_DISABLE).booleanValue()) {
            return;
        }
        RestApiInterface.setTimeout();
        RestApiInterface.setProxy();
        serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
        Authentication.setURI(serviceObject);
        Authentication.evaluateRequest(serviceObject);
    }

    public static void setURI(ServiceObject serviceObject) {
        String url = "";
        serviceObject.withUriPath(DataHelper.replaceParameters(serviceObject.getUriPath()));
        serviceObject.withUriPath(Helper.stringRemoveLines(serviceObject.getUriPath()));
        url = serviceObject.getUriPath().startsWith("http") ? serviceObject.getUriPath() : Helper.stringRemoveLines(Config.getValue("api.uriPath")) + serviceObject.getUriPath();
        serviceObject.withUriPath(url);
        URL aURL = Helper.convertToUrl(url);
        TestLog.logPass("request URL: " + aURL.toString(), new Object[0]);
        RestAssured.baseURI = aURL.getProtocol() + "://" + aURL.getHost();
        RestAssured.port = aURL.getPort();
        RestAssured.basePath = aURL.getPath();
    }

    private static RequestSpecification evaluateRequest(ServiceObject serviceObject) {
        RequestSpecification request = null;
        Authentication.evaluateOption(serviceObject);
        Map<String, String> parameterMap = Authentication.getParameters(serviceObject);
        TestLog.logPass("authentication type: " + Helper.stringRemoveLines(serviceObject.getOption()), new Object[0]);
        switch (serviceObject.getOption()) {
            case "BASIC": {
                String username = parameterMap.get("username");
                String password = parameterMap.get("password");
                ArrayList<String> credentials = new ArrayList<String>();
                credentials.add(username);
                credentials.add(password);
                Authentication.saveOutboundParameter(serviceObject, credentials);
                break;
            }
            case "NTLM": {
                String username = parameterMap.get("username");
                String password = parameterMap.get("password");
                String workstation = parameterMap.get("workstation");
                String domain = parameterMap.get("domain");
                ArrayList<String> credentials = new ArrayList<String>();
                credentials.add(username);
                credentials.add(password);
                credentials.add(workstation);
                credentials.add(domain);
                Authentication.saveOutboundParameter(serviceObject, credentials);
                break;
            }
            case "OAUTH2": {
                String username = parameterMap.get("username");
                String password = parameterMap.get("password");
                String clientId = parameterMap.get("cliendId");
                String clientSecret = parameterMap.get("clientSecret");
                String grantType = parameterMap.get("grantType");
                String scope = parameterMap.get("scope");
                String redirectUri = parameterMap.get("redirectUri");
                request = RestAssured.given().auth().preemptive().basic(clientId, clientSecret).formParam("grant_type", new Object[]{grantType}).formParam("username", new Object[]{username}).formParam("password", new Object[]{password}).formParam("redirect_uri", new Object[]{redirectUri}).formParam("scope", new Object[]{scope});
                break;
            }
            default: {
                Helper.assertFalse("Correct authentication type not set. selected: <" + serviceObject.getMethod() + "> Available options: BASIC");
            }
        }
        return request;
    }

    private static Map<String, String> getParameters(ServiceObject serviceObject) {
        String[] formData;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (serviceObject.getRequestBody().isEmpty()) {
            return parameterMap;
        }
        for (String data : formData = serviceObject.getRequestBody().split(",")) {
            String[] keyValue = data.split(":");
            parameterMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return parameterMap;
    }

    private static void evaluateOption(ServiceObject serviceObject) {
        Authentication.resetOptions();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                default: 
            }
        }
        KeyValue.printKeyValue(keywords, "option");
    }

    private static void resetOptions() {
        Config.putValue(AUTHORIZATION_HEADER, (Object)"", false);
    }

    private static void saveOutboundParameter(ServiceObject serviceObject, Object authorization) {
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOutputParams());
        if (keywords.isEmpty()) {
            Helper.assertFalse("Autehntication value must be stored in a variable. eg. auth:<$variable>");
        }
        if (!keywords.get((int)0).key.equals(AUTHENTICATION)) {
            Helper.assertFalse("Authentication storing format: auth:<$variable>");
        }
        KeyValue keyword = keywords.get(0);
        if (!(keyword.value.toString().startsWith("<") && keyword.value.toString().contains("$") && keyword.value.toString().endsWith(">"))) {
            Helper.assertFalse("variable placement must of format path: <$variable>. invalid value: " + keyword.value.toString());
        }
        String key = (String)keyword.value;
        key = key.replace("$", "").replace("<", "").replace(">", "").trim();
        Config.putValue(key, authorization, false);
        ArrayList request = (ArrayList)authorization;
        TestLog.logPass("output parameter: " + key + " value: " + Arrays.toString(request.toArray()), new Object[0]);
    }
}

