/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.helper.annotationMap;

import core.helpers.Helper;
import core.support.annotation.helper.Logger;
import core.support.annotation.helper.PackageHelper;
import core.support.annotation.helper.annotationMap.AnnotationObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ModuleMapHelper {
    private static String MODULE_ROOT = "module";
    private static String SOURCE_PATH = Helper.getFullPath("src" + File.separator + "main");

    public static Map<String, List<String>> getModuleMap(AnnotationObject annotation) {
        HashMap<String, List<String>> map = new HashMap();
        List<File> files = new ArrayList<File>();
        files = Helper.getFileListWithSubfolders(SOURCE_PATH, ".java", files);
        files = Helper.getFileListWithSubfolders(SOURCE_PATH, ".kt", files);
        List<File> annotationFiles = ModuleMapHelper.getFilesWithAnnotation(files, annotation);
        Logger.debug(annotation.annotation + " : " + Arrays.toString(annotationFiles.toArray()));
        map = ModuleMapHelper.getModuleMap(annotationFiles);
        return map;
    }

    public static Map<String, List<String>> getModuleMap(List<File> files) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String module = "";
        for (File file : files) {
            List filePath = new ArrayList();
            module = PackageHelper.getModuleFromFullPath(file);
            String path = MODULE_ROOT + StringUtils.substringAfter((String)file.getAbsolutePath(), (String)MODULE_ROOT);
            if (path.startsWith(File.separator)) {
                path = path.substring(1);
            }
            path = path.split("\\.")[0];
            path = path.replace(File.separator, ".");
            filePath = map.get(module) == null ? new ArrayList() : (List)map.get(module);
            filePath.add(path);
            Logger.debug("module:" + module + " adding panel: " + path);
            map.put(module, filePath);
        }
        return map;
    }

    public static List<File> getFilesWithAnnotation(List<File> files, AnnotationObject annotation) {
        ArrayList<File> dataFiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.getAbsolutePath().contains(File.separator + annotation.parentFolder + File.separator) || !Helper.isFileContainsString(annotation.annotation, file)) continue;
            dataFiles.add(file);
        }
        return dataFiles;
    }
}

