/*
 * Decompiled with CFR 0.152.
 */
package core.uiCore.driverProperties.capabilities;

import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.TestLog;
import core.support.objects.DeviceManager;
import core.support.objects.DeviceObject;
import core.support.objects.TestObject;
import core.uiCore.AppiumServer;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AndroidCapability {
    public DesiredCapabilities capabilities;
    public static String APP_DIR_PATH = "android.appDir";
    public static String APP_NAME = "android.app";
    public static String ANDROID_ENGINE = "android.capabilties.automationName";
    public static String UIAUTOMATOR2 = "UiAutomator2";
    public static boolean ANDROID_INIT = false;
    public static String ANDROID_HOME = "android.home";
    public static String ANDROID_UDID = "android.UDID";
    public static String IS_HYBRID_APP = "appium.isHybridApp";
    public static String CHROME_VERSION = "appium.chromeVersion";
    private static final String CAPABILITIES_PREFIX = "android.capabilties.";
    public List<String> simulatorList = new ArrayList<String>();
    public static int SYSTEM_PORT = 8200;

    public AndroidCapability() {
        this.capabilities = new DesiredCapabilities();
    }

    public AndroidCapability withCapability(DesiredCapabilities Capabilities) {
        this.capabilities = Capabilities;
        return this;
    }

    public AndroidCapability withDevice(String device) {
        this.simulatorList = Config.getValueList(device);
        return this;
    }

    public DesiredCapabilities getCapability() {
        return this.capabilities;
    }

    public String getAppPath() {
        String appRootPath = Helper.getFullPath(Config.getValue(APP_DIR_PATH));
        File appPath = new File(appRootPath, Config.getValue(APP_NAME));
        if (!appPath.exists()) {
            TestLog.ConsoleLogWarn("app not found at: " + appPath.getAbsolutePath(), new Object[0]);
        }
        return appPath.getAbsolutePath();
    }

    public AndroidCapability withAndroidCapability() {
        AndroidCapability.uninstallUiAutomator2();
        this.capabilities = this.setAndroidCapabilties();
        this.capabilities.setCapability("app", this.getAppPath());
        this.setChromeDriver();
        AndroidCapability.setAndroidHome();
        this.setAndroidDevice();
        this.setPort(TestObject.getTestInfo().deviceName);
        this.setSingleSignIn();
        return this;
    }

    public DesiredCapabilities setAndroidCapabilties() {
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            boolean isAndroidCapability = entry.getKey().toString().startsWith(CAPABILITIES_PREFIX);
            if (!isAndroidCapability) continue;
            String fullKey = entry.getKey().toString();
            String key = fullKey.substring(fullKey.lastIndexOf(".") + 1).trim();
            String value = entry.getValue().toString().trim();
            this.capabilities.setCapability(key, value);
        }
        return this.capabilities;
    }

    public void setChromeDriver() {
        boolean isHybridApp = Config.getBooleanValue(IS_HYBRID_APP);
        if (isHybridApp) {
            String chromeVersion = Config.getValue(CHROME_VERSION);
            try {
                if (chromeVersion.equals("LATEST")) {
                    WebDriverManager.chromedriver().setup();
                } else {
                    WebDriverManager.chromedriver().driverVersion(chromeVersion).setup();
                    String chromePath = WebDriverManager.chromedriver().getDownloadedDriverPath();
                    this.capabilities.setCapability("chromedriverExecutable", chromePath);
                }
            }
            catch (NoSuchMethodError er) {
                er.getMessage();
            }
            catch (Exception e) {
                e.getMessage();
            }
            TestLog.ConsoleLog("setting chrome version: " + chromeVersion, new Object[0]);
        }
    }

    public void setSingleSignIn() {
        if (CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            if (AbstractDriver.isFirstRun().booleanValue()) {
                this.capabilities.setCapability("noReset", false);
            } else {
                this.capabilities.setCapability("noReset", true);
            }
        }
    }

    public boolean isRealDeviceConnected() {
        List<String> devices = AndroidCapability.getAndroidDeviceList();
        for (String device : devices) {
            if (device.contains("emulator")) continue;
            return true;
        }
        return false;
    }

    public static List<String> getRealDevices(List<String> devices) {
        ArrayList<String> realDeviceList = new ArrayList<String>();
        for (String device : devices) {
            if (device.contains("emulator")) continue;
            realDeviceList.add(device);
        }
        return realDeviceList;
    }

    public static List<String> getAndroidDeviceList() {
        String cmd = "adb devices | tail -n +2 | cut -sf 1";
        if (!Config.getValue(AppiumServer.ANDROID_HOME).isEmpty()) {
            cmd = Config.getValue(AppiumServer.ANDROID_HOME) + "/platform-tools/" + cmd;
        }
        ArrayList<Object> deviceList = new ArrayList();
        deviceList = Config.getValueList(ANDROID_UDID);
        if (deviceList.isEmpty()) {
            deviceList = Helper.executeCommand(cmd);
        }
        if (!deviceList.isEmpty()) {
            TestLog.ConsoleLogDebug("Android device list: " + Arrays.toString(deviceList.toArray()), new Object[0]);
        }
        return deviceList;
    }

    public List<String> getAndroidRealDeviceList() {
        List<String> devices = AndroidCapability.getAndroidDeviceList();
        return AndroidCapability.getRealDevices(devices);
    }

    public void setSimulator() {
        int threads;
        List<String> devices = this.simulatorList;
        if (devices == null || devices.isEmpty()) {
            Helper.assertFalse("set device first");
        }
        if ((threads = CrossPlatformProperties.getParallelTests()) > devices.size()) {
            Helper.assertFalse("there are more threads than devices. global.parallelTestCount: " + threads + " devices: " + devices.size());
        }
        DeviceManager.loadDevices(devices, DeviceObject.DeviceType.Android);
        this.capabilities.setCapability("avd", DeviceManager.getFirstAvailableDevice(DeviceObject.DeviceType.Android));
    }

    public synchronized void setPort(String deviceName) {
        if (DeviceManager.devices.get(deviceName) != null && DeviceManager.devices.get((Object)deviceName).devicePort != -1) {
            this.capabilities.setCapability("systemPort", (Object)DeviceManager.devices.get((Object)deviceName).devicePort);
        } else {
            int systemPort = ++SYSTEM_PORT;
            this.capabilities.setCapability("systemPort", (Object)systemPort);
            DeviceManager.devices.get(deviceName).withDevicePort(systemPort);
        }
        TestLog.ConsoleLog("deviceName " + deviceName + " systemPort: " + DeviceManager.devices.get((Object)deviceName).devicePort, new Object[0]);
    }

    public static void restartAdb() {
        Helper.executeCommand("adb kill-server");
        Helper.executeCommand("adb start-server");
    }

    public static void uninstallUiAutomator2() {
        if (!ANDROID_INIT) {
            boolean isAndroidConnected;
            ANDROID_INIT = true;
            boolean bl = isAndroidConnected = !CollectionUtils.isEmpty(AndroidCapability.getAndroidDeviceList());
            if (isAndroidConnected && Config.getValue(ANDROID_ENGINE).equals(UIAUTOMATOR2)) {
                TestLog.ConsoleLog("Uninstalling uiautomator2.server", new Object[0]);
                TestLog.ConsoleLog("Uninstalling uiautomator2.server.test", new Object[0]);
                Helper.executeCommand("adb uninstall io.appium.uiautomator2.server");
                Helper.executeCommand("adb uninstall io.appium.uiautomator2.server.test");
            }
        }
    }

    public void setRealDevices() {
        List<String> devices = this.getAndroidRealDeviceList();
        int threads = CrossPlatformProperties.getParallelTests();
        if (threads > devices.size()) {
            Helper.assertFalse("there are more threads than devices. thread count: " + threads + " devices: " + devices.size());
        }
        DeviceManager.loadDevices(devices, DeviceObject.DeviceType.Android);
        this.capabilities.setCapability("udid", DeviceManager.getFirstAvailableDevice(DeviceObject.DeviceType.Android));
    }

    public void setAndroidDevice() {
        if (!PropertiesReader.isUsingCloud()) {
            if (this.isRealDeviceConnected()) {
                this.setRealDevices();
            } else {
                this.setSimulator();
            }
        }
    }

    public static void printAndroidHelp(Exception e) {
        String androidError = "It is impossible to create a new session";
        String androidSolution = "*******************************************************************\r\n\r\n\r\n\r\n*******************************************************************\r\n\r\n This could be an environment issue. Try the following solutions:\r\n    1. Try running against appium desktop server\r\n        1. Download And run appium desktop\r\n         2. Start the server\r\n        3. In resources/properties/appium.property, set values\r\n            1. appium.useExternalAppiumServer = true\r\n            2. appium.externalPort  = 4723\r\n            3. run test\r\n    2. Is appium terminal installation correct?\r\n             1. command line: appium\r\n            2. Does it start. If not install: \u201cnpm install -g appium\u201d  or \u201csudo npm install -g appium --unsafe-perm=true --allow-root\u201d\r\n            3. Run against appium terminal\r\n                1. In properties set:\r\n                    1. useExternalAppiumServer = true\r\n                    2. appiumExternalPort = 4723\r\n                2. run test And see if it passes\r\n    3. Turn on debugging in properties at resource folder for more info:\r\n        1. appiumLogging = true\r\n    2. set android home environment in properties\r\n        1. androidHome = \"/Users/username/Library/Android/sdk\"\r\n    4. please download appium doctor https://github.com/appium/appium-doctor\r\n        1. download with command: npm install appium-doctor -g\r\n        2. Run: appium-doctor -android\r\n        3. Ensure the environment is setup properly\r\n        4. Restart eclipse\r\n        *******************************************************************\r\n\r\n\r\n\r\n*******************************************************************";
        if (e.getMessage().contains(androidError)) {
            System.out.println(androidSolution);
        }
    }

    public static void setAndroidHome() {
        boolean isAndroidHome;
        if (!Helper.isMac()) {
            return;
        }
        String userHome = System.getProperty("user.home");
        String androidHome = Config.getValue(ANDROID_HOME);
        String javaHomePath = "";
        if (androidHome.isEmpty() && (isAndroidHome = new File(javaHomePath = userHome + File.separator + "Library" + File.separator + "Android" + File.separator + "sdk/").exists())) {
            Config.putValue(ANDROID_HOME, javaHomePath);
        }
    }
}

