/*
 * Decompiled with CFR 0.152.
 */
package core.support.rules;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.Status;
import com.microsoft.appcenter.appium.EnhancedAndroidDriver;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.PropertiesReader;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.openqa.selenium.WebDriver;

public class RetryTest
implements TestRule {
    public static final String[] PageErrors = new String[]{"MultipleFailureException", "WebDriverException", "GridException", "SessionNotFoundException", "UnreachableBrowserException", "loginException"};
    private int retryCount;
    private int testRun;
    public static final int RETRYCOUNTER = CrossPlatformProperties.getRetryCount();
    public static boolean enableRetry = true;
    private ExtentTest test;
    private ExtentTest step;
    private ExtentReports extent;
    public WebDriver webDriver;

    public RetryTest(int retryCount) {
        this.retryCount = retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getCurrentTestRun() {
        return this.testRun;
    }

    public void setExtendReport(ExtentTest test, ExtentTest step, ExtentReports extent) {
        this.test = test;
        this.step = step;
        this.extent = extent;
    }

    public ExtentTest getTest() {
        return this.test;
    }

    public ExtentTest getStep() {
        return this.step;
    }

    public void setWebDriver(WebDriver driver) {
        this.webDriver = driver;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base, description);
    }

    private Statement statement(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RetryTest.this.setTestId(description);
                long passedTimeInSeconds = 0L;
                StopWatchHelper watch = StopWatchHelper.start();
                RetryTest.this.testRun = 1;
                while (RetryTest.this.testRun <= RetryTest.this.retryCount) {
                    try {
                        base.evaluate();
                        TestObject.getTestInfo().isTestPass = true;
                        TestObject.getTestInfo().isFirstRun = false;
                        TestObject.getTestInfo().withIsForcedRestart(false);
                        if (RetryTest.this.webDriver == null) break;
                        DriverObject.setDriverAvailabiltity(RetryTest.this.webDriver, true);
                        break;
                    }
                    catch (Throwable t) {
                        RetryTest.this.getPageSource();
                        t.printStackTrace();
                        TestObject.getTestInfo().caughtThrowable = t;
                        RetryTest.this.errorHandling(TestObject.getTestInfo().caughtThrowable);
                        RetryTest.this.takeAppcenterScreenshot(t.getClass().getName());
                        RetryTest.this.processTestResult(description);
                        RetryTest.this.testRun++;
                    }
                }
                passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
                TestLog.ConsoleLog("test duration: " + passedTimeInSeconds + " seconds", new Object[0]);
                RetryTest.this.takeAppcenterScreenshot("test finished: " + passedTimeInSeconds + " seconds");
                if (!CrossPlatformProperties.isSingleSignIn().booleanValue()) {
                    DriverObject.quitTestDrivers();
                }
                RetryTest.this.writeToTestReport();
            }
        };
    }

    public void getPageSource() {
        if (this.webDriver != null) {
            TestLog.ConsoleLog(this.webDriver.getPageSource(), new Object[0]);
        }
    }

    public void setTestId(Description description) {
        TestObject.setTestName(description.getMethodName());
        String className = description.getClassName().substring(description.getClassName().lastIndexOf(".") + 1);
        TestObject.setTestId(className + "-" + TestObject.currentTestName.get());
    }

    public void takeAppcenterScreenshot(String label) {
        if (PropertiesReader.isUsingCloud()) {
            try {
                ((EnhancedAndroidDriver)this.webDriver).label(label);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void processTestResult(Description description) throws Throwable {
        if (TestObject.getTestInfo().isTestPass.booleanValue()) {
            this.randomFailStack(TestObject.getTestInfo().failTrace, TestObject.getTestInfo().description);
        } else {
            this.logReport(ReportType.info, "run " + this.testRun + " failed ", null);
            this.logReport(ReportType.debug, null, TestObject.getTestInfo().caughtThrowable);
            Helper.captureExtentReportScreenshot();
            TestLog.ConsoleLogError("run " + this.testRun + " failed", new Object[0]);
            DriverObject.quitTestDrivers();
            if (this.testRun == this.retryCount) {
                this.logReport(ReportType.fail, "giving up after " + this.retryCount + " failures", null);
                TestLog.ConsoleLogError("giving up after " + this.retryCount + " failures", new Object[0]);
                this.writeToTestReport();
                throw TestObject.getTestInfo().caughtThrowable;
            }
        }
    }

    public void writeToTestReport() {
        if (this.extent != null) {
            new File(ExtentManager.getReportHTMLFullPath()).mkdirs();
            this.extent.flush();
        }
    }

    public void logReport(ReportType type, String value, Throwable t) {
        if (this.getStep() == null) {
            return;
        }
        switch (type) {
            case pass: {
                this.getStep().pass(value);
                break;
            }
            case info: {
                this.getStep().info(value);
                break;
            }
            case warning: {
                this.getStep().warning(value);
                break;
            }
            case debug: {
                this.getStep().debug(t);
                break;
            }
            case fail: {
                this.getStep().fail(value);
                break;
            }
        }
    }

    public boolean pageHasError(Throwable t) {
        for (String error : PageErrors) {
            if (!t.getClass().toString().contains(error)) continue;
            return true;
        }
        return false;
    }

    public void errorHandling(Throwable t) {
        if (this.pageHasError(t)) {
            this.setRetryCount(RETRYCOUNTER + 3);
        } else {
            this.setRetryCount(RETRYCOUNTER);
        }
    }

    public void randomFailStack(ArrayList<String> FailTrace, Description description) {
        if (FailTrace.size() > 0) {
            TestLog.ConsoleLog("And finally test passed after " + this.retryCount + " failures", new Object[0]);
            this.getStep().log(Status.PASS, "And finally test passed after " + this.testRun + " failures");
        } else {
            TestLog.ConsoleLog("And finally test passed without failures", new Object[0]);
            this.getStep().log(Status.PASS, "And finally test passed without failures");
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public static ArrayList<String> getAllFiles(File curDir) {
        File[] filesList;
        ArrayList<String> array = new ArrayList<String>();
        for (File f : filesList = curDir.listFiles()) {
            if (f.isDirectory()) {
                RetryTest.getAllFiles(f);
            }
            if (!f.isFile()) continue;
            TestLog.ConsoleLog("All files: " + f.getPath() + " : " + f.getName(), new Object[0]);
            array.add("All files: " + f.getPath() + " : " + f.getName());
        }
        return array;
    }

    public static enum ReportType {
        pass,
        info,
        warning,
        debug,
        fail;

    }
}

