/*
 * Decompiled with CFR 0.152.
 */
package core.support.logger;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.gherkin.model.And;
import com.aventstack.extentreports.gherkin.model.Background;
import com.aventstack.extentreports.gherkin.model.But;
import com.aventstack.extentreports.gherkin.model.Given;
import com.aventstack.extentreports.gherkin.model.Then;
import com.aventstack.extentreports.gherkin.model.When;
import com.aventstack.extentreports.markuputils.ExtentColor;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import core.apiCore.interfaces.RestApiInterface;
import core.helpers.Helper;
import core.helpers.UtilityHelper;
import core.support.configReader.Config;
import core.support.logger.ExtentManager;
import core.support.logger.LogObject;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import io.restassured.response.Response;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.testng.util.Strings;

public class TestLog {
    public static final String ENABLE_EXTENT_SUBSTEPS = "report.enableDetailedReport";
    public static final String ENABLE_DEBUG = "console.debug.enable";
    public static final String IS_LOG_LIMIT = "log.limit.enabled";
    public static final String LOG_MAX_LIMIT = "log.max.limit.char";
    public static final String LOG_SKIP_CONSOLE = "console.skip.console.log";
    public static String WATSON = "WATSON";
    public static String MARY = "MARY";
    public static final String LOG4JPATH = Config.RESOURCE_PATH + "/log4j2.xml";

    public static void ConsoleLogNoLimit(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, TestLog.formatMessageNoLimit(value, args));
    }

    public static void ConsoleLog(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, TestLog.formatMessage(value, args));
    }

    public static void ConsoleLogWarn(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.WARN, TestLog.formatMessage(value, args));
    }

    public static void ConsoleLogDebug(String value, Object ... args) {
        boolean isDebug = Config.getBooleanValue(ENABLE_DEBUG);
        if (isDebug) {
            TestLog.logConsoleMessage(Level.WARN, TestLog.formatMessage(value, args));
        }
    }

    public static void ConsoleLogError(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.ERROR, TestLog.formatMessage(value, args));
    }

    public static synchronized void Background(String value, Object ... args) {
        TestLog.setTestStep(gherkins.Background, value, args);
    }

    public static synchronized void But(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, "But " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.But, value, args);
    }

    public static synchronized void Given(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, "Given " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.Given, value, args);
    }

    public static synchronized void When(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, "When " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.When, value, args);
        TestLog.playAudio(gherkins.When.name() + " " + TestLog.formatMessage(value, args));
    }

    public static synchronized void And(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, "And " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.And, value, args);
        TestLog.playAudio(gherkins.And.name() + " " + TestLog.formatMessage(value, args));
    }

    public static synchronized void Then(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, "Then " + TestLog.formatMessage(value, args));
        TestLog.setTestStep(gherkins.Then, value, args);
        TestLog.playAudio(gherkins.Then.name() + " " + TestLog.formatMessage(value, args));
    }

    public static synchronized void setTestStep(gherkins gherkinState, String value, Object ... args) {
        ExtentTest testStep = null;
        TestObject.testState state = TestObject.getTestState(TestObject.getTestInfo().testId);
        if (!state.equals((Object)TestObject.testState.testMethod)) {
            return;
        }
        switch (gherkinState) {
            case Given: {
                testStep = TestLog.getTestScenario().createNode(Given.class, "Given " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case When: {
                testStep = TestLog.getTestScenario().createNode(When.class, "When " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case Then: {
                testStep = TestLog.getTestScenario().createNode(Then.class, "Then " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case And: {
                testStep = TestLog.getTestScenario().createNode(And.class, "And " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case But: {
                testStep = TestLog.getTestScenario().createNode(But.class, "But " + TestLog.formatMessage(value, args)).pass("");
                break;
            }
            case Background: {
                testStep = TestLog.getTestScenario().createNode(Background.class, TestLog.formatMessage(value, args)).pass("");
                break;
            }
            default: {
                Helper.assertFalse("incorrect state " + gherkinState.name());
            }
        }
        if (TestObject.getTestInfo().testSteps == null) {
            return;
        }
        TestObject.getTestInfo().testSteps.add(testStep);
        AbstractDriver.getStep().set(testStep);
    }

    public static void setPassSubTestStep(String subStep) {
        if (TestLog.getTestStep() == null) {
            return;
        }
        TestObject.testState state = TestObject.getTestState(TestObject.getTestInfo().testId);
        if (!state.equals((Object)TestObject.testState.testMethod)) {
            return;
        }
        TestObject.getTestInfo().testSubSteps.add(subStep);
        String label = "<head>\r\n    <meta charset=\"UTF-8\">\r\n    <title>Textarea autoresize</title>\r\n    <style>\r\n    textarea {\r\n        border-style: none;\r\n        border-color: Transparent;\r\n        background-color: #f0f3f5;\r\n        font-size: 14px;\r\n        overflow: hidden;\r\n    }\r\n    </style>\r\n    <script>\r\n    function resizeTextarea(ev) {\r\n        this.style.height = '24px';\r\n        this.style.height = this.scrollHeight + 12 + 'px';\r\n    }\r\n\r\n    var te = document.querySelector('textarea');\r\n    te.addEventListener('input', resizeTextarea);\r\n    </script>\r\n</head> <body>\r\n    <textarea> " + subStep + "</textarea>\r\n";
        Markup m = MarkupHelper.createLabel((String)label, (ExtentColor)ExtentColor.WHITE);
        TestLog.getTestStep().pass(m);
    }

    public static void attachVideoLog(String path, boolean isVideoAttached) {
        TestObject.testState state = TestObject.getTestState(TestObject.getTestInfo().testId);
        if (!state.equals((Object)TestObject.testState.testMethod)) {
            return;
        }
        if (!Config.getValue("report.reporterType").equals("html")) {
            path = ExtentManager.getReportRootFullPath() + path;
        }
        String videoLog = "<video width=\"320\" height=\"240\" controls>\r\n  <source src=" + path + " type=\"video/mp4\">\r\n  Your browser does not support the video tag.\r\n</video>";
        if (isVideoAttached) {
            TestLog.getTestStep().pass(videoLog);
        }
        TestLog.getTestStep().pass("<a href='" + path + "'>screen recording Link</a>");
        TestObject.getTestInfo().testSubSteps.add("screen recording relative path: " + path);
    }

    public static void attachVideoLogToReportPortal(File video) {
        try {
            URL url = video.toURI().toURL();
            TestLog.ConsoleLog("path to file: ", url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void logPass(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.INFO, TestLog.formatMessage(value, args));
        if (Config.getValue(ENABLE_EXTENT_SUBSTEPS).equals("true")) {
            TestLog.setPassSubTestStep(TestLog.formatMessage(value, args));
        }
    }

    public static void logFail(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.ERROR, TestLog.formatMessage(value, args));
    }

    public static void logWarning(String value, Object ... args) {
        TestLog.logConsoleMessage(Level.WARN, TestLog.formatMessage(value, args));
    }

    public static ExtentTest getTestScenario() {
        return TestObject.getTestInfo().testScenerio;
    }

    public static String formatMessageNoLimit(String value, Object ... args) {
        return TestLog.formatMessage(value, false, args);
    }

    public static String formatMessage(String value, Object ... args) {
        return TestLog.formatMessage(value, true, args);
    }

    public static String formatMessage(String value, boolean isLimitMessage, Object ... args) {
        if (isLimitMessage) {
            value = TestLog.setMaxLength(value);
        }
        if (args == null || args.length == 0) {
            return value;
        }
        try {
            return new MessageFormat(value).format(args);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String setMaxLength(String value) {
        boolean isLogLimit = Config.getBooleanValue(IS_LOG_LIMIT);
        int logMaxLimit = Config.getIntValue(LOG_MAX_LIMIT);
        if (logMaxLimit == -1) {
            logMaxLimit = value.length();
        }
        if (isLogLimit) {
            return TestLog.setMaxLength(value, logMaxLimit);
        }
        return value;
    }

    public static String setMaxLength(String value, int length) {
        try {
            int maxLength;
            int n = maxLength = value.length() < length ? value.length() : length;
            if (maxLength == length) {
                return value.substring(0, maxLength) + "...";
            }
            return value.substring(0, maxLength);
        }
        catch (Exception e) {
            System.out.println("value: " + value);
            System.out.println("length: " + length);
            e.getMessage();
            return "";
        }
    }

    public static void removeLogUtilHandler() {
    }

    public static void setupLog4j() {
        File f = new File(LOG4JPATH);
        URI fc = f.toURI();
        LoggerContext.getContext().setConfigLocation(fc);
    }

    public static void playAudio(String value) {
        Boolean isAudioCommentaryEnabled = CrossPlatformProperties.getAudioCommentary();
        String type = CrossPlatformProperties.getAudioCommentaryType();
        if (isAudioCommentaryEnabled.booleanValue()) {
            if (type.equals(WATSON)) {
                TestLog.playWatsonAudio(value);
            } else if (type.equals(MARY)) {
                TestLog.playMaryAudio(value);
            }
        }
    }

    public static void playMaryAudio(String value) {
    }

    public static synchronized void playWatsonAudio(String value) {
    }

    private static void logConsoleMessage(Level priority, String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return;
        }
        if (Config.getBooleanValue(LOG_SKIP_CONSOLE).booleanValue()) {
            return;
        }
        value = Helper.date.getTimestampSeconds() + " : " + TestLog.getTestLogPrefix() + value;
        value = Helper.stringRemoveLines(value);
        Boolean enableBatchLogging = CrossPlatformProperties.getEnableBatchLogging();
        if (!enableBatchLogging.booleanValue()) {
            TestObject.getTestInfo().log.info(value);
        }
        LogObject log = new LogObject(value, priority);
        TestObject.getTestInfo().testLog.add(log);
    }

    private static String getTestLogPrefix() {
        return TestObject.getTestInfo().className + "-" + TestObject.getTestInfo().testName + " - ";
    }

    private static synchronized ExtentTest getTestStep() {
        return AbstractDriver.getStep().get();
    }

    public static synchronized void printBatchLogsToConsole() {
        Boolean enableBatchLogging = CrossPlatformProperties.getEnableBatchLogging();
        if (!enableBatchLogging.booleanValue()) {
            return;
        }
        if (TestObject.getTestInfo().isTestComplete.booleanValue()) {
            TestLog.printBatchClassToConsole(TestObject.BEFORE_CLASS_PREFIX);
            TestLog.printLogs(TestObject.getTestInfo().testLogAll);
        }
    }

    public static void printBatchClassToConsole(String classType) {
        String testId = TestObject.getTestInfo().testFileClassName + classType;
        TestLog.printBatchToConsole(testId);
    }

    public static void printBatchToConsole(String testId) {
        if (!CrossPlatformProperties.getEnableBatchLogging().booleanValue()) {
            return;
        }
        if (TestObject.testInfo.get(testId) == null) {
            return;
        }
        List<LogObject> logs = TestObject.getTestInfo((String)testId).testLog;
        if (!logs.isEmpty()) {
            TestLog.printLogs(logs, testId);
        }
    }

    public static void printLogs(List<LogObject> logs) {
        TestLog.printLogs(logs, "");
    }

    public static void printLogs(List<LogObject> testLog, String testId) {
        for (LogObject log : testLog) {
            if (testId.isEmpty()) {
                TestObject.getTestInfo().log.log(log.priority, log.value);
                continue;
            }
            TestObject.getTestInfo((String)testId).log.log(log.priority, log.value);
        }
        if (testId.isEmpty()) {
            TestObject.getTestInfo().testLog = new ArrayList<LogObject>();
        } else {
            TestObject.getTestInfo((String)testId).testLog = new ArrayList<LogObject>();
        }
    }

    public static void printLogoOnSuccess() {
        if (!Config.getBooleanValue("console.printLogoOnSuccess").booleanValue()) {
            return;
        }
        System.out.println("\r\n                   #                   \r\n               /##  /##                \r\n           ####    #    ###,           \r\n(########      ########      (######## \r\n#        *###################         #\r\n#  ############### # ############### .#\r\n#  ############# ##### ############/ /#\r\n#  ########### ###  .###.##########  ##\r\n#( ######### ###       ### ########  # \r\n##  ###### ###          .### ######  # \r\n #       ### #############.###      #( \r\n ##    ### #################.###    #  \r\n  ##  ## ##################### #(  #   \r\n   #(  #########################  #.   \r\n    #(  #######################  #/    \r\n     ##  ####################   #      \r\n      *#   #################  ,#       \r\n        ##   #############   #.        \r\n          #,   ########*   ##          \r\n            ##    .#     #(            \r\n              ,##    ,##               \r\n                  ##, ");
    }

    public static boolean checkLatestAutonomxMavenVersion() {
        try {
            return TestLog.checkLatestAutonomx();
        }
        catch (Exception e) {
            Config.putValue(LOG_SKIP_CONSOLE, (Object)false, false);
            System.out.println("Something has gone wrong with maven version check. error <: " + e.getMessage() + "> To disable this message, set console.checkLatestAutonomx to false at report.property");
        }
        catch (AssertionError e) {
            Config.putValue(LOG_SKIP_CONSOLE, (Object)false, false);
            System.out.println("Something has gone wrong with maven version check. error <: " + ((Throwable)((Object)e)).getMessage() + "> To disable this message, set console.checkLatestAutonomx to false at report.property");
        }
        return false;
    }

    public static boolean checkLatestAutonomx() {
        if (!Config.getBooleanValue("console.checkLatestAutonomx").booleanValue()) {
            return false;
        }
        Config.putValue(LOG_SKIP_CONSOLE, (Object)true, false);
        ServiceObject service = new ServiceObject().withMethod("GET").withUriPath("https://mvnrepository.com/artifact/io.autonomx/autonomx-core/latest");
        Response response = RestApiInterface.RestfullApiInterface(service);
        if (response == null) {
            return false;
        }
        String responseString = response.asString();
        if (responseString.isEmpty()) {
            return false;
        }
        String version = "";
        version = UtilityHelper.getValueBetweenStrings(responseString, "https://mvnrepository.com/artifact/io.autonomx/autonomx-core/", "/>", 1);
        if (version.isEmpty()) {
            return false;
        }
        String versionValue = Helper.stringNormalize(version);
        String autonomxCurrentVersionString = UtilityHelper.getMavenDependencyVersion("autonomxCore");
        if (autonomxCurrentVersionString.isEmpty()) {
            return false;
        }
        try {
            ComparableVersion autonomxMavenCentral = new ComparableVersion(versionValue);
            ComparableVersion localAutonomx = new ComparableVersion(autonomxCurrentVersionString);
            if (autonomxMavenCentral.compareTo(localAutonomx) > 0) {
                System.out.println("New version of Autonomx is available. current version: <" + autonomxCurrentVersionString + "> Latest version: <" + versionValue + "> Please consider updating to the latest version at the pom.xml file for the dependency: autonomxCore. Release notes at: https://github.com/autonomx/Autonomx/releases. To disable this message, set console.checkLatestAutonomx to false at report.property");
                return true;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return false;
    }

    static enum gherkins {
        Given,
        When,
        Then,
        And,
        But,
        Background;

    }
}

