/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.file.CloudFile;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileDirectory;
import com.microsoft.azure.storage.file.CloudFileShare;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;
import org.apache.commons.lang3.ArrayUtils;

public class AzureInterface {
    private static final String AZURE_ACCOUNT_KEY = "azure.key";
    private static final String AZURE_ACCOUNT = "azure.account";
    private static final String UPLOAD_TO_FILE_SHARE = "azure.uploadToFileShare";
    public static CloudStorageAccount conn = null;

    public static void AzureClientInterface(ServiceObject apiObject) throws Exception {
        AzureInterface.connectAzure();
        switch (apiObject.getMethod()) {
            case "azure.uploadToFileShare": {
                AzureInterface.azureUploadToFileShare(apiObject);
                break;
            }
            default: {
                Helper.assertTrue("method not selected", false);
            }
        }
    }

    public static synchronized void connectAzure() throws Exception {
        if (conn == null) {
            String account = Config.getValue(AZURE_ACCOUNT);
            String key = Config.getValue(AZURE_ACCOUNT_KEY);
            String storageConnectionString = "DefaultEndpointsProtocol=http;AccountName=" + account + ";AccountKey=" + key;
            conn = CloudStorageAccount.parse((String)storageConnectionString);
        }
    }

    public static void azureUploadToFileShare(ServiceObject apiObject) throws Exception {
        TestLog.logPass("calling method: " + apiObject.getMethod(), new Object[0]);
        CloudFileDirectory cloudFileDirectory = AzureInterface.getCloudfileDirectory(apiObject);
        String filePath = DataHelper.getTemplateFileLocation(apiObject.getTemplateFile());
        TestLog.logPass("uploading file: " + apiObject.getTemplateFile(), new Object[0]);
        CloudFile cloudFile = cloudFileDirectory.getFileReference(apiObject.getTemplateFile());
        cloudFile.uploadFromFile(filePath);
    }

    public static CloudFileDirectory getCloudfileDirectory(ServiceObject apiObject) throws Exception {
        String destination = apiObject.getOption().split(":")[1];
        TestLog.logPass("uploading to dir: " + destination, new Object[0]);
        Object[] dirs = destination.split("/");
        CloudFileClient fileClient = conn.createCloudFileClient();
        CloudFileShare share = fileClient.getShareReference(dirs[0]);
        dirs = (String[])ArrayUtils.removeElement((Object[])dirs, (Object)dirs[0]);
        CloudFileDirectory cloudFileDirectory = share.getRootDirectoryReference();
        for (Object dir : dirs) {
            cloudFileDirectory = cloudFileDirectory.getDirectoryReference((String)dir);
            cloudFileDirectory.createIfNotExists();
        }
        return cloudFileDirectory;
    }
}

