/*
 * Decompiled with CFR 0.152.
 */
package core.support.objects;

import core.helpers.Helper;
import core.support.objects.DeviceObject;
import core.support.objects.TestObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DeviceManager {
    public static Map<String, DeviceObject> devices = new ConcurrentHashMap<String, DeviceObject>();

    public static synchronized String getFirstAvailableDevice(DeviceObject.DeviceType deviceType) {
        for (Map.Entry<String, DeviceObject> entry : devices.entrySet()) {
            if (entry.getValue().deviceType != deviceType || !entry.getValue().isAvailable.equals(true)) continue;
            entry.getValue().isAvailable = false;
            devices.put(entry.getKey(), entry.getValue());
            TestObject.getTestInfo().deviceName = entry.getValue().deviceName;
            return entry.getValue().deviceName;
        }
        return "";
    }

    public static void loadDevices(List<String> deviceList, DeviceObject.DeviceType type) {
        for (String deviceName : deviceList) {
            if (devices.get(deviceName) != null) continue;
            DeviceObject device = new DeviceObject().withDeviceName(deviceName).withIsAvailable(true).withDeviceType(type);
            devices.put(deviceName, device);
        }
    }

    public static void setDeviceAvailability(Boolean isAvailable) {
        if (!Helper.mobile.isMobile()) {
            return;
        }
        if (Helper.mobile.isWinApp()) {
            return;
        }
        String deviceName = TestObject.getTestInfo().deviceName;
        if (devices.get(deviceName) != null) {
            devices.put(deviceName, devices.get(deviceName).withIsAvailable(true));
        } else {
            Helper.assertFalse("device not found: " + deviceName);
        }
    }
}

