/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.response.Response;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonHelper {
    public static String failOnEscapeChars = "service.validation.fail.on.escapechars";

    public static void saveOutboundJsonParameters(Response response, String outputParam) {
        if (response == null || outputParam.isEmpty()) {
            return;
        }
        outputParam = DataHelper.replaceParameters(outputParam);
        List<KeyValue> keywords = DataHelper.getValidationMap(outputParam);
        for (KeyValue keyword : keywords) {
            if (keyword.key.toString().trim().startsWith(DataHelper.JSON_COMMAND.command.name())) {
                String value;
                keyword.key = value = JsonHelper.validateResponseBody(keyword.key.toString(), response);
                JsonHelper.configMapKeyValues(response, keyword);
                continue;
            }
            JsonHelper.configMapJsonKeyValues(response, keyword);
        }
    }

    public static void configMapJsonKeyValues(Response response, KeyValue keyword) {
        String value;
        keyword.key = value = JsonHelper.getJsonValue(response, keyword.key);
        JsonHelper.configMapKeyValues(response, keyword);
    }

    public static void configMapKeyValues(Response response, KeyValue keyword) {
        if (!(keyword.value.toString().startsWith("<") && keyword.value.toString().contains("$") && keyword.value.toString().endsWith(">"))) {
            Helper.assertFalse("variable placement must of format path: <$variable>. invalid value: " + keyword.value.toString());
        }
        String key = (String)keyword.value;
        key = key.replace("$", "").replace("<", "").replace(">", "").trim();
        String value = keyword.key;
        if (!keyword.position.isEmpty()) {
            value = value.split(",")[Integer.valueOf(keyword.position) - 1];
        }
        Config.putValue(key, (Object)value, false);
        TestLog.logPass("output parameter: " + key + " value: " + value, new Object[0]);
    }

    public static String getJsonValue(Response response, String path) {
        String jsonResponse = response.getBody().asString();
        String value = JsonHelper.getJsonValue(jsonResponse, path);
        return value;
    }

    public static String getJsonValue(String json, String path) {
        return JsonHelper.getJsonValue(json, path, true);
    }

    public static String getJsonValue(String json, String path, boolean isAlwaysReturnList) {
        Object values = JsonHelper.getJsonPathValue(json, path, isAlwaysReturnList);
        if (values == null) {
            return null;
        }
        if (JsonHelper.isValidJsonObject(values)) {
            return values.toString();
        }
        return DataHelper.objectToString(values);
    }

    public static Object getJsonPathValue(String json, String path, boolean isAlwaysReturnList) {
        return JsonHelper.getJsonPathValue(json, path, isAlwaysReturnList, true);
    }

    public static Object getJsonPathValue(String json, String path, boolean isAlwaysReturnList, boolean checkError) {
        Object values;
        block7: {
            String prefix = "$.";
            values = null;
            JsonHelper.isJSONValid(json, true);
            if (Config.getBooleanValue(failOnEscapeChars).booleanValue() && JsonHelper.containsEscapeChar(json)) {
                Helper.assertFalse("invalid escape character in json. invalid chars are: \\\", \\b, \\n, \\r, \\f, \\', \\\\: " + json);
            }
            if (path.startsWith(prefix)) {
                path = path.replace(prefix, "");
            }
            Configuration config = null;
            config = isAlwaysReturnList ? Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST}) : Configuration.defaultConfiguration();
            DocumentContext ctx = JsonPath.using((Configuration)config).parse(json);
            if (path.equals(".")) {
                return json;
            }
            try {
                values = ctx.read(prefix + path, new Predicate[0]);
            }
            catch (Exception e) {
                if (e.getMessage().contains(Option.ALWAYS_RETURN_LIST.name()) && isAlwaysReturnList) {
                    values = JsonHelper.getJsonValue(json, path, false);
                }
                if (!checkError) break block7;
                TestLog.logWarning("invalid path: '" + path + "' for json string: " + json + "\n. see http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n" + e.getMessage(), new Object[0]);
            }
        }
        if (values == null && checkError) {
            TestLog.logWarning("no results returned: '" + path + "'. see http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info.", new Object[0]);
        }
        return values;
    }

    public static boolean isJsonPathValueString(String json, String path) {
        JSONArray array;
        String prefix = "$.";
        Object jsonResponse = null;
        Object value = "";
        if (path.startsWith(prefix)) {
            path = path.replace(prefix, "");
        }
        Configuration config = Configuration.defaultConfiguration().addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
        DocumentContext ctx = JsonPath.using((Configuration)config).parse(json);
        try {
            jsonResponse = ctx.read(prefix + path, new Predicate[0]);
        }
        catch (Exception e) {
            e.getCause();
        }
        if (jsonResponse == null) {
            return false;
        }
        if (jsonResponse instanceof List && !(array = (JSONArray)jsonResponse).isEmpty()) {
            value = array.get(0);
        }
        return value instanceof String;
    }

    public static boolean containsEscapeChar(String value) {
        String[] escapeChars;
        for (String escape : escapeChars = new String[]{"\\\"", "\\b", "\\n", "\\r", "\\f", "\\'", "\\\\"}) {
            if (!value.contains(escape)) continue;
            return true;
        }
        return false;
    }

    public static String getJsonValueFromXml(String xml, String path) {
        String json = JsonHelper.XMLToJson(xml);
        return JsonHelper.getJsonValue(json, path);
    }

    public static String XMLToJson(String xml) {
        int printIndentFactor = 4;
        String jsonString = "";
        try {
            JSONObject xmlJSONObj = XML.toJSONObject((String)xml);
            jsonString = xmlJSONObj.toString(printIndentFactor);
        }
        catch (JSONException je) {
            je.toString();
        }
        return jsonString;
    }

    public static String getResponseValue(Response response) {
        return response.getBody().asString();
    }

    public static List<String> validateJsonKeywords(List<KeyValue> keywords, String responseString) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (KeyValue keyword : keywords) {
            String jsonPath = Helper.removeSurroundingQuotes(keyword.key);
            String expectedValue = Helper.stringRemoveLines((String)keyword.value);
            String command = "";
            String[] expected = expectedValue.split("[\\(\\)]");
            if (expected.length > 1) {
                command = expected[0];
                expectedValue = expected[1];
            } else if (expected.length == 1) {
                command = expectedValue;
                expectedValue = "";
            }
            TestLog.ConsoleLog("command: <" + command + "> json path: <" + jsonPath + ">", new Object[0]);
            String jsonPathResponse = JsonHelper.getJsonValue(responseString, jsonPath);
            if (StringUtils.isBlank((String)jsonPathResponse) && !keyword.value.toString().startsWith(DataHelper.JSON_COMMAND.command.name())) {
                if (keyword.value.equals(DataHelper.JSON_COMMAND.isEmpty.name())) continue;
                errorMessages.add("response returned, however, no jsonpath response returned for path: " + jsonPath);
                continue;
            }
            String errorMessage = DataHelper.validateCommand(command, jsonPathResponse, expectedValue, keyword.position, false);
            errorMessages.add(errorMessage);
        }
        errorMessages.removeAll(Collections.singleton(""));
        return errorMessages;
    }

    public static boolean isJSONValid(String value, boolean isFailOnError) {
        String error = "";
        String expectedJson = Helper.stringNormalize(value);
        if (expectedJson.startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_VERIFY_JSON_PART_") || expectedJson.startsWith("_NOT_EMPTY_") || expectedJson.startsWith("_VERIFY_RESPONSE_BODY_")) {
            return false;
        }
        try {
            new JSONObject(value);
        }
        catch (JSONException ex) {
            try {
                error = ex.getMessage();
                new org.json.JSONArray(value);
            }
            catch (JSONException ex1) {
                if (error.isEmpty()) {
                    error = ex1.getMessage();
                }
                if (isFailOnError) {
                    Helper.assertFalse("Invalid Json. Error: " + error + "\n json: " + value);
                }
                return false;
            }
        }
        return true;
    }

    public static String validateByJsonBody(String expectedJson, String response) {
        return JsonHelper.validateByJsonBody(expectedJson, response, false);
    }

    public static String validateByJsonBody(String expectedJson, String response, boolean hasToBeJsonBody) {
        block6: {
            if (JsonHelper.isJSONValid(expectedJson = Helper.stringRemoveLines(expectedJson), false)) {
                if (StringUtils.isBlank((String)response)) {
                    return "response from json path is empty";
                }
                TestLog.logPass("expecting partial json: " + Helper.stringRemoveLines(expectedJson), new Object[0]);
                try {
                    JSONCompareResult result = JSONCompare.compareJSON((String)expectedJson, (String)response, (JSONCompareMode)JSONCompareMode.LENIENT);
                    if (result.failed()) {
                        return result.getMessage() + "\nsee http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n\n expectedJson: " + expectedJson + "\n\n response: " + response + "\n\n";
                    }
                    break block6;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return e.getMessage() + "\nsee http://jsonpath.herokuapp.com to validate your path against json string. see https://github.com/json-path/JsonPath for more info. \n\n expectedJson: " + expectedJson + "\n\n response: " + response + "\n\n";
                }
            }
            if (hasToBeJsonBody) {
                return "expected String is not valid json: " + expectedJson;
            }
        }
        return "";
    }

    public static List<String> validateByKeywords(String expectedJson, Response response) {
        String responseString = JsonHelper.getResponseValue(response);
        return JsonHelper.validateByKeywords(expectedJson, responseString);
    }

    public static List<String> validateByKeywords(String expectedJson, String responseString) {
        List<String> errorMessages = new ArrayList<String>();
        expectedJson = Helper.stringRemoveLines(expectedJson);
        if (!JsonHelper.isJSONValid(expectedJson = Helper.removeSurroundingQuotes(expectedJson), false)) {
            if (expectedJson.startsWith("_VERIFY.JSON.PART_") || expectedJson.startsWith("_VERIFY_JSON_PART_")) {
                List<KeyValue> keywords = DataHelper.getValidationMap(expectedJson);
                errorMessages = JsonHelper.validateJsonKeywords(keywords, responseString);
            } else if (expectedJson.startsWith("_NOT_EMPTY_") && responseString.isEmpty()) {
                errorMessages.add("response is empty");
            }
        }
        return errorMessages;
    }

    public static String validateResponseBody(String expected, Response response) {
        String responseString = JsonHelper.getResponseValue(response);
        return JsonHelper.validateResponseBody(expected, responseString);
    }

    public static String validateResponseBody(String expected, String responseString) {
        expected = Helper.stringRemoveLines(expected);
        if (!((expected = Helper.removeSurroundingQuotes(expected)).startsWith("_VERIFY_RESPONSE_BODY_") || expected.startsWith("_VERIFY_HEADER_PART_") || expected.startsWith(DataHelper.JSON_COMMAND.command.name()) || expected.startsWith("_VERIFY_TOPIC_PART_"))) {
            return "";
        }
        expected = JsonHelper.removeResponseIndicator(expected);
        String[] expectedArr = expected.split("[\\(\\)]");
        String expectedValue = "";
        String command = "";
        if (expectedArr.length == 1) {
            command = expected.trim();
        } else {
            command = expectedArr[0].trim();
            expectedValue = expectedArr[1].trim();
        }
        return DataHelper.validateCommand(command, responseString, expectedValue, "0", false);
    }

    public static String removeResponseIndicator(String expected) {
        ArrayList<String> indicator = new ArrayList<String>();
        indicator.add("_VERIFY_RESPONSE_BODY_");
        indicator.add("_VERIFY.JSON.PART_");
        indicator.add("_VERIFY_JSON_PART_");
        indicator.add("_VERIFY_HEADER_PART_");
        indicator.add("_VERIFY_TOPIC_PART_");
        indicator.add("_UPDATE_REQUEST_");
        for (String value : indicator) {
            expected = expected.replace(value, "");
        }
        return expected.trim();
    }

    public static String getRequestBodyFromJsonTemplate(ServiceObject serviceObject) {
        if (!JsonHelper.isJsonFile(serviceObject.getTemplateFile())) {
            return "";
        }
        Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
        String jsonFileValue = DataHelper.convertFileToString(templatePath);
        jsonFileValue = DataHelper.replaceParameters(jsonFileValue);
        if (serviceObject.getRequestBody().isEmpty()) {
            return jsonFileValue;
        }
        return JsonHelper.updateJsonFromRequestBody(serviceObject.getRequestBody(), jsonFileValue);
    }

    public static boolean isJsonFile(String filename) {
        return filename.toLowerCase().endsWith("json");
    }

    public static String convertJsonFileToString(Path templatePath) {
        return Helper.readFileContent(templatePath.toString());
    }

    public static String updateJsonFromRequestBody(ServiceObject service) {
        String jsonString = DataHelper.getServiceObjectTemplateString(service);
        return JsonHelper.updateJsonFromRequestBody(service.getRequestBody(), jsonString);
    }

    public static String updateJsonFromRequestBody(String requestbody, String jsonString) {
        Helper.assertTrue("json string is empty", !jsonString.isEmpty());
        jsonString = DataHelper.replaceParameters(jsonString);
        if (JsonHelper.isJSONValid(requestbody, false)) {
            return requestbody;
        }
        List<KeyValue> keywords = DataHelper.getValidationMap(requestbody);
        for (KeyValue keyword : keywords) {
            if (keyword.value.toString().isEmpty()) continue;
            jsonString = JsonHelper.replaceJsonPathValue(jsonString, keyword.key, keyword.value.toString());
        }
        return jsonString;
    }

    public static String replaceJsonPathValue(String jsonString, String path, String value) {
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        DocumentContext doc = null;
        doc = JsonHelper.isJsonPathValueExist(jsonString, path) ? JsonPath.parse((String)jsonString) : JsonPath.using((Configuration)conf).parse(jsonString);
        String prefix = "$.";
        boolean isJsonPathValueString = JsonHelper.isJsonPathValueString(jsonString, path);
        Object replacementValue = JsonHelper.convertToObject(value, isJsonPathValueString);
        if (path.startsWith(prefix)) {
            path = path.replace(prefix, "");
        }
        try {
            doc.set(JsonPath.compile((String)("$." + path), (Predicate[])new Predicate[0]), replacementValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc.jsonString();
    }

    public static boolean isJsonPathValueExist(String jsonString, String jsonPath) {
        Object value = JsonHelper.getJsonPathValue(jsonString, jsonPath, false, false);
        return value != null;
    }

    public static Object convertToObject(String value, boolean isPathValueString) {
        Object objectvalue = null;
        if (isPathValueString) {
            objectvalue = value;
        } else {
            ObjectMapper ob = new ObjectMapper();
            ob.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            try {
                objectvalue = ob.readValue(value, Object.class);
            }
            catch (IOException e) {
                objectvalue = value;
            }
        }
        if (objectvalue != null && objectvalue.equals("null")) {
            objectvalue = null;
        }
        return objectvalue;
    }

    public static org.json.JSONArray getJsonArray(String jsonString) {
        try {
            return new org.json.JSONArray(jsonString);
        }
        catch (JSONException ex) {
            ex.getMessage();
            return null;
        }
    }

    public static JSONObject getJsonObject(String jsonString) {
        try {
            return new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            ex.getMessage();
            return null;
        }
    }

    public static boolean isValidJsonObject(Object jsonObject) {
        String[] keyValues;
        String jsonString;
        if (jsonObject instanceof Map) {
            jsonObject = new Gson().toJson(jsonObject, Map.class);
        }
        if (JsonHelper.getJsonArray(jsonString = jsonObject.toString()) == null && JsonHelper.getJsonObject(jsonString) == null) {
            return false;
        }
        if (jsonString.startsWith("{") && jsonString.endsWith("}")) {
            return true;
        }
        if (jsonString.startsWith("[") && jsonString.endsWith("]") && jsonString.contains("{") && jsonString.contains("}")) {
            return true;
        }
        if (jsonString.startsWith("[") && jsonString.endsWith("]")) {
            return false;
        }
        String jsonNormalized = DataHelper.objectToString(jsonString);
        for (String keyvalue : keyValues = jsonNormalized.split(",")) {
            if (!keyvalue.contains(":") || StringUtils.countMatches((String)keyvalue, (String)":") != 1) continue;
            return true;
        }
        return false;
    }

    public static List<String> arrayRemoveAllEmptyString(List<String> list) {
        list.removeAll(Collections.singleton(""));
        return list;
    }
}

