/*
 * Decompiled with CFR 0.152.
 */
package core.support.objects;

import core.helpers.Helper;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ServiceObject {
    private String TestSuite = "";
    private String TestCaseID = "";
    private String RunFlag = "";
    private String Description = "";
    private String InterfaceType = "";
    private String UriPath = "";
    private String ContentType = "";
    private String Method = "";
    private String Option = "";
    private String RequestHeaders = "";
    private String TemplateFile = "";
    private String RequestBody = "";
    private String OutputParams = "";
    private String RespCodeExp = "";
    private String ExpectedResponse = "";
    private String TcComments = "";
    private String tcName = "";
    private String tcIndex = "";
    private String testType = "";
    private Object serviceSteps = null;
    private String parent = "";
    private Response response = null;
    private RequestSpecification request = null;
    private List<String> errorMessages = new ArrayList<String>();
    private Map<String, List<String>> headerMap = new HashMap<String, List<String>>();

    public ServiceObject setServiceObject(String TestSuite, String TestCaseID, String RunFlag, String Description2, String InterfaceType, String UriPath, String ContentType, String Method2, String Option, String RequestHeaders, String TemplateFile, String RequestBody, String OutputParams, String RespCodeExp, String ExpectedResponse, String TcComments, String tcName, String tcIndex, String testType2, Object serviceSteps) {
        this.TestSuite = TestSuite;
        this.TestCaseID = TestCaseID;
        this.RunFlag = RunFlag;
        this.Description = Description2;
        this.InterfaceType = InterfaceType;
        this.UriPath = UriPath;
        this.ContentType = ContentType;
        this.Method = Method2;
        this.Option = Option;
        this.RequestHeaders = RequestHeaders;
        this.TemplateFile = TemplateFile;
        this.RequestBody = RequestBody;
        this.OutputParams = OutputParams;
        this.RespCodeExp = RespCodeExp;
        this.ExpectedResponse = ExpectedResponse;
        this.TcComments = TcComments;
        this.tcName = tcName;
        this.tcIndex = tcIndex;
        this.testType = testType2;
        this.serviceSteps = serviceSteps;
        return this;
    }

    public ServiceObject setServiceObject(Object[] testData) {
        List<String> header = ServiceObject.getMatchingHeader(testData);
        this.TestSuite = ServiceObject.getArrayValue(testData, header.indexOf("TestSuite"));
        this.TestCaseID = ServiceObject.getArrayValue(testData, header.indexOf("TestCaseID"));
        this.RunFlag = ServiceObject.getArrayValue(testData, header.indexOf("RunFlag"));
        this.Description = ServiceObject.getArrayValue(testData, header.indexOf("Description"));
        this.InterfaceType = ServiceObject.getArrayValue(testData, header.indexOf("InterfaceType"));
        this.UriPath = ServiceObject.getArrayValue(testData, header.indexOf("UriPath"));
        this.ContentType = ServiceObject.getArrayValue(testData, header.indexOf("ContentType"));
        this.Method = ServiceObject.getArrayValue(testData, header.indexOf("Method"));
        this.Option = ServiceObject.getArrayValue(testData, header.indexOf("Option"));
        this.RequestHeaders = ServiceObject.getArrayValue(testData, header.indexOf("RequestHeaders"));
        this.TemplateFile = ServiceObject.getArrayValue(testData, header.indexOf("TemplateFile"));
        this.RequestBody = ServiceObject.getArrayValue(testData, header.indexOf("RequestBody"));
        this.OutputParams = ServiceObject.getArrayValue(testData, header.indexOf("OutputParams"));
        this.RespCodeExp = ServiceObject.getArrayValue(testData, header.indexOf("RespCodeExp"));
        this.ExpectedResponse = ServiceObject.getArrayValue(testData, header.indexOf("ExpectedResponse"));
        this.TcComments = ServiceObject.getArrayValue(testData, header.indexOf("TcComments"));
        this.tcName = ServiceObject.getArrayValue(testData, 16);
        this.tcIndex = ServiceObject.getArrayValue(testData, 17);
        this.testType = ServiceObject.getArrayValue(testData, 18);
        this.serviceSteps = this.getObjectValue(testData, 19);
        return this;
    }

    private static List<String> getMatchingHeader(Object[] testData) {
        Map<String, List<String>> headerMap = TestObject.getGlobalTestInfo().serviceObject.getHeaderMap();
        List<String> header = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : headerMap.entrySet()) {
            List<String> value;
            int suiteIndex;
            String testDataSuite;
            String key = entry.getKey();
            if (key.isEmpty() || !(testDataSuite = ServiceObject.getArrayValue(testData, suiteIndex = (value = entry.getValue()).indexOf("TestSuite"))).equals(key)) continue;
            header = value;
            break;
        }
        if (header.isEmpty()) {
            Helper.assertFalse("did not find matching test suite name. Please check suite name in csv file(s). Suite name must be the same in csv file. Test id must be unique in csv.");
        }
        return header;
    }

    private static String getArrayValue(Object[] testData, int index) {
        if (index >= testData.length) {
            return "";
        }
        String value = testData[index].toString();
        if (StringUtils.isBlank((String)value)) {
            return "";
        }
        return value;
    }

    private Object getObjectValue(Object[] testData, int index) {
        if (index >= testData.length) {
            return "";
        }
        Object value = testData[index];
        if (StringUtils.isBlank((String)value.toString())) {
            return "";
        }
        return value;
    }

    public ServiceObject withTestSuite(String testSuite) {
        this.TestSuite = testSuite;
        return this;
    }

    public String getTestSuite() {
        return this.TestSuite;
    }

    public ServiceObject withTestCaseID(String testCaseID) {
        this.TestCaseID = testCaseID;
        return this;
    }

    public String getTestCaseID() {
        return this.TestCaseID.trim();
    }

    public ServiceObject withRunFlag(String runFlag) {
        this.RunFlag = runFlag;
        return this;
    }

    public String getRunFlag() {
        return this.RunFlag.trim();
    }

    public ServiceObject withDescription(String Description2) {
        this.Description = Description2;
        return this;
    }

    public String getDescription() {
        return this.Description;
    }

    public ServiceObject withInterfaceType(String InterfaceType) {
        this.InterfaceType = InterfaceType;
        return this;
    }

    public String getInterfaceType() {
        return this.InterfaceType.trim();
    }

    public ServiceObject withUriPath(String UriPath) {
        this.UriPath = UriPath;
        return this;
    }

    public String getUriPath() {
        return this.UriPath.trim();
    }

    public ServiceObject withContentType(String ContentType) {
        this.ContentType = ContentType;
        return this;
    }

    public String getContentType() {
        return this.ContentType.trim();
    }

    public ServiceObject withMethod(String Method2) {
        this.Method = Method2;
        return this;
    }

    public String getMethod() {
        return ServiceObject.normalize(this.Method);
    }

    public ServiceObject withOption(String Option) {
        this.Option = Option;
        return this;
    }

    public ServiceObject withParent(String parent) {
        this.parent = parent;
        return this;
    }

    public String getParent() {
        if (StringUtils.isBlank((String)this.parent)) {
            return "Autonomx-default";
        }
        return this.parent;
    }

    public String getOption() {
        return this.Option.trim();
    }

    public ServiceObject withRequestHeaders(String RequestHeaders) {
        this.RequestHeaders = RequestHeaders;
        return this;
    }

    public String getRequestHeaders() {
        return ServiceObject.normalize(this.RequestHeaders);
    }

    public ServiceObject withTemplateFile(String TemplateFile) {
        this.TemplateFile = TemplateFile;
        return this;
    }

    public String getTemplateFile() {
        return this.TemplateFile.trim();
    }

    public ServiceObject withRequestBody(String RequestBody) {
        this.RequestBody = RequestBody;
        return this;
    }

    public ServiceObject withResponse(Response response) {
        this.response = response;
        return this;
    }

    public ServiceObject withRequest(RequestSpecification request) {
        this.request = request;
        return this;
    }

    public ServiceObject withErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
        return this;
    }

    public ServiceObject withOutputParams(String OutputParams) {
        this.OutputParams = OutputParams;
        return this;
    }

    public String getOutputParams() {
        return ServiceObject.normalize(this.OutputParams);
    }

    public ServiceObject withRespCodeExp(String RespCodeExp) {
        this.RespCodeExp = RespCodeExp;
        return this;
    }

    public String getRespCodeExp() {
        return this.RespCodeExp.trim();
    }

    public ServiceObject withExpectedResponse(String ExpectedResponse) {
        this.ExpectedResponse = ExpectedResponse;
        return this;
    }

    public ServiceObject withTcType(String testType2) {
        this.testType = testType2;
        return this;
    }

    public String getExpectedResponse() {
        return this.ExpectedResponse;
    }

    public ServiceObject withTcComments(String TcComments) {
        this.TcComments = TcComments;
        return this;
    }

    public String getTcComments() {
        return this.TcComments;
    }

    public ServiceObject withTcName(String tcName) {
        this.tcName = tcName.trim();
        return this;
    }

    public Response getResponse() {
        return this.response;
    }

    public RequestSpecification getRequest() {
        return this.request;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public String getRequestBody() {
        return ServiceObject.normalize(this.RequestBody);
    }

    public String getTcName() {
        return this.tcName.trim();
    }

    public String getTcType() {
        return this.testType;
    }

    public ServiceObject withHeaderMap(String testcaseId, ArrayList<String> header) {
        this.headerMap.put(testcaseId, header);
        return this;
    }

    public Map<String, List<String>> getHeaderMap() {
        return this.headerMap;
    }

    public HashMap<String, List<Object>> getServiceSteps() {
        if (this.serviceSteps == null) {
            return null;
        }
        if (this.serviceSteps.toString().isEmpty()) {
            return null;
        }
        HashMap map = (HashMap)this.serviceSteps;
        if (map != null && map.size() > 0) {
            return map;
        }
        return null;
    }

    public ServiceObject withTcIndex(String tcIndex) {
        this.tcIndex = tcIndex;
        return this;
    }

    public String getTcIndex() {
        return this.tcIndex.split(":")[0];
    }

    public String getTcCount() {
        return this.tcIndex.split(":")[1];
    }

    public static String normalizeLog(String value) {
        value = TestLog.setMaxLength(value);
        value = StringUtils.normalizeSpace((String)value);
        return value.replaceAll("[\\u2018\\u2019]", "'").replaceAll("[\\u201C\\u201D]", "\"");
    }

    public static String normalize(String value) {
        value = value.trim().replaceAll(" +", " ");
        return value.replaceAll("[\\u2018\\u2019]", "'").replaceAll("[\\u201C\\u201D]", "\"");
    }
}

