/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import com.epam.reportportal.message.ReportPortalMessage;
import com.profesorfalken.jpowershell.PowerShell;
import com.profesorfalken.jpowershell.PowerShellResponse;
import core.helpers.Element;
import core.helpers.Helper;
import core.support.annotation.processor.MainGenerator;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.drivers.AbstractDriverTestNG;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import java8.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.zeroturnaround.zip.ZipUtil;

public class UtilityHelper {
    public static String generateRandomString(int len) {
        String AB = "0123456789abcdefghijklmnopqrstuvwxyz";
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }

    public static String generateRandomInteger(int len) {
        String AB = "0123456789";
        SecureRandom rnd = new SecureRandom();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }

    public static int generateRandomNumber(int min, int max) {
        int random = ThreadLocalRandom.current().nextInt(min, max + 1);
        return random;
    }

    public static String generateUUID() {
        return UtilityHelper.generateUUID(-1, true);
    }

    public static String generateUUID(boolean includeDash) {
        return UtilityHelper.generateUUID(-1, includeDash);
    }

    public static String generateUUID(int length) {
        return UtilityHelper.generateUUID(length, true);
    }

    public static String generateUUID(int length, boolean includeDash) {
        String uuid = UUID.randomUUID().toString();
        if (!includeDash) {
            uuid = uuid.replace("-", "");
        }
        if (length != -1 || length > uuid.length()) {
            uuid = uuid.substring(0, length);
        }
        return uuid;
    }

    public static String stringNormalize(String value) {
        value = StringUtils.normalizeSpace((String)value);
        value = value.trim().replace("\n", "").replace("\r", "").replace("\"", "");
        value = value.replaceAll("\\r|\\n", "");
        return value;
    }

    public static String stringRemoveLines(String value) {
        value = StringUtils.normalizeSpace((String)value).trim();
        return value;
    }

    public static boolean isProcessRunning(String serviceName) throws Exception {
        String line;
        String TASKLIST = "tasklist";
        Process p = Runtime.getRuntime().exec(TASKLIST);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (!line.contains(serviceName)) continue;
            return true;
        }
        return false;
    }

    public static void killWindowsProcess(String serviceName) {
        String KILL = "taskkill /F /IM ";
        UtilityHelper.executeCommand(KILL + serviceName);
    }

    public static void killMacProcess(String serviceName) {
        UtilityHelper.executeCommand("killall " + serviceName);
    }

    public static ArrayList<String> executeCommand(String command) {
        ArrayList<String> results = new ArrayList<String>();
        if (Helper.isMac() || Helper.isUnix()) {
            results = UtilityHelper.runCommand("/bin/sh", "-c", command);
        } else if (Helper.isWindows()) {
            results = UtilityHelper.runCommand("cmd /c start " + command);
        }
        return results;
    }

    public static ArrayList<String> excuteCommandFromFile(String filePath) {
        File file = new File(filePath = Helper.getFullPath(filePath));
        if (!file.isFile()) {
            throw new IllegalArgumentException("The file " + filePath + " does not exist");
        }
        ArrayList<String> results = new ArrayList<String>();
        if (Helper.isMac() || Helper.isUnix()) {
            results = UtilityHelper.runCommand("/bin/sh", "-c", filePath);
        } else if (Helper.isWindows()) {
            results = UtilityHelper.runCommand("cmd /c start " + filePath);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> runCommand(String ... cmd) {
        ArrayList<String> results = new ArrayList<String>();
        Process pr = null;
        boolean success = false;
        int retry = 3;
        String path = CrossPlatformProperties.getPath();
        String[] env = new String[]{"PATH=" + path};
        do {
            --retry;
            try {
                String line;
                Runtime run = Runtime.getRuntime();
                pr = run.exec(cmd, env);
                pr.waitFor();
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                while ((line = buf.readLine()) != null) {
                    results.add(line);
                }
                success = true;
            }
            catch (Exception e) {
                TestLog.ConsoleLogDebug("shell command:  '" + cmd + "' output: " + e.getMessage(), new Object[0]);
            }
            finally {
                if (pr != null) {
                    pr.destroy();
                }
            }
        } while (!success && retry > 0);
        if (results.isEmpty()) {
            TestLog.ConsoleLogDebug("shell command:  '" + cmd + "' did not return results. please check your path: " + path, new Object[0]);
        }
        return results;
    }

    public static String runShellCommand(String command, String timeoutSeconds) {
        PowerShellResponse response = null;
        try (PowerShell powerShell = PowerShell.openSession();){
            HashMap<String, String> myConfig = new HashMap<String, String>();
            myConfig.put("maxWait", timeoutSeconds);
            response = powerShell.configuration(myConfig).executeCommand(command);
            TestLog.ConsoleLogDebug("Shell command: " + response.getCommandOutput(), new Object[0]);
            TestLog.ConsoleLogDebug("Shell command response: " + response.getCommandOutput(), new Object[0]);
        }
        catch (Exception ex) {
            Helper.logStackTrace(ex);
        }
        return response.getCommandOutput();
    }

    public static String runShellScriptFromFile(String scriptPath, String timeoutSeconds) {
        PowerShellResponse response = null;
        try (PowerShell powerShell = PowerShell.openSession();){
            HashMap<String, String> myConfig = new HashMap<String, String>();
            myConfig.put("maxWait", timeoutSeconds);
            response = powerShell.configuration(myConfig).executeScript(scriptPath);
            TestLog.ConsoleLogDebug("Shell command: " + response.getCommandOutput(), new Object[0]);
            TestLog.ConsoleLogDebug("Shell command response: " + response.getCommandOutput(), new Object[0]);
        }
        catch (Exception ex) {
            Helper.logStackTrace(ex);
        }
        return response.getCommandOutput();
    }

    public static void copyDirectory(String dirFrom, String dirTo) {
        File srcDir = new File(dirFrom);
        File destDir = new File(dirTo);
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void executeJavascript(String script) {
        JavascriptExecutor js = (JavascriptExecutor)AbstractDriver.getWebDriver();
        js.executeScript(script, new Object[0]);
    }

    public static ZipOutputStream zipFolder(String srcFolder, String destZipFile) throws Exception {
        ZipOutputStream zip = UtilityHelper.createZip(destZipFile);
        zip.flush();
        zip.close();
        return zip;
    }

    public static ZipOutputStream createZip(String destZipFile) throws FileNotFoundException {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
        return zip;
    }

    public static void addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFile);
        if (folder.isDirectory()) {
            UtilityHelper.addFolderToZip(path, srcFile, zip);
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            zip.putNextEntry(new ZipEntry(path + File.separator + folder.getName()));
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
        }
    }

    private static void addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        File folder = new File(srcFolder);
        for (String fileName : folder.list()) {
            if (path.equals("")) {
                UtilityHelper.addFileToZip(folder.getName(), srcFolder + File.separator + fileName, zip);
                continue;
            }
            UtilityHelper.addFileToZip(path + File.separator + folder.getName(), srcFolder + File.separator + fileName, zip);
        }
    }

    public static List<String> getAllValuesStartringWith(String source, String value) {
        ArrayList<String> values = new ArrayList<String>();
        Pattern pattern = Pattern.compile(value + "\\w+");
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            values.add(matcher.group());
        }
        return values;
    }

    public static String getValueFromPattern(String str, String pattern) {
        return UtilityHelper.getValuesFromPattern(str, pattern).get(0);
    }

    public static List<String> getValuesFromPattern(String str, String pattern) {
        ArrayList<String> tagValues = new ArrayList<String>();
        try {
            Pattern TAG_REGEX = Pattern.compile(pattern);
            Matcher matcher = TAG_REGEX.matcher(str);
            while (matcher.find()) {
                tagValues.add(matcher.group(1));
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return tagValues;
    }

    public static String getRootDir() {
        if (PropertiesReader.LOCAL_ROOT_PATH != null && !PropertiesReader.LOCAL_ROOT_PATH.isEmpty()) {
            return PropertiesReader.LOCAL_ROOT_PATH;
        }
        Path currentWorkingDir = Paths.get("", new String[0]).toAbsolutePath();
        if (UtilityHelper.isFilenameInDir(new File(currentWorkingDir.toString()), "pom")) {
            return currentWorkingDir.normalize().toString() + File.separator;
        }
        if (!MainGenerator.ANNOATION_WORKING_DIR.isEmpty()) {
            return MainGenerator.ANNOATION_WORKING_DIR + File.separator;
        }
        Helper.assertFalse("invalid root directory. is annotations processor turned off? " + currentWorkingDir.toString());
        return "";
    }

    public static boolean isFilenameInDir(File dir, String name) {
        if (dir.isFile() && dir.getName().contains(name)) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return false;
        }
        for (File file : files) {
            if (!file.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    public static void slackNotificationWithFile(String title, String comment, String filePath) {
    }

    public static String zipDir(String sourceDir, String destFilePath) {
        String destFile = destFilePath + ".zip";
        ZipUtil.pack((File)new File(sourceDir), (File)new File(destFile));
        Helper.wait.waitForSeconds(3.0);
        return destFile;
    }

    public static ArrayList<File> getFileListByType(String directoryPath, String type) {
        return UtilityHelper.getFileListByType(directoryPath, type, false);
    }

    public static ArrayList<File> getFileListByType(String directoryPath, String type, boolean includeSubDir) {
        directoryPath = Helper.getFullPath(directoryPath);
        ArrayList<File> filteredFiles = new ArrayList<File>();
        ArrayList<File> testFiles = UtilityHelper.getFileList(directoryPath, includeSubDir);
        for (File file : testFiles) {
            if (!file.isFile() || !file.getName().endsWith(type)) continue;
            filteredFiles.add(file);
        }
        return filteredFiles;
    }

    public static ArrayList<File> getFileList(String directoryPath, boolean includeSubDir) {
        ArrayList<File> testFiles = new ArrayList<File>();
        testFiles = includeSubDir ? UtilityHelper.getFileList(directoryPath, testFiles) : UtilityHelper.getFileList(directoryPath);
        return testFiles;
    }

    public static ArrayList<File> getFileList(String directoryPath, ArrayList<File> files) {
        File directory = new File(directoryPath = Helper.getFullPath(directoryPath));
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile()) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                UtilityHelper.getFileList(file.getAbsolutePath(), files);
            }
        }
        return files;
    }

    public static ArrayList<File> getFileList(String directoryPath) {
        directoryPath = Helper.getFullPath(directoryPath);
        File folder = new File(directoryPath);
        File[] listOfFiles = folder.listFiles();
        ArrayList<File> testFiles = new ArrayList<File>();
        if (listOfFiles == null) {
            Helper.assertFalse("test files not found at path: " + directoryPath);
        }
        for (File file : listOfFiles) {
            if (!file.isFile()) continue;
            testFiles.add(file);
        }
        return testFiles;
    }

    public static String getFullPath(String path) {
        if (!(path = path.replace("\\", File.separator).replace("//", File.separator)).contains(Helper.getRootDir())) {
            path = Helper.getRootDir() + path;
        }
        return path;
    }

    public static File getFile(String directoryPath) {
        File file = new File(directoryPath = Helper.getFullPath(directoryPath));
        if (!file.exists()) {
            Helper.assertFalse("test files not found at path: " + directoryPath);
        }
        return file;
    }

    public static File getFileByName(String path, String filename) {
        return UtilityHelper.getFileByName(path, filename, false);
    }

    public static File getFileByName(String path, String filename, boolean includeSubDir) {
        path = Helper.getFullPath(path);
        ArrayList<File> files = Helper.getFileList(path, includeSubDir);
        for (File file : files) {
            String simplename = file.getName().split("\\.")[0];
            if (!simplename.equals(filename)) continue;
            return file;
        }
        Helper.assertFalse("file: <" + filename + "> not found at path: " + path);
        return null;
    }

    public static List<File> getFileListWithSubfolders(String directoryName, List<File> files) {
        return UtilityHelper.getFileListWithSubfolders(directoryName, "", files);
    }

    public static List<File> getFileListWithSubfolders(String directoryName, String type, List<File> files) {
        File directory = new File(directoryName);
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && type.isEmpty()) {
                    files.add(file);
                    continue;
                }
                if (file.isFile() && !type.isEmpty() && file.getName().endsWith(type)) {
                    files.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                UtilityHelper.getFileListWithSubfolders(file.getAbsolutePath(), type, files);
            }
        }
        return files;
    }

    public static String readFileContent(String absolutePath) {
        return UtilityHelper.getFileContent(absolutePath);
    }

    public static String getFileContent(String absolutePath) {
        return UtilityHelper.getFileContent(absolutePath, true);
    }

    public static String getFileContent(String absolutePath, boolean verifyFileExists) {
        absolutePath = Helper.getFullPath(absolutePath);
        String content = "";
        File file = new File(absolutePath = absolutePath.replaceAll("'", ""));
        if (!file.exists() && verifyFileExists) {
            Helper.assertFalse("file not found at path: " + absolutePath);
        }
        try {
            content = new String(Files.readAllBytes(Paths.get(absolutePath, new String[0])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static File createFileFromPath(String absolutePath) {
        absolutePath = Helper.getFullPath(absolutePath);
        File file = new File(absolutePath);
        Path pathToFile = Paths.get(absolutePath, new String[0]);
        try {
            Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        file.setExecutable(true);
        return file;
    }

    public static void writeFile(String value, String directory, String filename, String type) {
        String fullPath = Helper.getFullPath(directory + File.separator + filename + "." + type);
        UtilityHelper.writeFile(value, fullPath);
    }

    public static void writeFile(String value, String absolutePath) {
        Helper.createFileFromPath(absolutePath);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(absolutePath), "utf-8"));){
            writer.write(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(String absolutePath) {
        File file = new File(absolutePath);
        if (file.isDirectory()) {
            UtilityHelper.deleteDirectory(absolutePath);
        } else {
            UtilityHelper.deleteSingleFile(absolutePath);
        }
    }

    private static void deleteDirectory(String absolutePath) {
        File file = new File(absolutePath);
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void deleteSingleFile(String absolutePath) {
        File file = new File(absolutePath);
        file.delete();
    }

    public static void appendToFile(String value, String absolutePath) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(absolutePath, true));
            writer.write(value);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void appendToFile(String value, String directory, String filename, String type) {
        String fullPath = Helper.getFullPath(directory + File.separator + filename + "." + type);
        UtilityHelper.appendToFile(value, fullPath);
    }

    public static void captureReportScreenshot() {
        Date now = new Date();
        if (AbstractDriverTestNG.getWebDriver() == null) {
            return;
        }
        String format1 = new SimpleDateFormat("yyyy-MM-dd'T'HH-mm-ss", Locale.ENGLISH).format(now);
        String extentReportImageFullPath = ExtentManager.getScreenshotsFolderFullPath() + TestObject.getTestInfo().testName + "-" + format1 + ".png";
        String imageRelativePath = ExtentManager.getScreenshotsFolderRelativePath() + TestObject.getTestInfo().testName + "-" + format1 + ".png";
        try {
            File scrFile = (File)((TakesScreenshot)AbstractDriverTestNG.getWebDriver()).getScreenshotAs(OutputType.FILE);
            FileUtils.copyFile((File)scrFile, (File)new File(extentReportImageFullPath));
            if (Config.getValue("report.reporterType").equals("html")) {
                AbstractDriver.getStep().get().info("").addScreenCaptureFromPath(imageRelativePath);
            } else {
                AbstractDriver.getStep().get().info("").addScreenCaptureFromPath(extentReportImageFullPath);
            }
            File screenshot = new File(extentReportImageFullPath);
            ReportPortalMessage message = new ReportPortalMessage(screenshot, screenshot.getName());
            TestObject.getTestInfo().log.info((Object)message);
        }
        catch (Exception e) {
            Helper.logStackTrace(e);
        }
    }

    public static File captureElementPicture(EnhancedBy element) {
        return UtilityHelper.captureElementPicture(element, 0);
    }

    public static File captureElementPicture(EnhancedBy element, int index) {
        File screen = null;
        try {
            EnhancedWebElement targetElement = Element.findElements(element);
            screen = (File)((TakesScreenshot)AbstractDriverTestNG.getWebDriver()).getScreenshotAs(OutputType.FILE);
            BufferedImage img = ImageIO.read(screen);
            int originalImageWidth = img.getWidth();
            int originalImageHeight = img.getHeight();
            int actualTestWidth = AbstractDriverTestNG.getWebDriver().findElement((By)By.tagName((String)"body")).getRect().width;
            int actualTestHeight = AbstractDriverTestNG.getWebDriver().findElement((By)By.tagName((String)"body")).getRect().height;
            if (Helper.mobile.isMobile()) {
                actualTestWidth = AbstractDriverTestNG.getWebDriver().manage().window().getSize().width;
                actualTestHeight = AbstractDriverTestNG.getWebDriver().manage().window().getSize().height;
            }
            double widthRatio = (double)originalImageWidth / (double)actualTestWidth;
            double heightRatio = (double)originalImageHeight / (double)actualTestHeight;
            int elementWidth = targetElement.get(index).getSize().getWidth();
            int elementHeight = targetElement.get(index).getSize().getHeight();
            Rectangle rect = new Rectangle(elementWidth, elementHeight);
            Point p = targetElement.get(index).getLocation();
            int xValue = (int)((double)p.getX() * widthRatio);
            int yValue = (int)((double)p.getY() * heightRatio);
            int widthValue = (int)((double)rect.width * widthRatio);
            int heightValue = (int)((double)rect.height * heightRatio);
            BufferedImage dest = img.getSubimage(xValue, yValue, widthValue, heightValue);
            ImageIO.write((RenderedImage)dest, "png", screen);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return screen;
    }

    public static void highLightWebElement(EnhancedBy by, int index) {
        if (!Helper.isWebDriver()) {
            return;
        }
        if (!Config.getBooleanValue("web.element.highlight.enable").booleanValue()) {
            return;
        }
        double duration = Config.getDoubleValue("web.element.highlight.waitDurationInSeconds");
        JavascriptExecutor jsEx = (JavascriptExecutor)AbstractDriver.getWebDriver();
        EnhancedWebElement targetElement = Element.findElements(by);
        jsEx.executeScript("arguments[0].setAttribute('style', 'background: yellow; border: 2px dashed red;');", new Object[]{targetElement.get(index)});
        Helper.waitForSeconds(duration);
        jsEx.executeScript("arguments[0].setAttribute('style','border: solid 2px white');", new Object[]{targetElement.get(index)});
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("mac");
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("win");
    }

    public static boolean isUnix() {
        String osName = System.getProperty("os.name");
        return osName.indexOf("nix") >= 0 || osName.indexOf("linux") >= 0 || osName.indexOf("nux") >= 0 || osName.indexOf("aix") > 0;
    }

    public static boolean isUUID(String value) {
        try {
            UUID.fromString(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isBoolean(String value) {
        return (value = value.toLowerCase()).equals("true") || value.equals("false");
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Object executeJs(String script, Object ... args) {
        JavascriptExecutor js = (JavascriptExecutor)AbstractDriver.getWebDriver();
        Object value = js.executeScript(script, args);
        return value;
    }

    public static List<String> executeJsWithListReturn(String script, Object ... args) {
        Object valueObject = UtilityHelper.executeJs(script, args);
        List value = (List)valueObject;
        return value;
    }

    public static String executeJsWithStringReturn(String script, Object ... args) {
        Object valueObject = UtilityHelper.executeJs(script, args);
        String value = (String)valueObject;
        return value;
    }

    public static int getIntFromString(String value, boolean isFailOnNoInt) {
        double doubleVal = UtilityHelper.getDoubleFromString(value, isFailOnNoInt);
        return (int)doubleVal;
    }

    public static int getFirstNumber(String value) {
        int number = -1;
        Matcher matcher = Pattern.compile("\\d+").matcher(value);
        matcher.find();
        try {
            number = Integer.valueOf(matcher.group());
        }
        catch (Exception e) {
            e.getMessage();
        }
        return number;
    }

    public static double getDoubleFromString(String value, boolean isFailOnNoInt) {
        if (!UtilityHelper.isStringContainNumber(value)) {
            if (isFailOnNoInt) {
                Helper.assertFalse("numeric value not found from String: " + value);
            } else {
                return -1.0;
            }
        }
        if ((value = value.replaceAll("[^\\d.]", "")).startsWith(".")) {
            value = value.substring(1);
        }
        if (value.isEmpty()) {
            return -1.0;
        }
        Scanner st = new Scanner(value);
        while (!st.hasNextDouble()) {
            st.next();
        }
        double valueDouble = st.nextDouble();
        st.close();
        return valueDouble;
    }

    public static boolean isStringContainOnlyNumber(String value) {
        boolean isNumb = NumberUtils.isCreatable((String)value);
        return isNumb;
    }

    public static boolean isStringContainNumber(String value) {
        value = value.replaceAll("[^\\d.]", "");
        return !StringUtils.isBlank((String)(value = value.replace(".", "")));
    }

    public static String removeSurroundingQuotes(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static URL convertToUrl(String url) {
        URL aURL = null;
        try {
            aURL = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            Helper.assertFalse(e.getMessage());
        }
        return aURL;
    }

    public static boolean isUrlAbleToConnect(URL source, Proxy proxy) {
        try {
            HttpURLConnection con = null;
            HttpURLConnection.setFollowRedirects(false);
            con = proxy != null ? (HttpURLConnection)source.openConnection(proxy) : (HttpURLConnection)source.openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            con.setRequestMethod("HEAD");
            return con.getResponseCode() < 400;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isProxyRequired(URL url) {
        String proxyState = Config.getGlobalValue("proxy.enabled");
        boolean isProxyEnabled = false;
        isProxyEnabled = proxyState.equals("auto") ? UtilityHelper.setProxyAutoDetection(url) : UtilityHelper.getProxyState();
        return isProxyEnabled;
    }

    private static boolean getProxyState() {
        String proxyState = Config.getGlobalValue("proxy.enabled");
        String proxyHost = Config.getValue("proxy.host");
        return proxyState.equals("true") && !proxyHost.isEmpty();
    }

    public static boolean setProxyAutoDetection(URL source) {
        Proxy proxy = null;
        String PROXY_ENABLED = "proxy.enabled";
        String PROXY_HOST = "proxy.host";
        String PROXY_PORT = "proxy.port";
        String PROXY_USERNAME = "proxy.username";
        String PROXY_PASSWORD = "proxy.password";
        String host = Config.getValue(PROXY_HOST);
        int port = Config.getIntValue(PROXY_PORT);
        final String username = Config.getValue(PROXY_USERNAME);
        final String password = Config.getValue(PROXY_PASSWORD);
        String proxyState = Config.getValue("proxy.enabled");
        boolean isProxyAutoDetect = false;
        if (proxyState.equals("auto")) {
            isProxyAutoDetect = true;
        }
        if (!isProxyAutoDetect) {
            return false;
        }
        boolean isValidConnection = UtilityHelper.isUrlAbleToConnect(source, null);
        if (isValidConnection) {
            Config.setGlobalValue(PROXY_ENABLED, false);
            TestLog.ConsoleLog("proxy auto detect: proxy not detected", new Object[0]);
            return false;
        }
        if (!username.isEmpty() && !password.isEmpty()) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        if (!host.isEmpty() && port != -1) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
        if (isValidConnection = UtilityHelper.isUrlAbleToConnect(source, proxy)) {
            TestLog.ConsoleLog("proxy detected, switching proxy on, host: " + host + " port: " + port, new Object[0]);
            Config.setGlobalValue(PROXY_ENABLED, true);
            return true;
        }
        Config.setGlobalValue(PROXY_ENABLED, false);
        return false;
    }

    public static String getMavenArtifactId() {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = reader.read((Reader)new FileReader(Helper.getFullPath("pom.xml")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model.getArtifactId();
    }

    public static String getMavenDependencyVersion(String dependency) {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = reader.read((Reader)new FileReader(Helper.getFullPath("pom.xml")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List dependencies = model.getDependencies();
        for (Dependency artifact : dependencies) {
            if (!artifact.getArtifactId().equals(dependency)) continue;
            return artifact.getVersion();
        }
        return "";
    }

    public static boolean isFileContainString(String value, File file) {
        List<Object> lines = new ArrayList();
        try (Stream<String> stream = Files.lines(file.toPath());){
            lines = Files.lines(file.toPath()).filter(line -> line.trim().startsWith(value)).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return !lines.isEmpty();
    }

    public static boolean isLineInFileStartWithString(String value, File file) {
        List<Object> lines = new ArrayList();
        try (Stream<String> stream = Files.lines(file.toPath());){
            lines = Files.lines(file.toPath()).filter(line -> line.trim().startsWith(value)).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return !lines.isEmpty();
    }

    public static List<String> getLinesInFileStartingWith(String value, File file) {
        List<String> lines = new ArrayList<String>();
        try (Stream<String> stream = Files.lines(file.toPath());){
            lines = Files.lines(file.toPath()).filter(line -> line.trim().startsWith(value)).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static List<String> getLinesInFileContainingWith(String value, File file) {
        List<String> lines = new ArrayList<String>();
        try (Stream<String> stream = Files.lines(file.toPath());){
            lines = Files.lines(file.toPath()).filter(line -> line.trim().contains(value)).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static void printPageSource() {
        if (AbstractDriver.getWebDriver() != null) {
            TestLog.ConsoleLog("page source: " + Helper.stringNormalize(AbstractDriver.getWebDriver().getPageSource()), new Object[0]);
        }
    }

    public static String getPageSource() {
        if (AbstractDriver.getWebDriver() != null) {
            return AbstractDriver.getWebDriver().getPageSource();
        }
        return "";
    }

    public static String convertListToString(ArrayList<String> list) {
        return UtilityHelper.convertListToString(list, ",");
    }

    public static String convertListToString(ArrayList<String> list, String separator) {
        String listString = "";
        for (int i = 0; i < list.size(); ++i) {
            listString = i == list.size() - 1 ? listString + list.get(i) : listString + list.get(i) + separator;
        }
        return listString;
    }

    public static String getValueBetweenStrings(String source, String value1, String value2, int position) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            String patternString = value1 + "(.*?)" + value2;
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(source);
            while (matcher.find()) {
                values.add(matcher.group(1));
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        if (position == 0) {
            Helper.assertFalse("position starts at 1. your position: " + position + ".");
        }
        if (values.isEmpty()) {
            Helper.assertFalse("value between positions value1:" + value1 + "and value2: " + value2 + " at position: " + position + " was not found at xml: \n" + source + " \n\n");
        }
        if (position > values.size()) {
            Helper.assertFalse("position is greater than response size. position: " + position + ". response size: " + values.size() + ". values: " + Arrays.toString(values.toArray()));
        }
        return (String)values.get(position - 1);
    }

    public static boolean isServerOnline(String url) {
        return UtilityHelper.isServerOnline(url, null);
    }

    public static boolean isServerOnline(String url, String proxyUrl) {
        HttpURLConnection connection = null;
        try {
            if (proxyUrl != null && !proxyUrl.isEmpty()) {
                URL proxyUrlLink = new URL(proxyUrl);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrlLink.getHost(), proxyUrlLink.getPort()));
                connection = (HttpURLConnection)new URL(url).openConnection(proxy);
            } else {
                connection = (HttpURLConnection)new URL(url).openConnection();
            }
            connection.setConnectTimeout(1000);
            connection.connect();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

