/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriver;
import org.apache.commons.lang3.StringUtils;

public class LoginHelper {
    public static void handleDifferentUser() {
        if (!DriverObject.isDriverSet()) {
            return;
        }
        if (!CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            return;
        }
        String username = TestObject.getTestInfo().login.getUsername();
        String password = TestObject.getTestInfo().login.getPassword();
        boolean isDifferentUser = LoginHelper.isDifferentUser();
        if (isDifferentUser) {
            LoginHelper.restartDriver(username, password);
        }
    }

    private static boolean isDifferentUser() {
        String loggedInUsername = DriverObject.getCurrentDriverObject().login.getLoggedInUsername();
        String loggedInPassword = DriverObject.getCurrentDriverObject().login.getLoggedInPassword();
        DriverObject.getCurrentDriverObject().login.withIsLoggedIn(false);
        String username = TestObject.getTestInfo().login.getUsername();
        String password = TestObject.getTestInfo().login.getPassword();
        boolean condition1 = !StringUtils.isEmpty((CharSequence)loggedInUsername) && !username.equals(loggedInUsername);
        boolean condition2 = username.equals(loggedInUsername) && !password.equals(loggedInPassword);
        return condition1 || condition2;
    }

    protected static boolean isContinueLogin() {
        if (!DriverObject.isDriverSet()) {
            return true;
        }
        if (!CrossPlatformProperties.isSingleSignIn().booleanValue()) {
            return true;
        }
        if (LoginHelper.isDifferentUser()) {
            return true;
        }
        String loggedInUsername = DriverObject.getCurrentDriverObject().login.getLoggedInUsername();
        String loggedInPassword = DriverObject.getCurrentDriverObject().login.getLoggedInPassword();
        return StringUtils.isEmpty((CharSequence)loggedInUsername) || StringUtils.isEmpty((CharSequence)loggedInPassword);
    }

    private static void restartDriver(String username, String password) {
        TestLog.ConsoleLog("logged in user has changed, restarting the driver...", new Object[0]);
        DriverObject driver = TestObject.getTestInfo().currentDriver;
        DriverObject.quitTestDrivers();
        AbstractDriver abstractDriver = new AbstractDriver();
        try {
            abstractDriver.setupDriver(driver);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }
}

