/*
 * Decompiled with CFR 0.152.
 */
package core.support.annotation.template.service;

import com.google.googlejavaformat.java.Formatter;
import core.apiCore.driver.ApiTestDriver;
import core.apiCore.helpers.CsvReader;
import core.helpers.Helper;
import core.support.annotation.template.service.ServiceData;
import core.support.configReader.Config;
import core.support.objects.ServiceObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ServiceClass {
    private static final String SERVICE_TEST_PATH = "src" + File.separator + "test" + File.separator + "java" + File.separator + "test" + File.separator + "module" + File.separator + "service" + File.separator + "generated" + File.separator;
    private static final String SERVICE_TEST_ROOT = ".." + File.separator + "apiTestData" + File.separator + "testCases" + File.separator;
    private static final String SERVICE_GENERATE_CLASS = "service.generate.class";

    public static void writeServiceGenerationClass() {
        if (!Config.getBooleanValue(SERVICE_GENERATE_CLASS).booleanValue()) {
            return;
        }
        try {
            ServiceClass.writeServiceClass();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeServiceClass() throws Exception {
        boolean includeSubDir = Config.getBooleanValue("api.csv.include.subdir");
        String testCsvPath = Config.getValue("api.parallelTestcasePath");
        if (!new File(Helper.getFullPath(testCsvPath)).exists()) {
            return;
        }
        ArrayList<File> testCsvFileList = Helper.getFileListByType(testCsvPath, ".csv", includeSubDir);
        for (File csvFile : testCsvFileList) {
            List<Object[]> csvList = CsvReader.getCsvTestListForTestRunner(csvFile.getName());
            if (csvList.isEmpty()) continue;
            File testClassPath = ServiceClass.createClassFile(csvFile);
            ServiceClass.writeTestClass(testClassPath, csvList);
        }
    }

    private static void writeTestClass(File classFile, List<Object[]> csvList) throws Exception {
        StringWriter sw = new StringWriter();
        sw.write("/**Auto generated code, do not modify.\n");
        sw.write("*");
        sw.write("**/\n\n\n\n");
        sw.write("package " + ServiceClass.getPackageName(classFile) + ";\n");
        sw.write("import core.support.objects.ServiceObject;\n");
        sw.write("import serviceManager.ServiceRunner;\n");
        sw.write("import org.testng.annotations.Test;\n");
        sw.write("import test.module.service.TestBase;\n");
        sw.write("public class " + ApiTestDriver.getTestClass(classFile.getName()) + " extends TestBase  {");
        int priority = 0;
        int index = 0;
        for (Object[] testRow : csvList) {
            ++priority;
            ServiceObject ServiceObject2 = CsvReader.mapToServiceObject(testRow);
            sw.write("\t/**\n");
            sw.write("\t* " + ServiceData.formatString(ServiceObject2.getDescription()) + "\n");
            sw.write("\t* @throws Exception\n");
            sw.write("\t*/\n");
            sw.write("  @Test(description =\"" + ServiceData.formatString(ServiceObject2.getDescription()) + "\", priority=" + priority + " )\n");
            sw.write("\tpublic static void " + ServiceObject2.getTestCaseID() + "() throws Exception {\n");
            sw.write("  ServiceObject service = new ServiceObject();\n");
            sw.write("service.withTestSuite(\"" + ServiceData.formatString(ServiceObject2.getTestSuite()) + "\");\n");
            sw.write("service.withTestCaseID(\"" + ServiceData.formatString(ServiceObject2.getTestCaseID()) + "\");\n");
            sw.write("service.withDescription(\"" + ServiceData.formatString(ServiceObject2.getDescription()) + "\");\n");
            if (!ServiceObject2.getInterfaceType().isEmpty()) {
                sw.write("service.withInterfaceType(\"" + ServiceData.formatString(ServiceObject2.getInterfaceType()) + "\");\n");
            }
            if (!ServiceObject2.getUriPath().isEmpty()) {
                sw.write("service.withUriPath(\"" + ServiceData.formatString(ServiceObject2.getUriPath()) + "\");\n");
            }
            if (!ServiceObject2.getContentType().isEmpty()) {
                sw.write("service.withContentType(\"" + ServiceData.formatString(ServiceObject2.getContentType()) + "\");\n");
            }
            if (!ServiceObject2.getMethod().isEmpty()) {
                sw.write("service.withMethod(\"" + ServiceData.formatString(ServiceObject2.getMethod()) + "\");\n");
            }
            if (!ServiceObject2.getOption().isEmpty()) {
                sw.write("service.withOption(\"" + ServiceData.formatString(ServiceObject2.getOption()) + "\");\n");
            }
            if (!ServiceObject2.getRequestHeaders().isEmpty()) {
                sw.write("service.withRequestHeaders(\"" + ServiceData.formatString(ServiceObject2.getRequestHeaders()) + "\");\n");
            }
            if (!ServiceObject2.getTemplateFile().isEmpty()) {
                sw.write("service.withTemplateFile(\"" + ServiceData.formatString(ServiceObject2.getTemplateFile()) + "\");\n");
            }
            if (!ServiceObject2.getRequestBody().isEmpty()) {
                sw.write("service.withRequestBody(\"" + ServiceData.formatString(ServiceObject2.getRequestBody()) + "\");\n");
            }
            if (!ServiceObject2.getOutputParams().isEmpty()) {
                sw.write("service.withOutputParams(\"" + ServiceData.formatString(ServiceObject2.getOutputParams()) + "\");\n");
            }
            if (!ServiceObject2.getRespCodeExp().isEmpty()) {
                sw.write("service.withRespCodeExp(\"" + ServiceData.formatString(ServiceObject2.getRespCodeExp()) + "\");\n");
            }
            if (!ServiceObject2.getExpectedResponse().isEmpty()) {
                sw.write("service.withExpectedResponse(\"" + ServiceData.formatString(ServiceObject2.getExpectedResponse()) + "\");\n");
            }
            if (!ServiceObject2.getTcComments().isEmpty()) {
                sw.write("service.withTcComments(\"" + ServiceData.formatString(ServiceObject2.getTcComments()) + "\");\n");
            }
            sw.write("service.withTcIndex(\"" + index + ":" + csvList.size() + "\");\n");
            sw.write("service.withTcName(\"" + ApiTestDriver.getTestClass(classFile.getName()) + "\");\n");
            sw.write("service.withTcType(\"service\");\n");
            sw.write("\tServiceRunner.TestRunner(service);\n");
            sw.write(" }\n");
            ++index;
        }
        sw.write("}\n");
        String output = sw.toString().replace("\\\\", "\\");
        Formatter formatter = new Formatter();
        output = formatter.formatSource(output);
        PrintWriter pw = new PrintWriter(classFile.getAbsolutePath());
        pw.print(output);
        pw.close();
    }

    private static File createClassFile(File csvFile) throws FileNotFoundException {
        String testname = ApiTestDriver.getTestClass(csvFile.getName());
        String fileRelativePath = csvFile.getParentFile().getAbsolutePath().replace(new File(Helper.getFullPath(SERVICE_TEST_ROOT)).getAbsolutePath(), "");
        String testClassPath = Helper.getFullPath(SERVICE_TEST_PATH + fileRelativePath + File.separator + testname + ".java");
        Helper.createFileFromPath(testClassPath);
        PrintWriter pw = new PrintWriter(testClassPath);
        pw.close();
        return new File(testClassPath);
    }

    private static String getPackageName(File file) {
        String packagename = "";
        String packageFormat = file.getParentFile().getAbsolutePath().replace(File.separatorChar, '.');
        String[] packagePath = packageFormat.split("test.module.service.generated");
        packagename = packagePath.length == 1 ? "test.module.service.generated" : "test.module.service.generated" + packagePath[1];
        return packagename;
    }
}

