/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import com.google.common.util.concurrent.Uninterruptibles;
import core.helpers.AssertHelper;
import core.helpers.Element;
import core.helpers.Helper;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitHelper {
    public boolean waitForElementToLoad(EnhancedBy target) {
        return this.waitForElementToLoad(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToLoad(EnhancedBy target, int time) {
        return this.waitForElementToLoad(target, time, 1);
    }

    public boolean waitForElementToLoad(final EnhancedBy target, int time, final int count) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Element.findElements(target).count() >= count;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public void mobile_waitAndRefreshForElementToLoad(EnhancedBy target) {
        this.mobile_waitAndRefreshForElementToLoad(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public void mobile_waitAndRefreshForElementToLoad(final EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        if (!Helper.mobile_isMobile()) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                Helper.mobile.refreshMobileApp();
                boolean isFound = Element.findElements(target).count() >= 1;
                return isFound;
            }
        };
        this.waitForCondition(condition, target, time);
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2) {
        return this.waitForFirstElementToLoad(element1, element2, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForFirstElementToLoad(final EnhancedBy element1, final EnhancedBy element2, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                boolean isElement1Found = Element.findElements(element1).count() >= 1;
                boolean isElement2Found = Element.findElements(element2).count() >= 1;
                return isElement1Found || isElement2Found;
            }
        };
        return this.waitForCondition(condition, element1, time);
    }

    public boolean waitForFirstElementToLoad(EnhancedBy element1, EnhancedBy element2, EnhancedBy element3) {
        return this.waitForFirstElementToLoad(element1, element2, element3, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForFirstElementToLoad(final EnhancedBy element1, final EnhancedBy element2, final EnhancedBy element3, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                boolean isElement1Found = Element.findElements(element1).count() >= 1;
                boolean isElement2Found = Element.findElements(element2).count() >= 1;
                boolean isElement3Found = Element.findElements(element3).count() >= 1;
                return isElement1Found || isElement2Found || isElement3Found;
            }
        };
        return this.waitForCondition(condition, element1, time);
    }

    public boolean waitForAdditionalElementsToLoad(EnhancedBy target, int originalCount) {
        return this.waitForAdditionalElementsToLoad(target, originalCount, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForAdditionalElementsToLoad(final EnhancedBy target, final int originalCount, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        Helper.assertTrue("driver is null", AbstractDriver.getWebDriver() != null);
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Helper.list.getListCount(target) > originalCount;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForElementToBeRemoved(EnhancedBy target) {
        return this.waitForElementToBeRemoved(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeRemoved(EnhancedBy target, int time, int waitForTargetToLoadInSeconds) {
        this.waitForElementToLoad(target, waitForTargetToLoadInSeconds);
        return this.waitForElementToBeRemoved(target, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeRemoved(final EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                try {
                    int x = 0;
                    while (x < elements.count()) {
                        if (!elements.isExist(x++)) continue;
                        return false;
                    }
                }
                catch (Exception e) {
                    e.getMessage();
                }
                return true;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public void waitForSeconds(double seconds) {
        long miliseconds = (long)(seconds * 1000.0);
        Uninterruptibles.sleepUninterruptibly((long)miliseconds, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void waitForPageToLoad() {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        if (!Helper.isWebDriver()) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete");
            }
        };
        this.waitForCondition(condition, null, AbstractDriver.TIMEOUT_SECONDS);
    }

    public void waitForListItemToLoad_Contains(final EnhancedBy list, final String option) {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Helper.list.isContainedInList(list, option);
            }
        };
        this.waitForCondition(condition, list, AbstractDriver.TIMEOUT_SECONDS);
    }

    public void waitForTextToLoad(EnhancedBy target, String text) {
        this.waitForTextToLoad(target, AbstractDriver.TIMEOUT_SECONDS, text);
    }

    public void waitForTextToLoad(final EnhancedBy target, int time, final String text) {
        if (AbstractDriver.getWebDriver() == null) {
            return;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return Element.findElements(target).getText().contains(text);
            }
        };
        this.waitForCondition(condition, target, time);
    }

    public boolean waitForElementToBeClickable(EnhancedBy selector) {
        return this.waitForElementToBeClickable(selector, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForElementToBeClickable(final EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                return elements.count() >= 1 && elements.isEnabled();
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForClassContain(EnhancedBy target, int index, String value) {
        return this.waitForClassContain(target, index, value, AbstractDriver.TIMEOUT_SECONDS);
    }

    public boolean waitForClassContain(final EnhancedBy target, final int index, final String value, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                return elements.getAttribute(index, "class").contains(value);
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForAnyTextToLoadContaining(EnhancedBy target, String ... text) {
        return this.waitForAnyTextToLoadContaining(target, AbstractDriver.TIMEOUT_SECONDS, text);
    }

    public boolean waitForAnyTextToLoadContaining(final EnhancedBy target, int time, final String ... text) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                String actualValue = elements.getText();
                for (String value : text) {
                    if (!actualValue.contains(value)) continue;
                    return true;
                }
                return false;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForAnyTextToLoad(EnhancedBy target, String ... text) {
        return this.waitForAnyTextToLoad(target, AbstractDriver.TIMEOUT_SECONDS, text);
    }

    public boolean waitForAnyTextToLoad(final EnhancedBy target, int time, final String ... text) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        ExpectedCondition<Boolean> condition = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                EnhancedWebElement elements = Element.findElements(target);
                String actualValue = elements.getText();
                for (String value : text) {
                    if (!actualValue.equals(value)) continue;
                    return true;
                }
                return false;
            }
        };
        return this.waitForCondition(condition, target, time);
    }

    public boolean waitForCondition(ExpectedCondition<Boolean> condition, EnhancedBy target, int time) {
        if (AbstractDriver.getWebDriver() == null) {
            return false;
        }
        FluentWait wait = new WebDriverWait(AbstractDriver.getWebDriver(), Duration.ofSeconds(time)).pollingEvery(Duration.ofMillis(5L)).withTimeout(Duration.ofSeconds(time)).ignoring(Exception.class);
        try {
            wait.until(condition);
        }
        catch (Exception e) {
            if (time == AbstractDriver.TIMEOUT_SECONDS && target != null) {
                AssertHelper.assertTrue("element: " + target.name + " did not meet condition in allowed time (s) " + time, false);
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }
}

