/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.apiCore.interfaces.RestApiInterface;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.listeners.ParamOverrideTestNgService;
import core.support.logger.TestLog;
import core.support.objects.ServiceObject;

public class ReportPortalHelper {
    final String uri = ParamOverrideTestNgService.ENDPOINT;
    final String uuid = ParamOverrideTestNgService.UUID;
    final String launch = ParamOverrideTestNgService.LAUNCH;
    final String project = ParamOverrideTestNgService.PROJECT;
    final String reportEnabled = ParamOverrideTestNgService.REPORT_PORTAL_ENABLE;
    final String launchUUID = ParamOverrideTestNgService.LAUNCH_UUID;
    final String launchId = ParamOverrideTestNgService.LAUNCH_ID;

    public void updateLaunchAttributes(String attributeString) {
        String[] attributes;
        if (!Config.getBooleanValue(this.reportEnabled).booleanValue()) {
            return;
        }
        if (attributeString.isEmpty()) {
            return;
        }
        for (String attribute : attributes = attributeString.split(";")) {
            this.updateLaunchAttribute(attribute);
        }
    }

    private void updateLaunchAttribute(String attributeString) {
        String launchId = this.getCurrentLaunchId();
        if (launchId.isEmpty()) {
            return;
        }
        String[] attribute = attributeString.split(":");
        if (attribute.length != 2) {
            Helper.assertFalse("attribute should be valid key:value format. attribute: " + attributeString);
        }
        String key = attribute[0];
        String value = attribute[1];
        String body = "{\r\n  \"attributes\": [\r\n    {\r\n      \"action\": \"CREATE\",\r\n      \"from\": {\r\n        \"key\": \"string\",\r\n        \"value\": \"string\"\r\n      },\r\n      \"to\": {\r\n        \"key\": \"" + key + "\",\r\n        \"value\": \"" + value + "\"\r\n      }\r\n    }\r\n  ],\r\n  \"description\": {\r\n    \"action\": \"DELETE\",\r\n    \"comment\": \"string\"\r\n  },\r\n  \"ids\": [\r\n    " + launchId + "\r\n  ]\r\n}";
        String endpoint = Config.getGlobalValue(this.uri) + "/api/v1/" + Config.getGlobalValue(this.project) + "/launch/info?access_token=" + Config.getGlobalValue(this.uuid);
        ServiceObject service = new ServiceObject().withUriPath(endpoint).withContentType("application/json").withMethod("PUT").withRequestBody(body).withRespCodeExp("200");
        RestApiInterface.RestfullApiInterface(service);
    }

    public void updateTestAttributes(String testname, String attributeString) {
        String[] attributes;
        if (!Config.getBooleanValue(this.reportEnabled).booleanValue()) {
            return;
        }
        if (testname.isEmpty() || attributeString.isEmpty()) {
            return;
        }
        for (String attribute : attributes = attributeString.split(";")) {
            this.updateTestAttribute(testname, attribute);
        }
    }

    private void updateTestAttribute(String testname, String attributeString) {
        String launchId = this.getCurrentLaunchId();
        if (launchId.isEmpty()) {
            return;
        }
        String testId = this.getTestId(testname, launchId);
        if (testId.isEmpty()) {
            TestLog.ConsoleLogWarn("test not found in recent launcher(s). test name: " + testname, new Object[0]);
            return;
        }
        String[] attribute = attributeString.split(":");
        if (attribute.length != 2) {
            Helper.assertFalse("attribute should be valid key:value format. attribute: " + attributeString);
        }
        String key = attribute[0];
        String value = attribute[1];
        String body = "{\r\n  \"attributes\": [\r\n    {\r\n      \"action\": \"CREATE\",\r\n      \"from\": {\r\n        \"key\": \"string\",\r\n        \"value\": \"string\"\r\n      },\r\n      \"to\": {\r\n        \"key\": \"" + key + "\",\r\n        \"value\": \"" + value + "\"\r\n      }\r\n    }\r\n  ],\r\n  \"description\": {\r\n    \"action\": \"DELETE\",\r\n    \"comment\": \"string\"\r\n  },\r\n  \"ids\": [\r\n    " + testId + "\r\n  ]\r\n}";
        String endpoint = Config.getGlobalValue(this.uri) + "/api/v1/" + Config.getGlobalValue(this.project) + "/item/info?access_token=" + Config.getGlobalValue(this.uuid);
        ServiceObject service = new ServiceObject().withUriPath(endpoint).withContentType("application/json").withMethod("PUT").withRequestBody(body).withRespCodeExp("200");
        RestApiInterface.RestfullApiInterface(service);
    }

    public void updateTestIssue(String testname, String issueName, String comment) {
        if (!Config.getBooleanValue(this.reportEnabled).booleanValue()) {
            return;
        }
        if (testname.isEmpty() || issueName.isEmpty()) {
            return;
        }
        String launchId = this.getCurrentLaunchId();
        if (launchId.isEmpty()) {
            return;
        }
        String testId = this.getTestId(testname, launchId);
        String issueLocator = this.getIssueId(issueName);
        String body = "{\r\n  \"issues\": [\r\n    {\r\n      \"issue\": {\r\n        \"autoAnalyzed\": true,\r\n        \"comment\": \"" + comment + "\",\r\n        \"ignoreAnalyzer\": false,\r\n        \"issueType\": \"" + issueLocator + "\"\r\n      },\r\n      \"testItemId\": " + testId + "\r\n    }\r\n  ]\r\n}";
        String endpoint = Config.getGlobalValue(this.uri) + "/api/v1/" + Config.getGlobalValue(this.project) + "/launch/latest?filter.eq.name=" + Config.getGlobalValue(this.launch) + "&access_token=" + Config.getGlobalValue(this.uuid);
        endpoint = Config.getGlobalValue(this.uri) + "/api/v1/" + Config.getGlobalValue(this.project) + "/item?access_token=" + Config.getGlobalValue(this.uuid);
        ServiceObject service = new ServiceObject().withUriPath(endpoint).withContentType("application/json").withMethod("PUT").withRequestBody(body).withRespCodeExp("200");
        RestApiInterface.RestfullApiInterface(service);
    }

    private String getCurrentLaunchId() {
        String launchUuid = Config.getGlobalValue(this.launchUUID);
        if (launchUuid.isEmpty()) {
            TestLog.ConsoleLogWarn("report portal launch uuid is empty", new Object[0]);
            return "";
        }
        if (!Config.getGlobalValue(this.launchId).isEmpty()) {
            return Config.getGlobalValue(this.launchId);
        }
        String endpoint = Config.getGlobalValue(this.uri) + "/api/v1/" + Config.getGlobalValue(this.project) + "/launch?filter.eq.uuid=" + launchUuid + "&access_token=" + Config.getGlobalValue(this.uuid);
        ServiceObject service = new ServiceObject().withUriPath(endpoint).withContentType("application/json").withMethod("GET").withRespCodeExp("200").withOutputParams(".id:<$launchId>;");
        RestApiInterface.RestfullApiInterface(service);
        String launchIdValue = Config.getValue("launchId");
        Config.setGlobalValue(this.launchId, launchIdValue);
        return launchIdValue;
    }

    private String getTestId(String testname, String launchId) {
        String endpoint = Config.getGlobalValue(this.uri) + "/api/v1/" + Config.getGlobalValue(this.project) + "/item?filter.eq.launchId=" + launchId + "&access_token=" + Config.getGlobalValue(this.uuid);
        ServiceObject service = new ServiceObject().withUriPath(endpoint).withContentType("application/json").withMethod("GET").withRespCodeExp("200").withOutputParams("$..content[?(@.name =~ /.*" + testname + "/i)].id:<$testId>;");
        RestApiInterface.RestfullApiInterface(service);
        String testId = Config.getValue("testId");
        return testId;
    }

    private String getIssueId(String issueName) {
        if (issueName.trim() == "") {
            return "";
        }
        String endpoint = Config.getGlobalValue(this.uri) + "/api/v1/project/" + Config.getGlobalValue(this.project) + "?access_token=" + Config.getGlobalValue(this.uuid);
        ServiceObject service = new ServiceObject().withUriPath(endpoint).withContentType("application/json").withMethod("GET").withRespCodeExp("200").withOutputParams("$..[?(@.longName =~ /.*" + issueName + "/i)].locator:<$issueLocator>;");
        RestApiInterface.RestfullApiInterface(service);
        String issueLocator = Config.getValue("issueLocator");
        return issueLocator;
    }
}

