/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.ConnectionHelper;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.SqlHelper;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.DatabaseObject;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class SqlInterface {
    private static final String SQL_PREFIX = "db.";
    public static final String SQL_CURRENT_DATABASE = "db.current.database";
    private static final String OPTION_DATABASE = "database";

    public static ResultSet DataBaseInterface(ServiceObject serviceObject) throws Exception {
        SqlInterface.setDatabaseMap();
        SqlInterface.setDefaultDatabase();
        SqlInterface.evaluateOption(serviceObject);
        SqlInterface.connectDB();
        ResultSet resSet = SqlInterface.evaluateRequestAndValidateResponse(serviceObject);
        return resSet;
    }

    public static synchronized void connectDB() {
        DatabaseObject currentDb = (DatabaseObject)Config.getObjectValue(SQL_CURRENT_DATABASE);
        if (currentDb.getConnection() == null) {
            try {
                ConnectionHelper.sshConnect();
                String SQLDriver = currentDb.getDriver();
                Class.forName(SQLDriver);
                String dbURL = currentDb.getUrl();
                String dbName = currentDb.getDatabaseName();
                String connectionString = dbURL + "/" + dbName;
                String dbUserName = currentDb.getUsername();
                String dbPassword = currentDb.getPassword();
                TestLog.logPass("db connection: " + connectionString, new Object[0]);
                TestLog.logPass("db username: " + dbUserName, new Object[0]);
                TestLog.logPass("db password: " + dbPassword, new Object[0]);
                currentDb.withConnection(DriverManager.getConnection(connectionString, dbUserName, dbPassword));
                Helper.wait.waitForSeconds(1.0);
            }
            catch (Exception e) {
                TestLog.logPass("sql connection failed: " + e.getMessage(), new Object[0]);
                e.printStackTrace();
                Helper.assertTrue("sql connection failed", false);
            }
        }
    }

    public static void evaluateOption(ServiceObject serviceObject) {
        SqlInterface.resetValidationTimeout();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key.toLowerCase()) {
                case "database": {
                    int position = Helper.getIntFromString(keyword.value.toString(), true);
                    if (DatabaseObject.DATABASES.get(position) == null) {
                        Helper.assertFalse("database number: " + position + " not found");
                    }
                    DatabaseObject database = DatabaseObject.DATABASES.get(position);
                    Config.putValue(SQL_CURRENT_DATABASE, (Object)database, false);
                    break;
                }
                case "NO_VALIDATION_TIMEOUT": {
                    Config.putValue("service.timeout.validation.isEnabled", false);
                    break;
                }
                case "WAIT_FOR_RESPONSE": {
                    Config.putValue("service.timeout.validation.isEnabled", false);
                    Config.putValue("service.timeout.validation.seconds", keyword.value, false);
                    break;
                }
                case "WAIT_FOR_RESPONSE_DELAY_SECONDS": {
                    Config.putValue("service.timeout.validation.delay.between.attempt.seconds", keyword.value, false);
                    break;
                }
            }
        }
        KeyValue.printKeyValue(keywords, "option");
    }

    public static void setDatabaseMap() {
        if (DatabaseObject.DATABASES.size() > 0) {
            return;
        }
        Map<String, Object> propertiesMap = TestObject.getTestInfo().config;
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            String[] split;
            boolean isDatabase = entry.getKey().toString().startsWith(SQL_PREFIX);
            if (!isDatabase) continue;
            String fullKey = entry.getKey().toString();
            int position = Helper.getIntFromString(fullKey);
            String splitter = SQL_PREFIX + position + ".";
            if (position == -1) {
                position = 0;
                splitter = SQL_PREFIX;
            }
            if ((split = fullKey.split(splitter)).length == 1) continue;
            String command = split[1].trim();
            String value = entry.getValue().toString().trim();
            SqlInterface.setDatabaseObject(command, position, value);
        }
    }

    public static void setDefaultDatabase() {
        if (DatabaseObject.DATABASES.get(0) != null && !DatabaseObject.DATABASES.get(0).getDriver().isEmpty()) {
            Config.putValue(SQL_CURRENT_DATABASE, DatabaseObject.DATABASES.get(0));
        } else if (DatabaseObject.DATABASES.get(1) != null) {
            Config.putValue(SQL_CURRENT_DATABASE, DatabaseObject.DATABASES.get(1));
        } else {
            Helper.assertFalse("database position must be set. eg. db.1.driver = value where 1 is position of database ");
        }
    }

    public static void setDatabaseObject(String command, int position, String value) {
        DatabaseObject database = null;
        database = DatabaseObject.DATABASES.get(position) == null ? new DatabaseObject() : DatabaseObject.DATABASES.get(position);
        switch (command) {
            case "driver": {
                database.withDriver(value);
                break;
            }
            case "url": {
                database.withUrl(value);
                break;
            }
            case "name": {
                database.withDatabaseName(value);
                break;
            }
            case "username": {
                database.withUsername(value);
                break;
            }
            case "password": {
                database.withPassword(value);
                break;
            }
        }
        DatabaseObject.DATABASES.put(position, database);
    }

    public static ResultSet evaluateDbQuery(ServiceObject serviceObject) throws Exception {
        serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
        String sql = serviceObject.getRequestBody();
        TestLog.logPass("sql statement: " + sql, new Object[0]);
        DatabaseObject currentDb = (DatabaseObject)Config.getObjectValue(SQL_CURRENT_DATABASE);
        PreparedStatement sqlStmt = currentDb.getConnection().prepareStatement(sql, 1004, 1008);
        ResultSet resSet = null;
        try {
            resSet = SqlInterface.executeAndWaitForDbResponse(sqlStmt, serviceObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            Helper.assertFalse(e.getMessage());
        }
        return resSet;
    }

    public static List<String> evaluateReponse(ServiceObject serviceObject, ResultSet resSet) throws Exception {
        List<String> errorMessages = new ArrayList<String>();
        if (serviceObject.getExpectedResponse().isEmpty() && serviceObject.getOutputParams().isEmpty()) {
            return errorMessages;
        }
        if (!resSet.isBeforeFirst()) {
            Helper.assertTrue("no results returned from db query", false);
        }
        resSet.next();
        SqlHelper.saveOutboundSQLParameters(resSet, serviceObject.getOutputParams());
        errorMessages = SqlInterface.validateExpectedResponse(serviceObject.getExpectedResponse(), resSet);
        resSet.close();
        errorMessages = DataHelper.removeEmptyElements(errorMessages);
        return errorMessages;
    }

    public static ResultSet executeAndWaitForDbResponse(PreparedStatement sqlStmt, ServiceObject serviceObject) throws SQLException {
        ResultSet resSet;
        int timeout = CrossPlatformProperties.getGlobalTimeout();
        StopWatchHelper watch = StopWatchHelper.start();
        boolean messageReceived = false;
        long passedTimeInSeconds = 0L;
        do {
            sqlStmt.execute();
            resSet = sqlStmt.getResultSet();
            if (serviceObject.getExpectedResponse().isEmpty()) {
                return resSet;
            }
            if (resSet.isBeforeFirst()) {
                messageReceived = true;
                return resSet;
            }
            Helper.wait.waitForSeconds(1.0);
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!messageReceived && passedTimeInSeconds < (long)timeout);
        return resSet;
    }

    public static List<String> validateExpectedResponse(String expected, ResultSet resSet) throws SQLException {
        String[] criteria;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (expected.isEmpty()) {
            return errorMessages;
        }
        expected = DataHelper.replaceParameters(expected);
        TestLog.logPass("expected result: " + Helper.stringRemoveLines(expected), new Object[0]);
        for (String criterion : criteria = expected.split("&&")) {
            if (SqlHelper.isValidJson(criterion)) {
                SqlHelper.validateByJsonBody(criterion, resSet);
                continue;
            }
            List<KeyValue> keywords = DataHelper.getValidationMap(expected);
            errorMessages.addAll(SqlHelper.validateSqlKeywords(keywords, resSet));
        }
        return errorMessages;
    }

    public static ResultSet evaluateRequestAndValidateResponse(ServiceObject serviceObject) throws Exception {
        List<Object> errorMessages = new ArrayList();
        ResultSet resSet = null;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        boolean isValidationTimeout = Config.getBooleanValue("service.timeout.validation.isEnabled");
        int maxRetrySeconds = Config.getIntValue("service.timeout.validation.seconds");
        int currentRetryCount = 0;
        do {
            resSet = SqlInterface.evaluateDbQuery(serviceObject);
            errorMessages = SqlInterface.evaluateReponse(serviceObject, resSet);
            if (!isValidationTimeout) break;
            if (currentRetryCount > 0) {
                int waitTime = Config.getIntValue("service.timeout.validation.delay.between.attempt.seconds");
                double waitMultiplier = Config.getDoubleValue("service.timeout.validation.delay.between.attempt.multiplier");
                double waitTimeSeconds = (double)waitTime * Math.pow(waitMultiplier, currentRetryCount - 1);
                Helper.waitForSeconds(waitTimeSeconds);
                TestLog.ConsoleLog("attempt #" + currentRetryCount + " waiting seconds: " + waitTimeSeconds, new Object[0]);
                String errors = StringUtils.join(errorMessages, (String)"\n error: ");
                TestLog.ConsoleLog("attempt failed with message: " + errors, new Object[0]);
                TestLog.ConsoleLog("attempt #" + (currentRetryCount + 1), new Object[0]);
            }
            ++currentRetryCount;
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!errorMessages.isEmpty() && passedTimeInSeconds < (long)maxRetrySeconds);
        if (!errorMessages.isEmpty()) {
            TestLog.ConsoleLog("Validation failed after: " + passedTimeInSeconds + " seconds with " + currentRetryCount + " retries", new Object[0]);
            String errorString = StringUtils.join(errorMessages, (String)"\n error: ");
            TestLog.ConsoleLog(errorString, new Object[0]);
            Helper.assertFalse(StringUtils.join(errorMessages, (String)"\n error: "));
        }
        return resSet;
    }

    private static void resetValidationTimeout() {
        int defaultValidationTimeoutDelay;
        String defaultValidationTimeoutIsEnabled = Config.getGlobalValue("service.timeout.validation.isEnabled");
        int defaultValidationTimeoutIsSeconds = Config.getGlobalIntValue("service.timeout.validation.seconds");
        if (defaultValidationTimeoutIsSeconds == -1) {
            defaultValidationTimeoutIsSeconds = 60;
        }
        if ((defaultValidationTimeoutDelay = Config.getGlobalIntValue("service.timeout.validation.delay.between.attempt.seconds")) == -1) {
            defaultValidationTimeoutDelay = 3;
        }
        Config.putValue("service.timeout.validation.isEnabled", (Object)defaultValidationTimeoutIsEnabled, false);
        Config.putValue("service.timeout.validation.seconds", (Object)defaultValidationTimeoutIsSeconds, false);
        Config.putValue("service.timeout.validation.delay.between.attempt.seconds", (Object)defaultValidationTimeoutDelay, false);
    }
}

