/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import io.restassured.response.Response;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class SqlHelper {
    public static void saveOutboundJsonParameters(Response response, String outputParam) {
        if (response == null || outputParam.isEmpty()) {
            return;
        }
        JsonHelper.saveOutboundJsonParameters(response, outputParam);
    }

    public static void saveOutboundSQLParameters(ResultSet resSet, String outputParam) throws Exception {
        SqlHelper.configMapSqlKeyValues(resSet, outputParam);
    }

    public static void configMapSqlKeyValues(ResultSet resSet, String keyValue) throws Exception {
        if (keyValue.isEmpty()) {
            return;
        }
        keyValue = SqlHelper.setRandomRowValue(resSet, keyValue);
        keyValue = DataHelper.replaceParameters(keyValue);
        List<KeyValue> keywords = DataHelper.getValidationMap(keyValue);
        for (KeyValue keyword : keywords) {
            String key = (String)keyword.value;
            key = key.replace("$", "").replace("<", "").replace(">", "").trim();
            String value = "";
            if (keyword.position.isEmpty()) {
                value = SqlHelper.getAllValuesInColumn(resSet, keyword.key);
            } else {
                resSet.absolute(Integer.valueOf(keyword.position));
                value = resSet.getString(keyword.key);
            }
            if (!keyword.position.isEmpty()) {
                value = value.split(",")[Integer.valueOf(keyword.position) - 1];
            }
            Config.putValue(key, (Object)value, false);
        }
        KeyValue.printKeyValue(keywords, "saving value");
    }

    private static String getAllValuesInColumn(ResultSet resSet, String column) throws SQLException {
        resSet.beforeFirst();
        ArrayList<String> results = new ArrayList<String>();
        while (resSet.next()) {
            results.add(resSet.getString(column));
        }
        return String.join((CharSequence)",", results);
    }

    public static String setRandomRowValue(ResultSet resSet, String outputParam) throws SQLException {
        if (outputParam.isEmpty()) {
            return outputParam;
        }
        if (outputParam.contains("<@RAND_DatabaseMaxRows>")) {
            int maxRowCount = SqlHelper.getMaxResultRowCount(resSet);
            int row = Helper.generateRandomNumber(1, maxRowCount);
            outputParam = outputParam.replace("<@RAND_DatabaseMaxRows>", String.valueOf(row));
        }
        return outputParam;
    }

    private static int getMaxResultRowCount(ResultSet resSet) throws SQLException {
        resSet.last();
        int size = resSet.getRow();
        resSet.beforeFirst();
        return size;
    }

    public static List<String> validateSqlKeywords(List<KeyValue> keywords, ResultSet resSet) throws SQLException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (KeyValue keyword : keywords) {
            String key = Helper.removeSurroundingQuotes(keyword.key);
            String position = Helper.stringNormalize(keyword.position);
            String expectedValue = Helper.stringRemoveLines((String)keyword.value);
            String responseString = "";
            String command = "";
            String[] expected = expectedValue.split("[\\(\\)]");
            if (expected.length > 1) {
                command = expected[0];
                expectedValue = expected[1];
            } else if (expected.length == 1) {
                command = expectedValue;
                expectedValue = "";
            }
            if (position.isEmpty()) {
                responseString = SqlHelper.getAllValuesInColumn(resSet, keyword.key);
            } else {
                resSet.absolute(Integer.valueOf(position));
                responseString = Helper.removeSurroundingQuotes(resSet.getString(key));
            }
            errorMessages.add(DataHelper.validateCommand(command, responseString, expectedValue));
        }
        return errorMessages;
    }

    public static void validateByJsonBody(String expectedJson, ResultSet resSet) throws SQLException {
        if (SqlHelper.isValidJson(expectedJson)) {
            TestLog.logPass("expected: " + Helper.stringRemoveLines(expectedJson), new Object[0]);
            String key = StringUtils.substringBefore((String)expectedJson, (String)":");
            String json = StringUtils.substringAfter((String)expectedJson, (String)":");
            try {
                String responseBody = resSet.getString(key);
                JSONAssert.assertEquals((String)json, (String)responseBody, (JSONCompareMode)JSONCompareMode.LENIENT);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isValidJson(String expected) {
        String value = StringUtils.substringAfter((String)expected, (String)":");
        return JsonHelper.isJSONValid(value, false);
    }
}

