/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.excelHelper;

import core.helpers.excelHelper.ExcelObject;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelHelper {
    public static final String Path_TestData = "testData/";

    public static ExcelObject setExcelFile(ExcelObject excel) throws Exception {
        FileInputStream ExcelFile = new FileInputStream(Path_TestData + excel.file);
        excel.withExcelWBook(new XSSFWorkbook((InputStream)ExcelFile));
        excel.withExcelWSheet(excel.ExcelWBook.getSheet(excel.sheetName));
        return excel;
    }

    public static List<String> getColumData(ExcelObject excel) throws Exception {
        excel = ExcelHelper.setExcelFile(excel);
        ArrayList<String> columnData = new ArrayList<String>();
        for (Row row : excel.ExcelWSheet) {
            Cell cell = row.getCell(excel.column);
            String cellData = cell.getStringCellValue();
            if (cellData == null) continue;
            columnData.add(cellData);
        }
        return columnData;
    }

    public static String getCellData(ExcelObject excel) throws Exception {
        ExcelHelper.setExcelFile(excel);
        XSSFCell Cell2 = excel.ExcelWSheet.getRow(excel.row).getCell(excel.column);
        String CellData = Cell2.getStringCellValue();
        return CellData;
    }

    public static void setCellData(ExcelObject excel) throws Exception {
        ExcelHelper.setExcelFile(excel);
        XSSFRow Row2 = excel.ExcelWSheet.getRow(excel.row);
        XSSFCell Cell2 = Row2.getCell(excel.column, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
        if (Cell2 == null) {
            Cell2 = Row2.createCell(excel.column);
            Cell2.setCellValue(excel.value);
        } else {
            Cell2.setCellValue(excel.value);
        }
        FileOutputStream fileOut = new FileOutputStream(Path_TestData + excel.file);
        excel.ExcelWBook.write((OutputStream)fileOut);
        fileOut.flush();
        fileOut.close();
    }

    public static void setCellData(List<ExcelObject> excelObjects) throws Exception {
        ExcelHelper.setExcelFile(excelObjects.get(0));
        for (ExcelObject excel : excelObjects) {
            XSSFRow Row2 = excel.ExcelWSheet.getRow(excel.row);
            XSSFCell Cell2 = Row2.getCell(excel.column, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
            if (Cell2 == null) {
                Cell2 = Row2.createCell(excel.column);
                Cell2.setCellValue(excel.value);
                continue;
            }
            Cell2.setCellValue(excel.value);
        }
        FileOutputStream fileOut = new FileOutputStream(Path_TestData + excelObjects.get((int)0).file);
        excelObjects.get((int)0).ExcelWBook.write((OutputStream)fileOut);
        fileOut.flush();
        fileOut.close();
    }
}

