/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.emailHelper;

import core.helpers.emailHelper.EmailObject;
import core.support.logger.TestLog;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.SearchTerm;

public class EmailHelper {
    public static void searchEmail(final EmailObject email) throws Exception {
        String line;
        Message[] foundMessages;
        Properties props = System.getProperties();
        props.setProperty("mail.store.protocol", "imaps");
        Session session = Session.getDefaultInstance((Properties)props, null);
        Store store = session.getStore("imaps");
        store.connect("imap.gmail.com", email.toEmail, email.password);
        Folder folder = store.getFolder("INBOX");
        folder.open(2);
        TestLog.ConsoleLog("Total Message:" + folder.getMessageCount(), new Object[0]);
        TestLog.ConsoleLog("Unread Message:" + folder.getUnreadMessageCount(), new Object[0]);
        boolean isMailFound = false;
        Message mailFrom = null;
        SearchTerm searchCondition = new SearchTerm(){

            public boolean match(Message message) {
                try {
                    if (message.getSubject().contains(email.subject)) {
                        TestLog.ConsoleLog("message.getSubject()" + message.getSubject(), new Object[0]);
                        return true;
                    }
                }
                catch (MessagingException ex) {
                    ex.printStackTrace();
                }
                return false;
            }
        };
        Message[] messageArray = foundMessages = folder.search(searchCondition);
        int n = messageArray.length;
        int n2 = 0;
        if (n2 < n) {
            Message mail;
            mailFrom = mail = messageArray[n2];
            TestLog.ConsoleLog("Message Count is: " + mailFrom.getMessageNumber(), new Object[0]);
            isMailFound = true;
        }
        if (!isMailFound) {
            throw new Exception("Could not find new mail");
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(mailFrom.getInputStream()));
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        String registrationURL = buffer.toString().split("&amp;gt;http://www.god.de/members/?")[0].split("href=")[1];
        TestLog.ConsoleLog(registrationURL, new Object[0]);
    }
}

