/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.objects.DateFormats;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.reflections8.util.Joiner;

public class DateHelper {
    public static final String CONFIG_DATE_FORMAT = "date.format";
    public static final String CONFIG_DATE_CURRENT_ZONE = "date.current.zone";
    public static final String CONFIG_DATE_OUTPUT_ZONE = "date.output.zone";
    public static final String CONFIG_DATE_LOCAL = "date.local";
    public static final String CONFIG_DATE_FORMAT_DEFAULT = "date.format.default";
    public static final String CONFIG_DATE_ZONE_INPUT_DEFAULT = "date.zone.input.default";
    public static final String CONFIG_DATE_ZONE_OUTPUT_DEFAULT = "date.zone.output.default";

    public String getTimestampMiliseconds() {
        return this.getCurrentTime("yyyyMMddHHmmssSSSSS");
    }

    public String getCurrentTimeEpochSeconds() {
        String value = String.valueOf(Instant.now().getEpochSecond());
        return value;
    }

    public String getCurrentTimeEpochMS() {
        String value = String.valueOf(Instant.now().toEpochMilli());
        return value;
    }

    public String getTimeEpochMS(ZonedDateTime time) {
        String value = String.valueOf(time.toInstant().toEpochMilli());
        return value;
    }

    public String getTimeInstance() {
        return Instant.now().toString();
    }

    public String getTimestampSeconds() {
        return this.getCurrentTime("yyyy-MM-dd HH:mm:ss");
    }

    public String getTimeISOInstant() {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }

    public String getCurrentTime(String format, String currentZone) {
        Instant time = Instant.now();
        return this.getTime(time, format, currentZone);
    }

    public String getCurrentTime(String format) {
        Instant time = Instant.now();
        return this.getTime(time, format);
    }

    public String getCurrentTime(Locale locale) {
        Instant time = Instant.now();
        return this.getTime(time, locale);
    }

    public String getCurrentTime(String format, String currentZone, String outputZone, Locale locale) {
        Instant time = Instant.now();
        return this.getTime(time, format, currentZone, outputZone, locale);
    }

    public String getTime(Instant time) {
        return this.getTime(time, "", "UTC", "UTC", null);
    }

    public String getTime(Instant time, Locale locale) {
        return this.getTime(time, "", "UTC", "UTC", locale);
    }

    public String getTime(Instant time, String format) {
        return this.getTime(time, format, "UTC", "UTC", null);
    }

    public String getTime(Instant time, String format, Locale locale) {
        return this.getTime(time, format, "UTC", "UTC", locale);
    }

    public String getTime(Instant time, String format, String zone) {
        return this.getTime(time, format, zone, "UTC", null);
    }

    public String getTime(Instant time, String format, String zone, Locale locale) {
        return this.getTime(time, format, zone, "UTC", locale);
    }

    public String getTime(Instant time, String format, String currentZone, String outputZone, Locale locale) {
        DateTimeFormatter formatter;
        ZonedDateTime zdt = null;
        String formatDefault = Config.getValue(CONFIG_DATE_FORMAT_DEFAULT);
        String zoneInputDefault = Config.getValue(CONFIG_DATE_ZONE_INPUT_DEFAULT);
        String zoneOoutputDefault = Config.getValue(CONFIG_DATE_ZONE_OUTPUT_DEFAULT);
        if (StringUtils.isBlank((String)formatDefault) && StringUtils.isBlank((String)format)) {
            format = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        }
        if (StringUtils.isBlank((String)zoneInputDefault) && StringUtils.isBlank((String)currentZone)) {
            currentZone = "UTC";
        }
        if (StringUtils.isBlank((String)zoneOoutputDefault) && StringUtils.isBlank((String)outputZone)) {
            outputZone = "UTC";
        }
        if (StringUtils.isBlank((String)currentZone)) {
            currentZone = zoneInputDefault;
        }
        if (StringUtils.isBlank((String)outputZone)) {
            outputZone = zoneOoutputDefault;
        }
        if (!StringUtils.isBlank((String)currentZone)) {
            LocalDateTime timelocal = LocalDateTime.ofInstant(time, ZoneId.of("UTC"));
            zdt = ZonedDateTime.of(timelocal, ZoneId.of(currentZone));
        }
        zdt = zdt.withZoneSameInstant(ZoneId.of(outputZone));
        if (StringUtils.isBlank((String)format)) {
            format = formatDefault;
        }
        if (format.startsWith("cc") || format.startsWith("CC")) {
            formatter = DateTimeFormatter.ofPattern("YYYY").withZone(ZoneId.of("UTC"));
            String year = formatter.format(time).substring(0, 2);
            int cc = Integer.valueOf(year) + 1;
            format = format.replace("cc", "").replace("CC", "");
            formatter = DateTimeFormatter.ofPattern(format);
            return String.valueOf(cc) + formatter.format(zdt);
        }
        formatter = null;
        formatter = locale != null ? DateTimeFormatter.ofPattern(format).withLocale(locale) : DateTimeFormatter.ofPattern(format);
        return formatter.format(zdt);
    }

    public String getTime(String timeString, String format, String zone) {
        return this.getTime(timeString, format, zone, "", null);
    }

    public String getTime(String timeString, String format, String outputZone, String zone) {
        return this.getTime(timeString, format, zone, outputZone, null);
    }

    public String getTimeString(String timeString, String format, String zone, String outputZone, String localeStr) {
        Locale locale = null;
        switch (localeStr) {
            case "english": {
                locale = Locale.ENGLISH;
                break;
            }
            case "france": {
                locale = Locale.FRANCE;
                break;
            }
            case "germany": {
                locale = Locale.GERMAN;
                break;
            }
            case "canada": {
                locale = Locale.CANADA;
                break;
            }
            case "china": {
                locale = Locale.CHINA;
                break;
            }
            case "japan": {
                locale = Locale.JAPAN;
                break;
            }
            case "italy": {
                locale = Locale.ITALY;
                break;
            }
            case "uk": {
                locale = Locale.UK;
                break;
            }
            case "taiwan": {
                locale = Locale.TAIWAN;
                break;
            }
            case "korea": {
                locale = Locale.KOREA;
                break;
            }
            case "us": {
                locale = Locale.US;
                break;
            }
            default: {
                if (StringUtils.isBlank((String)localeStr)) {
                    locale = null;
                    break;
                }
                Helper.assertFalse("correct local not selected. options: english, france, germany, canada, china, jpan, italy, uk, taiwan, korea, us");
            }
        }
        return this.getTime(timeString, format, zone, outputZone, locale);
    }

    public String getTime(String timeString, String format, String zone, String outputZone, Locale locale) {
        LocalDateTime date1Date = this.getLocalDateTime(timeString);
        Instant timeInstant = date1Date.atZone(ZoneId.of("UTC")).toInstant();
        return this.getTime(timeInstant, format, zone, outputZone, locale);
    }

    public int getDayOfWeekIndex(String day) {
        DateTimeFormatter dayOfWeekFormatter = DateTimeFormatter.ofPattern("EEEE", Locale.ENGLISH);
        Locale loc = Locale.US;
        WeekFields wf = WeekFields.of(loc);
        DayOfWeek dayOfWeek = DayOfWeek.from(dayOfWeekFormatter.parse(day));
        int dayNumber = dayOfWeek.get(wf.dayOfWeek());
        return dayNumber;
    }

    public int getDayOfWeekIndex(LocalDateTime time) {
        Locale loc = Locale.US;
        WeekFields wf = WeekFields.of(loc);
        DayOfWeek dayOfWeek = time.getDayOfWeek();
        int day = dayOfWeek.get(wf.dayOfWeek());
        return day;
    }

    public int getMonthOfYearIndex(String month) {
        int monthNum = Month.valueOf(month.toUpperCase()).getValue();
        return monthNum;
    }

    public int getMonthOfYearIndex(LocalDateTime time) {
        return time.getMonth().getValue();
    }

    public boolean isBetweenDates(String source, String date1, String date2) {
        LocalDateTime sourceDate = this.getLocalDateTime(source);
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        LocalDateTime date2Date = this.getLocalDateTime(date2);
        return sourceDate.isAfter(date1Date) && sourceDate.isBefore(date2Date);
    }

    public boolean isBetweenDates(List<String> sources, String date1, String date2) {
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        LocalDateTime date2Date = this.getLocalDateTime(date2);
        for (String source : sources) {
            LocalDateTime sourceDate = this.getLocalDateTime(source);
            if (sourceDate.isAfter(date1Date) && sourceDate.isBefore(date2Date)) continue;
            return false;
        }
        return true;
    }

    public boolean isDateAfter(String source, String date1) {
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        LocalDateTime sourceDate = this.getLocalDateTime(source);
        return sourceDate.isAfter(date1Date);
    }

    public boolean isDateAfter(List<String> sources, String date1) {
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        for (String source : sources) {
            LocalDateTime sourceDate = this.getLocalDateTime(source);
            if (sourceDate.isAfter(date1Date)) continue;
            return false;
        }
        return true;
    }

    public boolean isDateBefore(String source, String date1) {
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        LocalDateTime sourceDate = this.getLocalDateTime(source);
        return sourceDate.isBefore(date1Date);
    }

    public boolean isDateBefore(List<String> sources, String date1) {
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        for (String source : sources) {
            LocalDateTime sourceDate = this.getLocalDateTime(source);
            if (sourceDate.isBefore(date1Date)) continue;
            return false;
        }
        return true;
    }

    public boolean isDateEqual(String source, String target) {
        LocalDateTime date1Date = this.getLocalDateTime(target);
        LocalDateTime sourceDate = this.getLocalDateTime(source);
        return sourceDate.isEqual(date1Date);
    }

    public boolean isDateEqual(List<String> sources, String target) {
        LocalDateTime date1Date = this.getLocalDateTime(target);
        for (String source : sources) {
            LocalDateTime sourceDate = this.getLocalDateTime(source);
            if (sourceDate.equals(date1Date)) continue;
            return false;
        }
        return true;
    }

    public boolean isDateNotEqual(String source, String target) {
        LocalDateTime date1Date = this.getLocalDateTime(target);
        LocalDateTime sourceDate = this.getLocalDateTime(source);
        return !sourceDate.isEqual(date1Date);
    }

    public boolean isDateNotEqual(List<String> sources, String target) {
        LocalDateTime date1Date = this.getLocalDateTime(target);
        for (String source : sources) {
            LocalDateTime sourceDate = this.getLocalDateTime(source);
            if (!sourceDate.equals(date1Date)) continue;
            return false;
        }
        return true;
    }

    public LocalDateTime getLocalDateTime(String timeString) {
        LocalDateTime dateTime = null;
        timeString = timeString.trim();
        for (String format : DateFormats.dateFormats) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                dateTime = LocalDateTime.parse(timeString.trim(), formatter);
                return dateTime;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        if (Helper.isNumeric(timeString)) {
            try {
                Long epochTime = Long.valueOf(timeString);
                dateTime = timeString.length() <= 10 ? LocalDateTime.ofInstant(Instant.ofEpochSecond(epochTime), ZoneId.of("UTC")) : LocalDateTime.ofInstant(Instant.ofEpochMilli(epochTime), ZoneId.of("UTC"));
                return dateTime;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        Helper.assertFalse("no matching date format for string: " + timeString);
        return null;
    }

    private static void resetDateConfig() {
        Config.putValue(CONFIG_DATE_FORMAT, (Object)"", false);
        Config.putValue(CONFIG_DATE_CURRENT_ZONE, (Object)"", false);
        Config.putValue(CONFIG_DATE_OUTPUT_ZONE, (Object)"", false);
        Config.putValue(CONFIG_DATE_LOCAL, (Object)"", false);
    }

    public String getTime(String parameter, String timeString) {
        String[] values;
        parameter = DataHelper.replaceParameters(parameter, "\\{@(.+?)\\}", "{@", "}");
        parameter = Helper.date.setTimeParameterFormat(parameter);
        for (String value : values = parameter.split(";")) {
            String setDay;
            String zone;
            if (value.contains("FORMAT")) {
                String format = value.split("FORMAT")[1];
                format = this.removeFirstAndLastChars(format, ":", "<", ">");
                Config.putValue(CONFIG_DATE_FORMAT, (Object)format, false);
                continue;
            }
            if (value.contains("OUTPUT_ZONE")) {
                zone = value.split("OUTPUT_ZONE")[1];
                zone = this.removeFirstAndLastChars(zone, ":", "<", ">");
                Config.putValue(CONFIG_DATE_OUTPUT_ZONE, (Object)zone, false);
                continue;
            }
            if (value.contains("ZONE")) {
                zone = value.split("ZONE")[1];
                zone = this.removeFirstAndLastChars(zone, ":", "<", ">");
                Config.putValue(CONFIG_DATE_CURRENT_ZONE, (Object)zone, false);
                continue;
            }
            if (value.contains("LOCALE")) {
                String locale = value.split("LOCALE")[1];
                locale = this.removeFirstAndLastChars(locale, ":", "<", ">");
                Config.putValue(CONFIG_DATE_LOCAL, (Object)locale, false);
                continue;
            }
            if (value.contains("setInitialDate")) {
                String setInitialDate = value.split("setInitialDate")[1];
                setInitialDate = this.removeFirstAndLastChars(setInitialDate, ":", "<", ">");
                timeString = this.setInitialDate(setInitialDate);
                continue;
            }
            if (value.contains("setTime")) {
                String setTime = value.split("setTime")[1];
                setTime = this.removeFirstAndLastChars(setTime, ":", "<", ">");
                timeString = this.setTime(setTime, timeString);
                continue;
            }
            if (value.contains("setDay")) {
                setDay = value.split("setDay")[1];
                setDay = this.removeFirstAndLastChars(setDay, ":", "<", ">");
                timeString = this.setDay(setDay, timeString);
                continue;
            }
            if (value.contains("setMonth")) {
                setDay = value.split("setMonth")[1];
                setDay = this.removeFirstAndLastChars(setDay, ":", "<", ">");
                timeString = this.setMonth(setDay, timeString);
                continue;
            }
            value = this.removeFirstAndLastChars(value, ":", "<", ">");
            timeString = this.getTimeWithModification(value, timeString);
        }
        timeString = Helper.date.getTimeString(timeString, Config.getValue(CONFIG_DATE_FORMAT), Config.getValue(CONFIG_DATE_CURRENT_ZONE), Config.getValue(CONFIG_DATE_OUTPUT_ZONE), Config.getValue(CONFIG_DATE_LOCAL));
        DateHelper.resetDateConfig();
        return timeString;
    }

    public String setTimeParameterFormat(String parameter) {
        String setTimeString = "setTime";
        String setDayString = "setDay";
        String setMonthString = "setMonth";
        if (!(parameter.contains(setTimeString) || parameter.contains(setDayString) || parameter.contains(setMonthString))) {
            return parameter;
        }
        String[] values = parameter.split(";");
        ArrayList<String> updatedParameters = new ArrayList<String>();
        ArrayList<String> existingParameters = new ArrayList<String>();
        for (String value : values) {
            if (!(value.contains(setTimeString) || value.contains(setDayString) || value.contains(setMonthString))) {
                existingParameters.add(value);
                continue;
            }
            if (value.contains(setDayString)) {
                updatedParameters.add(value);
                continue;
            }
            if (value.contains(setTimeString)) {
                updatedParameters.add(value);
                continue;
            }
            if (!value.contains(setMonthString)) continue;
            updatedParameters.add(value);
        }
        updatedParameters.addAll(existingParameters);
        parameter = Joiner.on((String)";").join(updatedParameters);
        return parameter;
    }

    public String setInitialDate(String parameter) {
        LocalDateTime date = Helper.date.getLocalDateTime(parameter);
        Instant time = date.atZone(ZoneId.of("UTC")).toInstant();
        return time.toString();
    }

    public String setTime(String parameter, String timeString) {
        LocalDateTime date = Helper.date.getLocalDateTime(timeString);
        Instant time = date.atZone(ZoneId.of("UTC")).toInstant();
        String[] parameters = parameter.split(":");
        if (parameters.length != 3) {
            Helper.assertFalse("format must be hh:mm:ss. value: " + parameter);
        }
        int hour = Helper.getIntFromString(parameters[0]);
        int minute = Helper.getIntFromString(parameters[1]);
        int second = Helper.getIntFromString(parameters[2]);
        time = time.atZone(ZoneOffset.UTC).withHour(hour).withMinute(minute).withSecond(second).withNano(0).toInstant();
        return time.toString();
    }

    public String setDay(String dayName, String timeString) {
        LocalDateTime time = Helper.date.getLocalDateTime(timeString);
        int currentDay = Helper.date.getDayOfWeekIndex(time);
        int targetDay = Helper.date.getDayOfWeekIndex(dayName);
        int timeDifference = targetDay - currentDay;
        time = time.plusDays(timeDifference);
        return time.toString();
    }

    public String setMonth(String monthName, String timeString) {
        LocalDateTime time = Helper.date.getLocalDateTime(timeString);
        int currentMonth = Helper.date.getMonthOfYearIndex(time);
        int targetMonth = Helper.date.getMonthOfYearIndex(monthName);
        int timeDifference = targetMonth - currentMonth;
        time = time.plusMonths(timeDifference);
        return time.toString();
    }

    public String removeFirstAndLastChars(String value, String ... toRemove) {
        if (StringUtils.isBlank((String)value)) {
            return value;
        }
        if (toRemove.length == 0) {
            return value;
        }
        for (String remove : toRemove) {
            if (value.startsWith(remove)) {
                value = StringUtils.removeStart((String)value, (String)remove);
            }
            if (!value.endsWith(remove)) continue;
            value = StringUtils.removeEnd((String)value, (String)remove);
        }
        return value;
    }

    public String getTimeWithModification(String parameter, String timeString) {
        LocalDateTime localTime = Helper.date.getLocalDateTime(timeString);
        Instant newTime = localTime.atZone(ZoneId.of("UTC")).toInstant();
        String[] parameterArray = parameter.split("(?=[+-])");
        LinkedList<String> parameterList = new LinkedList<String>(Arrays.asList(parameterArray));
        if (!((String)parameterList.get(0)).contains("_TIME")) {
            Helper.assertFalse("Date does not have correct format. must start with: _TIME");
        }
        parameterList.remove(0);
        block16: for (String value : parameterList) {
            if (parameterArray.length == 1) {
                return newTime.toString();
            }
            String modifier = value.split("[+-]")[1];
            String modiferSign = value.replaceAll("[^+-]", "");
            int modifierDuration = Helper.getIntFromString(modifier);
            String modifierUnit = modifier.replaceAll("[^A-Za-z]+", "");
            if (modiferSign.isEmpty() || modifierDuration == -1 || modifierUnit.isEmpty()) {
                Helper.assertFalse("invalid time modifier. format: eg. _TIME_STRING_17+72h or _TIME_STRING_17-72m");
            }
            switch (modifierUnit) {
                case "y": {
                    if (modiferSign.equals("+")) {
                        localTime = localTime.plusYears(modifierDuration);
                        continue block16;
                    }
                    if (!modiferSign.equals("-")) continue block16;
                    localTime = localTime.minusYears(modifierDuration);
                    continue block16;
                }
                case "mo": {
                    if (modiferSign.equals("+")) {
                        localTime = localTime.plusMonths(modifierDuration);
                        continue block16;
                    }
                    if (!modiferSign.equals("-")) continue block16;
                    localTime = localTime.minusMonths(modifierDuration);
                    continue block16;
                }
                case "w": {
                    if (modiferSign.equals("+")) {
                        localTime = localTime.plusWeeks(modifierDuration);
                        continue block16;
                    }
                    if (!modiferSign.equals("-")) continue block16;
                    localTime = localTime.minusWeeks(modifierDuration);
                    continue block16;
                }
                case "d": {
                    if (modiferSign.equals("+")) {
                        localTime = localTime.plusDays(modifierDuration);
                        continue block16;
                    }
                    if (!modiferSign.equals("-")) continue block16;
                    localTime = localTime.minusDays(modifierDuration);
                    continue block16;
                }
                case "h": {
                    if (modiferSign.equals("+")) {
                        localTime = localTime.plusHours(modifierDuration);
                        continue block16;
                    }
                    if (!modiferSign.equals("-")) continue block16;
                    localTime = localTime.minusHours(modifierDuration);
                    continue block16;
                }
                case "m": {
                    if (modiferSign.equals("+")) {
                        localTime = localTime.plusMinutes(modifierDuration);
                        continue block16;
                    }
                    if (!modiferSign.equals("-")) continue block16;
                    localTime = localTime.minusMinutes(modifierDuration);
                    continue block16;
                }
            }
            Helper.assertFalse("invalid time modifier. format: eg. +2d or +72h or -72m or +1mo or +2y");
        }
        String dateString = localTime.toInstant(ZoneOffset.UTC).toString();
        return dateString;
    }
}

