/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.emailHelper;

import core.helpers.emailHelper.EmailObject;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailSendHelper {
    public static void sendMail(EmailObject email) {
        final String username = email.fromEmail;
        final String password = email.password;
        Properties props = new Properties();
        props.put("mail.smtp.auth", email.smtpAuth.toString());
        props.put("mail.smtp.starttls.enable", email.smtpStarttlsEnabled.toString());
        props.put("mail.smtp.host", email.smtpHost);
        props.put("mail.smtp.port", email.smtpPort);
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(email.fromEmail));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)email.toEmail));
            message.setSubject(email.subject);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(email.body);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            String file = email.attachmentPath;
            String fileName = email.attachmentFile;
            FileDataSource source = new FileDataSource(file);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(fileName);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }
}

