/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.opencsv.CSVReader;
import core.apiCore.helpers.CsvReader;
import core.apiCore.helpers.JsonHelper;
import core.apiCore.helpers.XmlHelper;
import core.apiCore.interfaces.ExternalInterface;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.json.JSONArray;

public class DataHelper {
    public static final String VERIFY_JSON_PART_INDICATOR = "_VERIFY.JSON.PART_";
    public static final String VERIFY_JSON_PART_INDICATOR_UNDERSCORE = "_VERIFY_JSON_PART_";
    public static final String VERIFY_RESPONSE_BODY_INDICATOR = "_VERIFY_RESPONSE_BODY_";
    public static final String VERIFY_RESPONSE_NO_EMPTY = "_NOT_EMPTY_";
    public static final String VERIFY_HEADER_PART_INDICATOR = "_VERIFY_HEADER_PART_";
    public static final String VERIFY_TOPIC_PART_INDICATOR = "_VERIFY_TOPIC_PART_";
    public static final String EXPECTED_MESSAGE_COUNT = "EXPECTED_MESSAGE_COUNT";
    public static final String IS_IGNORE_XML_NAMESPACE = "service.xml.ignore.namespace";
    public static final String TEST_DATA_TEMPLATE_DATA_PATH = "api.templateDataFile";
    public static final String VALIDATION_OR_CONDITION_ECODE = "\\|\\|";
    public static final String VALIDATION_OR_CONDITION = "||";
    public static final String VALIDATION_AND_CONDITION = "&&";
    public static final String REQUEST_BODY_UPDATE_INDICATOR = "_UPDATE_REQUEST_";

    public static String replaceParameters(String source) {
        return DataHelper.replaceParameters(source, "<@(.+?)>", "<@", ">");
    }

    public static String replaceParameters(String source, String tagPattern, String openingTag, String closingTag) {
        if (source.isEmpty()) {
            return source;
        }
        List<String> parameters = Helper.getValuesFromPattern(source, tagPattern);
        Object value = null;
        int length = 0;
        String newTime = "";
        for (String parameter : parameters) {
            Instant time;
            if (parameter.contains("_TIME_MS_")) {
                newTime = Helper.date.getTime(parameter, Config.getValue("_startTimeString_"));
                time = DataHelper.getTimeInstance(newTime);
                value = DataHelper.getTimeSubstring(parameter, String.valueOf(time.toEpochMilli()));
            } else if (parameter.contains("_TIME_S_")) {
                newTime = Helper.date.getTime(parameter, Config.getValue("_startTimeString_"));
                time = DataHelper.getTimeInstance(newTime);
                value = DataHelper.getTimeSubstring(parameter, String.valueOf(time.getEpochSecond()));
            } else if (parameter.contains("_TIME_STRING_")) {
                newTime = Helper.date.getTime(parameter, Config.getValue("_startTimeString_"));
                value = DataHelper.getTimeSubstring(parameter, Helper.date.getTime(newTime, "yyyyMMddHHmmssSSS", null));
            } else if (parameter.contains("_TIME_ISO_")) {
                newTime = Helper.date.getTime(parameter, Config.getValue("_startTimeString_"));
                value = DataHelper.getTimeSubstring(parameter, newTime);
            } else if (parameter.contains("_TIME")) {
                newTime = Helper.date.getTime(parameter, Config.getValue("_startTimeString_"));
                value = DataHelper.getTimeSubstring(parameter, newTime);
            } else if (parameter.contains("_RANDUUID")) {
                value = Helper.generateUUID();
            } else if (parameter.contains("_UUID_STATIC")) {
                value = Config.getValue("_uuidStaticString_");
            } else if (parameter.contains("_RAND")) {
                length = Helper.getIntFromString(parameter);
                value = Config.getValue("_randomString_").substring(0, length);
            } else if (parameter.contains("_INCREMENT_FROM_")) {
                value = DataHelper.getIncrementalValue(parameter);
            } else if (parameter.contains("_XML")) {
                String[] valueArray = parameter.split(":");
                int index = 0;
                String tag = valueArray[1];
                if (valueArray.length == 3) {
                    index = Integer.valueOf(parameter.split(":")[2]);
                }
                value = XmlHelper.getXmlTagValue(source, tag, index + 1);
            } else {
                value = Config.getObjectValue(parameter.replace("@", ""));
            }
            if (DataHelper.isObjectEmpty(value)) {
                TestLog.logWarning("parameter value not found: " + parameter, new Object[0]);
                continue;
            }
            source = source.replace(openingTag + parameter + closingTag, Matcher.quoteReplacement(value.toString()));
        }
        return source;
    }

    public static boolean isObjectEmpty(Object value) {
        return value == null || StringUtils.isBlank((CharSequence)value.toString()) || value.equals("null");
    }

    public static int getIncrementalValue(String parameter) {
        int startingValue = Helper.getIntFromString(parameter);
        int testCurrentRunCount = 1;
        String testId = TestObject.getTestInfo().serviceObject.getTestCaseID();
        if (testId.matches(".*_run_(\\d)?$")) {
            testId = testId.substring(testId.lastIndexOf("_run_") + 1);
            testCurrentRunCount = Helper.getIntFromString(testId);
        }
        int incrementalValue = startingValue + testCurrentRunCount - 1;
        return incrementalValue;
    }

    public static String getTimeSubstring(String parameter, String finalTime) {
        int maxLength;
        String[] values = parameter.split(";");
        String modifier = values[0].split("[+-]")[0];
        int length = Helper.getFirstNumber(modifier);
        if (length > (maxLength = finalTime.length()) || length == -1 || length == 0) {
            length = maxLength;
        }
        return finalTime.substring(0, length);
    }

    public static Instant getTimeInstance(String timeString) {
        LocalDateTime localDateTime = Helper.date.getLocalDateTime(timeString);
        Instant timeInstant = localDateTime.toInstant(ZoneOffset.UTC);
        return timeInstant;
    }

    public static List<KeyValue> getValidationMap(String expected) {
        return DataHelper.getValidationMap(expected, ";");
    }

    public static List<KeyValue> getValidationMap(String expected, String separator) {
        String[] keyVals;
        ArrayList<KeyValue> keywords = new ArrayList<KeyValue>();
        expected = JsonHelper.removeResponseIndicator(expected);
        for (String keyVal : keyVals = expected.split(separator)) {
            String key = "";
            String position = "";
            String value = "";
            if (keyVal.isEmpty()) continue;
            List<String> parts = DataHelper.splitToKeyPositionValue(keyVal, ":", 3);
            if (parts.size() == 1) {
                key = Helper.stringRemoveLines(parts.get(0));
            }
            if (parts.size() == 2) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = "";
                value = Helper.stringRemoveLines(parts.get(1));
            } else if (parts.size() == 3) {
                key = Helper.stringRemoveLines(parts.get(0));
                position = Helper.stringRemoveLines(parts.get(1));
                value = Helper.stringRemoveLines(parts.get(2));
            }
            if (key.isEmpty()) continue;
            KeyValue keyword = new KeyValue(key, position, value);
            keywords.add(keyword);
        }
        return keywords;
    }

    public static String getTemplateFileLocation(String file) {
        String templatePath = Config.getValue("api.templatePath").trim();
        String templateTestPath = Helper.getFullPath(templatePath);
        return templateTestPath + file;
    }

    public static Path getTemplateFilePath(String file) {
        String templatePath = Config.getValue("api.templatePath").trim();
        String templateTestPath = Helper.getFullPath(templatePath);
        String fullLocation = templateTestPath + file;
        return new File(fullLocation).toPath();
    }

    public static File getFile(String filename) {
        String templatePath = Config.getValue("api.templatePath").trim();
        String templateTestPath = Helper.getFullPath(templatePath);
        File file = new File(templateTestPath + filename);
        return file;
    }

    public static String getServiceObjectTemplateString(ServiceObject serviceObject) {
        Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
        return DataHelper.convertFileToString(templatePath);
    }

    public static String validateCommand(String command, String responseString, String expectedString) {
        String error = DataHelper.validateExpectedCommand(command, responseString, expectedString, "");
        if (error.isEmpty()) {
            TestLog.ConsoleLog("validation passed for command: " + responseString + " " + command + " " + expectedString, new Object[0]);
        } else {
            TestLog.ConsoleLog("validation failed for command: " + command + " with error: " + error, new Object[0]);
        }
        return error;
    }

    public static String validateCommand(String command, String responseString, String expectedString, String position, boolean skipValidation) {
        String response = DataHelper.validateExpectedCommand(command, responseString, expectedString, position);
        if (skipValidation) {
            return response;
        }
        if (response.isEmpty()) {
            TestLog.ConsoleLog("validation passed for command: response " + command + " " + expectedString, new Object[0]);
        } else {
            TestLog.ConsoleLog("validation failed for command: " + command + " with error: " + response, new Object[0]);
        }
        return response;
    }

    public static String validateExpectedCommand(String command, String responseString, String expectedString, String position) {
        expectedString = Helper.removeSurroundingQuotes(expectedString);
        command = Helper.removeSurroundingQuotes(command);
        responseString = Helper.removeSurroundingQuotes(responseString);
        List<String> expectedArray = DataHelper.getResponseArray(expectedString);
        List<String> actualArray = DataHelper.getResponseArray(responseString);
        String actualString = "";
        int positionInt = 0;
        if (!position.isEmpty() && Helper.getIntFromString(position) > 0) {
            boolean inBounds;
            positionInt = Helper.getIntFromString(position);
            boolean bl = inBounds = positionInt > 0 && positionInt <= actualArray.size();
            if (!inBounds) {
                Helper.assertFalse("items returned are less than specified. returned: " + actualArray.size() + " specified: " + positionInt);
            }
            actualString = actualArray.get(positionInt - 1);
        }
        if (DataHelper.getCommandFromExpectedString(command).isEmpty()) {
            Helper.assertFalse("Command not set. Options: " + Arrays.asList(JSON_COMMAND.values()) + ". See examples for usage.");
        }
        JSON_COMMAND jsonCommand = JSON_COMMAND.valueOf(command);
        switch (jsonCommand) {
            case command: {
                if (expectedArray.size() < 1) {
                    Helper.assertFalse("invalid command format. must be: Jsonpath:command(class.methodname, value) eg. Jsonpath:command(Command.hasMethod, value");
                }
                String method = expectedArray.get(0);
                expectedArray.remove(0);
                expectedArray = DataHelper.removeEmptyElements(expectedArray);
                String values = "";
                values = "values:" + Arrays.toString(expectedArray.toArray());
                ServiceObject serviceObject = new ServiceObject().withMethod("METHOD:" + method).withRequestBody("response:" + responseString + ";" + values);
                return ExternalInterface.ExternalInterfaceRunner(serviceObject).toString();
            }
            case notEqualTo: {
                boolean val = false;
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " not equals " + expectedString, new Object[0]);
                    boolean bl = val = !actualString.equals(expectedString);
                    if (val) break;
                    return actualString + " does equal " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying: " + responseString + " not equals " + expectedString, new Object[0]);
                    boolean bl = val = !responseString.equals(expectedString);
                    if (val) break;
                    return responseString + " does equal " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " not equals " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean bl = val = !actualArray.equals(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does equal " + Arrays.toString(expectedArray.toArray());
            }
            case equalTo: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " equals " + expectedString, new Object[0]);
                    boolean val = actualString.equals(expectedString);
                    if (val) break;
                    return actualString + " does not equal " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying: " + responseString + " equals " + expectedString, new Object[0]);
                    boolean val = responseString.equals(expectedString);
                    if (val) break;
                    return responseString + " does not equal " + expectedString;
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " equals " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = actualArray.equals(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not equal " + Arrays.toString(expectedArray.toArray());
            }
            case allValuesEqualTo: {
                boolean val;
                boolean bl = val = actualArray.get(0).equals(expectedString) && actualArray.stream().distinct().limit(2L).count() == 1L;
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " are not all equal to: " + expectedString;
            }
            case notHaveItems: 
            case notContains: 
            case notContain: {
                actualArray = DataHelper.removeEmptyElements(actualArray);
                if (actualArray.size() == 1) {
                    position = "1";
                }
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " does not contain " + expectedString, new Object[0]);
                    Set<String> missing = DataHelper.isListContain(actualString, expectedArray);
                    if (!missing.isEmpty()) break;
                    return actualString + " does contain " + missing.toString();
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " does not contain " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                Set<String> missing = DataHelper.isListContain(responseString, expectedArray);
                if (!missing.isEmpty()) break;
                return Arrays.toString(actualArray.toArray()) + " does contain " + expectedArray.removeAll(new ArrayList<String>(missing));
            }
            case hasItems: 
            case contains: 
            case contain: {
                actualArray = DataHelper.removeEmptyElements(actualArray);
                if (actualArray.size() == 1) {
                    position = "1";
                }
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying: " + actualString + " contains " + expectedString, new Object[0]);
                    Set<String> missing = DataHelper.isListContain(actualString, expectedArray);
                    if (missing.isEmpty()) break;
                    return actualString + " does not contain " + missing.toString();
                }
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " contains " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                Set<String> missing = DataHelper.isListContain(responseString, expectedArray);
                if (missing.isEmpty()) break;
                return Arrays.toString(actualArray.toArray()) + " does not contain " + missing.toString();
            }
            case containsInAnyOrder: {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " contains any order " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                Set<String> missing = DataHelper.isListContain(responseString, expectedArray);
                if (missing.isEmpty()) break;
                return Arrays.toString(actualArray.toArray()) + " does not contain " + missing.toString();
            }
            case integerGreaterThan: {
                TestLog.logPass("verifying: " + responseString + " is greater than " + expectedString, new Object[0]);
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "greaterThan");
                if (val) break;
                return "actual: " + responseString + " is not greater than expected: " + expectedString;
            }
            case integerLessThan: {
                TestLog.logPass("verifying: " + responseString + " is less than " + expectedString, new Object[0]);
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "lessThan");
                if (val) break;
                return "actual: " + responseString + " is not less than expected: " + expectedString;
            }
            case integerEqual: {
                TestLog.logPass("verifying: " + responseString + " is equal to " + expectedString, new Object[0]);
                boolean val = DataHelper.compareNumbers(responseString, expectedString, "equalTo");
                if (val) break;
                return "actual: " + responseString + " is not equal to expected: " + expectedString;
            }
            case integerNotEqual: {
                boolean val;
                boolean bl = val = !DataHelper.compareNumbers(responseString, expectedString, "equalTo");
                if (val) break;
                return "actual: " + responseString + " is not equal to expected: " + expectedString;
            }
            case countGreaterThan: 
            case nodeSizeGreaterThan: {
                int intValue = Integer.valueOf(expectedString);
                int actualLength = DataHelper.getResponseArrayLength(actualArray, responseString);
                TestLog.logPass("verifying node with size " + actualLength + " greater than " + intValue, new Object[0]);
                if (actualLength > intValue) break;
                return "response node size is: " + actualLength + " expected it to be greater than: " + intValue;
            }
            case countLessThan: 
            case nodeSizeLessThan: {
                int intValue = Integer.valueOf(expectedString);
                int actualLength = DataHelper.getResponseArrayLength(actualArray, responseString);
                TestLog.logPass("verifying node with size " + actualLength + " less than " + intValue, new Object[0]);
                if (actualLength < intValue) break;
                return "response node size is: " + actualLength + " expected it to be less than: " + intValue;
            }
            case countExact: 
            case nodeSizeExact: {
                int intValue = Integer.valueOf(expectedString);
                int actualLength = DataHelper.getResponseArrayLength(actualArray, responseString);
                TestLog.logPass("verifying node with size " + actualLength + " equals " + intValue, new Object[0]);
                if (actualLength == intValue) break;
                return "response node size is: " + actualLength + " expected: " + intValue;
            }
            case sequence: {
                TestLog.logPass("verifying: " + Arrays.toString(actualArray.toArray()) + " with sequence " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = actualArray.equals(expectedArray);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " does not equal " + Arrays.toString(expectedArray.toArray());
            }
            case jsonbody: {
                TestLog.logPass("verifying response: \n" + ServiceObject.normalizeLog(responseString) + "\n against expected: \n" + ServiceObject.normalizeLog(expectedString), new Object[0]);
                String error = JsonHelper.validateByJsonBody(expectedString, responseString, true);
                if (error.isEmpty()) break;
                return error;
            }
            case isNotEmpty: {
                TestLog.logPass("verifying response for path is not empty", new Object[0]);
                if (!DataHelper.isEmpty(responseString)) break;
                return "value is empty";
            }
            case isEmpty: {
                TestLog.logPass("verifying response for path is empty ", new Object[0]);
                if (DataHelper.isEmpty(responseString)) break;
                return "value is not empty";
            }
            case isBetweenDate: {
                boolean val;
                if (!position.isEmpty() && positionInt > 0) {
                    boolean val2;
                    TestLog.logPass("verifying date: " + actualString + " is in between dates: " + expectedString, new Object[0]);
                    String[] expectedDates = expectedString.split(",");
                    if (expectedDates.length != 2) {
                        Helper.assertFalse("require 2 dates to validate inbewteen date");
                    }
                    if (val2 = Helper.date.isBetweenDates(actualString, expectedDates[0], expectedDates[1])) break;
                    return actualString + " is not in between dates: " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    boolean val3;
                    TestLog.logPass("verifying date: " + responseString + " is in between dates: " + expectedString, new Object[0]);
                    String[] expectedDates = expectedString.split(",");
                    if (expectedDates.length != 2) {
                        Helper.assertFalse("require 2 dates to validate inbewteen date");
                    }
                    if (val3 = Helper.date.isBetweenDates(responseString, expectedDates[0], expectedDates[1])) break;
                    return responseString + " is not in between dates: " + expectedString;
                }
                TestLog.logPass("verifying dates: " + Arrays.toString(actualArray.toArray()) + " is in between dates: " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                String[] expectedDates = expectedString.split(",");
                if (expectedDates.length != 2) {
                    Helper.assertFalse("require 2 dates to validate inbewteen date");
                }
                if (val = Helper.date.isBetweenDates(actualArray, expectedDates[0], expectedDates[1])) break;
                return Arrays.toString(actualArray.toArray()) + " is not in between dates: " + Arrays.toString(expectedArray.toArray());
            }
            case isDateEqual: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying date: " + actualString + " is equal date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateEqual(actualString, expectedString);
                    if (val) break;
                    return actualString + " is equal date: " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying date: " + responseString + " is equal date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateEqual(responseString, expectedString);
                    if (val) break;
                    return responseString + " is not equal date: " + expectedString;
                }
                TestLog.logPass("verifying date: " + Arrays.toString(actualArray.toArray()) + " is equal date: " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = Helper.date.isDateEqual(actualArray, expectedString);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " is equal date: " + Arrays.toString(expectedArray.toArray());
            }
            case isDateNotEqual: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying date: " + actualString + " is not equal date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateNotEqual(actualString, expectedString);
                    if (val) break;
                    return actualString + " is not equal date: " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying date: " + responseString + " is not equal date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateNotEqual(responseString, expectedString);
                    if (val) break;
                    return responseString + " is not equal date: " + expectedString;
                }
                TestLog.logPass("verifying date: " + Arrays.toString(actualArray.toArray()) + " is not equal date: " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = Helper.date.isDateNotEqual(actualArray, expectedString);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " is not equal date: " + Arrays.toString(expectedArray.toArray());
            }
            case isDateAfter: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying date: " + actualString + " is after date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateAfter(actualString, expectedString);
                    if (val) break;
                    return actualString + " is after date: " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying date: " + responseString + " is after date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateAfter(responseString, expectedString);
                    if (val) break;
                    return responseString + " is not after date: " + expectedString;
                }
                TestLog.logPass("verifying date: " + Arrays.toString(actualArray.toArray()) + " is after date: " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = Helper.date.isDateAfter(actualArray, expectedString);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " is after date: " + Arrays.toString(expectedArray.toArray());
            }
            case isDateBefore: {
                if (!position.isEmpty() && positionInt > 0) {
                    TestLog.logPass("verifying date: " + actualString + " is before date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateBefore(actualString, expectedString);
                    if (val) break;
                    return actualString + " is before date: " + expectedString;
                }
                if (!position.isEmpty() && positionInt == 0) {
                    TestLog.logPass("verifying date: " + responseString + " is before date: " + expectedString, new Object[0]);
                    boolean val = Helper.date.isDateBefore(responseString, expectedString);
                    if (val) break;
                    return responseString + " is not before date: " + expectedString;
                }
                TestLog.logPass("verifying date: " + Arrays.toString(actualArray.toArray()) + " is before date: " + Arrays.toString(expectedArray.toArray()), new Object[0]);
                boolean val = Helper.date.isDateBefore(actualArray, expectedString);
                if (val) break;
                return Arrays.toString(actualArray.toArray()) + " is before date: " + Arrays.toString(expectedArray.toArray());
            }
            default: {
                Helper.assertFalse("Command not set. Options: " + Arrays.asList(JSON_COMMAND.values()) + ". See examples for usage.");
            }
        }
        return "";
    }

    public static List<String> getResponseArray(String array) {
        String[] responses;
        ArrayList<String> list = new ArrayList<String>();
        if (array == null) {
            return list;
        }
        for (String response : responses = array.split(",")) {
            response = response.trim().replace("\"", "");
            response = response.replace("[", "").replace("]", "");
            list.add(response);
        }
        return list;
    }

    public static int getResponseArrayLength(List<String> actualArray, String responseString) {
        int responseLength = -1;
        actualArray = DataHelper.removeEmptyElements(actualArray);
        JSONArray jsonArray = JsonHelper.getJsonArray(responseString);
        responseLength = jsonArray != null ? jsonArray.length() : actualArray.size();
        return responseLength;
    }

    public static boolean isGreaterThan(String value1, String value2) {
        return Helper.isNumeric(value1) && Helper.isNumeric(value2) && Integer.valueOf(value1) > Integer.valueOf(value2);
    }

    public static boolean isLessThan(String value1, String value2) {
        return Helper.isNumeric(value1) && Helper.isNumeric(value2) && Integer.valueOf(value1) < Integer.valueOf(value2);
    }

    public static boolean compareNumbers(String value1, String value2, String comparator) {
        if (!Helper.isStringContainNumber(value1) || !Helper.isStringContainNumber(value2)) {
            return false;
        }
        double val1Double = Helper.getDoubleFromString(value1);
        double val2Double = Helper.getDoubleFromString(value2);
        return DataHelper.compareNumbers(val1Double, val2Double, comparator);
    }

    public static boolean compareNumbers(double value1, double value2, String comparator) {
        switch (comparator) {
            case "greaterThan": {
                if (!(value1 > value2)) break;
                return true;
            }
            case "lessThan": {
                if (!(value1 < value2)) break;
                return true;
            }
            case "equalTo": {
                if (value1 != value2) break;
                return true;
            }
        }
        return false;
    }

    public static String listToString(List<String> values) {
        return StringUtils.join(values, (String)",");
    }

    public static String objectToString(Object values) {
        String stringVal = values.toString();
        stringVal = stringVal.replaceAll("[\\[\\](){}]", "");
        stringVal = stringVal.replace("\"", "");
        stringVal = stringVal.replace("\\/", "/");
        return stringVal;
    }

    public static List<String> splitToKeyPositionValue(String keyvalue, String regex, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        if (!keyvalue.contains(":")) {
            result.add(keyvalue);
            return result;
        }
        String commandValue = DataHelper.getCommandFromExpectedString(keyvalue);
        if (!commandValue.isEmpty()) {
            return DataHelper.getJsonKeyValue(keyvalue, commandValue);
        }
        String position = "";
        boolean hasPosition = Pattern.compile(":\\d{1}:").matcher(keyvalue).find();
        if (hasPosition) {
            String[] resultArray = keyvalue.split(":\\d{1}:");
            Pattern pattern = Pattern.compile(":\\d{1}:");
            Matcher matcher = pattern.matcher(keyvalue);
            if (matcher.find()) {
                position = matcher.group(0);
            }
            result.add(resultArray[0]);
            result.add(Helper.date.removeFirstAndLastChars(position, ":"));
            if (resultArray.length == 2) {
                result.add(resultArray[1]);
            } else {
                result.add("");
            }
        } else {
            String[] resultArray = keyvalue.split(":", 2);
            result.add(resultArray[0]);
            if (resultArray.length == 2) {
                result.add(resultArray[1]);
            } else {
                result.add("");
            }
        }
        return result;
    }

    public static List<String> splitRight(String value, String regex, int limit) {
        String string = value;
        ArrayList<String> result = new ArrayList<String>();
        String[] temp = new String[]{};
        for (int i = 1; i < limit; ++i) {
            if (!string.matches(".*" + regex + ".*")) continue;
            temp = string.split(DataHelper.modifyRegex(regex));
            Helper.assertTrue("value not set for: " + string, temp.length > 1);
            result.add(temp[1]);
            string = temp[0];
        }
        if (temp.length > 0) {
            result.add(temp[0]);
        }
        if (value.split(":").length == 1) {
            result.add(string);
        }
        Collections.reverse(result);
        return result;
    }

    private static String getCommandFromExpectedString(String value) {
        String commandValue = "";
        for (JSON_COMMAND command : JSON_COMMAND.values()) {
            List<String> parameters = Helper.getValuesFromPattern(value, (Object)((Object)command) + "\\(([^)]+)\\)");
            if (!parameters.isEmpty()) {
                commandValue = (Object)((Object)command) + "(" + parameters.get(0) + ")";
                if (!value.endsWith(commandValue)) continue;
                return commandValue;
            }
            if (!value.endsWith(command.name())) continue;
            return command.name();
        }
        return "";
    }

    private static List<String> getJsonKeyValue(String value, String commandValue) {
        ArrayList<String> result = new ArrayList<String>();
        String keyPosition = (value = value.replace(commandValue, "")).trim().replaceAll(":$", "");
        List<String> keyPositionList = DataHelper.splitRight(keyPosition, ":", 2);
        if (keyPositionList.size() == 2 && Helper.isStringContainOnlyNumber(keyPositionList.get(1))) {
            result.add(keyPositionList.get(0));
            result.add(keyPositionList.get(1));
        } else {
            result.add(keyPosition);
        }
        result.add(commandValue);
        return result;
    }

    private static String modifyRegex(String regex) {
        return regex + "(?!.*" + regex + ".*$)";
    }

    public static boolean isEmpty(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        return value.equals("null");
    }

    public static String getRequestBodyIncludingTemplate(ServiceObject serviceObject) {
        String requestbody = "";
        DataHelper.loadDataFile(serviceObject);
        Object[] criterion = serviceObject.getRequestBody().split(VALIDATION_AND_CONDITION);
        if (criterion.length == 1 && criterion[0].startsWith(REQUEST_BODY_UPDATE_INDICATOR)) {
            criterion = (String[])ArrayUtils.add((Object[])criterion, (int)0, (Object)"");
        }
        for (Object criteria : criterion) {
            if (!((String)(criteria = Helper.stringRemoveLines((String)criteria))).startsWith(REQUEST_BODY_UPDATE_INDICATOR)) {
                serviceObject.withRequestBody((String)criteria);
                if (JsonHelper.isJsonFile(serviceObject.getTemplateFile())) {
                    requestbody = JsonHelper.getRequestBodyFromJsonTemplate(serviceObject);
                } else if (XmlHelper.isXmlFile(serviceObject.getTemplateFile())) {
                    requestbody = XmlHelper.getRequestBodyFromXmlTemplate(serviceObject);
                } else if (!serviceObject.getTemplateFile().isEmpty()) {
                    Path templatePath = DataHelper.getTemplateFilePath(serviceObject.getTemplateFile());
                    requestbody = DataHelper.convertFileToString(templatePath);
                } else if (requestbody.isEmpty()) {
                    requestbody = serviceObject.getRequestBody();
                }
                requestbody = DataHelper.replaceParameters(requestbody);
                continue;
            }
            criteria = JsonHelper.removeResponseIndicator((String)criteria);
            if (JsonHelper.isJSONValid(requestbody, false)) {
                requestbody = JsonHelper.updateJsonFromRequestBody((String)criteria, requestbody);
            } else if (XmlHelper.isValidXmlString(requestbody)) {
                requestbody = XmlHelper.replaceRequestTagValues((String)criteria, requestbody);
            }
            requestbody = DataHelper.replaceParameters(requestbody);
        }
        return requestbody;
    }

    public static void loadDataFile(ServiceObject serviceObject) {
        if (serviceObject.getRequestBody().isEmpty()) {
            return;
        }
        String DataFile = "DataFile";
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestBody());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "DataFile": {
                    String updateRequest = serviceObject.getRequestBody().replace(keyword.value.toString(), "").replace(keyword.value.toString() + ";", "").replace("DataFile:", "");
                    String[] dataInfo = keyword.value.toString().split(":");
                    if (dataInfo.length != 2) {
                        Helper.assertFalse("format must be file:dataId. actual value: " + keyword.value.toString());
                    }
                    String dataFilename = dataInfo[0];
                    String expectedDataId = dataInfo[1];
                    String templateDataFilePath = Helper.getFullPath(Config.getValue(TEST_DATA_TEMPLATE_DATA_PATH));
                    File dataFile = new File(templateDataFilePath + dataFilename + ".csv");
                    try {
                        String[] line;
                        CSVReader reader = CsvReader.readCsvFile(dataFile);
                        String[] header = reader.readNext();
                        int dataId = CsvReader.getColumnIndexByName("dataId", header);
                        if (header.length > 1 && !updateRequest.isEmpty()) {
                            updateRequest = updateRequest + ";";
                        }
                        while ((line = reader.readNext()) != null) {
                            if (!expectedDataId.equals(line[dataId])) continue;
                            for (int i = 1; i < header.length; ++i) {
                                updateRequest = updateRequest + header[i] + ":" + line[i] + ";";
                            }
                        }
                        reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    serviceObject.withRequestBody(updateRequest);
                    break;
                }
            }
        }
    }

    public static void saveDataToConfig(String source) {
        if (source.isEmpty()) {
            return;
        }
        source = DataHelper.replaceParameters(source);
        List<KeyValue> keywords = DataHelper.getValidationMap(source);
        for (KeyValue keyword : keywords) {
            if (!(keyword.value.toString().startsWith("<") && keyword.value.toString().contains("$") && keyword.value.toString().endsWith(">"))) {
                return;
            }
            String value = (String)keyword.value;
            value = value.replace("$", "").replace("<", "").replace(">", "").trim();
            String key = keyword.key;
            Config.putValue(value, key);
        }
    }

    public static String convertFileToString(Path templatePath) {
        String content = Helper.readFileContent(templatePath.toString());
        return DataHelper.replaceParameters(content);
    }

    public static String removeSectionFromExpectedResponse(String section, String expectedResponse) {
        String[] criteria = expectedResponse.split(VALIDATION_AND_CONDITION);
        ArrayList<String> newResponse = new ArrayList<String>();
        for (String criterion : criteria) {
            if ((criterion = Helper.removeSurroundingQuotes(criterion)).trim().startsWith(section)) continue;
            newResponse.add(criterion);
        }
        return String.join((CharSequence)VALIDATION_AND_CONDITION, newResponse);
    }

    public static String getSectionFromExpectedResponse(String section, String expectedResponse) {
        String[] criteria = expectedResponse.split(VALIDATION_AND_CONDITION);
        ArrayList<String> newResponse = new ArrayList<String>();
        for (String criterion : criteria) {
            if (!(criterion = Helper.removeSurroundingQuotes(criterion)).trim().startsWith(section)) continue;
            newResponse.add(criterion);
        }
        return String.join((CharSequence)VALIDATION_AND_CONDITION, newResponse);
    }

    public static List<String> validateExpectedValues(List<String> responseValues, String expectedResponse) {
        List<String> errorMessages = new ArrayList<String>();
        if (expectedResponse.trim().isEmpty()) {
            return errorMessages;
        }
        errorMessages = DataHelper.validateEmptyResponse(responseValues, expectedResponse);
        if (!errorMessages.isEmpty()) {
            return errorMessages;
        }
        expectedResponse = DataHelper.replaceParameters(expectedResponse);
        String[] criteria = DataHelper.getCriteria(expectedResponse);
        DataHelper.logJsonResponse(responseValues);
        String booleanLogicPattern = "";
        for (String criterion : criteria) {
            criterion = criterion.trim();
            booleanLogicPattern = booleanLogicPattern + DataHelper.getValidationPattern(criterion);
            criterion = DataHelper.removeLogicIdentifiers(criterion);
            Helper.assertTrue("expected response is not valid xml or json, or section identifier, are you missing the section identifier? eg. _VERIFY_JSON_PART_:  " + criterion, DataHelper.isValidExpectation(criterion));
            criterion = DataHelper.convertXmlResponseToJson(criterion);
            List<String> errors = DataHelper.validateExpectedResponse(criterion, responseValues);
            errors = DataHelper.removeEmptyElements(errors);
            booleanLogicPattern = errors.isEmpty() ? booleanLogicPattern.replace("value", "true") : booleanLogicPattern.replace("value", "false");
            errorMessages.addAll(errors);
        }
        boolean isPass = DataHelper.evaluateLogic(booleanLogicPattern);
        if (isPass) {
            errorMessages = new ArrayList();
        }
        errorMessages = DataHelper.removeEmptyElements(errorMessages);
        return errorMessages;
    }

    private static String[] getCriteria(String expectedResponse) {
        String[] criteria = expectedResponse.split("(?=&&)|(?=\\|\\|)");
        ArrayList<String> updatedCriteria = new ArrayList<String>();
        String criteriaVal = "";
        for (int i = 0; i < criteria.length; ++i) {
            criteriaVal = criteria[i];
            if ((criteriaVal = DataHelper.removeLogicIdentifiers(criteriaVal)).trim().startsWith("!@") || criteriaVal.trim().startsWith("@")) {
                int lastItem = updatedCriteria.size() - 1;
                updatedCriteria.set(lastItem, (String)updatedCriteria.get(lastItem) + criteria[i]);
                continue;
            }
            updatedCriteria.add(criteria[i]);
        }
        return updatedCriteria.toArray(new String[updatedCriteria.size()]);
    }

    public static String removeAndOrIndicator(String value) {
        if (value.trim().startsWith(VALIDATION_OR_CONDITION)) {
            value = value.replaceFirst(VALIDATION_OR_CONDITION_ECODE, "");
        } else if (value.trim().startsWith(VALIDATION_AND_CONDITION)) {
            value = value.replaceFirst(VALIDATION_AND_CONDITION, "");
        }
        return value;
    }

    public static boolean evaluateLogic(String logicString) {
        logicString = DataHelper.removeAndOrIndicator(logicString);
        boolean result = false;
        try {
            Context polyglot = Context.newBuilder((String[])new String[]{"js"}).option("engine.WarnInterpreterOnly", "false").build();
            Value array = polyglot.eval("js", (CharSequence)logicString.trim());
            result = array.asBoolean();
        }
        catch (Exception e) {
            e.printStackTrace();
            Helper.assertFalse(e.getMessage());
        }
        return result;
    }

    public static String removeLogicIdentifiers(String criterion) {
        criterion = DataHelper.removeAndOrIndicator(criterion);
        while (criterion.trim().startsWith("(")) {
            criterion = criterion.replaceFirst("\\(", "");
        }
        while (criterion.trim().endsWith("))")) {
            criterion = criterion.substring(0, criterion.length() - 1);
        }
        while (criterion.trim().endsWith(";)")) {
            criterion = criterion.substring(0, criterion.length() - 1);
        }
        return criterion;
    }

    public static String getValidationPattern(String criterion) {
        String pattern = "";
        boolean isORCondition = criterion.startsWith(VALIDATION_OR_CONDITION);
        pattern = isORCondition ? pattern + " ||" : pattern + " &&";
        criterion = DataHelper.removeAndOrIndicator(criterion);
        while (criterion.trim().startsWith("(")) {
            pattern = pattern + " (";
            criterion = criterion.replaceFirst("\\(", "");
        }
        pattern = pattern + " value";
        while (criterion.trim().endsWith("))")) {
            pattern = pattern + " )";
            criterion = criterion.substring(0, criterion.length() - 1);
        }
        while (criterion.trim().endsWith(";)")) {
            pattern = pattern + " )";
            criterion = criterion.substring(0, criterion.length() - 1);
        }
        return pattern;
    }

    private static String convertXmlResponseToJson(String xmlString) {
        if (!XmlHelper.isValidXmlString(xmlString)) {
            return xmlString;
        }
        TestLog.ConsoleLog("expected xml: " + ServiceObject.normalizeLog(xmlString), new Object[0]);
        boolean isIgnoreNamespace = Config.getBooleanValue(IS_IGNORE_XML_NAMESPACE);
        if (isIgnoreNamespace) {
            xmlString = XmlHelper.removeXmlNameSpace(xmlString);
        }
        xmlString = JsonHelper.XMLToJson(xmlString);
        TestLog.ConsoleLog("expected value converted to json for validation: " + ServiceObject.normalizeLog(xmlString), new Object[0]);
        return xmlString;
    }

    public static void logJsonResponse(List<String> responseValues) {
        ArrayList<String> updatedList = new ArrayList<String>();
        for (String response : responseValues) {
            updatedList.add(response.replace(System.lineSeparator(), ""));
        }
        String responseString = String.join((CharSequence)System.lineSeparator(), updatedList);
        TestLog.logPass("response to be validated: " + ServiceObject.normalizeLog(responseString), new Object[0]);
    }

    public static List<String> validateEmptyResponse(List<String> responseValues, String expected) {
        ArrayList<String> errorMessage = new ArrayList<String>();
        boolean isEmptyExpected = DataHelper.isEmptyResponseExpected(expected);
        for (String resonse : responseValues) {
            if (!resonse.isEmpty() || isEmptyExpected) continue;
            errorMessage.add("response value is empty");
            return errorMessage;
        }
        return errorMessage;
    }

    public static boolean isEmptyResponseExpected(String expected) {
        return (expected = JsonHelper.removeResponseIndicator(expected)).equals(JSON_COMMAND.isEmpty.name());
    }

    public static List<String> validateExpectedResponse(String criterion, List<String> responseString) {
        List<String> errorMessages = new ArrayList<String>();
        for (int i = 0; i < responseString.size(); ++i) {
            errorMessages = new ArrayList();
            if (XmlHelper.isValidXmlString(responseString.get(i))) {
                boolean isIgnoreNamespace = Config.getBooleanValue(IS_IGNORE_XML_NAMESPACE);
                if (isIgnoreNamespace) {
                    String xmlIgnoreNameSpace = XmlHelper.removeXmlNameSpace(responseString.get(i));
                    responseString.set(i, JsonHelper.XMLToJson(xmlIgnoreNameSpace));
                } else {
                    responseString.set(i, JsonHelper.XMLToJson(responseString.get(i)));
                }
            }
            errorMessages.add(JsonHelper.validateByJsonBody(criterion, responseString.get(i)));
            errorMessages.addAll(JsonHelper.validateByKeywords(criterion, responseString.get(i)));
            errorMessages.add(JsonHelper.validateResponseBody(criterion, responseString.get(i)));
            errorMessages = DataHelper.removeEmptyElements(errorMessages);
            if (errorMessages.isEmpty()) break;
            if (i <= 0 || i != responseString.size() || errorMessages.isEmpty()) continue;
            errorMessages = new ArrayList();
            errorMessages.add("expected requirement: " + criterion + " not met by the responses: " + String.join((CharSequence)System.lineSeparator(), responseString));
        }
        return errorMessages;
    }

    public static boolean isValidExpectation(String expectedValue) {
        if (JsonHelper.isJSONValid(expectedValue, false)) {
            return true;
        }
        if (XmlHelper.isValidXmlString(expectedValue)) {
            return true;
        }
        return (expectedValue = Helper.stringNormalize(expectedValue)).startsWith(VERIFY_JSON_PART_INDICATOR) || expectedValue.startsWith(VERIFY_JSON_PART_INDICATOR_UNDERSCORE) || expectedValue.startsWith(VERIFY_RESPONSE_NO_EMPTY) || expectedValue.startsWith(VERIFY_RESPONSE_BODY_INDICATOR) || expectedValue.startsWith(VERIFY_HEADER_PART_INDICATOR) || expectedValue.startsWith(EXPECTED_MESSAGE_COUNT) || expectedValue.startsWith(VERIFY_TOPIC_PART_INDICATOR);
    }

    public static List<String> removeEmptyElements(List<String> list) {
        Iterator<String> i = list.iterator();
        while (i.hasNext()) {
            String s = i.next();
            if (s != null && !s.trim().isEmpty()) continue;
            i.remove();
        }
        return list;
    }

    public static String[] removeEmptyElements(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        for (String text : array) {
            if (text == null || text.trim().isEmpty()) continue;
            list.add(text.trim());
        }
        array = list.toArray(new String[0]);
        return array;
    }

    public static Set<String> isListContain(String actual, List<String> expectedValues) {
        actual = actual.trim().replace("\"", "");
        HashSet<String> missing = new HashSet<String>();
        for (String expected : expectedValues) {
            if (actual.contains(expected)) continue;
            missing.add(expected);
        }
        return missing;
    }

    public static enum JSON_COMMAND {
        hasItems,
        notHaveItems,
        notEqualTo,
        equalTo,
        notContain,
        contains,
        containsInAnyOrder,
        integerGreaterThan,
        integerLessThan,
        integerEqual,
        integerNotEqual,
        nodeSizeGreaterThan,
        nodeSizeExact,
        sequence,
        jsonbody,
        isNotEmpty,
        isEmpty,
        nodeSizeLessThan,
        isBetweenDate,
        allValuesEqualTo,
        countGreaterThan,
        countLessThan,
        countExact,
        command,
        notContains,
        contain,
        isDateAfter,
        isDateBefore,
        isDateEqual,
        isDateNotEqual;

    }
}

