/*
 * Decompiled with CFR 0.152.
 */
package core.helpers.legacy;

import core.helpers.Element;
import core.helpers.legacy.Helper;
import core.support.listeners.TestListener;
import core.support.objects.TestObject;
import core.uiCore.drivers.AbstractDriver;
import core.uiCore.webElement.EnhancedBy;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class DriverLegacy {
    public static EnhancedBy getEnhancedElement(WebElement target) {
        String[] locator = DriverLegacy.getLocator(target);
        String selector = locator[0].trim();
        String value = locator[1].trim();
        EnhancedBy element = DriverLegacy.setEnhancedElement(selector, value);
        return element;
    }

    protected static String[] getLocator(WebElement element) {
        String[] path = new String[2];
        try {
            Object proxyOrigin = FieldUtils.readField((Object)element, (String)"h", (boolean)true);
            Object locator = FieldUtils.readField((Object)proxyOrigin, (String)"locator", (boolean)true);
            Object findBy = FieldUtils.readField((Object)locator, (String)"by", (boolean)true);
            if (findBy != null) {
                path = findBy.toString().split(":", 2);
                if (path.length != 2) {
                    Helper.assertFalse("element could not be parsed: " + findBy);
                }
                path[0] = path[0].split("By.")[1];
                return path;
            }
        }
        catch (Exception ignored) {
            return DriverLegacy.getLocatorThroughParsing(element);
        }
        Helper.assertFalse("element could not be parsed: " + element.toString());
        return null;
    }

    protected static String[] getLocatorThroughParsing(WebElement element) {
        String[] locator = new String[2];
        String path = element.toString();
        String[] pathVariables = path.split("->")[1].replaceFirst("(?s)(.*)\\]", "$1").split(":");
        if (pathVariables.length != 2) {
            throw new IllegalStateException("webElement : " + path + " not containg valid by:locator format!");
        }
        String selector = pathVariables[0].trim();
        String value = pathVariables[1].trim();
        locator[0] = selector;
        locator[1] = value;
        return locator;
    }

    public static void setDriver(WebDriver driver) {
        TestListener.isTestNG = true;
        TestObject.IS_PROPERTIES_DISABLED = true;
        AbstractDriver.TIMEOUT_SECONDS = 60;
        AbstractDriver.TIMEOUT_IMPLICIT_SECONDS = 5;
        AbstractDriver.setWebDriver(driver);
    }

    public static void setDriver(WebDriver driver, boolean isPropertyDisabled, int timeoutSec, int implicitSec) {
        TestListener.isTestNG = true;
        TestObject.IS_PROPERTIES_DISABLED = isPropertyDisabled;
        AbstractDriver.TIMEOUT_SECONDS = timeoutSec;
        AbstractDriver.TIMEOUT_IMPLICIT_SECONDS = implicitSec;
        AbstractDriver.setWebDriver(driver);
    }

    protected static EnhancedBy setEnhancedElement(String selector, String value) {
        EnhancedBy element = null;
        switch (selector) {
            case "cssSelector": 
            case "css selector": 
            case "css": {
                element = Element.byCss(value, value);
                break;
            }
            case "xpath": {
                element = Element.byXpath(value, value);
                break;
            }
            case "name": {
                element = Element.byName(value, value);
                break;
            }
            case "id": {
                element = Element.byId(value, value);
                break;
            }
            case "class": 
            case "className": {
                element = Element.byClass(value, value);
                break;
            }
            case "tagName": {
                element = Element.byTagName(value, value);
                break;
            }
            case "linkText": {
                element = Element.byLinkText(value, value);
                break;
            }
            case "partialLinkText": {
                element = Element.byPartialLinkText(value, value);
            }
        }
        return element;
    }
}

