/*
 * Decompiled with CFR 0.152.
 */
package core.support.listeners;

import core.apiCore.TestDataProvider;
import core.apiCore.helpers.CsvReader;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.listeners.RetryTest;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.testng.IAnnotationTransformer;
import org.testng.IRetryAnalyzer;
import org.testng.annotations.ITestAnnotation;

public class AnnotationTransformer
implements IAnnotationTransformer {
    public static final String THREAD_COUNT = "global.parallel_test_count";
    public static final String API_TEST_RUNNER_PREFIX = "serviceRunner";

    public void transform(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        IRetryAnalyzer retry;
        if (TestObject.getTestInfo().isTestComplete.booleanValue()) {
            TestObject.setupDefaultDriver();
        }
        if ((retry = annotation.getRetryAnalyzer()) == null) {
            annotation.setRetryAnalyzer(RetryTest.class);
        }
        this.setupApiRunner(annotation, testClass, testConstructor, testMethod);
        if (annotation.getInvocationCount() == 0) {
            Helper.assertFalse("invocation count is 0. if this is a ApiRunner test, please add csv file to api test case folder");
        }
    }

    private void setupApiRunner(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        if (!testMethod.getName().endsWith(API_TEST_RUNNER_PREFIX)) {
            return;
        }
        this.setApiThreadCount(annotation, testClass, testConstructor, testMethod);
        ArrayList<File> csvFiles = CsvReader.filterTests();
        int csvTestCount = csvFiles.size();
        annotation.setInvocationCount(csvTestCount);
    }

    private void setApiThreadCount(ITestAnnotation annotation, Class testClass, Constructor testConstructor, Method testMethod) {
        String testName = testMethod.getName();
        if (testName.endsWith(API_TEST_RUNNER_PREFIX)) {
            annotation.setThreadPoolSize(CrossPlatformProperties.getParallelTests());
            TestDataProvider.TEST_DATA_PATH = Config.getValue("api.parallelTestcasePath");
        }
    }
}

