/*
 * Decompiled with CFR 0.152.
 */
package core.support.runner;

import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DriverObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.xml.DOMConfigurator;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;

public class ParallelRunner
extends BlockJUnit4ClassRunner {
    private static final int NUM_THREADS = CrossPlatformProperties.getParallelTests();
    private static final AtomicInteger numTestsWaitingToStart = new AtomicInteger(0);
    static ExecutorService executorService = Executors.newFixedThreadPool(NUM_THREADS);
    private static CompletionService<Void> completionService = new ExecutorCompletionService<Void>(executorService);
    private static Queue<Future<Void>> tasks = new LinkedList<Future<Void>>();

    public ParallelRunner(Class<?> klass) throws InitializationError {
        super(klass);
        DOMConfigurator.configure((String)TestLog.LOG4JPATH);
        numTestsWaitingToStart.incrementAndGet();
        this.setScheduler(new RunnerScheduler(){

            public void schedule(Runnable childStatement) {
                tasks.offer(completionService.submit(childStatement, null));
            }

            public void finished() {
                if (numTestsWaitingToStart.decrementAndGet() == 0) {
                    try {
                        while (!tasks.isEmpty()) {
                            tasks.remove(completionService.take());
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        while (!tasks.isEmpty()) {
                            ((Future)tasks.poll()).cancel(true);
                        }
                        ParallelRunner.this.sendReport();
                        if (ParallelRunner.runningFromIde()) {
                            DriverObject.quitAllDrivers();
                            ExtentManager.printReportLink();
                            ExtentManager.launchReportAfterTest();
                            executorService.shutdown();
                        }
                    }
                }
            }
        });
    }

    public void sendReport() {
        String message = "Tests are complete";
        ExtentManager.slackNotification(message);
        ExtentManager.emailTestReport(message);
    }

    public static boolean runningFromIde() {
        String classPath = System.getProperty("java.class.path");
        boolean isEclipse = classPath.contains("eclipse");
        boolean isIntelliJ = classPath.contains("idea_rt.jar");
        return isEclipse || isIntelliJ;
    }
}

