/*
 * Decompiled with CFR 0.152.
 */
package core.support.listeners;

import com.google.common.base.Joiner;
import core.apiCore.ServiceManager;
import core.apiCore.driver.ApiTestDriver;
import core.helpers.Helper;
import core.helpers.ScreenRecorderHelper;
import core.support.configReader.Config;
import core.support.listeners.RetryTest;
import core.support.logger.ExtentManager;
import core.support.logger.TestLog;
import core.support.objects.DeviceManager;
import core.support.objects.DriverObject;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.driverType;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IRetryAnalyzer;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.xml.XmlSuite;

public class TestListener
implements ITestListener,
IClassListener,
ISuiteListener,
IConfigurationListener {
    public static boolean isTestNG = false;
    public static final String PARALLEL_TEST_TYPE = "global.parallel.type";

    public void onStart(ITestContext iTestContext) {
        isTestNG = true;
        iTestContext.setAttribute("WebDriver", (Object)AbstractDriverTestNG.getWebDriver());
        String testId = this.getSuiteName(iTestContext.getSuite().getName().toString()) + TestObject.BEFORE_SUITE_PREFIX;
        TestLog.printBatchToConsole(testId);
        this.cleanupProcessess();
        iTestContext.setAttribute("platform", (Object)"");
        for (ITestNGMethod method : iTestContext.getAllTestMethods()) {
            method.setRetryAnalyzer((IRetryAnalyzer)new RetryTest());
        }
        this.setParallelRun(iTestContext);
        ExtentManager.clearTestReport();
        ExtentManager.clearOldTestReports();
        ScreenRecorderHelper.deleteScreenRecorderTempDir();
    }

    private void setParallelRun(ITestContext iTestContext) {
        String parallelType = CrossPlatformProperties.getParallelTestType();
        if (parallelType.equals("CLASSES")) {
            iTestContext.getCurrentXmlTest().setParallel(XmlSuite.ParallelMode.CLASSES);
        } else {
            iTestContext.getCurrentXmlTest().setParallel(XmlSuite.ParallelMode.METHODS);
        }
        int threadCount = CrossPlatformProperties.getParallelTests();
        iTestContext.getCurrentXmlTest().setThreadCount(threadCount);
        iTestContext.getCurrentXmlTest().getSuite().setDataProviderThreadCount(threadCount);
        iTestContext.getCurrentXmlTest().getSuite().setPreserveOrder(Boolean.valueOf(true));
    }

    public void onFinish(ITestContext iTestContext) {
        ExtentManager.writeTestReport();
        DriverObject.quitAllDrivers();
        ExtentManager.launchReportAfterTest();
        ExtentManager.printReportLink();
        this.sendReport(iTestContext);
        String suitename = this.getSuiteName(iTestContext.getSuite().getName());
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(suitename + TestObject.AFTER_SUITE_PREFIX, driver);
        if (iTestContext.getFailedTests().size() == 0) {
            TestLog.printLogoOnSuccess();
        }
    }

    private void sendReport(ITestContext iTestContext) {
        String message = this.generateTestMessage(iTestContext);
        boolean hasErrors = iTestContext.getFailedTests().size() > 0;
        boolean slackNotifyOnFailOnly = Config.getBooleanValue("slack.notifyOnFailureOnly");
        boolean emailNotifyOnFailOnly = Config.getBooleanValue("email.notifyOnFailureOnly");
        if (slackNotifyOnFailOnly && hasErrors) {
            ExtentManager.slackNotification(message);
        } else if (!slackNotifyOnFailOnly) {
            ExtentManager.slackNotification(message);
        }
        if (emailNotifyOnFailOnly && hasErrors) {
            ExtentManager.emailTestReport(message);
        } else if (!emailNotifyOnFailOnly) {
            ExtentManager.emailTestReport(message);
        }
    }

    public void onTestStart(ITestResult iTestResult) {
        this.setTestClassName(iTestResult);
        ScreenRecorderHelper.startRecording();
    }

    public void onTestSuccess(ITestResult iTestResult) {
        this.setTestClassName(iTestResult);
        TestObject.getTestInfo().withIsTestPass(true);
        this.setTestComplete();
        ScreenRecorderHelper.stopRecording();
        if (CrossPlatformProperties.isSingleSignIn().booleanValue() && AbstractDriverTestNG.getWebDriver() != null) {
            DriverObject.setDriverAvailabiltity(AbstractDriverTestNG.getWebDriver(), true);
        }
        DeviceManager.setDeviceAvailability(true);
        ApiTestDriver.parentTrackChildTests();
        ApiTestDriver.trackServiceTestLogs();
        TestLog.Then("Test is finished successfully", new Object[0]);
        TestLog.printBatchLogsToConsole();
    }

    public void onTestFailure(ITestResult iTestResult) {
        this.setTestClassName(iTestResult);
        TestObject.getTestInfo().withIsForcedRestart(true);
        TestObject.getTestInfo().isFirstRun = true;
        TestObject.getTestInfo().withIsTestPass(false);
        this.setTestComplete();
        DeviceManager.setDeviceAvailability(true);
        ScreenRecorderHelper.stopRecording();
        ApiTestDriver.parentTrackChildTests();
        ApiTestDriver.trackServiceTestLogs();
        TestLog.Then("Test failed", new Object[0]);
        TestLog.printBatchLogsToConsole();
    }

    public void onTestSkipped(ITestResult iTestResult) {
        TestObject.getTestInfo().withIsForcedRestart(true);
        TestObject.getTestInfo().isFirstRun = true;
        TestObject.getTestInfo().withIsTestPass(false);
        iTestResult.setStatus(3);
        DeviceManager.setDeviceAvailability(true);
        ScreenRecorderHelper.stopRecording();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        TestLog.ConsoleLog("Test failed But it is in defined success ratio " + TestObject.getTestInfo().testName, new Object[0]);
    }

    public void cleanupProcessess() {
        if (Helper.isWindows()) {
            if (Helper.mobile.isMobile()) {
                Helper.killWindowsProcess("node.exe");
            }
            Helper.killWindowsProcess("IEDriverServer.exe");
            Helper.killWindowsProcess("chromedriver.exe");
            Helper.killWindowsProcess("MicrosoftWebDriver.exe");
        } else if (Helper.isMac()) {
            Helper.killMacProcess("chromedriver");
        }
    }

    public String generateTestMessage(ITestContext iTestContext) {
        int testCount = iTestContext.getPassedTests().size() + iTestContext.getFailedTests().size();
        String message = iTestContext.getPassedTests().size() + " of " + testCount + " tests passed.";
        if (iTestContext.getFailedTests().size() > 0) {
            ArrayList<String> failedMessage = this.getAllResults(iTestContext.getFailedTests().getAllResults());
            message = message + " Failed test(s): " + Joiner.on((String)",").join(failedMessage);
        }
        return message;
    }

    private ArrayList<String> getAllResults(Collection<ITestResult> results) {
        ArrayList<String> tests = new ArrayList<String>();
        for (ITestResult result : results) {
            String className = result.getInstanceName().substring(result.getInstanceName().lastIndexOf(".") + 1);
            tests.add(className + "." + result.getMethod().getMethodName());
        }
        return tests;
    }

    public void onBeforeClass(ITestClass testClass) {
        String classname = this.getClassName(testClass.getName());
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(classname + TestObject.BEFORE_CLASS_PREFIX, driver);
    }

    public void onAfterClass(ITestClass testClass) {
        String classname = this.getClassName(testClass.getName());
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(classname + TestObject.AFTER_CLASS_PREFIX, driver);
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    public void onConfigurationFailure(ITestResult itr) {
    }

    public void onConfigurationSkip(ITestResult itr) {
    }

    public void setTestClassName(ITestResult iTestResult) {
        String classname = iTestResult.getMethod().getTestClass().getName();
        TestObject.getTestInfo().testFileClassName = classname = classname.substring(classname.lastIndexOf(".") + 1);
    }

    public void onStart(ISuite suite) {
        TestLog.setupLog4j();
        TestObject.setupDefaultDriver();
        TestLog.ConsoleLog("Autonomx initiating...", new Object[0]);
        String suitename = this.getSuiteName(suite.getName());
        TestObject.APP_IDENTIFIER = this.getTestPackage(suite);
        TestObject.SUITE_NAME = suitename;
        DriverObject driver = new DriverObject().withDriverType(driverType.DriverType.API);
        new AbstractDriverTestNG().setupWebDriver(TestObject.SUITE_NAME + TestObject.BEFORE_SUITE_PREFIX, driver);
        if (this.isServiceSuite(suite)) {
            ServiceManager.runServiceBeforeSuite();
        }
    }

    private boolean isServiceSuite(ISuite suite) {
        List methods = suite.getAllMethods();
        if (methods.size() == 0 || methods.size() > 1) {
            return false;
        }
        return ((ITestNGMethod)methods.get(0)).getMethodName().contains("serviceRunner");
    }

    private String getTestPackage(ISuite suite) {
        String testPackageName = "";
        try {
            testPackageName = ((ITestNGMethod)suite.getAllMethods().get(0)).getInstance().toString();
            testPackageName = testPackageName.substring(testPackageName.indexOf(".") + 1);
            int lastIndex = testPackageName.lastIndexOf(46);
            testPackageName = testPackageName.substring(0, lastIndex);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return testPackageName;
    }

    public void onFinish(ISuite suite) {
        String testId = this.getSuiteName(suite.getName()) + TestObject.AFTER_SUITE_PREFIX;
        TestLog.printBatchToConsole(testId);
        if (this.isServiceSuite(suite)) {
            ServiceManager.runServiceAfterSuite();
        }
        Config.printMissingConfigVariables();
    }

    private String getSuiteName(String suitename) {
        suitename = suitename.replaceAll("\\s", "");
        return suitename;
    }

    private String getClassName(String className) {
        className = className.substring(className.lastIndexOf(".") + 1);
        return className;
    }

    private void setTestComplete() {
        TestObject.getTestInfo().withIsTestComplete(ApiTestDriver.isCsvTestComplete());
        if (ApiTestDriver.isRunningUITest()) {
            TestObject.getTestInfo().withIsTestComplete(true);
        }
    }
}

