/*
 * Decompiled with CFR 0.152.
 */
package core.support.listeners;

import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import core.helpers.Helper;
import core.helpers.excelHelper.ExcelObject;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import core.uiCore.driverProperties.globalProperties.CrossPlatformProperties;
import core.uiCore.drivers.AbstractDriverTestNG;
import java.util.ArrayList;
import java.util.List;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class RetryTest
implements IRetryAnalyzer {
    public static final String[] PageErrors = new String[]{"MultipleFailureException", "WebDriverException", "GridException", "SessionNotFoundException", "UnreachableBrowserException", "LoginException"};
    public static int userIndex = 0;
    public static int login_success_withError = 0;
    public static List<ExcelObject> exceList = new ArrayList<ExcelObject>();
    public static List<String> errorList = new ArrayList<String>();
    public int retryCount = 1;
    public static boolean enableRetry = true;
    private ExtentTest test;
    private ExtentTest step;

    public void setExtendReport(ExtentTest test, ExtentTest step) {
        this.test = test;
        this.step = step;
    }

    public void setExtendReport() {
        this.test = TestObject.getTestInfo().testScenerio;
        this.step = AbstractDriverTestNG.step.get();
    }

    public ExtentTest getTest() {
        return this.test;
    }

    public ExtentTest getStep() {
        return this.step;
    }

    public boolean retry(ITestResult iTestResult) {
        int maxRetryCount = CrossPlatformProperties.getRetryCount();
        this.setExtendReport();
        TestObject.getTestInfo().withCaughtThrowable(iTestResult.getThrowable());
        maxRetryCount = this.processTestResult(maxRetryCount);
        if (TestObject.getTestInfo().runCount < maxRetryCount + 1) {
            TestObject.getTestInfo().incremenetRunCount();
            return true;
        }
        return false;
    }

    public String getTestId(ITestResult iTestResult) {
        String className = iTestResult.getInstanceName().substring(iTestResult.getInstanceName().lastIndexOf(".") + 1);
        String testId = className + "-" + iTestResult.getName();
        return testId;
    }

    public int processTestResult(int maxRetryCount) {
        this.logReport(ReportType.info, "run " + TestObject.getTestInfo().runCount + " failed ", null);
        this.logReport(ReportType.code, TestObject.getTestInfo().caughtThrowable.toString(), null);
        maxRetryCount = this.errorHandling(TestObject.getTestInfo().caughtThrowable, maxRetryCount);
        Helper.captureExtentReportScreenshot();
        this.logError("run " + TestObject.getTestInfo().runCount + " failed");
        if (TestObject.getTestInfo().runCount == maxRetryCount + 1) {
            this.logReport(ReportType.fail, "giving up after " + (maxRetryCount + 1) + " failures", null);
            this.logError("giving up after " + (maxRetryCount + 1) + " failures");
        }
        return maxRetryCount;
    }

    public void logReport(ReportType type, String value, Throwable t) {
        if (this.getStep() == null) {
            return;
        }
        switch (type) {
            case pass: {
                this.getStep().pass(value);
                break;
            }
            case info: {
                this.getStep().info(value);
                break;
            }
            case warning: {
                this.getStep().warning(value);
                break;
            }
            case debug: {
                this.getStep().debug(t);
                break;
            }
            case fail: {
                this.getStep().fail(value);
                break;
            }
            case code: {
                Markup m = MarkupHelper.createCodeBlock((String)value);
                this.getStep().info(m);
                break;
            }
        }
    }

    public void logError(String error) {
        TestLog.ConsoleLog(error, new Object[0]);
    }

    public boolean pageHasError(Throwable t) {
        for (String error : PageErrors) {
            if (!t.getClass().toString().contains(error)) continue;
            return true;
        }
        return false;
    }

    public int errorHandling(Throwable t, int maxRetryCount) {
        if (this.pageHasError(t)) {
            return ++maxRetryCount;
        }
        return maxRetryCount;
    }

    public void randomFailStack(ArrayList<String> FailTrace) {
        if (FailTrace.size() > 0) {
            TestLog.ConsoleLog("And finally test passed after " + TestObject.getTestInfo().runCount + " failures", new Object[0]);
            this.getStep().log(Status.PASS, "And finally test passed after " + TestObject.getTestInfo().runCount + " failures");
        } else {
            TestLog.ConsoleLog("And finally test passed without failures", new Object[0]);
            this.getStep().log(Status.PASS, "And finally test passed without failures");
        }
    }

    public static enum ReportType {
        pass,
        info,
        warning,
        debug,
        fail,
        code;

    }
}

