/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Element;
import core.helpers.Helper;
import core.support.logger.TestLog;
import core.uiCore.webElement.EnhancedBy;
import core.uiCore.webElement.EnhancedWebElement;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.Keys;

public class FormHelper {
    public void clearAndSetField(EnhancedBy field, CharSequence ... value) {
        this.clearField(field, 0);
        this.setField(field, 0, value);
    }

    public void clearAndSetField(EnhancedBy field, int index, CharSequence ... value) {
        if (value.length == 0) {
            return;
        }
        this.clearField(field, index);
        this.setField(field, index, value);
    }

    public void setField(EnhancedBy field, CharSequence ... value) {
        this.setField(field, 0, value);
    }

    public void setField(EnhancedBy field, int index, CharSequence ... value) {
        if (value.length == 0) {
            return;
        }
        TestLog.logPass("I set field '" + field.name + "' with value '" + Arrays.toString(value) + "'", new Object[0]);
        if (!StringUtils.isBlank((String)value.toString())) {
            EnhancedWebElement fieldElement = Element.findElements(field);
            Helper.mobile.smartHideKeyboard(field);
            Helper.wait.waitForElementToLoad(field);
            fieldElement.sendKeys(index, value);
        }
    }

    public void setFieldByAction(EnhancedBy field, CharSequence ... value) {
        this.setFieldByAction(field, 0, value);
    }

    public void setFieldByAction(EnhancedBy field, int index, CharSequence ... value) {
        if (value.length == 0) {
            return;
        }
        TestLog.logPass("I set field '" + field.name + "' with value '" + Arrays.toString(value) + "'", new Object[0]);
        if (!StringUtils.isBlank((String)value.toString())) {
            EnhancedWebElement fieldElement = Element.findElements(field);
            Helper.wait.waitForElementToLoad(field);
            fieldElement.sendKeysByAction(index, value);
            Helper.mobile.hideKeyboard();
        }
    }

    public void setFieldByJs(EnhancedBy field, CharSequence ... value) {
        this.setFieldByJs(field, 0, value);
    }

    public void setFieldByJs(EnhancedBy field, int index, CharSequence ... value) {
        if (value.length == 0) {
            return;
        }
        TestLog.logPass("I set field '" + field.name + "' with value '" + Arrays.toString(value) + "'", new Object[0]);
        if (!StringUtils.isBlank((String)value.toString())) {
            EnhancedWebElement fieldElement = Element.findElements(field);
            Helper.wait.waitForElementToLoad(field);
            fieldElement.sendKeyByJs(index, value);
            Helper.mobile.hideKeyboard();
        }
    }

    public void clearField(EnhancedBy field, int index) {
        EnhancedWebElement fieldElement = Element.findElements(field);
        Helper.waitForElementToLoad(field);
        String value = fieldElement.getText(index);
        if (value.isEmpty()) {
            return;
        }
        Helper.clickAndWait(field, 0.0);
        fieldElement.clear(index);
        value = fieldElement.getText(index);
        if (!value.isEmpty()) {
            for (int i = 0; i < value.length(); ++i) {
                fieldElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
            }
        }
        Helper.wait.waitForSeconds(0.1);
    }

    public void setField(String value, EnhancedBy field, int index) {
        this.setField(field, index, value);
    }

    public void setKeyChildField(EnhancedBy parent, int parentIndex, EnhancedBy child, int childIndex, CharSequence ... value) {
        if (value.length == 0) {
            return;
        }
        TestLog.logPass("I set field '" + child.name + "' with value '" + Arrays.toString(value) + "'", new Object[0]);
        if (value != null && value.length != 0) {
            EnhancedWebElement childElement = Element.findElements(parent, parentIndex, child);
            childElement.clear(childIndex);
            childElement.sendKeys(childIndex, value);
            Helper.mobile.hideKeyboard();
        }
    }

    public void setFieldAndEnter(EnhancedBy field, CharSequence ... value) {
        if (value.length == 0) {
            return;
        }
        this.setField(field, value);
        this.pressEnterOnWeb(field);
        Helper.mobile.pressEnterOnAndroid();
    }

    public void setKey(Keys key, EnhancedBy field) {
        EnhancedWebElement fieldElement = Element.findElements(field);
        fieldElement.sendKeys(new CharSequence[]{key});
    }

    public void pressEnterOnWeb(EnhancedBy field) {
        if (Helper.mobile.isWebDriver()) {
            EnhancedWebElement targetElement = Element.findElements(field);
            targetElement.sendKeys(new CharSequence[]{Keys.ENTER});
        }
    }

    public void formSubmit(EnhancedBy button, EnhancedBy expected) {
        Helper.click.clickAndExpect(button, expected, false);
    }

    public void formSubmitNoRetry(EnhancedBy button, EnhancedBy expected) {
        Helper.mobile.smartHideKeyboard(button);
        Helper.click.clickAndExpectNoRetry(button, 0, expected);
    }

    public void formSubmitNoRetry(EnhancedBy button, int index, EnhancedBy expected) {
        Helper.click.clickAndExpectNoRetry(button, index, expected);
    }

    public void formSubmit(EnhancedBy button, EnhancedBy expected, EnhancedBy spinner) {
        Helper.mobile.smartHideKeyboard(button);
        Helper.click.clickAndExpect(button, expected, spinner);
    }

    public void selectDropDownWithDoubleClick(String option, EnhancedBy field, EnhancedBy list) {
        this.selectDropDownWithDoubleClick(option, field, 0, list);
    }

    public void selectDropDownWithDoubleClick(String option, EnhancedBy field, int index, EnhancedBy list) {
        if (StringUtils.isBlank((String)option)) {
            return;
        }
        TestLog.logPass("I select drop down option '" + option + "'", new Object[0]);
        Helper.click.clickAndWait(field, index, 0.1);
        Helper.click.clickAndExpect(field, index, list, true);
        Helper.list.selectListItemEqualsByName(list, option);
    }

    public void selectDropDown(String option, EnhancedBy field, EnhancedBy list) {
        if (StringUtils.isBlank((String)option)) {
            return;
        }
        TestLog.logPass("I select drop down option '" + option + "'", new Object[0]);
        Helper.click.clickAndExpect(field, list);
        Helper.list.selectListItemEqualsByName(list, option);
    }

    public void selectDropDown(String option, EnhancedBy field, String field_Identifier, EnhancedBy list) {
        if (StringUtils.isBlank((String)option)) {
            return;
        }
        Helper.list.selectListItemContainsByName(field, field_Identifier);
        Helper.list.selectListItemEqualsByName(list, option);
    }

    public void selectDropDown(int index, EnhancedBy field, EnhancedBy list) {
        if (index != -1) {
            Helper.click.clickAndExpect(field, list);
            Helper.list.selectListItemByIndex(list, index);
        }
    }

    public void selectDropDown(EnhancedBy field, int index, EnhancedBy list, int optionIndex) {
        if (index != -1) {
            Helper.click.clickAndExpect(field, index, list);
            Helper.list.selectListItemByIndex(list, index);
        }
    }

    public void selectDropDown(EnhancedBy field, int index, EnhancedBy list, String text) {
        if (index != -1) {
            Helper.click.clickAndExpect(field, index, list);
            Helper.list.selectListItemEqualsByName(list, text);
        }
    }

    public void selectDropDown(EnhancedBy field, EnhancedBy list) {
        this.selectDropDown(0, field, list);
    }

    public void selectDropDown(String option, EnhancedBy field, int index, EnhancedBy list) {
        if (StringUtils.isBlank((String)option)) {
            return;
        }
        Helper.click.clickAndExpect(field, index, list, true);
        Helper.list.selectListItemEqualsByName(list, option);
    }

    public void selectDropDown(String option, EnhancedBy field, EnhancedBy list, int listIndex) {
        if (StringUtils.isBlank((String)option)) {
            return;
        }
        Helper.click.clickAndExpect(field, list);
        EnhancedWebElement fieldElement = Element.findElements(list);
        fieldElement.sendKeys(listIndex, option);
    }

    public void selectDropDown(String option, EnhancedBy field, int index, EnhancedBy list, int listIndex) {
        if (StringUtils.isBlank((String)option)) {
            return;
        }
        Helper.click.clickAndExpect(field, index, list);
        EnhancedWebElement fieldElement = Element.findElements(list);
        fieldElement.sendKeys(listIndex, option);
    }

    public void selectRadioButton(String option, EnhancedBy buttons) {
        if (StringUtils.isBlank((String)option)) {
            return;
        }
        Helper.list.selectListItemEqualsByName(buttons, option);
    }

    public void selectCheckBox(EnhancedBy button, boolean isSelect) {
        if (isSelect) {
            Helper.click.clickAndWait(button, 0.1);
        }
    }

    public void selectRadioButton(EnhancedBy button) {
        Helper.click.clickAndExpect(button, button);
    }

    public void selectToggle(EnhancedBy on, EnhancedBy off, boolean isOn) {
        if (isOn) {
            Helper.clickAndWait(on, 0.0);
        } else {
            Helper.clickAndWait(off, 0.0);
        }
    }

    public void selectMultipleCheckboxOptions(List<String> selections, EnhancedBy checkboxes) {
        for (String selection : selections) {
            TestLog.logPass("I select '" + selection + "'", new Object[0]);
            Helper.list.selectListItemEqualsByName(checkboxes, selection);
        }
    }

    public void uploadFile(String location, EnhancedBy imageButton) {
        TestLog.logPass("I upload file at location '" + location + "'", new Object[0]);
        File file = new File("");
        String path = file.getAbsolutePath() + location;
        this.setField(imageButton, path);
    }

    public void uploadImages(List<String> locations, EnhancedBy imageButton, EnhancedBy images) {
        for (String location : locations) {
            this.uploadImage(location, imageButton, images);
        }
    }

    public void uploadImage(String location, EnhancedBy imageButton, EnhancedBy images) {
        TestLog.logPass("uploaded file: " + location, new Object[0]);
        int imageCount = Helper.list.getListCount(images);
        File file = new File("");
        String path = file.getAbsolutePath() + location;
        this.setField(imageButton, path);
        Helper.wait.waitForAdditionalElementsToLoad(images, imageCount);
    }

    public String getTextValue(EnhancedBy element) {
        Helper.waitForElementToLoad(element);
        EnhancedWebElement targetElement = Element.findElements(element);
        return targetElement.getText();
    }

    public String getTextValue(EnhancedBy element, int index) {
        Helper.waitForElementToLoad(element);
        EnhancedWebElement targetElement = Element.findElements(element);
        return targetElement.getText(index);
    }
}

