/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.helpers.Helper;
import core.support.objects.DateFormats;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.reflections8.util.Joiner;

public class DateHelper {
    public String getTimestampMiliseconds() {
        return this.getTime("yyyyMMddHHmmssSSSSS");
    }

    public String getTimeInstance() {
        return Instant.now().toString();
    }

    public String getTimestampSeconds() {
        return this.getTime("yyyy-MM-dd HH:mm:ss");
    }

    public String getTimeISOInstant() {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }

    public String getTime(String format, String zone) {
        Instant time = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of(zone));
        return formatter.format(time);
    }

    public String getTime(String format) {
        Instant time = Instant.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("UTC"));
        return formatter.format(time);
    }

    public String getTime(Instant time, String format) {
        if (format.startsWith("cc") || format.startsWith("CC")) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYY").withZone(ZoneId.of("UTC"));
            String year = formatter.format(time).substring(0, 2);
            int cc = Integer.valueOf(year) + 1;
            format = format.replace("cc", "").replace("CC", "");
            formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("UTC"));
            return String.valueOf(cc) + formatter.format(time);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of("UTC"));
        return formatter.format(time);
    }

    public String getTime(String timeString, String format, String zone) {
        LocalDateTime date1Date = this.getLocalDateTime(timeString);
        Instant timeInstant = date1Date.atZone(ZoneId.of("UTC")).toInstant();
        DateTimeFormatter formatter = null;
        if (StringUtils.isBlank((String)format) && StringUtils.isBlank((String)zone)) {
            return timeInstant.toString();
        }
        if (!StringUtils.isBlank((String)format) && StringUtils.isBlank((String)zone)) {
            return this.getTime(timeInstant, format);
        }
        if (StringUtils.isBlank((String)format) && !StringUtils.isBlank((String)zone)) {
            LocalDateTime timelocal = LocalDateTime.ofInstant(timeInstant, ZoneId.of("UTC"));
            ZoneId zoneId = ZoneId.of(zone);
            ZonedDateTime zdt = timelocal.atZone(zoneId);
            String dateString = zdt.toInstant().toString();
            return dateString;
        }
        formatter = DateTimeFormatter.ofPattern(format).withZone(ZoneId.of(zone));
        return formatter.format(timeInstant);
    }

    public int getDayOfWeekIndex(String day) {
        DateTimeFormatter dayOfWeekFormatter = DateTimeFormatter.ofPattern("EEEE", Locale.ENGLISH);
        Locale loc = Locale.US;
        WeekFields wf = WeekFields.of(loc);
        DayOfWeek dayOfWeek = DayOfWeek.from(dayOfWeekFormatter.parse(day));
        int dayNumber = dayOfWeek.get(wf.dayOfWeek());
        return dayNumber;
    }

    public int getDayOfWeekIndex(LocalDateTime time) {
        Locale loc = Locale.US;
        WeekFields wf = WeekFields.of(loc);
        DayOfWeek dayOfWeek = time.getDayOfWeek();
        int day = dayOfWeek.get(wf.dayOfWeek());
        return day;
    }

    public int getMonthOfYearIndex(String month) {
        int monthNum = Month.valueOf(month.toUpperCase()).getValue();
        return monthNum;
    }

    public int getMonthOfYearIndex(LocalDateTime time) {
        return time.getMonth().getValue();
    }

    public boolean isBetweenDates(String source, String date1, String date2) {
        LocalDateTime sourceDate = this.getLocalDateTime(source);
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        LocalDateTime date2Date = this.getLocalDateTime(date2);
        return sourceDate.isAfter(date1Date) && sourceDate.isBefore(date2Date);
    }

    public boolean isBetweenDates(List<String> sources, String date1, String date2) {
        LocalDateTime date1Date = this.getLocalDateTime(date1);
        LocalDateTime date2Date = this.getLocalDateTime(date2);
        for (String source : sources) {
            LocalDateTime sourceDate = this.getLocalDateTime(source);
            if (sourceDate.isAfter(date1Date) && sourceDate.isBefore(date2Date)) continue;
            return false;
        }
        return true;
    }

    public LocalDateTime getLocalDateTime(String timeString) {
        LocalDateTime dateTime = null;
        timeString = timeString.trim();
        for (String format : DateFormats.dateFormats) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                dateTime = LocalDateTime.parse(timeString.trim(), formatter);
                return dateTime;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        if (Helper.isNumeric(timeString)) {
            try {
                Long epochTime = Long.valueOf(timeString);
                dateTime = timeString.length() <= 10 ? LocalDateTime.ofInstant(Instant.ofEpochSecond(epochTime), ZoneId.of("UTC")) : LocalDateTime.ofInstant(Instant.ofEpochMilli(epochTime), ZoneId.of("UTC"));
                return dateTime;
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        Helper.assertFalse("no matching date format for string: " + timeString);
        return null;
    }

    public String setTimeParameterFormat(String parameter) {
        String FormatString = "FORMAT";
        String ZoneString = "ZONE";
        if (!parameter.contains(ZoneString) && !parameter.contains(FormatString)) {
            return parameter;
        }
        String[] values = parameter.split(";");
        ArrayList<String> updatedParameters = new ArrayList<String>();
        String zoneParameter = "";
        String FormatParameter = "";
        for (String value : values) {
            if (!value.contains(ZoneString) && !value.contains(FormatString)) {
                updatedParameters.add(value);
            }
            if (value.contains(ZoneString)) {
                zoneParameter = value;
            }
            if (!value.contains(FormatString)) continue;
            FormatParameter = value;
        }
        updatedParameters.add(zoneParameter);
        updatedParameters.add(FormatParameter);
        parameter = Joiner.on((String)";").join(updatedParameters);
        return parameter;
    }
}

