/*
 * Decompiled with CFR 0.152.
 */
package core.helpers;

import core.support.configReader.Config;
import core.support.logger.LogObject;
import core.support.logger.TestLog;
import core.support.objects.TestObject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.asserts.SoftAssert;

public class AssertHelper {
    protected static void assertTrue(String message, boolean value) {
        try {
            Assert.assertTrue((boolean)value, (String)(TestObject.getTestId() + ": " + message));
        }
        catch (AssertionError e) {
            AssertHelper.logStackTrace(e);
            message = AssertHelper.getLogsAsString(message);
            Assert.assertTrue((boolean)value, (String)(TestObject.getTestId() + ": " + message));
        }
    }

    protected static void assertFalse(String message) {
        try {
            Assert.assertTrue((boolean)false, (String)(TestObject.getTestId() + ": " + message));
        }
        catch (AssertionError e) {
            AssertHelper.logStackTrace(e);
            message = AssertHelper.getLogsAsString(message);
            Assert.assertTrue((boolean)false, (String)(TestObject.getTestId() + ": " + message));
        }
    }

    protected static void assertFalse(String message, boolean value) {
        try {
            message = AssertHelper.getLogsAsString(message);
            Assert.assertTrue((!value ? 1 : 0) != 0, (String)(TestObject.getTestId() + ": " + message));
        }
        catch (AssertionError e) {
            AssertHelper.logStackTrace(e);
            message = AssertHelper.getLogsAsString(message);
            Assert.assertTrue((!value ? 1 : 0) != 0, (String)(TestObject.getTestId() + ": " + message));
        }
    }

    protected static void assertEquals(String expected, String actual) {
        TestLog.logPass("validating if expected: " + expected + " equals to actual: " + actual, new Object[0]);
        if (expected == null) {
            AssertHelper.assertTrue("expected value: " + expected + " actual:" + actual, expected == actual);
        } else {
            AssertHelper.assertTrue("expected value: " + expected + " actual:" + actual, expected.equals(actual));
        }
    }

    protected static void assertEquals(boolean expected, boolean actual) {
        AssertHelper.assertTrue("expected value: " + expected + " actual:" + actual, Objects.equals(expected, actual));
    }

    protected static void assertEquals(int expected, int actual) {
        AssertHelper.assertTrue("expected value: " + expected + " actual:" + actual, expected == actual);
    }

    protected static void softAssertTrue(String message, boolean value) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertTrue(value, message);
        TestLog.ConsoleLogWarn("soft assert failed: " + message, new Object[0]);
    }

    protected static void softAssertEqual(String expected, String actual) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertEquals(actual, expected);
        TestLog.ConsoleLogWarn("soft assert failed: expected: " + expected + " but actual was: " + actual, new Object[0]);
    }

    protected static void softAssertEqual(int expected, int actual) {
        SoftAssert softAssertion = new SoftAssert();
        softAssertion.assertEquals(actual, expected);
        TestLog.ConsoleLogWarn("soft assert failed: expected: " + expected + " but actual was: " + actual, new Object[0]);
    }

    protected static void assertContains(String actual, String expected) {
        TestLog.logPass("validating if expected: " + expected + " contains actual: " + actual, new Object[0]);
        AssertHelper.assertTrue("actual: " + actual + " does not contain expected: " + expected, actual.contains(expected));
    }

    protected static void logStackTrace(AssertionError e) {
        StringWriter sw = new StringWriter();
        ((Throwable)((Object)e)).printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        TestLog.ConsoleLog(exceptionAsString, new Object[0]);
    }

    public static String getLogsAsString(String message) {
        boolean isLogWithStackTrace = Config.getBooleanValue("log.steps.with.stacktrace");
        if (!isLogWithStackTrace) {
            return message;
        }
        ArrayList<String> logValues = new ArrayList<String>();
        List<LogObject> logs = TestObject.getTestInfo().testLog;
        for (LogObject log : logs) {
            logValues.add(log.value);
        }
        String list = StringUtils.join(logValues, (String)"\n");
        message = message + "\n" + list;
        return message;
    }
}

