/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.JsonHelper;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class RestApiInterface {
    public static final String API_TIMEOUT_PAGINATION_VALIDATION_ENABLED = "api.timeout.pagination.validation.isEnabled";
    private static final String INVALID_TOKEN = "INVALID_TOKEN";
    private static final String NO_TOKEN = "NO_TOKEN";
    private static final String OPTION_PAGINATION_STOP_CRITERIA = "PAGINATION_STOP_CRITERIA";
    private static final String OPTION_PAGINATION_MAX_PAGES = "PAGINATION_MAX_PAGES";
    private static final String OPTION_PAGINATION_FROM = "PAGINATION_FROM";
    private static final String OPTION_PAGINATION_INCREMENET = "PAGINATION_INCREMENT";
    public static final String API_PAGINATION_STOP_CRITERIA = "api.pagination.stop.criteria";
    public static final String API_PAGINATION_MAX_PAGES = "api.pagination.max.pages";
    public static final String API_PAGINATION_PAGES_FROM = "api.pagination.pages.from";
    public static final String API_PAGINATION_INCREMENT = "api.pagination.incremenet";
    public static final String API_PAGINATION_COUNTER = "PAGINATION";
    public static final String API_PARAMETER_ENCODING = "api.encoding.parameter";
    public static final String API_URL_ENCODING = "api.encoding.url";
    public static final String API_BASE_URL = "api.uriPath";
    public static boolean API_AUTO_PROXY_SET = false;

    public static Response RestfullApiInterface(ServiceObject serviceObject) {
        if (serviceObject == null) {
            Helper.assertFalse("service object is null");
        }
        RestApiInterface.setTimeout();
        RestApiInterface.setProxy();
        Response response = RestApiInterface.evaluate(serviceObject);
        return response;
    }

    public static Response evaluate(ServiceObject serviceObject) {
        Response response = null;
        response = serviceObject.getUriPath().contains(API_PAGINATION_COUNTER) ? RestApiInterface.evaluatePagination(serviceObject) : RestApiInterface.evaluateRequestAndValidateResponse(serviceObject);
        return response;
    }

    public static Response evaluateRequestAndValidateResponse(ServiceObject serviceObject) {
        RestApiInterface.evaluateOption(serviceObject);
        int getRetryCount = Config.getIntValue("service.retry.count");
        int getRetryAfterSecond = Config.getIntValue("service.retry.after.seconds");
        for (int i = 1; i <= getRetryCount + 1; ++i) {
            RestApiInterface.evaluateRequestAndReceiveResponse(serviceObject);
            if (serviceObject.getExpectedResponse().isEmpty() && serviceObject.getRespCodeExp().isEmpty()) {
                return serviceObject.getResponse();
            }
            if (serviceObject.getErrorMessages().isEmpty()) break;
            if (i > getRetryCount) continue;
            TestLog.logPass("Run: " + i + " Failed, attempting another retry... " + (getRetryCount + 1 - i) + " retry(s) remaining", new Object[0]);
            if (getRetryAfterSecond <= 0) continue;
            Helper.waitForSeconds(getRetryAfterSecond);
        }
        if (!serviceObject.getErrorMessages().isEmpty()) {
            String errorString = StringUtils.join(serviceObject.getErrorMessages(), (String)"\n error: ");
            TestLog.ConsoleLog(ServiceObject.normalize(errorString), new Object[0]);
            Helper.assertFalse(StringUtils.join(serviceObject.getErrorMessages(), (String)"\n error: "));
        }
        return serviceObject.getResponse();
    }

    public static Response evaluatePagination(ServiceObject serviceObject) {
        RestApiInterface.evaluateOption(serviceObject);
        boolean isValidationTimeout = Config.getBooleanValue("service.timeout.validation.isEnabled");
        Config.putValue(API_TIMEOUT_PAGINATION_VALIDATION_ENABLED, (Object)isValidationTimeout, false);
        boolean isCriteriaSuccess = false;
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        int maxRetrySeconds = -1;
        int currentRunCount = 1;
        do {
            if (++currentRunCount > 1) {
                TestLog.ConsoleLog("attempt #" + currentRunCount, new Object[0]);
            }
            isCriteriaSuccess = RestApiInterface.evaluateRequestAndValidatePagination(serviceObject);
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
            maxRetrySeconds = Config.getIntValue("service.timeout.validation.seconds");
        } while (isValidationTimeout && !isCriteriaSuccess && passedTimeInSeconds < (long)maxRetrySeconds);
        Config.putValue(API_TIMEOUT_PAGINATION_VALIDATION_ENABLED, false);
        Helper.assertTrue("expected validation not found in pages.", isCriteriaSuccess);
        return serviceObject.getResponse();
    }

    public static boolean evaluateRequestAndValidatePagination(ServiceObject serviceObject) {
        String criteria = Config.getValue(API_PAGINATION_STOP_CRITERIA);
        int maxPages = Config.getIntValue(API_PAGINATION_MAX_PAGES);
        int startingPage = Helper.getIntFromString(Config.getValue(API_PAGINATION_PAGES_FROM));
        int incrementBy = Helper.getIntFromString(Config.getValue(API_PAGINATION_INCREMENT));
        String uri = serviceObject.getUriPath();
        boolean isCriteriaSuccess = false;
        for (int index = startingPage; index <= maxPages; index += incrementBy) {
            TestLog.logPass("Validating page: " + index, new Object[0]);
            serviceObject = serviceObject.withUriPath(uri);
            Config.putValue(API_PAGINATION_COUNTER, (Object)index, false);
            serviceObject = RestApiInterface.evaluateRequestAndReceiveResponse(serviceObject);
            List<String> criteriaErrors = RestApiInterface.validatePaginationStopCriteria(serviceObject, criteria);
            if (!criteriaErrors.isEmpty()) {
                TestLog.logPass("no more results returned at page: " + index + " with criteria: " + criteria, new Object[0]);
                break;
            }
            if (!serviceObject.getErrorMessages().isEmpty()) {
                TestLog.logPass(Arrays.toString(serviceObject.getErrorMessages().toArray()), new Object[0]);
                continue;
            }
            if (!serviceObject.getErrorMessages().isEmpty()) continue;
            isCriteriaSuccess = true;
            break;
        }
        return isCriteriaSuccess;
    }

    private static List<String> validatePaginationStopCriteria(ServiceObject serviceObject, String criteria) {
        if (!criteria.isEmpty()) {
            criteria = "_VERIFY.JSON.PART_" + criteria + ":" + DataHelper.JSON_COMMAND.nodeSizeGreaterThan.name() + "(0)";
        }
        ServiceObject criteriaService = new ServiceObject().withResponse(serviceObject.getResponse()).withExpectedResponse(criteria);
        List<String> criteriaErrors = RestApiInterface.validateResponse(criteriaService);
        return criteriaErrors;
    }

    public static ServiceObject evaluateRequestAndReceiveResponse(ServiceObject serviceObject) {
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        int maxRetrySeconds = -1;
        int currentRetryCount = 0;
        do {
            ArrayList<String> errors = new ArrayList<String>();
            serviceObject.withErrorMessages(errors);
            if (++currentRetryCount > 1) {
                TestLog.ConsoleLog("attempt #" + currentRetryCount, new Object[0]);
                RestApiInterface.evaluateOption(serviceObject);
            }
            RequestSpecification request = RestApiInterface.setURI(serviceObject);
            serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
            serviceObject = RestApiInterface.evaluateRequest(serviceObject, request);
            serviceObject.withErrorMessages(RestApiInterface.validateResponse(serviceObject));
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
            boolean isValidationTimeout = Config.getBooleanValue("service.timeout.validation.isEnabled");
            maxRetrySeconds = Config.getIntValue("service.timeout.validation.seconds");
            if (!isValidationTimeout) break;
            RestApiInterface.logTestRunError(currentRetryCount, serviceObject.getErrorMessages());
        } while (!serviceObject.getErrorMessages().isEmpty() && passedTimeInSeconds < (long)maxRetrySeconds);
        if (!serviceObject.getErrorMessages().isEmpty()) {
            TestLog.ConsoleLog("Validation failed after: " + passedTimeInSeconds + " seconds", new Object[0]);
        }
        return serviceObject;
    }

    private static void logTestRunError(int currentRetryCount, List<String> errorMessages) {
        int waitTime = Config.getIntValue("service.timeout.validation.delay.between.attempt.seconds");
        String errors = StringUtils.join(errorMessages, (String)"\n error: ");
        if (!errors.isEmpty()) {
            TestLog.ConsoleLog("attempt failed with message: " + ServiceObject.normalize(errors), new Object[0]);
        }
        if (currentRetryCount > 1) {
            Helper.waitForSeconds(waitTime);
        }
    }

    public static RequestSpecification setURI(ServiceObject serviceObject) {
        String url = "";
        RequestSpecification request = RestAssured.given();
        serviceObject.withUriPath(DataHelper.replaceParameters(serviceObject.getUriPath()));
        serviceObject.withUriPath(Helper.stringRemoveLines(serviceObject.getUriPath()));
        url = serviceObject.getUriPath().startsWith("http") ? serviceObject.getUriPath() : Helper.stringRemoveLines(Config.getValue(API_BASE_URL)) + serviceObject.getUriPath();
        serviceObject.withUriPath(url);
        URL aURL = Helper.convertToUrl(url);
        TestLog.logPass("request URL: " + aURL.toString(), new Object[0]);
        request.baseUri(aURL.getProtocol() + "://" + aURL.getHost());
        request.port(aURL.getPort());
        request.basePath(aURL.getPath());
        boolean urlEncoding = Config.getBooleanValue(API_URL_ENCODING);
        request = request.urlEncodingEnabled(urlEncoding);
        return request;
    }

    public static void setTimeout() {
        int connectTimeout = Config.getIntValue("service.response.timeout.seconds");
        if (connectTimeout == -1) {
            connectTimeout = 60;
        }
        RestAssured.config = RestAssuredConfig.config().httpClient(HttpClientConfig.httpClientConfig().setParam("http.connection.timeout", (Object)(connectTimeout * 1000)).setParam("http.socket.timeout", (Object)(connectTimeout * 1000)).setParam("http.connection-manager.timeout", (Object)(connectTimeout * 1000)));
    }

    public static void setProxy() {
        String host = Config.getValue("proxy.host");
        int port = Config.getIntValue("proxy.port");
        String proxyProtocal = Config.getValue("proxy.maven.protocol");
        boolean isProxyAutoDetect = Config.getBooleanValue("proxy.auto.detect");
        boolean isProxyEnabled = false;
        if (isProxyAutoDetect && !API_AUTO_PROXY_SET) {
            isProxyEnabled = Helper.setProxyAutoDetection(RestApiInterface.getBaseUrl());
            API_AUTO_PROXY_SET = true;
        } else if (!isProxyAutoDetect) {
            isProxyEnabled = Config.getBooleanValue("proxy.enabled");
        }
        if (!isProxyEnabled) {
            return;
        }
        if (host.isEmpty() || port == -1) {
            return;
        }
        if (proxyProtocal.equals("http") || proxyProtocal.equals("https")) {
            RestAssured.proxy((String)host, (int)port, (String)proxyProtocal);
        } else {
            RestAssured.proxy((String)host, (int)port);
        }
    }

    public static List<String> validateResponse(ServiceObject serviceObject) {
        List<String> errorMessages = serviceObject.getErrorMessages();
        if (serviceObject.getResponse() == null) {
            errorMessages.add("no response returned");
            return errorMessages;
        }
        JsonHelper.saveOutboundJsonParameters(serviceObject.getResponse(), serviceObject.getOutputParams());
        errorMessages.addAll(RestApiInterface.validateStatusCode(serviceObject.getResponse(), serviceObject));
        String responseString = JsonHelper.getResponseValue(serviceObject.getResponse());
        ArrayList<String> responses = new ArrayList<String>();
        responses.add(responseString);
        errorMessages.addAll(DataHelper.validateExpectedValues(responses, serviceObject.getExpectedResponse()));
        errorMessages = DataHelper.removeEmptyElements(errorMessages);
        return errorMessages;
    }

    public static List<String> validateStatusCode(Response response, ServiceObject serviceObject) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!serviceObject.getRespCodeExp().isEmpty()) {
            String message = "expected status code: " + serviceObject.getRespCodeExp() + " response status code: " + response.getStatusCode();
            TestLog.logPass(message, new Object[0]);
            if (response.getStatusCode() != Integer.valueOf(serviceObject.getRespCodeExp()).intValue()) {
                errorMessages.add(message);
            }
        }
        return errorMessages;
    }

    public static RequestSpecification evaluateRequestHeaders(ServiceObject serviceObject, RequestSpecification request) {
        if (serviceObject.getRequestHeaders().isEmpty()) {
            return request;
        }
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestHeaders());
        block14: for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "BASIC": {
                    String key;
                    ArrayList basicRequest;
                    List<String> keys = Helper.getValuesFromPattern(keyword.value.toString(), "<@(.+?)>");
                    if (keys.size() == 0) {
                        Helper.assertFalse("value not set with format identifier:<@variable>");
                    }
                    if ((basicRequest = (ArrayList)Config.getObjectValue(key = keys.get(0))) == null || basicRequest.size() != 2) {
                        Helper.assertFalse("basicRequest request info not correct. Should include username, password: " + Arrays.toString(basicRequest.toArray()));
                    }
                    request = request.auth().basic((String)basicRequest.get(0), (String)basicRequest.get(1));
                    keyword.value = Arrays.toString(basicRequest.toArray());
                    continue block14;
                }
                case "NTLM": {
                    ArrayList ntlmRequest;
                    String key;
                    List<String> keys = Helper.getValuesFromPattern(keyword.value.toString(), "<@(.+?)>");
                    if (keys.size() == 0) {
                        Helper.assertFalse("value not set with format identifier:<@variable>");
                    }
                    if ((ntlmRequest = (ArrayList)Config.getObjectValue(key = keys.get(0))) == null || ntlmRequest.size() != 4) {
                        Helper.assertFalse("ntlmRequest request info not correct. Should include username, password, workstation, domain: " + Arrays.toString(ntlmRequest.toArray()));
                    }
                    request = request.auth().ntlm((String)ntlmRequest.get(0), (String)ntlmRequest.get(1), (String)ntlmRequest.get(2), (String)ntlmRequest.get(3));
                    keyword.value = Arrays.toString(ntlmRequest.toArray());
                    continue block14;
                }
                case "INVALID_TOKEN": {
                    String authValue = Config.getValue("Authorization");
                    if (!authValue.isEmpty()) {
                        authValue = Helper.generateRandomString(authValue.length());
                        request = request.given().header("Authorization", (Object)authValue, new Object[0]);
                        continue block14;
                    }
                    request = request.given().header("Authorization", (Object)"invalid", new Object[0]);
                    continue block14;
                }
                case "NO_TOKEN": {
                    request = request.given().header("Authorization", (Object)"", new Object[0]);
                    continue block14;
                }
                case "Authorization": {
                    keyword.value = DataHelper.replaceParameters(keyword.value.toString());
                    Config.putValue("Authorization", keyword.value, false);
                    request = request.given().header(keyword.key, keyword.value, new Object[0]);
                    continue block14;
                }
            }
            keyword.value = DataHelper.replaceParameters(keyword.value.toString());
            request = request.given().header(keyword.key, keyword.value, new Object[0]);
        }
        KeyValue.printKeyValue(keywords, "header");
        return request;
    }

    public static RequestSpecification evaluateQueryParameters(ServiceObject serviceObject, RequestSpecification request) {
        URL aURL = Helper.convertToUrl(serviceObject.getUriPath());
        if (StringUtils.isBlank((String)aURL.getQuery())) {
            return request;
        }
        String[] queryParameters = aURL.getQuery().split("(&&)|(&)");
        if (queryParameters.length == 0) {
            Helper.assertFalse("query parameters are wrong format: " + aURL.getQuery() + ". should be \"key=value&key2=value2\"");
        }
        for (String queryParameter : queryParameters) {
            String[] query = queryParameter.split("=");
            if (query.length == 0) {
                Helper.assertFalse("query parameters are wrong format: " + aURL.getQuery() + ". should be \"key=value&key2=value2\"");
            }
            request = query.length == 1 ? request.given().queryParam(query[0], new Object[]{""}) : request.given().queryParam(query[0], new Object[]{query[1]});
        }
        boolean paramterEncoding = Config.getBooleanValue(API_PARAMETER_ENCODING);
        request = request.urlEncodingEnabled(paramterEncoding);
        return request;
    }

    public static RequestSpecification evaluateRequestBody(ServiceObject serviceObject, RequestSpecification request) {
        if (serviceObject.getRequestBody().isEmpty()) {
            return request;
        }
        request = request.contentType(serviceObject.getContentType());
        if (serviceObject.getContentType().contains("form")) {
            String[] formData;
            request = request.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().encodeContentTypeAs("multipart/form-data", ContentType.TEXT)));
            for (String data : formData = serviceObject.getRequestBody().split(",")) {
                String[] keyValue = data.split(":");
                if (keyValue.length == 3) {
                    switch (keyValue[1]) {
                        case "FILE": {
                            File file = DataHelper.getFile(keyValue[2]);
                            request.multiPart(file);
                            break;
                        }
                    }
                    continue;
                }
                request = request.formParam(keyValue[0].trim(), new Object[]{keyValue[1].trim()});
            }
            return request;
        }
        return request.body(serviceObject.getRequestBody());
    }

    public static void evaluateOption(ServiceObject serviceObject) {
        RestApiInterface.resetValidationTimeout();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        DataHelper.saveDataToConfig(serviceObject.getOption());
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "NO_VALIDATION_TIMEOUT": {
                    Config.putValue("service.timeout.validation.isEnabled", (Object)false, false);
                    break;
                }
                case "WAIT_FOR_RESPONSE": {
                    if (Config.getBooleanValue(API_TIMEOUT_PAGINATION_VALIDATION_ENABLED).booleanValue()) {
                        Config.putValue("service.timeout.validation.isEnabled", (Object)false, false);
                    } else {
                        Config.putValue("service.timeout.validation.isEnabled", (Object)true, false);
                    }
                    Config.putValue("service.timeout.validation.seconds", keyword.value, false);
                    break;
                }
                case "WAIT_FOR_RESPONSE_DELAY_SECONDS": {
                    Config.putValue("service.timeout.validation.delay.between.attempt.seconds", keyword.value, false);
                    break;
                }
                case "RETRY_COUNT": {
                    Config.putValue("service.retry.count", keyword.value, false);
                    break;
                }
                case "RETRY_AFTER_SECONDS": {
                    Config.putValue("service.retry.after.seconds", keyword.value, false);
                    break;
                }
                case "PAGINATION_STOP_CRITERIA": {
                    Config.putValue(API_PAGINATION_STOP_CRITERIA, keyword.value, false);
                    break;
                }
                case "PAGINATION_MAX_PAGES": {
                    Config.putValue(API_PAGINATION_MAX_PAGES, keyword.value, false);
                    break;
                }
                case "PAGINATION_FROM": {
                    Config.putValue(API_PAGINATION_PAGES_FROM, keyword.value, false);
                    break;
                }
                case "PAGINATION_INCREMENT": {
                    Config.putValue(API_PAGINATION_INCREMENT, keyword.value, false);
                    break;
                }
            }
        }
        KeyValue.printKeyValue(keywords, "option");
    }

    private static void resetValidationTimeout() {
        int defaultRetryAfterSeconds;
        String defaultValidationTimeoutIsEnabled = Config.getGlobalValue("service.timeout.validation.isEnabled");
        String defaultValidationTimeoutIsSeconds = Config.getGlobalValue("service.timeout.validation.seconds");
        int defaultValidationTimeoutDelay = Config.getGlobalIntValue("service.timeout.validation.delay.between.attempt.seconds");
        if (defaultValidationTimeoutDelay == -1) {
            defaultValidationTimeoutDelay = 3;
        }
        Config.putValue("service.timeout.validation.isEnabled", (Object)defaultValidationTimeoutIsEnabled, false);
        Config.putValue("service.timeout.validation.seconds", (Object)defaultValidationTimeoutIsSeconds, false);
        Config.putValue("service.timeout.validation.delay.between.attempt.seconds", (Object)defaultValidationTimeoutDelay, false);
        int defaultRetryCount = Config.getGlobalIntValue("service.retry.count");
        if (defaultRetryCount == -1) {
            defaultRetryCount = 0;
        }
        if ((defaultRetryAfterSeconds = Config.getGlobalIntValue("service.retry.after.seconds")) == -1) {
            defaultRetryAfterSeconds = 1;
        }
        Config.putValue("service.retry.count", (Object)defaultRetryCount, false);
        Config.putValue("service.retry.after.seconds", (Object)defaultRetryAfterSeconds, false);
        Config.putValue(API_PAGINATION_STOP_CRITERIA, (Object)"", false);
        Config.putValue(API_PAGINATION_MAX_PAGES, (Object)100, false);
        Config.putValue(API_PAGINATION_PAGES_FROM, (Object)1, false);
        Config.putValue(API_PAGINATION_INCREMENT, (Object)1, false);
    }

    public static ServiceObject evaluateRequest(ServiceObject serviceObject, RequestSpecification request) {
        Response response = null;
        ArrayList<String> errors = new ArrayList<String>();
        request = RestApiInterface.evaluateRequestHeaders(serviceObject, request);
        request = RestApiInterface.evaluateQueryParameters(serviceObject, request);
        request = RestApiInterface.evaluateRequestBody(serviceObject, request);
        serviceObject.withRequest(request);
        if (!serviceObject.getRequestBody().isEmpty()) {
            TestLog.logPass("request body: " + Helper.stringRemoveLines(serviceObject.getRequestBody()), new Object[0]);
        }
        TestLog.logPass("request type: " + serviceObject.getMethod(), new Object[0]);
        try {
            switch (serviceObject.getMethod()) {
                case "POST": {
                    response = (Response)request.when().post();
                    break;
                }
                case "PUT": {
                    response = (Response)request.when().put();
                    break;
                }
                case "PATCH": {
                    response = (Response)request.when().patch();
                    break;
                }
                case "DELETE": {
                    response = (Response)request.when().delete();
                    break;
                }
                case "GET": {
                    response = (Response)request.when().get();
                    break;
                }
                case "OPTIONS": {
                    response = (Response)request.when().options();
                    break;
                }
                case "HEAD": {
                    response = (Response)request.when().head();
                    break;
                }
                default: {
                    Helper.assertTrue("request type not found", false);
                    break;
                }
            }
        }
        catch (Exception e) {
            errors.add(e.getMessage());
            serviceObject.withErrorMessages(errors);
        }
        if (response != null) {
            TestLog.logPass("response: " + ServiceObject.normalize(response.getBody().asString()), new Object[0]);
            serviceObject.withResponse((Response)((ValidatableResponse)response.then()).extract().response());
        } else {
            serviceObject.withResponse(response);
        }
        return serviceObject;
    }

    public static URL getBaseUrl() {
        URL baseUrl = null;
        String baseUrlValue = Config.getValue(API_BASE_URL);
        try {
            baseUrl = new URL(baseUrlValue);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return baseUrl;
    }
}

