/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.interfaces;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.GetResponse;
import core.apiCore.helpers.DataHelper;
import core.apiCore.helpers.MessageQueueHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.MessageObject;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.util.HashMap;
import java.util.List;

public class RabbitMqInterface {
    public static final String RABBIT_MQ_HOST = "rabbitMQ.host";
    public static final String RABBIT_MQ_PORT = "rabbitMQ.port";
    public static final String RABBIT_MQ_VIRTUAL_HOST = "rabbitMQ.virtualhost";
    public static final String RABBIT_MQ_USER = "rabbitMQ.user";
    public static final String RABBIT_MQ_PASS = "rabbitMQ.password";
    public static final String RABBIT_MQ_EXCHANGE = "rabbitMQ.exchange";
    public static final String RABBIT_MQ_OUTBOUND_EXCHANGE = "rabbitMQ.outbound.exchange";
    public static final String RABBIT_MQ_EXCHANGE_TYPE = "rabbitMQ.exchange.type";
    public static final String RABBIT_MQ_QUEUE = "rabbitMQ.queue";
    public static final String RABBIT_MQ_OUTBOUND_QUEUE = "rabbitMQ.outbound.queue";
    public static final String RABBIT_MQ_QUEUE_DURABLE = "rabbitMQ.Queue.durable";
    public static final String RABBIT_MQ_DECLARE_QUEUE = "rabbitMQ.queue.declare";
    public static final String RABBIT_MQ_MESSAGE_ID_PREFIX = "rabbitMQ.msgId.prefix";
    public static Connection connection = null;
    public static Channel channel;

    public static void testRabbitMqInterface(ServiceObject serviceObject) throws Exception {
        RabbitMqInterface.connectRabbitMq(serviceObject);
        RabbitMqInterface.evaluateOption(serviceObject);
        serviceObject.withRequestBody(DataHelper.getRequestBodyIncludingTemplate(serviceObject));
        String messageId = MessageQueueHelper.generateMessageId(serviceObject, Config.getValue(RABBIT_MQ_MESSAGE_ID_PREFIX));
        RabbitMqInterface.sendRabbitMqMessage(serviceObject, messageId);
        MessageQueueHelper.receiveAndValidateMessages(serviceObject, messageId, MessageObject.messageType.RABBITMQ);
    }

    public static synchronized void connectRabbitMq(ServiceObject serviceObject) {
        if (channel == null) {
            try {
                ConnectionFactory factory = new ConnectionFactory();
                int port = Config.getIntValue(RABBIT_MQ_PORT);
                String username = Config.getValue(RABBIT_MQ_USER);
                String password = Config.getValue(RABBIT_MQ_PASS);
                String virtualHost = Config.getValue(RABBIT_MQ_VIRTUAL_HOST);
                factory.setHost(Config.getValue(RABBIT_MQ_HOST));
                if (port != -1) {
                    factory.setPort(port);
                }
                if (!username.isEmpty()) {
                    factory.setUsername(Config.getValue(RABBIT_MQ_USER));
                }
                if (!password.isEmpty()) {
                    factory.setPassword(Config.getValue(RABBIT_MQ_PASS));
                }
                if (!virtualHost.isEmpty()) {
                    factory.setVirtualHost(Config.getValue(RABBIT_MQ_VIRTUAL_HOST));
                }
                connection = factory.newConnection();
                channel = connection.createChannel();
                Helper.waitForSeconds(1.0);
            }
            catch (Exception e) {
                e.printStackTrace();
                TestLog.ConsoleLog("Connection failed: " + e.getMessage(), new Object[0]);
                throw new RuntimeException("Could not connect. ", e);
            }
        }
    }

    public static void sendRabbitMqMessage(ServiceObject serviceObject, String messageId) {
        TestLog.ConsoleLog("rabbitMq request body: " + serviceObject.getRequestBody(), new Object[0]);
        AMQP.BasicProperties props = RabbitMqInterface.evaluateRequestHeaders(serviceObject);
        props = props.builder().correlationId(messageId).messageId(messageId).build();
        String exchange = Config.getValue(RABBIT_MQ_EXCHANGE);
        String queueName = Config.getValue(RABBIT_MQ_QUEUE);
        String exchangeType = Config.getValue(RABBIT_MQ_EXCHANGE_TYPE);
        try {
            if (!exchangeType.isEmpty()) {
                channel.exchangeDeclare(exchange, exchangeType);
            }
            channel.basicPublish(exchange, queueName, props, serviceObject.getRequestBody().getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not send message. ", e);
        }
    }

    public static AMQP.BasicProperties evaluateRequestHeaders(ServiceObject serviceObject) {
        if (serviceObject.getRequestHeaders().isEmpty()) {
            return new AMQP.BasicProperties();
        }
        AMQP.BasicProperties props = new AMQP.BasicProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getRequestHeaders());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                default: 
            }
            map.put(keyword.key, keyword.value);
        }
        props = props.builder().headers(map).build();
        return props;
    }

    public static void evaluateOption(ServiceObject serviceObject) {
        RabbitMqInterface.resetOptions();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        DataHelper.saveDataToConfig(serviceObject.getOption());
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key.toLowerCase()) {
                case "exchange": {
                    Config.putValue(RABBIT_MQ_EXCHANGE, keyword.value, false);
                    break;
                }
                case "queue": {
                    Config.putValue(RABBIT_MQ_QUEUE, keyword.value, false);
                    break;
                }
                case "outbound_queue": {
                    Config.putValue(RABBIT_MQ_OUTBOUND_QUEUE, keyword.value, false);
                    break;
                }
                case "response_identifier": {
                    Config.putValue("response.identifier", keyword.value, false);
                }
            }
        }
        KeyValue.printKeyValue(keywords, "option");
    }

    private static void resetOptions() {
        String defaultExchange = TestObject.getDefaultTestInfo().config.get(RABBIT_MQ_EXCHANGE).toString();
        String outboundExchange = TestObject.getDefaultTestInfo().config.get(RABBIT_MQ_OUTBOUND_EXCHANGE).toString();
        String defaultQueue = TestObject.getDefaultTestInfo().config.get(RABBIT_MQ_QUEUE).toString();
        String outboundQueue = TestObject.getDefaultTestInfo().config.get(RABBIT_MQ_OUTBOUND_QUEUE).toString();
        Config.putValue(RABBIT_MQ_EXCHANGE, (Object)defaultExchange, false);
        Config.putValue(RABBIT_MQ_QUEUE, (Object)defaultQueue, false);
        Config.putValue(RABBIT_MQ_OUTBOUND_QUEUE, (Object)outboundQueue, false);
        Config.putValue(RABBIT_MQ_OUTBOUND_EXCHANGE, (Object)outboundExchange, false);
        Config.putValue("response.identifier", (Object)"", false);
    }

    public static void closeConnection() {
        try {
            channel.close();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getOutboundMessages() throws Exception {
        GetResponse delivery;
        String queueName = Config.getValue(RABBIT_MQ_QUEUE);
        String outboundQueue = Config.getValue(RABBIT_MQ_OUTBOUND_QUEUE);
        boolean queueDurable = Config.getBooleanValue(RABBIT_MQ_QUEUE_DURABLE);
        boolean isDeclareQueue = Config.getBooleanValue(RABBIT_MQ_DECLARE_QUEUE);
        if (!outboundQueue.isEmpty()) {
            queueName = outboundQueue;
        }
        if (isDeclareQueue) {
            channel.queueDeclare(queueName, queueDurable, false, false, null);
        }
        String exchangeName = Config.getValue(RABBIT_MQ_EXCHANGE);
        String exchangeOutboundName = Config.getValue(RABBIT_MQ_OUTBOUND_EXCHANGE);
        String exchangeType = Config.getValue(RABBIT_MQ_EXCHANGE_TYPE);
        if (!exchangeOutboundName.isEmpty()) {
            exchangeName = exchangeOutboundName;
        }
        if (!exchangeType.isEmpty()) {
            channel.exchangeDeclare(exchangeName, exchangeType);
        }
        if (!exchangeName.isEmpty()) {
            channel.queueBind(queueName, exchangeName, "");
        }
        if ((delivery = channel.basicGet(queueName, true)) != null) {
            String messageString = new String(delivery.getBody(), "UTF-8");
            MessageObject message = new MessageObject().withMessageType(MessageObject.messageType.RABBITMQ).withMessageId(delivery.getProps().getMessageId()).withCorrelationId(delivery.getProps().getCorrelationId()).withMessage(messageString);
            if (message != null) {
                TestLog.logPass("Received message with Id: " + message.getMessageId() + " message: " + message.getMessage(), new Object[0]);
                MessageObject.outboundMessages.put(message, true);
            }
        }
    }
}

