/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import core.apiCore.helpers.DataHelper;
import core.apiCore.interfaces.KafkaInterface;
import core.apiCore.interfaces.RabbitMqInterface;
import core.apiCore.interfaces.ServiceBusInterface;
import core.helpers.Helper;
import core.helpers.StopWatchHelper;
import core.support.configReader.Config;
import core.support.logger.TestLog;
import core.support.objects.KeyValue;
import core.support.objects.MessageObject;
import core.support.objects.ServiceObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.TextUtils;

public class MessageQueueHelper {
    public static final String RESPONSE_IDENTIFIER = "response.identifier";

    public static String generateMessageId(ServiceObject serviceObject, String messageIdPrefix) {
        String messageId = "";
        if (!serviceObject.getRequestBody().isEmpty()) {
            messageId = messageIdPrefix + "-" + UUID.randomUUID().toString();
        }
        return messageId;
    }

    public static long logPerInterval(int interval, StopWatchHelper watch, long lastLogged, int receivedMessageCount) {
        long passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        if (passedTimeInSeconds > (long)interval && passedTimeInSeconds - lastLogged > (long)interval) {
            TestLog.logPass("waiting: " + watch.time(TimeUnit.SECONDS) + " seconds", new Object[0]);
            TestLog.logPass("received: " + receivedMessageCount + " relevant message(s)", new Object[0]);
            Helper.waitForSeconds(1.0);
            lastLogged = passedTimeInSeconds;
        }
        return lastLogged;
    }

    public static List<String> validateExpectedMessageCount(String request, List<String> filteredMessages) {
        int actualMessageCount;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (filteredMessages.isEmpty()) {
            errorMessages.add("no messages received");
            return errorMessages;
        }
        int expectedMessageCount = 1;
        Map<String, String> params = MessageQueueHelper.getKeyValueFromString(request, ";", ":");
        if (params.containsKey("EXPECTED_MESSAGE_COUNT")) {
            expectedMessageCount = Helper.getIntFromString(params.get("EXPECTED_MESSAGE_COUNT"), true);
        }
        if (expectedMessageCount != (actualMessageCount = filteredMessages.size())) {
            String errorMessage = "Response received " + filteredMessages.size() + " out of " + expectedMessageCount + ".\n Received messages: \n";
            errorMessages.add(errorMessage + String.join((CharSequence)"\n ", filteredMessages));
        }
        return errorMessages;
    }

    public static Map<String, String> getKeyValueFromString(String value, String entriesSeparator, String separator) {
        String[] entries;
        HashMap<String, String> map = new HashMap<String, String>();
        value = value.replaceAll("\\s+", "");
        for (String entry : entries = value.split(entriesSeparator)) {
            if (TextUtils.isEmpty((CharSequence)entry) || !entry.contains(separator)) continue;
            String[] keyValue = entry.split(separator);
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    public static CopyOnWriteArrayList<MessageObject> findMessagesBasedOnResponseIdentifier() {
        CopyOnWriteArrayList<MessageObject> filteredMessages = new CopyOnWriteArrayList<MessageObject>();
        String identifier = Config.getValue(RESPONSE_IDENTIFIER);
        if (identifier.isEmpty()) {
            return filteredMessages;
        }
        for (Map.Entry<MessageObject, Boolean> entry : MessageObject.outboundMessages.entrySet()) {
            String receiveMessage = Optional.ofNullable(entry.getKey().getMessage()).orElse("");
            boolean isMessageMatch = receiveMessage.contains(identifier);
            if (!entry.getValue().equals(true) || !isMessageMatch) continue;
            filteredMessages.add(entry.getKey());
            MessageObject.outboundMessages.put(entry.getKey(), false);
        }
        return filteredMessages;
    }

    public static CopyOnWriteArrayList<MessageObject> findMessagesBasedOnMessageId(String messageId) {
        CopyOnWriteArrayList<MessageObject> filteredMessages = new CopyOnWriteArrayList<MessageObject>();
        if (messageId.isEmpty()) {
            return filteredMessages;
        }
        for (Map.Entry<MessageObject, Boolean> entry : MessageObject.outboundMessages.entrySet()) {
            boolean isMessageMatch;
            String receivedMessageId = Optional.ofNullable(entry.getKey().getMessageId()).orElse("");
            String receivedCorrelationId = Optional.ofNullable(entry.getKey().getCorrelationId()).orElse("");
            boolean bl = isMessageMatch = receivedMessageId.contains(messageId) || receivedCorrelationId.contains(messageId);
            if (!entry.getValue().equals(true) || !isMessageMatch) continue;
            filteredMessages.add(entry.getKey());
            MessageObject.outboundMessages.put(entry.getKey(), false);
        }
        return filteredMessages;
    }

    public static CopyOnWriteArrayList<MessageObject> filterOutboundMessage(String messageId) {
        CopyOnWriteArrayList<MessageObject> filteredMessages = new CopyOnWriteArrayList<MessageObject>();
        CopyOnWriteArrayList<MessageObject> filterByMessageId = MessageQueueHelper.findMessagesBasedOnMessageId(messageId);
        if (!filterByMessageId.isEmpty()) {
            filteredMessages.addAll(filterByMessageId);
        } else {
            CopyOnWriteArrayList<MessageObject> filterByMessageIdentifier = MessageQueueHelper.findMessagesBasedOnResponseIdentifier();
            filteredMessages.addAll(filterByMessageIdentifier);
        }
        return filteredMessages;
    }

    public static void receiveAndValidateMessages(ServiceObject serviceObject, String messageId, MessageObject.messageType messageType2) throws Exception {
        MessageQueueHelper.evaluateOption(serviceObject);
        if (serviceObject.getExpectedResponse().isEmpty()) {
            return;
        }
        serviceObject.withExpectedResponse(DataHelper.replaceParameters(serviceObject.getExpectedResponse()));
        CopyOnWriteArrayList<MessageObject> filteredMessages = new CopyOnWriteArrayList<MessageObject>();
        List<Object> errorMessages = new ArrayList();
        int maxRetrySeconds = Config.getIntValue("service.response.timeout.seconds");
        StopWatchHelper watch = StopWatchHelper.start();
        long passedTimeInSeconds = 0L;
        long lastLogged = 0L;
        int interval = 10;
        do {
            lastLogged = MessageQueueHelper.logPerInterval(interval, watch, lastLogged, filteredMessages.size());
            MessageQueueHelper.getOutboundMessages(messageType2);
            filteredMessages.addAll(MessageQueueHelper.filterOutboundMessage(messageId));
            errorMessages = MessageQueueHelper.validateExpectedMessageCount(serviceObject.getExpectedResponse(), MessageQueueHelper.getMessageList(filteredMessages));
            if (errorMessages.isEmpty()) {
                MessageQueueHelper.printAllFilteredMessages(filteredMessages);
                errorMessages.addAll(MessageQueueHelper.validateMessages(serviceObject, filteredMessages));
                break;
            }
            passedTimeInSeconds = watch.time(TimeUnit.SECONDS);
        } while (!errorMessages.isEmpty() && passedTimeInSeconds < (long)maxRetrySeconds);
        if (!errorMessages.isEmpty()) {
            String errorString = StringUtils.join(errorMessages, (String)"\n error: ");
            TestLog.ConsoleLog(errorString, new Object[0]);
            Helper.assertFalse(StringUtils.join(errorMessages, (String)"\n error: "));
        }
    }

    public static void getOutboundMessages(MessageObject.messageType messageType2) throws Exception {
        switch (messageType2) {
            case KAFKA: {
                KafkaInterface.getOutboundMessages();
                break;
            }
            case RABBITMQ: {
                RabbitMqInterface.getOutboundMessages();
                break;
            }
            case SERVICEBUS: {
                ServiceBusInterface.getOutboundMessages();
                break;
            }
            case TEST: {
                break;
            }
        }
    }

    public static void printAllMessages() {
        TestLog.ConsoleLog("Printing All received messages", new Object[0]);
        for (Map.Entry<MessageObject, Boolean> entry : MessageObject.outboundMessages.entrySet()) {
            String messageId = entry.getKey().getMessageId();
            Boolean messageAvailable = entry.getValue();
            TestLog.ConsoleLog("received messagesId: '" + messageId + "'. was message read: " + (messageAvailable == false), new Object[0]);
        }
    }

    public static void printAllFilteredMessages(CopyOnWriteArrayList<MessageObject> filteredMessages) {
        TestLog.ConsoleLog("Printing All relevant received messages", new Object[0]);
        for (MessageObject message : filteredMessages) {
            String messageId = message.getMessageId();
            String messageContent = message.getMessage();
            TestLog.logPass("received messagesId: '" + messageId + "' with message content: \n" + messageContent, new Object[0]);
        }
    }

    public static List<String> getMessageList(CopyOnWriteArrayList<MessageObject> filteredMessages) {
        ArrayList<String> messages = new ArrayList<String>();
        for (MessageObject message : filteredMessages) {
            messages.add(message.getMessage());
        }
        return messages;
    }

    public static List<String> getHeaderList(CopyOnWriteArrayList<MessageObject> filteredMessages) {
        ArrayList<String> messages = new ArrayList<String>();
        for (MessageObject message : filteredMessages) {
            messages.addAll(message.getHeader());
        }
        return messages;
    }

    public static List<String> getTopicList(CopyOnWriteArrayList<MessageObject> filteredMessages) {
        ArrayList<String> messages = new ArrayList<String>();
        for (MessageObject message : filteredMessages) {
            messages.add(message.getTopic());
        }
        return messages;
    }

    public static List<String> validateMessages(ServiceObject serviceObject, CopyOnWriteArrayList<MessageObject> filteredMessages) {
        List<String> errorMessages = new ArrayList<String>();
        if (filteredMessages.isEmpty()) {
            errorMessages.add("no messages received");
            return errorMessages;
        }
        List<String> messageList = MessageQueueHelper.getMessageList(filteredMessages);
        List<String> headerList = MessageQueueHelper.getHeaderList(filteredMessages);
        List<String> topicList = MessageQueueHelper.getTopicList(filteredMessages);
        String expectedMessage = DataHelper.removeSectionFromExpectedResponse("_VERIFY_HEADER_PART_", serviceObject.getExpectedResponse());
        expectedMessage = DataHelper.removeSectionFromExpectedResponse("_VERIFY_TOPIC_PART_", expectedMessage);
        expectedMessage = DataHelper.removeSectionFromExpectedResponse("EXPECTED_MESSAGE_COUNT", expectedMessage);
        String expectedHeader = DataHelper.getSectionFromExpectedResponse("_VERIFY_HEADER_PART_", serviceObject.getExpectedResponse());
        String expectedTopic = DataHelper.getSectionFromExpectedResponse("_VERIFY_TOPIC_PART_", serviceObject.getExpectedResponse());
        if (!expectedMessage.isEmpty()) {
            TestLog.logPass("validating message list:", new Object[0]);
            errorMessages = DataHelper.validateExpectedValues(messageList, expectedMessage);
        }
        if (!expectedHeader.isEmpty()) {
            TestLog.logPass("validating header list:", new Object[0]);
            errorMessages.addAll(DataHelper.validateExpectedValues(headerList, expectedHeader));
        }
        if (!expectedTopic.isEmpty()) {
            TestLog.logPass("validating topic list:", new Object[0]);
            errorMessages.addAll(DataHelper.validateExpectedValues(topicList, expectedTopic));
        }
        return errorMessages;
    }

    public static void evaluateOption(ServiceObject serviceObject) {
        MessageQueueHelper.resetValidationTimeout();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        DataHelper.saveDataToConfig(serviceObject.getOption());
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "NO_VALIDATION_TIMEOUT": {
                    Config.putValue("service.timeout.validation.isEnabled", false);
                    break;
                }
                case "WAIT_FOR_RESPONSE": {
                    Config.putValue("service.timeout.validation.isEnabled", true);
                    Config.putValue("service.timeout.validation.seconds", keyword.value);
                    break;
                }
            }
        }
    }

    private static void resetValidationTimeout() {
        String defaultValidationTimeoutIsEnabled = Config.getGlobalValue("service.timeout.validation.isEnabled");
        String defaultValidationTimeoutIsSeconds = Config.getGlobalValue("service.timeout.validation.seconds");
        Config.putValue("service.timeout.validation.isEnabled", defaultValidationTimeoutIsEnabled);
        Config.putValue("service.timeout.validation.seconds", defaultValidationTimeoutIsSeconds);
    }
}

