/*
 * Decompiled with CFR 0.152.
 */
package core.apiCore.helpers;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.RFC4180Parser;
import com.opencsv.RFC4180ParserBuilder;
import core.apiCore.TestDataProvider;
import core.apiCore.helpers.DataHelper;
import core.helpers.Helper;
import core.support.configReader.Config;
import core.support.configReader.PropertiesReader;
import core.support.objects.KeyValue;
import core.support.objects.ServiceObject;
import core.support.objects.TestObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;

public class CsvReader {
    public static int SERVICE_CSV_COLUMN_COUNT = 20;
    public static int SERVICE_CSV_VISIBLE_COLUMN_COUNT = 16;
    public static String SERVICE_CSV_FILE_PREFIX = "TestCases_";
    public static final String ACTION_KEY = "action";
    public static final String SERVICE_CSV_SEPARATOR = "service.csv.separator";
    public static final String SERVICE_CSV_DATAPROVIDER_COUNT = "service.csv.dataprovider.count";
    public static final String SERVICE_CSV_INCLUDE_SUB_DIR = "api.csv.include.subdir";
    public static final String OPTION_RUN_COUNT = "RUN_COUNT";
    public static final String SERVICE_RUN_COUNT = "service.run.count";
    public static final String SERVICE_RUN_CURRENT_COUNT = "service.run.current.count";
    public static final String SERVICE_RUN_PREFIX = "_run_";
    public static final String SERVICE_STEP_PREFIX = "step";

    public static synchronized List<Object> getTestCasesFromCsvFile() {
        int index = CsvReader.getCurrentTestInvocation();
        String testCaseFile = Config.getValue("api.testCaseFile");
        if (!testCaseFile.isEmpty()) {
            index = CsvReader.getCsvFileIndex(testCaseFile);
        }
        String csvFileName = CsvReader.getCsvFileFromIndex(index);
        List<Object[]> csvList = CsvReader.getCsvTestListForTestRunner(csvFileName);
        List<Object[]> updatedCsvList = new ArrayList<Object[]>();
        updatedCsvList.addAll(CsvReader.addActionCsvTests(csvList));
        updatedCsvList = CsvReader.setTestRerun(updatedCsvList);
        Map<String, List<Object[]>> testStepMap = CsvReader.getTestStepMap(csvList);
        updatedCsvList = CsvReader.setTestSteps(updatedCsvList, testStepMap);
        List<Object[]> testCaseList = CsvReader.updateCsvFileFromFile(updatedCsvList, csvFileName, testCaseFile, testStepMap);
        ArrayList<Object> tests = new ArrayList<Object>();
        for (Object[] object : testCaseList) {
            tests.add(object);
        }
        return tests;
    }

    public static List<Object[]> setTestSteps(List<Object[]> csvList, Map<String, List<Object[]>> testStepMap) {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        String currentTestname = "";
        for (int i = 0; i < csvList.size(); ++i) {
            Object[] csvRow = csvList.get(i);
            String testname = CsvReader.getTestname(csvRow);
            if (testStepMap.get(testname) != null && !currentTestname.equals(testname)) {
                csvRow[1] = testname;
                testCases.add(csvRow);
                currentTestname = testname;
                continue;
            }
            if (testStepMap.get(testname) != null) continue;
            testCases.add(csvRow);
        }
        return testCases;
    }

    private static String getTestname(Object[] csvRow) {
        if (!CsvReader.isContainTestStep(csvRow[1].toString())) {
            return csvRow[1].toString();
        }
        String testname = CsvReader.getTestname(csvRow[1].toString());
        return testname;
    }

    public static String getTestname(String fullTestname) {
        String testname = fullTestname.toString().split("(?i)_step")[0];
        if (CsvReader.isContainTestStep(testname)) {
            testname = fullTestname.toString().split("(?i)-step")[0];
        }
        return testname;
    }

    private static boolean isContainTestStep(String testname) {
        if (testname.toLowerCase().contains("_step")) {
            return true;
        }
        return testname.toLowerCase().contains("-step");
    }

    public static Map<String, List<Object[]>> getTestStepMap(List<Object[]> csvList) {
        HashMap<String, List<Object[]>> testStepMap = new HashMap<String, List<Object[]>>();
        for (int i = 0; i < csvList.size(); ++i) {
            Object[] csvRow = csvList.get(i);
            if (!CsvReader.isContainTestStep(csvRow[1].toString())) continue;
            String testname = CsvReader.getTestname(csvRow);
            ArrayList<Object[]> rowList = (ArrayList<Object[]>)testStepMap.get(testname);
            if (rowList == null) {
                rowList = new ArrayList<Object[]>();
            }
            csvRow[1] = testname;
            rowList.add(csvRow);
            testStepMap.put(testname, rowList);
        }
        return testStepMap;
    }

    public static List<Object[]> setTestRerun(List<Object[]> testCaseList) {
        ArrayList<Object[]> updatedTestCases = new ArrayList<Object[]>();
        for (Object[] testCase : testCaseList) {
            ServiceObject serviceObject = CsvReader.mapToServiceObject(testCase);
            CsvReader.evaluateOption(serviceObject);
            int runCount = Config.getIntValue(SERVICE_RUN_COUNT);
            String testid = testCase[1].toString();
            for (int i = 1; i <= runCount; ++i) {
                if (runCount > 1) {
                    testCase[1] = testid + SERVICE_RUN_PREFIX + i;
                }
                Object[] testCaseUpdated = Arrays.copyOf(testCase, testCase.length);
                updatedTestCases.add(testCaseUpdated);
            }
        }
        return updatedTestCases;
    }

    public static List<Object[]> updateCsvFileFromFile(List<Object[]> csvList, String csvFileName, String testCaseFile, Map<String, List<Object[]>> testStepMap) {
        ArrayList<Object[]> testCases = new ArrayList<Object[]>();
        for (int i = 0; i < csvList.size(); ++i) {
            Object[] obj = new Object[]{csvFileName, String.valueOf(i) + ":" + String.valueOf(csvList.size()), TestObject.testType.service.name()};
            Object[] csvRow = ArrayUtils.addAll((Object[])csvList.get(i), (Object[])obj);
            String testname = CsvReader.getTestname(csvRow);
            if (testStepMap != null && testStepMap.get(testname) != null) {
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(csvRow));
                list.add(testStepMap);
                Object[] arr = list.toArray(new Object[list.size()]);
                csvRow = ArrayUtils.addAll((Object[])arr, (Object[])new Object[0]);
            } else {
                int dataCount = Config.getIntValue(SERVICE_CSV_DATAPROVIDER_COUNT);
                if (dataCount >= 20) {
                    csvRow = ArrayUtils.addAll((Object[])csvRow, (Object[])new Object[]{""});
                }
            }
            String testCase = Config.getValue("api.testCase");
            if (testCaseFile.isEmpty() || testCase.isEmpty()) {
                testCases.add(csvRow);
                continue;
            }
            if (!csvRow[1].equals(testCase)) continue;
            testCases.add(csvRow);
            return testCases;
        }
        return testCases;
    }

    public static List<Object[]> addActionCsvTests(List<Object[]> csvList) {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.actionTestcasePath");
        ArrayList<Object[]> updateDataList = new ArrayList<Object[]>();
        boolean hasActionKey = false;
        for (Object[] dataRow : csvList) {
            hasActionKey = false;
            ServiceObject serviceObject = CsvReader.mapToServiceObject(dataRow);
            List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getMethod());
            String runFlag = serviceObject.getRunFlag();
            if (!runFlag.equals("Y")) break;
            for (KeyValue keyword : keywords) {
                if (!keyword.key.equals(ACTION_KEY)) continue;
                List<Object[]> tests = CsvReader.getCsvTestListForTestRunner(csvTestPath, keyword.value.toString());
                updateDataList.addAll(tests);
                hasActionKey = true;
            }
            if (hasActionKey) continue;
            updateDataList.add(dataRow);
        }
        return updateDataList;
    }

    public static Map<String, ServiceObject> mapToApiObject(List<Object[]> testCases) {
        ConcurrentHashMap<String, ServiceObject> serviceMap = new ConcurrentHashMap<String, ServiceObject>();
        for (Object[] testCase : testCases) {
            ServiceObject ServiceObject2 = CsvReader.mapToServiceObject(testCase);
            serviceMap.put(ServiceObject2.getTestCaseID(), ServiceObject2);
        }
        return serviceMap;
    }

    public static ServiceObject mapToServiceObject(Object[] testData) {
        return new ServiceObject().setServiceObject(testData);
    }

    public static void getAllTestCases(String testPath, String prefix) {
        ArrayList<File> csvFiles = Helper.getFileListByType(testPath, prefix);
        for (int i = 0; i < csvFiles.size(); ++i) {
            List<Object[]> testCases = CsvReader.getCsvTestList(csvFiles.get(i));
            Map<String, ServiceObject> apiMap = CsvReader.mapToApiObject(testCases);
            TestObject.getTestInfo().apiMap.putAll(apiMap);
        }
    }

    public static synchronized void getAllKeywords() {
        String testFolderPath = Config.getValue("api.keywordPath");
        String csvTestPath = PropertiesReader.getLocalRootPath() + testFolderPath;
        CsvReader.getAllTestCases(csvTestPath, ".csv");
    }

    public static int getCurrentTestInvocation() {
        if (CsvReader.isRunningServiceTest()) {
            String activeTest = TestObject.getTestInfo().testCsvFileName;
            return CsvReader.getCsvFileIndex(activeTest);
        }
        return TestDataProvider.csvFileIndex.getAndIncrement();
    }

    public static boolean isRunningServiceTest() {
        return !TestObject.getTestInfo().testCsvFileName.isEmpty();
    }

    public static String getCsvFileFromIndex(int index) {
        ArrayList<File> testCsvList = CsvReader.getTestDataCsvFileList();
        Helper.assertTrue("test not found at index: " + index, testCsvList.size() > index);
        return testCsvList.get(index).getName();
    }

    public static int getCsvFileCount() {
        return CsvReader.getTestDataCsvFileList().size();
    }

    public static ArrayList<File> getTestDataCsvFileList() {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.parallelTestcasePath");
        return CsvReader.getCsvFileList(csvTestPath);
    }

    public static ArrayList<File> getCsvFileList(String csvTestPath) {
        boolean includeSubDirectories = Config.getBooleanValue(SERVICE_CSV_INCLUDE_SUB_DIR);
        ArrayList<File> csvFiles = Helper.getFileListByType(csvTestPath, ".csv", includeSubDirectories);
        return csvFiles;
    }

    public static int getCsvFileIndex(String fileName) {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.parallelTestcasePath");
        return CsvReader.getCsvFileIndex(csvTestPath, fileName);
    }

    public static int getCsvFileIndex(String csvDir, String fileName) {
        Helper.assertTrue("csv file is null", fileName != null);
        ArrayList<File> csvFiles = CsvReader.getCsvFileList(csvDir);
        OptionalInt indexOpt = IntStream.range(0, csvFiles.size()).filter(i -> fileName.contains(((File)csvFiles.get(i)).getName())).findFirst();
        Helper.assertTrue("csv file: " + fileName + " not found", indexOpt.isPresent());
        return indexOpt.getAsInt();
    }

    public static List<Object[]> getCsvTestListForTestRunner(String csvFile) {
        String csvTestPath = PropertiesReader.getLocalRootPath() + Config.getValue("api.parallelTestcasePath");
        return CsvReader.getCsvTestListForTestRunner(csvTestPath, csvFile);
    }

    public static List<Object[]> getCsvTestListForTestRunner(String csvDir, String csvFile) {
        ArrayList<Object[]> csvList = new ArrayList();
        ArrayList<File> testCsvFileList = CsvReader.getCsvFileList(csvDir);
        int fileIndex = CsvReader.getFileIndex(testCsvFileList, csvFile);
        if (fileIndex == -1) {
            Helper.assertFalse("csv file not found. csv file: " + csvFile + " at location: " + csvDir);
        }
        csvList = CsvReader.getCsvTestList(testCsvFileList.get(fileIndex));
        return csvList;
    }

    public static List<Object[]> getCsvTestList(File file) {
        ArrayList<Object[]> csvList = new ArrayList<Object[]>();
        try {
            String[] line;
            CSVReader reader = CsvReader.readCsvFile(file);
            String[] header = reader.readNext();
            int runFlag = CsvReader.getColumnIndexByName("RunFlag", header);
            int testCaseID = CsvReader.getColumnIndexByName("TestCaseID", header);
            while ((line = reader.readNext()) != null) {
                String[] newline = Arrays.copyOfRange(line, 0, SERVICE_CSV_VISIBLE_COLUMN_COUNT);
                if (!newline[runFlag].equals("Y") || newline[testCaseID].isEmpty()) continue;
                csvList.add(newline);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvList;
    }

    public static CSVReader readCsvFile(File file) {
        CSVReader reader = null;
        try {
            char separator = CsvReader.getCsvSeparator();
            FileInputStream fis = new FileInputStream(file.getPath());
            InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            RFC4180Parser parser = new RFC4180ParserBuilder().withSeparator(separator).build();
            reader = new CSVReaderBuilder((Reader)isr).withCSVParser((ICSVParser)parser).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reader;
    }

    private static char getCsvSeparator() {
        String separatorString = Config.getValue(SERVICE_CSV_SEPARATOR);
        if (separatorString.isEmpty()) {
            separatorString = ",";
        }
        char separator = separatorString.charAt(0);
        return separator;
    }

    public static int getFileIndex(ArrayList<File> testCsvFileList, String csvFile) {
        for (int i = 0; i < testCsvFileList.size(); ++i) {
            if (!testCsvFileList.get(i).getName().equals(csvFile)) continue;
            return i;
        }
        return -1;
    }

    public static int getColumnIndexByName(String column, String[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (!row[i].equals(column)) continue;
            return i;
        }
        Helper.assertTrue("column not found", false);
        return -1;
    }

    public static int getCsvTestcount() {
        return CsvReader.getCsvTestListForTestRunner(TestObject.getTestInfo().testCsvFileName).size();
    }

    public static boolean isValidTestFileType(String filename) {
        for (VALID_TEST_FILE_TYPES types : VALID_TEST_FILE_TYPES.values()) {
            if (!filename.endsWith(types.name())) continue;
            return true;
        }
        return false;
    }

    public static void evaluateOption(ServiceObject serviceObject) {
        CsvReader.resetOptions();
        if (serviceObject.getOption().isEmpty()) {
            return;
        }
        DataHelper.saveDataToConfig(serviceObject.getOption());
        serviceObject.withOption(DataHelper.replaceParameters(serviceObject.getOption()));
        List<KeyValue> keywords = DataHelper.getValidationMap(serviceObject.getOption());
        for (KeyValue keyword : keywords) {
            switch (keyword.key) {
                case "RUN_COUNT": {
                    Config.putValue(SERVICE_RUN_COUNT, keyword.value);
                    break;
                }
            }
        }
    }

    private static void resetOptions() {
        Config.putValue(SERVICE_RUN_COUNT, (Object)1, false);
    }

    static enum VALID_TEST_FILE_TYPES {
        csv;

    }
}

